// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovider"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// ModelProviderDelete is the builder for deleting a ModelProvider entity.
type ModelProviderDelete struct {
	config
	hooks    []Hook
	mutation *ModelProviderMutation
}

// Where appends a list predicates to the ModelProviderDelete builder.
func (mpd *ModelProviderDelete) Where(ps ...predicate.ModelProvider) *ModelProviderDelete {
	mpd.mutation.Where(ps...)
	return mpd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (mpd *ModelProviderDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, mpd.sqlExec, mpd.mutation, mpd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (mpd *ModelProviderDelete) ExecX(ctx context.Context) int {
	n, err := mpd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (mpd *ModelProviderDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(modelprovider.Table, sqlgraph.NewFieldSpec(modelprovider.FieldID, field.TypeString))
	if ps := mpd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, mpd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	mpd.mutation.done = true
	return affected, err
}

// ModelProviderDeleteOne is the builder for deleting a single ModelProvider entity.
type ModelProviderDeleteOne struct {
	mpd *ModelProviderDelete
}

// Where appends a list predicates to the ModelProviderDelete builder.
func (mpdo *ModelProviderDeleteOne) Where(ps ...predicate.ModelProvider) *ModelProviderDeleteOne {
	mpdo.mpd.mutation.Where(ps...)
	return mpdo
}

// Exec executes the deletion query.
func (mpdo *ModelProviderDeleteOne) Exec(ctx context.Context) error {
	n, err := mpdo.mpd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{modelprovider.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (mpdo *ModelProviderDeleteOne) ExecX(ctx context.Context) {
	if err := mpdo.Exec(ctx); err != nil {
		panic(err)
	}
}
