// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent"
	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovider"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovidermodel"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/google/uuid"
)

// ModelProviderModelQuery is the builder for querying ModelProviderModel entities.
type ModelProviderModelQuery struct {
	config
	ctx          *QueryContext
	order        []modelprovidermodel.OrderOption
	inters       []Interceptor
	predicates   []predicate.ModelProviderModel
	withProvider *ModelProviderQuery
	modifiers    []func(*sql.Selector)
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the ModelProviderModelQuery builder.
func (mpmq *ModelProviderModelQuery) Where(ps ...predicate.ModelProviderModel) *ModelProviderModelQuery {
	mpmq.predicates = append(mpmq.predicates, ps...)
	return mpmq
}

// Limit the number of records to be returned by this query.
func (mpmq *ModelProviderModelQuery) Limit(limit int) *ModelProviderModelQuery {
	mpmq.ctx.Limit = &limit
	return mpmq
}

// Offset to start from.
func (mpmq *ModelProviderModelQuery) Offset(offset int) *ModelProviderModelQuery {
	mpmq.ctx.Offset = &offset
	return mpmq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (mpmq *ModelProviderModelQuery) Unique(unique bool) *ModelProviderModelQuery {
	mpmq.ctx.Unique = &unique
	return mpmq
}

// Order specifies how the records should be ordered.
func (mpmq *ModelProviderModelQuery) Order(o ...modelprovidermodel.OrderOption) *ModelProviderModelQuery {
	mpmq.order = append(mpmq.order, o...)
	return mpmq
}

// QueryProvider chains the current query on the "provider" edge.
func (mpmq *ModelProviderModelQuery) QueryProvider() *ModelProviderQuery {
	query := (&ModelProviderClient{config: mpmq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := mpmq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := mpmq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(modelprovidermodel.Table, modelprovidermodel.FieldID, selector),
			sqlgraph.To(modelprovider.Table, modelprovider.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, modelprovidermodel.ProviderTable, modelprovidermodel.ProviderColumn),
		)
		fromU = sqlgraph.SetNeighbors(mpmq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// First returns the first ModelProviderModel entity from the query.
// Returns a *NotFoundError when no ModelProviderModel was found.
func (mpmq *ModelProviderModelQuery) First(ctx context.Context) (*ModelProviderModel, error) {
	nodes, err := mpmq.Limit(1).All(setContextOp(ctx, mpmq.ctx, ent.OpQueryFirst))
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{modelprovidermodel.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (mpmq *ModelProviderModelQuery) FirstX(ctx context.Context) *ModelProviderModel {
	node, err := mpmq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first ModelProviderModel ID from the query.
// Returns a *NotFoundError when no ModelProviderModel ID was found.
func (mpmq *ModelProviderModelQuery) FirstID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = mpmq.Limit(1).IDs(setContextOp(ctx, mpmq.ctx, ent.OpQueryFirstID)); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{modelprovidermodel.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (mpmq *ModelProviderModelQuery) FirstIDX(ctx context.Context) uuid.UUID {
	id, err := mpmq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single ModelProviderModel entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one ModelProviderModel entity is found.
// Returns a *NotFoundError when no ModelProviderModel entities are found.
func (mpmq *ModelProviderModelQuery) Only(ctx context.Context) (*ModelProviderModel, error) {
	nodes, err := mpmq.Limit(2).All(setContextOp(ctx, mpmq.ctx, ent.OpQueryOnly))
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{modelprovidermodel.Label}
	default:
		return nil, &NotSingularError{modelprovidermodel.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (mpmq *ModelProviderModelQuery) OnlyX(ctx context.Context) *ModelProviderModel {
	node, err := mpmq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only ModelProviderModel ID in the query.
// Returns a *NotSingularError when more than one ModelProviderModel ID is found.
// Returns a *NotFoundError when no entities are found.
func (mpmq *ModelProviderModelQuery) OnlyID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = mpmq.Limit(2).IDs(setContextOp(ctx, mpmq.ctx, ent.OpQueryOnlyID)); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{modelprovidermodel.Label}
	default:
		err = &NotSingularError{modelprovidermodel.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (mpmq *ModelProviderModelQuery) OnlyIDX(ctx context.Context) uuid.UUID {
	id, err := mpmq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of ModelProviderModels.
func (mpmq *ModelProviderModelQuery) All(ctx context.Context) ([]*ModelProviderModel, error) {
	ctx = setContextOp(ctx, mpmq.ctx, ent.OpQueryAll)
	if err := mpmq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	qr := querierAll[[]*ModelProviderModel, *ModelProviderModelQuery]()
	return withInterceptors[[]*ModelProviderModel](ctx, mpmq, qr, mpmq.inters)
}

// AllX is like All, but panics if an error occurs.
func (mpmq *ModelProviderModelQuery) AllX(ctx context.Context) []*ModelProviderModel {
	nodes, err := mpmq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of ModelProviderModel IDs.
func (mpmq *ModelProviderModelQuery) IDs(ctx context.Context) (ids []uuid.UUID, err error) {
	if mpmq.ctx.Unique == nil && mpmq.path != nil {
		mpmq.Unique(true)
	}
	ctx = setContextOp(ctx, mpmq.ctx, ent.OpQueryIDs)
	if err = mpmq.Select(modelprovidermodel.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (mpmq *ModelProviderModelQuery) IDsX(ctx context.Context) []uuid.UUID {
	ids, err := mpmq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (mpmq *ModelProviderModelQuery) Count(ctx context.Context) (int, error) {
	ctx = setContextOp(ctx, mpmq.ctx, ent.OpQueryCount)
	if err := mpmq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return withInterceptors[int](ctx, mpmq, querierCount[*ModelProviderModelQuery](), mpmq.inters)
}

// CountX is like Count, but panics if an error occurs.
func (mpmq *ModelProviderModelQuery) CountX(ctx context.Context) int {
	count, err := mpmq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (mpmq *ModelProviderModelQuery) Exist(ctx context.Context) (bool, error) {
	ctx = setContextOp(ctx, mpmq.ctx, ent.OpQueryExist)
	switch _, err := mpmq.FirstID(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("db: check existence: %w", err)
	default:
		return true, nil
	}
}

// ExistX is like Exist, but panics if an error occurs.
func (mpmq *ModelProviderModelQuery) ExistX(ctx context.Context) bool {
	exist, err := mpmq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the ModelProviderModelQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (mpmq *ModelProviderModelQuery) Clone() *ModelProviderModelQuery {
	if mpmq == nil {
		return nil
	}
	return &ModelProviderModelQuery{
		config:       mpmq.config,
		ctx:          mpmq.ctx.Clone(),
		order:        append([]modelprovidermodel.OrderOption{}, mpmq.order...),
		inters:       append([]Interceptor{}, mpmq.inters...),
		predicates:   append([]predicate.ModelProviderModel{}, mpmq.predicates...),
		withProvider: mpmq.withProvider.Clone(),
		// clone intermediate query.
		sql:       mpmq.sql.Clone(),
		path:      mpmq.path,
		modifiers: append([]func(*sql.Selector){}, mpmq.modifiers...),
	}
}

// WithProvider tells the query-builder to eager-load the nodes that are connected to
// the "provider" edge. The optional arguments are used to configure the query builder of the edge.
func (mpmq *ModelProviderModelQuery) WithProvider(opts ...func(*ModelProviderQuery)) *ModelProviderModelQuery {
	query := (&ModelProviderClient{config: mpmq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	mpmq.withProvider = query
	return mpmq
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		Name string `json:"name,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.ModelProviderModel.Query().
//		GroupBy(modelprovidermodel.FieldName).
//		Aggregate(db.Count()).
//		Scan(ctx, &v)
func (mpmq *ModelProviderModelQuery) GroupBy(field string, fields ...string) *ModelProviderModelGroupBy {
	mpmq.ctx.Fields = append([]string{field}, fields...)
	grbuild := &ModelProviderModelGroupBy{build: mpmq}
	grbuild.flds = &mpmq.ctx.Fields
	grbuild.label = modelprovidermodel.Label
	grbuild.scan = grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		Name string `json:"name,omitempty"`
//	}
//
//	client.ModelProviderModel.Query().
//		Select(modelprovidermodel.FieldName).
//		Scan(ctx, &v)
func (mpmq *ModelProviderModelQuery) Select(fields ...string) *ModelProviderModelSelect {
	mpmq.ctx.Fields = append(mpmq.ctx.Fields, fields...)
	sbuild := &ModelProviderModelSelect{ModelProviderModelQuery: mpmq}
	sbuild.label = modelprovidermodel.Label
	sbuild.flds, sbuild.scan = &mpmq.ctx.Fields, sbuild.Scan
	return sbuild
}

// Aggregate returns a ModelProviderModelSelect configured with the given aggregations.
func (mpmq *ModelProviderModelQuery) Aggregate(fns ...AggregateFunc) *ModelProviderModelSelect {
	return mpmq.Select().Aggregate(fns...)
}

func (mpmq *ModelProviderModelQuery) prepareQuery(ctx context.Context) error {
	for _, inter := range mpmq.inters {
		if inter == nil {
			return fmt.Errorf("db: uninitialized interceptor (forgotten import db/runtime?)")
		}
		if trv, ok := inter.(Traverser); ok {
			if err := trv.Traverse(ctx, mpmq); err != nil {
				return err
			}
		}
	}
	for _, f := range mpmq.ctx.Fields {
		if !modelprovidermodel.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
		}
	}
	if mpmq.path != nil {
		prev, err := mpmq.path(ctx)
		if err != nil {
			return err
		}
		mpmq.sql = prev
	}
	return nil
}

func (mpmq *ModelProviderModelQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*ModelProviderModel, error) {
	var (
		nodes       = []*ModelProviderModel{}
		_spec       = mpmq.querySpec()
		loadedTypes = [1]bool{
			mpmq.withProvider != nil,
		}
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*ModelProviderModel).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &ModelProviderModel{config: mpmq.config}
		nodes = append(nodes, node)
		node.Edges.loadedTypes = loadedTypes
		return node.assignValues(columns, values)
	}
	if len(mpmq.modifiers) > 0 {
		_spec.Modifiers = mpmq.modifiers
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, mpmq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	if query := mpmq.withProvider; query != nil {
		if err := mpmq.loadProvider(ctx, query, nodes, nil,
			func(n *ModelProviderModel, e *ModelProvider) { n.Edges.Provider = e }); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

func (mpmq *ModelProviderModelQuery) loadProvider(ctx context.Context, query *ModelProviderQuery, nodes []*ModelProviderModel, init func(*ModelProviderModel), assign func(*ModelProviderModel, *ModelProvider)) error {
	ids := make([]string, 0, len(nodes))
	nodeids := make(map[string][]*ModelProviderModel)
	for i := range nodes {
		fk := nodes[i].ProviderID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(modelprovider.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "provider_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}

func (mpmq *ModelProviderModelQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := mpmq.querySpec()
	if len(mpmq.modifiers) > 0 {
		_spec.Modifiers = mpmq.modifiers
	}
	_spec.Node.Columns = mpmq.ctx.Fields
	if len(mpmq.ctx.Fields) > 0 {
		_spec.Unique = mpmq.ctx.Unique != nil && *mpmq.ctx.Unique
	}
	return sqlgraph.CountNodes(ctx, mpmq.driver, _spec)
}

func (mpmq *ModelProviderModelQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := sqlgraph.NewQuerySpec(modelprovidermodel.Table, modelprovidermodel.Columns, sqlgraph.NewFieldSpec(modelprovidermodel.FieldID, field.TypeUUID))
	_spec.From = mpmq.sql
	if unique := mpmq.ctx.Unique; unique != nil {
		_spec.Unique = *unique
	} else if mpmq.path != nil {
		_spec.Unique = true
	}
	if fields := mpmq.ctx.Fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, modelprovidermodel.FieldID)
		for i := range fields {
			if fields[i] != modelprovidermodel.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
		if mpmq.withProvider != nil {
			_spec.Node.AddColumnOnce(modelprovidermodel.FieldProviderID)
		}
	}
	if ps := mpmq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := mpmq.ctx.Limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := mpmq.ctx.Offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := mpmq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (mpmq *ModelProviderModelQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(mpmq.driver.Dialect())
	t1 := builder.Table(modelprovidermodel.Table)
	columns := mpmq.ctx.Fields
	if len(columns) == 0 {
		columns = modelprovidermodel.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if mpmq.sql != nil {
		selector = mpmq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if mpmq.ctx.Unique != nil && *mpmq.ctx.Unique {
		selector.Distinct()
	}
	for _, m := range mpmq.modifiers {
		m(selector)
	}
	for _, p := range mpmq.predicates {
		p(selector)
	}
	for _, p := range mpmq.order {
		p(selector)
	}
	if offset := mpmq.ctx.Offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := mpmq.ctx.Limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// ForUpdate locks the selected rows against concurrent updates, and prevent them from being
// updated, deleted or "selected ... for update" by other sessions, until the transaction is
// either committed or rolled-back.
func (mpmq *ModelProviderModelQuery) ForUpdate(opts ...sql.LockOption) *ModelProviderModelQuery {
	if mpmq.driver.Dialect() == dialect.Postgres {
		mpmq.Unique(false)
	}
	mpmq.modifiers = append(mpmq.modifiers, func(s *sql.Selector) {
		s.ForUpdate(opts...)
	})
	return mpmq
}

// ForShare behaves similarly to ForUpdate, except that it acquires a shared mode lock
// on any rows that are read. Other sessions can read the rows, but cannot modify them
// until your transaction commits.
func (mpmq *ModelProviderModelQuery) ForShare(opts ...sql.LockOption) *ModelProviderModelQuery {
	if mpmq.driver.Dialect() == dialect.Postgres {
		mpmq.Unique(false)
	}
	mpmq.modifiers = append(mpmq.modifiers, func(s *sql.Selector) {
		s.ForShare(opts...)
	})
	return mpmq
}

// Modify adds a query modifier for attaching custom logic to queries.
func (mpmq *ModelProviderModelQuery) Modify(modifiers ...func(s *sql.Selector)) *ModelProviderModelSelect {
	mpmq.modifiers = append(mpmq.modifiers, modifiers...)
	return mpmq.Select()
}

// ModelProviderModelGroupBy is the group-by builder for ModelProviderModel entities.
type ModelProviderModelGroupBy struct {
	selector
	build *ModelProviderModelQuery
}

// Aggregate adds the given aggregation functions to the group-by query.
func (mpmgb *ModelProviderModelGroupBy) Aggregate(fns ...AggregateFunc) *ModelProviderModelGroupBy {
	mpmgb.fns = append(mpmgb.fns, fns...)
	return mpmgb
}

// Scan applies the selector query and scans the result into the given value.
func (mpmgb *ModelProviderModelGroupBy) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, mpmgb.build.ctx, ent.OpQueryGroupBy)
	if err := mpmgb.build.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*ModelProviderModelQuery, *ModelProviderModelGroupBy](ctx, mpmgb.build, mpmgb, mpmgb.build.inters, v)
}

func (mpmgb *ModelProviderModelGroupBy) sqlScan(ctx context.Context, root *ModelProviderModelQuery, v any) error {
	selector := root.sqlQuery(ctx).Select()
	aggregation := make([]string, 0, len(mpmgb.fns))
	for _, fn := range mpmgb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(*mpmgb.flds)+len(mpmgb.fns))
		for _, f := range *mpmgb.flds {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	selector.GroupBy(selector.Columns(*mpmgb.flds...)...)
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := mpmgb.build.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// ModelProviderModelSelect is the builder for selecting fields of ModelProviderModel entities.
type ModelProviderModelSelect struct {
	*ModelProviderModelQuery
	selector
}

// Aggregate adds the given aggregation functions to the selector query.
func (mpms *ModelProviderModelSelect) Aggregate(fns ...AggregateFunc) *ModelProviderModelSelect {
	mpms.fns = append(mpms.fns, fns...)
	return mpms
}

// Scan applies the selector query and scans the result into the given value.
func (mpms *ModelProviderModelSelect) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, mpms.ctx, ent.OpQuerySelect)
	if err := mpms.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*ModelProviderModelQuery, *ModelProviderModelSelect](ctx, mpms.ModelProviderModelQuery, mpms, mpms.inters, v)
}

func (mpms *ModelProviderModelSelect) sqlScan(ctx context.Context, root *ModelProviderModelQuery, v any) error {
	selector := root.sqlQuery(ctx)
	aggregation := make([]string, 0, len(mpms.fns))
	for _, fn := range mpms.fns {
		aggregation = append(aggregation, fn(selector))
	}
	switch n := len(*mpms.selector.flds); {
	case n == 0 && len(aggregation) > 0:
		selector.Select(aggregation...)
	case n != 0 && len(aggregation) > 0:
		selector.AppendSelect(aggregation...)
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := mpms.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// Modify adds a query modifier for attaching custom logic to queries.
func (mpms *ModelProviderModelSelect) Modify(modifiers ...func(s *sql.Selector)) *ModelProviderModelSelect {
	mpms.modifiers = append(mpms.modifiers, modifiers...)
	return mpms
}
