// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanning"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanningresult"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/workspace"
	"github.com/google/uuid"
)

// SecurityScanningCreate is the builder for creating a SecurityScanning entity.
type SecurityScanningCreate struct {
	config
	mutation *SecurityScanningMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetUserID sets the "user_id" field.
func (ssc *SecurityScanningCreate) SetUserID(u uuid.UUID) *SecurityScanningCreate {
	ssc.mutation.SetUserID(u)
	return ssc
}

// SetWorkspaceID sets the "workspace_id" field.
func (ssc *SecurityScanningCreate) SetWorkspaceID(u uuid.UUID) *SecurityScanningCreate {
	ssc.mutation.SetWorkspaceID(u)
	return ssc
}

// SetStatus sets the "status" field.
func (ssc *SecurityScanningCreate) SetStatus(css consts.SecurityScanningStatus) *SecurityScanningCreate {
	ssc.mutation.SetStatus(css)
	return ssc
}

// SetWorkspace sets the "workspace" field.
func (ssc *SecurityScanningCreate) SetWorkspace(s string) *SecurityScanningCreate {
	ssc.mutation.SetWorkspace(s)
	return ssc
}

// SetLanguage sets the "language" field.
func (ssc *SecurityScanningCreate) SetLanguage(csl consts.SecurityScanningLanguage) *SecurityScanningCreate {
	ssc.mutation.SetLanguage(csl)
	return ssc
}

// SetRule sets the "rule" field.
func (ssc *SecurityScanningCreate) SetRule(s string) *SecurityScanningCreate {
	ssc.mutation.SetRule(s)
	return ssc
}

// SetNillableRule sets the "rule" field if the given value is not nil.
func (ssc *SecurityScanningCreate) SetNillableRule(s *string) *SecurityScanningCreate {
	if s != nil {
		ssc.SetRule(*s)
	}
	return ssc
}

// SetErrorMessage sets the "error_message" field.
func (ssc *SecurityScanningCreate) SetErrorMessage(s string) *SecurityScanningCreate {
	ssc.mutation.SetErrorMessage(s)
	return ssc
}

// SetNillableErrorMessage sets the "error_message" field if the given value is not nil.
func (ssc *SecurityScanningCreate) SetNillableErrorMessage(s *string) *SecurityScanningCreate {
	if s != nil {
		ssc.SetErrorMessage(*s)
	}
	return ssc
}

// SetCreatedAt sets the "created_at" field.
func (ssc *SecurityScanningCreate) SetCreatedAt(t time.Time) *SecurityScanningCreate {
	ssc.mutation.SetCreatedAt(t)
	return ssc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ssc *SecurityScanningCreate) SetNillableCreatedAt(t *time.Time) *SecurityScanningCreate {
	if t != nil {
		ssc.SetCreatedAt(*t)
	}
	return ssc
}

// SetUpdatedAt sets the "updated_at" field.
func (ssc *SecurityScanningCreate) SetUpdatedAt(t time.Time) *SecurityScanningCreate {
	ssc.mutation.SetUpdatedAt(t)
	return ssc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (ssc *SecurityScanningCreate) SetNillableUpdatedAt(t *time.Time) *SecurityScanningCreate {
	if t != nil {
		ssc.SetUpdatedAt(*t)
	}
	return ssc
}

// SetID sets the "id" field.
func (ssc *SecurityScanningCreate) SetID(u uuid.UUID) *SecurityScanningCreate {
	ssc.mutation.SetID(u)
	return ssc
}

// SetUser sets the "user" edge to the User entity.
func (ssc *SecurityScanningCreate) SetUser(u *User) *SecurityScanningCreate {
	return ssc.SetUserID(u.ID)
}

// AddResultIDs adds the "results" edge to the SecurityScanningResult entity by IDs.
func (ssc *SecurityScanningCreate) AddResultIDs(ids ...uuid.UUID) *SecurityScanningCreate {
	ssc.mutation.AddResultIDs(ids...)
	return ssc
}

// AddResults adds the "results" edges to the SecurityScanningResult entity.
func (ssc *SecurityScanningCreate) AddResults(s ...*SecurityScanningResult) *SecurityScanningCreate {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return ssc.AddResultIDs(ids...)
}

// SetWorkspaceEdgeID sets the "workspace_edge" edge to the Workspace entity by ID.
func (ssc *SecurityScanningCreate) SetWorkspaceEdgeID(id uuid.UUID) *SecurityScanningCreate {
	ssc.mutation.SetWorkspaceEdgeID(id)
	return ssc
}

// SetWorkspaceEdge sets the "workspace_edge" edge to the Workspace entity.
func (ssc *SecurityScanningCreate) SetWorkspaceEdge(w *Workspace) *SecurityScanningCreate {
	return ssc.SetWorkspaceEdgeID(w.ID)
}

// Mutation returns the SecurityScanningMutation object of the builder.
func (ssc *SecurityScanningCreate) Mutation() *SecurityScanningMutation {
	return ssc.mutation
}

// Save creates the SecurityScanning in the database.
func (ssc *SecurityScanningCreate) Save(ctx context.Context) (*SecurityScanning, error) {
	ssc.defaults()
	return withHooks(ctx, ssc.sqlSave, ssc.mutation, ssc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (ssc *SecurityScanningCreate) SaveX(ctx context.Context) *SecurityScanning {
	v, err := ssc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (ssc *SecurityScanningCreate) Exec(ctx context.Context) error {
	_, err := ssc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ssc *SecurityScanningCreate) ExecX(ctx context.Context) {
	if err := ssc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (ssc *SecurityScanningCreate) defaults() {
	if _, ok := ssc.mutation.CreatedAt(); !ok {
		v := securityscanning.DefaultCreatedAt()
		ssc.mutation.SetCreatedAt(v)
	}
	if _, ok := ssc.mutation.UpdatedAt(); !ok {
		v := securityscanning.DefaultUpdatedAt()
		ssc.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ssc *SecurityScanningCreate) check() error {
	if _, ok := ssc.mutation.UserID(); !ok {
		return &ValidationError{Name: "user_id", err: errors.New(`db: missing required field "SecurityScanning.user_id"`)}
	}
	if _, ok := ssc.mutation.WorkspaceID(); !ok {
		return &ValidationError{Name: "workspace_id", err: errors.New(`db: missing required field "SecurityScanning.workspace_id"`)}
	}
	if _, ok := ssc.mutation.Status(); !ok {
		return &ValidationError{Name: "status", err: errors.New(`db: missing required field "SecurityScanning.status"`)}
	}
	if _, ok := ssc.mutation.Workspace(); !ok {
		return &ValidationError{Name: "workspace", err: errors.New(`db: missing required field "SecurityScanning.workspace"`)}
	}
	if _, ok := ssc.mutation.Language(); !ok {
		return &ValidationError{Name: "language", err: errors.New(`db: missing required field "SecurityScanning.language"`)}
	}
	if _, ok := ssc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "SecurityScanning.created_at"`)}
	}
	if _, ok := ssc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "SecurityScanning.updated_at"`)}
	}
	if len(ssc.mutation.UserIDs()) == 0 {
		return &ValidationError{Name: "user", err: errors.New(`db: missing required edge "SecurityScanning.user"`)}
	}
	if len(ssc.mutation.WorkspaceEdgeIDs()) == 0 {
		return &ValidationError{Name: "workspace_edge", err: errors.New(`db: missing required edge "SecurityScanning.workspace_edge"`)}
	}
	return nil
}

func (ssc *SecurityScanningCreate) sqlSave(ctx context.Context) (*SecurityScanning, error) {
	if err := ssc.check(); err != nil {
		return nil, err
	}
	_node, _spec := ssc.createSpec()
	if err := sqlgraph.CreateNode(ctx, ssc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	ssc.mutation.id = &_node.ID
	ssc.mutation.done = true
	return _node, nil
}

func (ssc *SecurityScanningCreate) createSpec() (*SecurityScanning, *sqlgraph.CreateSpec) {
	var (
		_node = &SecurityScanning{config: ssc.config}
		_spec = sqlgraph.NewCreateSpec(securityscanning.Table, sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = ssc.conflict
	if id, ok := ssc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := ssc.mutation.Status(); ok {
		_spec.SetField(securityscanning.FieldStatus, field.TypeString, value)
		_node.Status = value
	}
	if value, ok := ssc.mutation.Workspace(); ok {
		_spec.SetField(securityscanning.FieldWorkspace, field.TypeString, value)
		_node.Workspace = value
	}
	if value, ok := ssc.mutation.Language(); ok {
		_spec.SetField(securityscanning.FieldLanguage, field.TypeString, value)
		_node.Language = value
	}
	if value, ok := ssc.mutation.Rule(); ok {
		_spec.SetField(securityscanning.FieldRule, field.TypeString, value)
		_node.Rule = value
	}
	if value, ok := ssc.mutation.ErrorMessage(); ok {
		_spec.SetField(securityscanning.FieldErrorMessage, field.TypeString, value)
		_node.ErrorMessage = value
	}
	if value, ok := ssc.mutation.CreatedAt(); ok {
		_spec.SetField(securityscanning.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := ssc.mutation.UpdatedAt(); ok {
		_spec.SetField(securityscanning.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if nodes := ssc.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanning.UserTable,
			Columns: []string{securityscanning.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.UserID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := ssc.mutation.ResultsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   securityscanning.ResultsTable,
			Columns: []string{securityscanning.ResultsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanningresult.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := ssc.mutation.WorkspaceEdgeIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanning.WorkspaceEdgeTable,
			Columns: []string{securityscanning.WorkspaceEdgeColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspace.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.WorkspaceID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.SecurityScanning.Create().
//		SetUserID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.SecurityScanningUpsert) {
//			SetUserID(v+v).
//		}).
//		Exec(ctx)
func (ssc *SecurityScanningCreate) OnConflict(opts ...sql.ConflictOption) *SecurityScanningUpsertOne {
	ssc.conflict = opts
	return &SecurityScanningUpsertOne{
		create: ssc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.SecurityScanning.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (ssc *SecurityScanningCreate) OnConflictColumns(columns ...string) *SecurityScanningUpsertOne {
	ssc.conflict = append(ssc.conflict, sql.ConflictColumns(columns...))
	return &SecurityScanningUpsertOne{
		create: ssc,
	}
}

type (
	// SecurityScanningUpsertOne is the builder for "upsert"-ing
	//  one SecurityScanning node.
	SecurityScanningUpsertOne struct {
		create *SecurityScanningCreate
	}

	// SecurityScanningUpsert is the "OnConflict" setter.
	SecurityScanningUpsert struct {
		*sql.UpdateSet
	}
)

// SetUserID sets the "user_id" field.
func (u *SecurityScanningUpsert) SetUserID(v uuid.UUID) *SecurityScanningUpsert {
	u.Set(securityscanning.FieldUserID, v)
	return u
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *SecurityScanningUpsert) UpdateUserID() *SecurityScanningUpsert {
	u.SetExcluded(securityscanning.FieldUserID)
	return u
}

// SetWorkspaceID sets the "workspace_id" field.
func (u *SecurityScanningUpsert) SetWorkspaceID(v uuid.UUID) *SecurityScanningUpsert {
	u.Set(securityscanning.FieldWorkspaceID, v)
	return u
}

// UpdateWorkspaceID sets the "workspace_id" field to the value that was provided on create.
func (u *SecurityScanningUpsert) UpdateWorkspaceID() *SecurityScanningUpsert {
	u.SetExcluded(securityscanning.FieldWorkspaceID)
	return u
}

// SetStatus sets the "status" field.
func (u *SecurityScanningUpsert) SetStatus(v consts.SecurityScanningStatus) *SecurityScanningUpsert {
	u.Set(securityscanning.FieldStatus, v)
	return u
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *SecurityScanningUpsert) UpdateStatus() *SecurityScanningUpsert {
	u.SetExcluded(securityscanning.FieldStatus)
	return u
}

// SetWorkspace sets the "workspace" field.
func (u *SecurityScanningUpsert) SetWorkspace(v string) *SecurityScanningUpsert {
	u.Set(securityscanning.FieldWorkspace, v)
	return u
}

// UpdateWorkspace sets the "workspace" field to the value that was provided on create.
func (u *SecurityScanningUpsert) UpdateWorkspace() *SecurityScanningUpsert {
	u.SetExcluded(securityscanning.FieldWorkspace)
	return u
}

// SetLanguage sets the "language" field.
func (u *SecurityScanningUpsert) SetLanguage(v consts.SecurityScanningLanguage) *SecurityScanningUpsert {
	u.Set(securityscanning.FieldLanguage, v)
	return u
}

// UpdateLanguage sets the "language" field to the value that was provided on create.
func (u *SecurityScanningUpsert) UpdateLanguage() *SecurityScanningUpsert {
	u.SetExcluded(securityscanning.FieldLanguage)
	return u
}

// SetRule sets the "rule" field.
func (u *SecurityScanningUpsert) SetRule(v string) *SecurityScanningUpsert {
	u.Set(securityscanning.FieldRule, v)
	return u
}

// UpdateRule sets the "rule" field to the value that was provided on create.
func (u *SecurityScanningUpsert) UpdateRule() *SecurityScanningUpsert {
	u.SetExcluded(securityscanning.FieldRule)
	return u
}

// ClearRule clears the value of the "rule" field.
func (u *SecurityScanningUpsert) ClearRule() *SecurityScanningUpsert {
	u.SetNull(securityscanning.FieldRule)
	return u
}

// SetErrorMessage sets the "error_message" field.
func (u *SecurityScanningUpsert) SetErrorMessage(v string) *SecurityScanningUpsert {
	u.Set(securityscanning.FieldErrorMessage, v)
	return u
}

// UpdateErrorMessage sets the "error_message" field to the value that was provided on create.
func (u *SecurityScanningUpsert) UpdateErrorMessage() *SecurityScanningUpsert {
	u.SetExcluded(securityscanning.FieldErrorMessage)
	return u
}

// ClearErrorMessage clears the value of the "error_message" field.
func (u *SecurityScanningUpsert) ClearErrorMessage() *SecurityScanningUpsert {
	u.SetNull(securityscanning.FieldErrorMessage)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *SecurityScanningUpsert) SetCreatedAt(v time.Time) *SecurityScanningUpsert {
	u.Set(securityscanning.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *SecurityScanningUpsert) UpdateCreatedAt() *SecurityScanningUpsert {
	u.SetExcluded(securityscanning.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *SecurityScanningUpsert) SetUpdatedAt(v time.Time) *SecurityScanningUpsert {
	u.Set(securityscanning.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *SecurityScanningUpsert) UpdateUpdatedAt() *SecurityScanningUpsert {
	u.SetExcluded(securityscanning.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.SecurityScanning.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(securityscanning.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *SecurityScanningUpsertOne) UpdateNewValues() *SecurityScanningUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(securityscanning.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.SecurityScanning.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *SecurityScanningUpsertOne) Ignore() *SecurityScanningUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *SecurityScanningUpsertOne) DoNothing() *SecurityScanningUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the SecurityScanningCreate.OnConflict
// documentation for more info.
func (u *SecurityScanningUpsertOne) Update(set func(*SecurityScanningUpsert)) *SecurityScanningUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&SecurityScanningUpsert{UpdateSet: update})
	}))
	return u
}

// SetUserID sets the "user_id" field.
func (u *SecurityScanningUpsertOne) SetUserID(v uuid.UUID) *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *SecurityScanningUpsertOne) UpdateUserID() *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateUserID()
	})
}

// SetWorkspaceID sets the "workspace_id" field.
func (u *SecurityScanningUpsertOne) SetWorkspaceID(v uuid.UUID) *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetWorkspaceID(v)
	})
}

// UpdateWorkspaceID sets the "workspace_id" field to the value that was provided on create.
func (u *SecurityScanningUpsertOne) UpdateWorkspaceID() *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateWorkspaceID()
	})
}

// SetStatus sets the "status" field.
func (u *SecurityScanningUpsertOne) SetStatus(v consts.SecurityScanningStatus) *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetStatus(v)
	})
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *SecurityScanningUpsertOne) UpdateStatus() *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateStatus()
	})
}

// SetWorkspace sets the "workspace" field.
func (u *SecurityScanningUpsertOne) SetWorkspace(v string) *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetWorkspace(v)
	})
}

// UpdateWorkspace sets the "workspace" field to the value that was provided on create.
func (u *SecurityScanningUpsertOne) UpdateWorkspace() *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateWorkspace()
	})
}

// SetLanguage sets the "language" field.
func (u *SecurityScanningUpsertOne) SetLanguage(v consts.SecurityScanningLanguage) *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetLanguage(v)
	})
}

// UpdateLanguage sets the "language" field to the value that was provided on create.
func (u *SecurityScanningUpsertOne) UpdateLanguage() *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateLanguage()
	})
}

// SetRule sets the "rule" field.
func (u *SecurityScanningUpsertOne) SetRule(v string) *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetRule(v)
	})
}

// UpdateRule sets the "rule" field to the value that was provided on create.
func (u *SecurityScanningUpsertOne) UpdateRule() *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateRule()
	})
}

// ClearRule clears the value of the "rule" field.
func (u *SecurityScanningUpsertOne) ClearRule() *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.ClearRule()
	})
}

// SetErrorMessage sets the "error_message" field.
func (u *SecurityScanningUpsertOne) SetErrorMessage(v string) *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetErrorMessage(v)
	})
}

// UpdateErrorMessage sets the "error_message" field to the value that was provided on create.
func (u *SecurityScanningUpsertOne) UpdateErrorMessage() *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateErrorMessage()
	})
}

// ClearErrorMessage clears the value of the "error_message" field.
func (u *SecurityScanningUpsertOne) ClearErrorMessage() *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.ClearErrorMessage()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *SecurityScanningUpsertOne) SetCreatedAt(v time.Time) *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *SecurityScanningUpsertOne) UpdateCreatedAt() *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *SecurityScanningUpsertOne) SetUpdatedAt(v time.Time) *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *SecurityScanningUpsertOne) UpdateUpdatedAt() *SecurityScanningUpsertOne {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *SecurityScanningUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for SecurityScanningCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *SecurityScanningUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *SecurityScanningUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: SecurityScanningUpsertOne.ID is not supported by MySQL driver. Use SecurityScanningUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *SecurityScanningUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// SecurityScanningCreateBulk is the builder for creating many SecurityScanning entities in bulk.
type SecurityScanningCreateBulk struct {
	config
	err      error
	builders []*SecurityScanningCreate
	conflict []sql.ConflictOption
}

// Save creates the SecurityScanning entities in the database.
func (sscb *SecurityScanningCreateBulk) Save(ctx context.Context) ([]*SecurityScanning, error) {
	if sscb.err != nil {
		return nil, sscb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(sscb.builders))
	nodes := make([]*SecurityScanning, len(sscb.builders))
	mutators := make([]Mutator, len(sscb.builders))
	for i := range sscb.builders {
		func(i int, root context.Context) {
			builder := sscb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*SecurityScanningMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, sscb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = sscb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, sscb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, sscb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (sscb *SecurityScanningCreateBulk) SaveX(ctx context.Context) []*SecurityScanning {
	v, err := sscb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (sscb *SecurityScanningCreateBulk) Exec(ctx context.Context) error {
	_, err := sscb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (sscb *SecurityScanningCreateBulk) ExecX(ctx context.Context) {
	if err := sscb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.SecurityScanning.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.SecurityScanningUpsert) {
//			SetUserID(v+v).
//		}).
//		Exec(ctx)
func (sscb *SecurityScanningCreateBulk) OnConflict(opts ...sql.ConflictOption) *SecurityScanningUpsertBulk {
	sscb.conflict = opts
	return &SecurityScanningUpsertBulk{
		create: sscb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.SecurityScanning.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (sscb *SecurityScanningCreateBulk) OnConflictColumns(columns ...string) *SecurityScanningUpsertBulk {
	sscb.conflict = append(sscb.conflict, sql.ConflictColumns(columns...))
	return &SecurityScanningUpsertBulk{
		create: sscb,
	}
}

// SecurityScanningUpsertBulk is the builder for "upsert"-ing
// a bulk of SecurityScanning nodes.
type SecurityScanningUpsertBulk struct {
	create *SecurityScanningCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.SecurityScanning.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(securityscanning.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *SecurityScanningUpsertBulk) UpdateNewValues() *SecurityScanningUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(securityscanning.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.SecurityScanning.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *SecurityScanningUpsertBulk) Ignore() *SecurityScanningUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *SecurityScanningUpsertBulk) DoNothing() *SecurityScanningUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the SecurityScanningCreateBulk.OnConflict
// documentation for more info.
func (u *SecurityScanningUpsertBulk) Update(set func(*SecurityScanningUpsert)) *SecurityScanningUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&SecurityScanningUpsert{UpdateSet: update})
	}))
	return u
}

// SetUserID sets the "user_id" field.
func (u *SecurityScanningUpsertBulk) SetUserID(v uuid.UUID) *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *SecurityScanningUpsertBulk) UpdateUserID() *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateUserID()
	})
}

// SetWorkspaceID sets the "workspace_id" field.
func (u *SecurityScanningUpsertBulk) SetWorkspaceID(v uuid.UUID) *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetWorkspaceID(v)
	})
}

// UpdateWorkspaceID sets the "workspace_id" field to the value that was provided on create.
func (u *SecurityScanningUpsertBulk) UpdateWorkspaceID() *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateWorkspaceID()
	})
}

// SetStatus sets the "status" field.
func (u *SecurityScanningUpsertBulk) SetStatus(v consts.SecurityScanningStatus) *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetStatus(v)
	})
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *SecurityScanningUpsertBulk) UpdateStatus() *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateStatus()
	})
}

// SetWorkspace sets the "workspace" field.
func (u *SecurityScanningUpsertBulk) SetWorkspace(v string) *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetWorkspace(v)
	})
}

// UpdateWorkspace sets the "workspace" field to the value that was provided on create.
func (u *SecurityScanningUpsertBulk) UpdateWorkspace() *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateWorkspace()
	})
}

// SetLanguage sets the "language" field.
func (u *SecurityScanningUpsertBulk) SetLanguage(v consts.SecurityScanningLanguage) *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetLanguage(v)
	})
}

// UpdateLanguage sets the "language" field to the value that was provided on create.
func (u *SecurityScanningUpsertBulk) UpdateLanguage() *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateLanguage()
	})
}

// SetRule sets the "rule" field.
func (u *SecurityScanningUpsertBulk) SetRule(v string) *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetRule(v)
	})
}

// UpdateRule sets the "rule" field to the value that was provided on create.
func (u *SecurityScanningUpsertBulk) UpdateRule() *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateRule()
	})
}

// ClearRule clears the value of the "rule" field.
func (u *SecurityScanningUpsertBulk) ClearRule() *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.ClearRule()
	})
}

// SetErrorMessage sets the "error_message" field.
func (u *SecurityScanningUpsertBulk) SetErrorMessage(v string) *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetErrorMessage(v)
	})
}

// UpdateErrorMessage sets the "error_message" field to the value that was provided on create.
func (u *SecurityScanningUpsertBulk) UpdateErrorMessage() *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateErrorMessage()
	})
}

// ClearErrorMessage clears the value of the "error_message" field.
func (u *SecurityScanningUpsertBulk) ClearErrorMessage() *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.ClearErrorMessage()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *SecurityScanningUpsertBulk) SetCreatedAt(v time.Time) *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *SecurityScanningUpsertBulk) UpdateCreatedAt() *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *SecurityScanningUpsertBulk) SetUpdatedAt(v time.Time) *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *SecurityScanningUpsertBulk) UpdateUpdatedAt() *SecurityScanningUpsertBulk {
	return u.Update(func(s *SecurityScanningUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *SecurityScanningUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the SecurityScanningCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for SecurityScanningCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *SecurityScanningUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
