// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanning"
)

// SecurityScanningDelete is the builder for deleting a SecurityScanning entity.
type SecurityScanningDelete struct {
	config
	hooks    []Hook
	mutation *SecurityScanningMutation
}

// Where appends a list predicates to the SecurityScanningDelete builder.
func (ssd *SecurityScanningDelete) Where(ps ...predicate.SecurityScanning) *SecurityScanningDelete {
	ssd.mutation.Where(ps...)
	return ssd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (ssd *SecurityScanningDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, ssd.sqlExec, ssd.mutation, ssd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (ssd *SecurityScanningDelete) ExecX(ctx context.Context) int {
	n, err := ssd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (ssd *SecurityScanningDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(securityscanning.Table, sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID))
	if ps := ssd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, ssd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	ssd.mutation.done = true
	return affected, err
}

// SecurityScanningDeleteOne is the builder for deleting a single SecurityScanning entity.
type SecurityScanningDeleteOne struct {
	ssd *SecurityScanningDelete
}

// Where appends a list predicates to the SecurityScanningDelete builder.
func (ssdo *SecurityScanningDeleteOne) Where(ps ...predicate.SecurityScanning) *SecurityScanningDeleteOne {
	ssdo.ssd.mutation.Where(ps...)
	return ssdo
}

// Exec executes the deletion query.
func (ssdo *SecurityScanningDeleteOne) Exec(ctx context.Context) error {
	n, err := ssdo.ssd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{securityscanning.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (ssdo *SecurityScanningDeleteOne) ExecX(ctx context.Context) {
	if err := ssdo.Exec(ctx); err != nil {
		panic(err)
	}
}
