// Code generated by ent, DO NOT EDIT.

package securityscanningresult

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the securityscanningresult type in the database.
	Label = "security_scanning_result"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldSecurityScanningID holds the string denoting the security_scanning_id field in the database.
	FieldSecurityScanningID = "security_scanning_id"
	// FieldCheckID holds the string denoting the check_id field in the database.
	FieldCheckID = "check_id"
	// FieldEngineKind holds the string denoting the engine_kind field in the database.
	FieldEngineKind = "engine_kind"
	// FieldLines holds the string denoting the lines field in the database.
	FieldLines = "lines"
	// FieldPath holds the string denoting the path field in the database.
	FieldPath = "path"
	// FieldMessage holds the string denoting the message field in the database.
	FieldMessage = "message"
	// FieldMessageZh holds the string denoting the message_zh field in the database.
	FieldMessageZh = "message_zh"
	// FieldSeverity holds the string denoting the severity field in the database.
	FieldSeverity = "severity"
	// FieldAbstractEn holds the string denoting the abstract_en field in the database.
	FieldAbstractEn = "abstract_en"
	// FieldAbstractZh holds the string denoting the abstract_zh field in the database.
	FieldAbstractZh = "abstract_zh"
	// FieldCategoryEn holds the string denoting the category_en field in the database.
	FieldCategoryEn = "category_en"
	// FieldCategoryZh holds the string denoting the category_zh field in the database.
	FieldCategoryZh = "category_zh"
	// FieldConfidence holds the string denoting the confidence field in the database.
	FieldConfidence = "confidence"
	// FieldCwe holds the string denoting the cwe field in the database.
	FieldCwe = "cwe"
	// FieldImpact holds the string denoting the impact field in the database.
	FieldImpact = "impact"
	// FieldOwasp holds the string denoting the owasp field in the database.
	FieldOwasp = "owasp"
	// FieldFileContent holds the string denoting the file_content field in the database.
	FieldFileContent = "file_content"
	// FieldStartPosition holds the string denoting the start_position field in the database.
	FieldStartPosition = "start_position"
	// FieldEndPosition holds the string denoting the end_position field in the database.
	FieldEndPosition = "end_position"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// EdgeSecurityScanning holds the string denoting the security_scanning edge name in mutations.
	EdgeSecurityScanning = "security_scanning"
	// Table holds the table name of the securityscanningresult in the database.
	Table = "security_scanning_results"
	// SecurityScanningTable is the table that holds the security_scanning relation/edge.
	SecurityScanningTable = "security_scanning_results"
	// SecurityScanningInverseTable is the table name for the SecurityScanning entity.
	// It exists in this package in order to avoid circular dependency with the "securityscanning" package.
	SecurityScanningInverseTable = "security_scannings"
	// SecurityScanningColumn is the table column denoting the security_scanning relation/edge.
	SecurityScanningColumn = "security_scanning_id"
)

// Columns holds all SQL columns for securityscanningresult fields.
var Columns = []string{
	FieldID,
	FieldSecurityScanningID,
	FieldCheckID,
	FieldEngineKind,
	FieldLines,
	FieldPath,
	FieldMessage,
	FieldMessageZh,
	FieldSeverity,
	FieldAbstractEn,
	FieldAbstractZh,
	FieldCategoryEn,
	FieldCategoryZh,
	FieldConfidence,
	FieldCwe,
	FieldImpact,
	FieldOwasp,
	FieldFileContent,
	FieldStartPosition,
	FieldEndPosition,
	FieldCreatedAt,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
)

// OrderOption defines the ordering options for the SecurityScanningResult queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// BySecurityScanningID orders the results by the security_scanning_id field.
func BySecurityScanningID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSecurityScanningID, opts...).ToFunc()
}

// ByCheckID orders the results by the check_id field.
func ByCheckID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCheckID, opts...).ToFunc()
}

// ByEngineKind orders the results by the engine_kind field.
func ByEngineKind(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldEngineKind, opts...).ToFunc()
}

// ByLines orders the results by the lines field.
func ByLines(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldLines, opts...).ToFunc()
}

// ByPath orders the results by the path field.
func ByPath(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldPath, opts...).ToFunc()
}

// ByMessage orders the results by the message field.
func ByMessage(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldMessage, opts...).ToFunc()
}

// ByMessageZh orders the results by the message_zh field.
func ByMessageZh(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldMessageZh, opts...).ToFunc()
}

// BySeverity orders the results by the severity field.
func BySeverity(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldSeverity, opts...).ToFunc()
}

// ByAbstractEn orders the results by the abstract_en field.
func ByAbstractEn(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAbstractEn, opts...).ToFunc()
}

// ByAbstractZh orders the results by the abstract_zh field.
func ByAbstractZh(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAbstractZh, opts...).ToFunc()
}

// ByCategoryEn orders the results by the category_en field.
func ByCategoryEn(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCategoryEn, opts...).ToFunc()
}

// ByCategoryZh orders the results by the category_zh field.
func ByCategoryZh(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCategoryZh, opts...).ToFunc()
}

// ByConfidence orders the results by the confidence field.
func ByConfidence(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldConfidence, opts...).ToFunc()
}

// ByImpact orders the results by the impact field.
func ByImpact(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldImpact, opts...).ToFunc()
}

// ByFileContent orders the results by the file_content field.
func ByFileContent(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFileContent, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// BySecurityScanningField orders the results by security_scanning field.
func BySecurityScanningField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newSecurityScanningStep(), sql.OrderByField(field, opts...))
	}
}
func newSecurityScanningStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(SecurityScanningInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, SecurityScanningTable, SecurityScanningColumn),
	)
}
