// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanning"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanningresult"
	"github.com/chaitin/MonkeyCode/backend/ent/types"
	"github.com/google/uuid"
)

// SecurityScanningResultCreate is the builder for creating a SecurityScanningResult entity.
type SecurityScanningResultCreate struct {
	config
	mutation *SecurityScanningResultMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetSecurityScanningID sets the "security_scanning_id" field.
func (ssrc *SecurityScanningResultCreate) SetSecurityScanningID(u uuid.UUID) *SecurityScanningResultCreate {
	ssrc.mutation.SetSecurityScanningID(u)
	return ssrc
}

// SetCheckID sets the "check_id" field.
func (ssrc *SecurityScanningResultCreate) SetCheckID(s string) *SecurityScanningResultCreate {
	ssrc.mutation.SetCheckID(s)
	return ssrc
}

// SetEngineKind sets the "engine_kind" field.
func (ssrc *SecurityScanningResultCreate) SetEngineKind(s string) *SecurityScanningResultCreate {
	ssrc.mutation.SetEngineKind(s)
	return ssrc
}

// SetLines sets the "lines" field.
func (ssrc *SecurityScanningResultCreate) SetLines(s string) *SecurityScanningResultCreate {
	ssrc.mutation.SetLines(s)
	return ssrc
}

// SetPath sets the "path" field.
func (ssrc *SecurityScanningResultCreate) SetPath(s string) *SecurityScanningResultCreate {
	ssrc.mutation.SetPath(s)
	return ssrc
}

// SetMessage sets the "message" field.
func (ssrc *SecurityScanningResultCreate) SetMessage(s string) *SecurityScanningResultCreate {
	ssrc.mutation.SetMessage(s)
	return ssrc
}

// SetMessageZh sets the "message_zh" field.
func (ssrc *SecurityScanningResultCreate) SetMessageZh(s string) *SecurityScanningResultCreate {
	ssrc.mutation.SetMessageZh(s)
	return ssrc
}

// SetSeverity sets the "severity" field.
func (ssrc *SecurityScanningResultCreate) SetSeverity(s string) *SecurityScanningResultCreate {
	ssrc.mutation.SetSeverity(s)
	return ssrc
}

// SetAbstractEn sets the "abstract_en" field.
func (ssrc *SecurityScanningResultCreate) SetAbstractEn(s string) *SecurityScanningResultCreate {
	ssrc.mutation.SetAbstractEn(s)
	return ssrc
}

// SetAbstractZh sets the "abstract_zh" field.
func (ssrc *SecurityScanningResultCreate) SetAbstractZh(s string) *SecurityScanningResultCreate {
	ssrc.mutation.SetAbstractZh(s)
	return ssrc
}

// SetCategoryEn sets the "category_en" field.
func (ssrc *SecurityScanningResultCreate) SetCategoryEn(s string) *SecurityScanningResultCreate {
	ssrc.mutation.SetCategoryEn(s)
	return ssrc
}

// SetCategoryZh sets the "category_zh" field.
func (ssrc *SecurityScanningResultCreate) SetCategoryZh(s string) *SecurityScanningResultCreate {
	ssrc.mutation.SetCategoryZh(s)
	return ssrc
}

// SetConfidence sets the "confidence" field.
func (ssrc *SecurityScanningResultCreate) SetConfidence(s string) *SecurityScanningResultCreate {
	ssrc.mutation.SetConfidence(s)
	return ssrc
}

// SetCwe sets the "cwe" field.
func (ssrc *SecurityScanningResultCreate) SetCwe(i []interface{}) *SecurityScanningResultCreate {
	ssrc.mutation.SetCwe(i)
	return ssrc
}

// SetImpact sets the "impact" field.
func (ssrc *SecurityScanningResultCreate) SetImpact(s string) *SecurityScanningResultCreate {
	ssrc.mutation.SetImpact(s)
	return ssrc
}

// SetOwasp sets the "owasp" field.
func (ssrc *SecurityScanningResultCreate) SetOwasp(i []interface{}) *SecurityScanningResultCreate {
	ssrc.mutation.SetOwasp(i)
	return ssrc
}

// SetFileContent sets the "file_content" field.
func (ssrc *SecurityScanningResultCreate) SetFileContent(s string) *SecurityScanningResultCreate {
	ssrc.mutation.SetFileContent(s)
	return ssrc
}

// SetStartPosition sets the "start_position" field.
func (ssrc *SecurityScanningResultCreate) SetStartPosition(t *types.Position) *SecurityScanningResultCreate {
	ssrc.mutation.SetStartPosition(t)
	return ssrc
}

// SetEndPosition sets the "end_position" field.
func (ssrc *SecurityScanningResultCreate) SetEndPosition(t *types.Position) *SecurityScanningResultCreate {
	ssrc.mutation.SetEndPosition(t)
	return ssrc
}

// SetCreatedAt sets the "created_at" field.
func (ssrc *SecurityScanningResultCreate) SetCreatedAt(t time.Time) *SecurityScanningResultCreate {
	ssrc.mutation.SetCreatedAt(t)
	return ssrc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ssrc *SecurityScanningResultCreate) SetNillableCreatedAt(t *time.Time) *SecurityScanningResultCreate {
	if t != nil {
		ssrc.SetCreatedAt(*t)
	}
	return ssrc
}

// SetID sets the "id" field.
func (ssrc *SecurityScanningResultCreate) SetID(u uuid.UUID) *SecurityScanningResultCreate {
	ssrc.mutation.SetID(u)
	return ssrc
}

// SetSecurityScanning sets the "security_scanning" edge to the SecurityScanning entity.
func (ssrc *SecurityScanningResultCreate) SetSecurityScanning(s *SecurityScanning) *SecurityScanningResultCreate {
	return ssrc.SetSecurityScanningID(s.ID)
}

// Mutation returns the SecurityScanningResultMutation object of the builder.
func (ssrc *SecurityScanningResultCreate) Mutation() *SecurityScanningResultMutation {
	return ssrc.mutation
}

// Save creates the SecurityScanningResult in the database.
func (ssrc *SecurityScanningResultCreate) Save(ctx context.Context) (*SecurityScanningResult, error) {
	ssrc.defaults()
	return withHooks(ctx, ssrc.sqlSave, ssrc.mutation, ssrc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (ssrc *SecurityScanningResultCreate) SaveX(ctx context.Context) *SecurityScanningResult {
	v, err := ssrc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (ssrc *SecurityScanningResultCreate) Exec(ctx context.Context) error {
	_, err := ssrc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ssrc *SecurityScanningResultCreate) ExecX(ctx context.Context) {
	if err := ssrc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (ssrc *SecurityScanningResultCreate) defaults() {
	if _, ok := ssrc.mutation.CreatedAt(); !ok {
		v := securityscanningresult.DefaultCreatedAt()
		ssrc.mutation.SetCreatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ssrc *SecurityScanningResultCreate) check() error {
	if _, ok := ssrc.mutation.SecurityScanningID(); !ok {
		return &ValidationError{Name: "security_scanning_id", err: errors.New(`db: missing required field "SecurityScanningResult.security_scanning_id"`)}
	}
	if _, ok := ssrc.mutation.CheckID(); !ok {
		return &ValidationError{Name: "check_id", err: errors.New(`db: missing required field "SecurityScanningResult.check_id"`)}
	}
	if _, ok := ssrc.mutation.EngineKind(); !ok {
		return &ValidationError{Name: "engine_kind", err: errors.New(`db: missing required field "SecurityScanningResult.engine_kind"`)}
	}
	if _, ok := ssrc.mutation.Lines(); !ok {
		return &ValidationError{Name: "lines", err: errors.New(`db: missing required field "SecurityScanningResult.lines"`)}
	}
	if _, ok := ssrc.mutation.Path(); !ok {
		return &ValidationError{Name: "path", err: errors.New(`db: missing required field "SecurityScanningResult.path"`)}
	}
	if _, ok := ssrc.mutation.Message(); !ok {
		return &ValidationError{Name: "message", err: errors.New(`db: missing required field "SecurityScanningResult.message"`)}
	}
	if _, ok := ssrc.mutation.MessageZh(); !ok {
		return &ValidationError{Name: "message_zh", err: errors.New(`db: missing required field "SecurityScanningResult.message_zh"`)}
	}
	if _, ok := ssrc.mutation.Severity(); !ok {
		return &ValidationError{Name: "severity", err: errors.New(`db: missing required field "SecurityScanningResult.severity"`)}
	}
	if _, ok := ssrc.mutation.AbstractEn(); !ok {
		return &ValidationError{Name: "abstract_en", err: errors.New(`db: missing required field "SecurityScanningResult.abstract_en"`)}
	}
	if _, ok := ssrc.mutation.AbstractZh(); !ok {
		return &ValidationError{Name: "abstract_zh", err: errors.New(`db: missing required field "SecurityScanningResult.abstract_zh"`)}
	}
	if _, ok := ssrc.mutation.CategoryEn(); !ok {
		return &ValidationError{Name: "category_en", err: errors.New(`db: missing required field "SecurityScanningResult.category_en"`)}
	}
	if _, ok := ssrc.mutation.CategoryZh(); !ok {
		return &ValidationError{Name: "category_zh", err: errors.New(`db: missing required field "SecurityScanningResult.category_zh"`)}
	}
	if _, ok := ssrc.mutation.Confidence(); !ok {
		return &ValidationError{Name: "confidence", err: errors.New(`db: missing required field "SecurityScanningResult.confidence"`)}
	}
	if _, ok := ssrc.mutation.Cwe(); !ok {
		return &ValidationError{Name: "cwe", err: errors.New(`db: missing required field "SecurityScanningResult.cwe"`)}
	}
	if _, ok := ssrc.mutation.Impact(); !ok {
		return &ValidationError{Name: "impact", err: errors.New(`db: missing required field "SecurityScanningResult.impact"`)}
	}
	if _, ok := ssrc.mutation.Owasp(); !ok {
		return &ValidationError{Name: "owasp", err: errors.New(`db: missing required field "SecurityScanningResult.owasp"`)}
	}
	if _, ok := ssrc.mutation.FileContent(); !ok {
		return &ValidationError{Name: "file_content", err: errors.New(`db: missing required field "SecurityScanningResult.file_content"`)}
	}
	if _, ok := ssrc.mutation.StartPosition(); !ok {
		return &ValidationError{Name: "start_position", err: errors.New(`db: missing required field "SecurityScanningResult.start_position"`)}
	}
	if _, ok := ssrc.mutation.EndPosition(); !ok {
		return &ValidationError{Name: "end_position", err: errors.New(`db: missing required field "SecurityScanningResult.end_position"`)}
	}
	if _, ok := ssrc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "SecurityScanningResult.created_at"`)}
	}
	if len(ssrc.mutation.SecurityScanningIDs()) == 0 {
		return &ValidationError{Name: "security_scanning", err: errors.New(`db: missing required edge "SecurityScanningResult.security_scanning"`)}
	}
	return nil
}

func (ssrc *SecurityScanningResultCreate) sqlSave(ctx context.Context) (*SecurityScanningResult, error) {
	if err := ssrc.check(); err != nil {
		return nil, err
	}
	_node, _spec := ssrc.createSpec()
	if err := sqlgraph.CreateNode(ctx, ssrc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	ssrc.mutation.id = &_node.ID
	ssrc.mutation.done = true
	return _node, nil
}

func (ssrc *SecurityScanningResultCreate) createSpec() (*SecurityScanningResult, *sqlgraph.CreateSpec) {
	var (
		_node = &SecurityScanningResult{config: ssrc.config}
		_spec = sqlgraph.NewCreateSpec(securityscanningresult.Table, sqlgraph.NewFieldSpec(securityscanningresult.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = ssrc.conflict
	if id, ok := ssrc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := ssrc.mutation.CheckID(); ok {
		_spec.SetField(securityscanningresult.FieldCheckID, field.TypeString, value)
		_node.CheckID = value
	}
	if value, ok := ssrc.mutation.EngineKind(); ok {
		_spec.SetField(securityscanningresult.FieldEngineKind, field.TypeString, value)
		_node.EngineKind = value
	}
	if value, ok := ssrc.mutation.Lines(); ok {
		_spec.SetField(securityscanningresult.FieldLines, field.TypeString, value)
		_node.Lines = value
	}
	if value, ok := ssrc.mutation.Path(); ok {
		_spec.SetField(securityscanningresult.FieldPath, field.TypeString, value)
		_node.Path = value
	}
	if value, ok := ssrc.mutation.Message(); ok {
		_spec.SetField(securityscanningresult.FieldMessage, field.TypeString, value)
		_node.Message = value
	}
	if value, ok := ssrc.mutation.MessageZh(); ok {
		_spec.SetField(securityscanningresult.FieldMessageZh, field.TypeString, value)
		_node.MessageZh = value
	}
	if value, ok := ssrc.mutation.Severity(); ok {
		_spec.SetField(securityscanningresult.FieldSeverity, field.TypeString, value)
		_node.Severity = value
	}
	if value, ok := ssrc.mutation.AbstractEn(); ok {
		_spec.SetField(securityscanningresult.FieldAbstractEn, field.TypeString, value)
		_node.AbstractEn = value
	}
	if value, ok := ssrc.mutation.AbstractZh(); ok {
		_spec.SetField(securityscanningresult.FieldAbstractZh, field.TypeString, value)
		_node.AbstractZh = value
	}
	if value, ok := ssrc.mutation.CategoryEn(); ok {
		_spec.SetField(securityscanningresult.FieldCategoryEn, field.TypeString, value)
		_node.CategoryEn = value
	}
	if value, ok := ssrc.mutation.CategoryZh(); ok {
		_spec.SetField(securityscanningresult.FieldCategoryZh, field.TypeString, value)
		_node.CategoryZh = value
	}
	if value, ok := ssrc.mutation.Confidence(); ok {
		_spec.SetField(securityscanningresult.FieldConfidence, field.TypeString, value)
		_node.Confidence = value
	}
	if value, ok := ssrc.mutation.Cwe(); ok {
		_spec.SetField(securityscanningresult.FieldCwe, field.TypeJSON, value)
		_node.Cwe = value
	}
	if value, ok := ssrc.mutation.Impact(); ok {
		_spec.SetField(securityscanningresult.FieldImpact, field.TypeString, value)
		_node.Impact = value
	}
	if value, ok := ssrc.mutation.Owasp(); ok {
		_spec.SetField(securityscanningresult.FieldOwasp, field.TypeJSON, value)
		_node.Owasp = value
	}
	if value, ok := ssrc.mutation.FileContent(); ok {
		_spec.SetField(securityscanningresult.FieldFileContent, field.TypeString, value)
		_node.FileContent = value
	}
	if value, ok := ssrc.mutation.StartPosition(); ok {
		_spec.SetField(securityscanningresult.FieldStartPosition, field.TypeJSON, value)
		_node.StartPosition = value
	}
	if value, ok := ssrc.mutation.EndPosition(); ok {
		_spec.SetField(securityscanningresult.FieldEndPosition, field.TypeJSON, value)
		_node.EndPosition = value
	}
	if value, ok := ssrc.mutation.CreatedAt(); ok {
		_spec.SetField(securityscanningresult.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if nodes := ssrc.mutation.SecurityScanningIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanningresult.SecurityScanningTable,
			Columns: []string{securityscanningresult.SecurityScanningColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.SecurityScanningID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.SecurityScanningResult.Create().
//		SetSecurityScanningID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.SecurityScanningResultUpsert) {
//			SetSecurityScanningID(v+v).
//		}).
//		Exec(ctx)
func (ssrc *SecurityScanningResultCreate) OnConflict(opts ...sql.ConflictOption) *SecurityScanningResultUpsertOne {
	ssrc.conflict = opts
	return &SecurityScanningResultUpsertOne{
		create: ssrc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.SecurityScanningResult.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (ssrc *SecurityScanningResultCreate) OnConflictColumns(columns ...string) *SecurityScanningResultUpsertOne {
	ssrc.conflict = append(ssrc.conflict, sql.ConflictColumns(columns...))
	return &SecurityScanningResultUpsertOne{
		create: ssrc,
	}
}

type (
	// SecurityScanningResultUpsertOne is the builder for "upsert"-ing
	//  one SecurityScanningResult node.
	SecurityScanningResultUpsertOne struct {
		create *SecurityScanningResultCreate
	}

	// SecurityScanningResultUpsert is the "OnConflict" setter.
	SecurityScanningResultUpsert struct {
		*sql.UpdateSet
	}
)

// SetSecurityScanningID sets the "security_scanning_id" field.
func (u *SecurityScanningResultUpsert) SetSecurityScanningID(v uuid.UUID) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldSecurityScanningID, v)
	return u
}

// UpdateSecurityScanningID sets the "security_scanning_id" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateSecurityScanningID() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldSecurityScanningID)
	return u
}

// SetCheckID sets the "check_id" field.
func (u *SecurityScanningResultUpsert) SetCheckID(v string) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldCheckID, v)
	return u
}

// UpdateCheckID sets the "check_id" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateCheckID() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldCheckID)
	return u
}

// SetEngineKind sets the "engine_kind" field.
func (u *SecurityScanningResultUpsert) SetEngineKind(v string) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldEngineKind, v)
	return u
}

// UpdateEngineKind sets the "engine_kind" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateEngineKind() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldEngineKind)
	return u
}

// SetLines sets the "lines" field.
func (u *SecurityScanningResultUpsert) SetLines(v string) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldLines, v)
	return u
}

// UpdateLines sets the "lines" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateLines() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldLines)
	return u
}

// SetPath sets the "path" field.
func (u *SecurityScanningResultUpsert) SetPath(v string) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldPath, v)
	return u
}

// UpdatePath sets the "path" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdatePath() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldPath)
	return u
}

// SetMessage sets the "message" field.
func (u *SecurityScanningResultUpsert) SetMessage(v string) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldMessage, v)
	return u
}

// UpdateMessage sets the "message" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateMessage() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldMessage)
	return u
}

// SetMessageZh sets the "message_zh" field.
func (u *SecurityScanningResultUpsert) SetMessageZh(v string) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldMessageZh, v)
	return u
}

// UpdateMessageZh sets the "message_zh" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateMessageZh() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldMessageZh)
	return u
}

// SetSeverity sets the "severity" field.
func (u *SecurityScanningResultUpsert) SetSeverity(v string) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldSeverity, v)
	return u
}

// UpdateSeverity sets the "severity" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateSeverity() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldSeverity)
	return u
}

// SetAbstractEn sets the "abstract_en" field.
func (u *SecurityScanningResultUpsert) SetAbstractEn(v string) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldAbstractEn, v)
	return u
}

// UpdateAbstractEn sets the "abstract_en" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateAbstractEn() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldAbstractEn)
	return u
}

// SetAbstractZh sets the "abstract_zh" field.
func (u *SecurityScanningResultUpsert) SetAbstractZh(v string) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldAbstractZh, v)
	return u
}

// UpdateAbstractZh sets the "abstract_zh" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateAbstractZh() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldAbstractZh)
	return u
}

// SetCategoryEn sets the "category_en" field.
func (u *SecurityScanningResultUpsert) SetCategoryEn(v string) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldCategoryEn, v)
	return u
}

// UpdateCategoryEn sets the "category_en" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateCategoryEn() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldCategoryEn)
	return u
}

// SetCategoryZh sets the "category_zh" field.
func (u *SecurityScanningResultUpsert) SetCategoryZh(v string) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldCategoryZh, v)
	return u
}

// UpdateCategoryZh sets the "category_zh" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateCategoryZh() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldCategoryZh)
	return u
}

// SetConfidence sets the "confidence" field.
func (u *SecurityScanningResultUpsert) SetConfidence(v string) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldConfidence, v)
	return u
}

// UpdateConfidence sets the "confidence" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateConfidence() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldConfidence)
	return u
}

// SetCwe sets the "cwe" field.
func (u *SecurityScanningResultUpsert) SetCwe(v []interface{}) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldCwe, v)
	return u
}

// UpdateCwe sets the "cwe" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateCwe() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldCwe)
	return u
}

// SetImpact sets the "impact" field.
func (u *SecurityScanningResultUpsert) SetImpact(v string) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldImpact, v)
	return u
}

// UpdateImpact sets the "impact" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateImpact() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldImpact)
	return u
}

// SetOwasp sets the "owasp" field.
func (u *SecurityScanningResultUpsert) SetOwasp(v []interface{}) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldOwasp, v)
	return u
}

// UpdateOwasp sets the "owasp" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateOwasp() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldOwasp)
	return u
}

// SetFileContent sets the "file_content" field.
func (u *SecurityScanningResultUpsert) SetFileContent(v string) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldFileContent, v)
	return u
}

// UpdateFileContent sets the "file_content" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateFileContent() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldFileContent)
	return u
}

// SetStartPosition sets the "start_position" field.
func (u *SecurityScanningResultUpsert) SetStartPosition(v *types.Position) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldStartPosition, v)
	return u
}

// UpdateStartPosition sets the "start_position" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateStartPosition() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldStartPosition)
	return u
}

// SetEndPosition sets the "end_position" field.
func (u *SecurityScanningResultUpsert) SetEndPosition(v *types.Position) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldEndPosition, v)
	return u
}

// UpdateEndPosition sets the "end_position" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateEndPosition() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldEndPosition)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *SecurityScanningResultUpsert) SetCreatedAt(v time.Time) *SecurityScanningResultUpsert {
	u.Set(securityscanningresult.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *SecurityScanningResultUpsert) UpdateCreatedAt() *SecurityScanningResultUpsert {
	u.SetExcluded(securityscanningresult.FieldCreatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.SecurityScanningResult.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(securityscanningresult.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *SecurityScanningResultUpsertOne) UpdateNewValues() *SecurityScanningResultUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(securityscanningresult.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.SecurityScanningResult.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *SecurityScanningResultUpsertOne) Ignore() *SecurityScanningResultUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *SecurityScanningResultUpsertOne) DoNothing() *SecurityScanningResultUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the SecurityScanningResultCreate.OnConflict
// documentation for more info.
func (u *SecurityScanningResultUpsertOne) Update(set func(*SecurityScanningResultUpsert)) *SecurityScanningResultUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&SecurityScanningResultUpsert{UpdateSet: update})
	}))
	return u
}

// SetSecurityScanningID sets the "security_scanning_id" field.
func (u *SecurityScanningResultUpsertOne) SetSecurityScanningID(v uuid.UUID) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetSecurityScanningID(v)
	})
}

// UpdateSecurityScanningID sets the "security_scanning_id" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateSecurityScanningID() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateSecurityScanningID()
	})
}

// SetCheckID sets the "check_id" field.
func (u *SecurityScanningResultUpsertOne) SetCheckID(v string) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetCheckID(v)
	})
}

// UpdateCheckID sets the "check_id" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateCheckID() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateCheckID()
	})
}

// SetEngineKind sets the "engine_kind" field.
func (u *SecurityScanningResultUpsertOne) SetEngineKind(v string) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetEngineKind(v)
	})
}

// UpdateEngineKind sets the "engine_kind" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateEngineKind() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateEngineKind()
	})
}

// SetLines sets the "lines" field.
func (u *SecurityScanningResultUpsertOne) SetLines(v string) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetLines(v)
	})
}

// UpdateLines sets the "lines" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateLines() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateLines()
	})
}

// SetPath sets the "path" field.
func (u *SecurityScanningResultUpsertOne) SetPath(v string) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetPath(v)
	})
}

// UpdatePath sets the "path" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdatePath() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdatePath()
	})
}

// SetMessage sets the "message" field.
func (u *SecurityScanningResultUpsertOne) SetMessage(v string) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetMessage(v)
	})
}

// UpdateMessage sets the "message" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateMessage() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateMessage()
	})
}

// SetMessageZh sets the "message_zh" field.
func (u *SecurityScanningResultUpsertOne) SetMessageZh(v string) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetMessageZh(v)
	})
}

// UpdateMessageZh sets the "message_zh" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateMessageZh() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateMessageZh()
	})
}

// SetSeverity sets the "severity" field.
func (u *SecurityScanningResultUpsertOne) SetSeverity(v string) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetSeverity(v)
	})
}

// UpdateSeverity sets the "severity" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateSeverity() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateSeverity()
	})
}

// SetAbstractEn sets the "abstract_en" field.
func (u *SecurityScanningResultUpsertOne) SetAbstractEn(v string) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetAbstractEn(v)
	})
}

// UpdateAbstractEn sets the "abstract_en" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateAbstractEn() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateAbstractEn()
	})
}

// SetAbstractZh sets the "abstract_zh" field.
func (u *SecurityScanningResultUpsertOne) SetAbstractZh(v string) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetAbstractZh(v)
	})
}

// UpdateAbstractZh sets the "abstract_zh" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateAbstractZh() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateAbstractZh()
	})
}

// SetCategoryEn sets the "category_en" field.
func (u *SecurityScanningResultUpsertOne) SetCategoryEn(v string) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetCategoryEn(v)
	})
}

// UpdateCategoryEn sets the "category_en" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateCategoryEn() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateCategoryEn()
	})
}

// SetCategoryZh sets the "category_zh" field.
func (u *SecurityScanningResultUpsertOne) SetCategoryZh(v string) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetCategoryZh(v)
	})
}

// UpdateCategoryZh sets the "category_zh" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateCategoryZh() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateCategoryZh()
	})
}

// SetConfidence sets the "confidence" field.
func (u *SecurityScanningResultUpsertOne) SetConfidence(v string) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetConfidence(v)
	})
}

// UpdateConfidence sets the "confidence" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateConfidence() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateConfidence()
	})
}

// SetCwe sets the "cwe" field.
func (u *SecurityScanningResultUpsertOne) SetCwe(v []interface{}) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetCwe(v)
	})
}

// UpdateCwe sets the "cwe" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateCwe() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateCwe()
	})
}

// SetImpact sets the "impact" field.
func (u *SecurityScanningResultUpsertOne) SetImpact(v string) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetImpact(v)
	})
}

// UpdateImpact sets the "impact" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateImpact() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateImpact()
	})
}

// SetOwasp sets the "owasp" field.
func (u *SecurityScanningResultUpsertOne) SetOwasp(v []interface{}) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetOwasp(v)
	})
}

// UpdateOwasp sets the "owasp" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateOwasp() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateOwasp()
	})
}

// SetFileContent sets the "file_content" field.
func (u *SecurityScanningResultUpsertOne) SetFileContent(v string) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetFileContent(v)
	})
}

// UpdateFileContent sets the "file_content" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateFileContent() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateFileContent()
	})
}

// SetStartPosition sets the "start_position" field.
func (u *SecurityScanningResultUpsertOne) SetStartPosition(v *types.Position) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetStartPosition(v)
	})
}

// UpdateStartPosition sets the "start_position" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateStartPosition() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateStartPosition()
	})
}

// SetEndPosition sets the "end_position" field.
func (u *SecurityScanningResultUpsertOne) SetEndPosition(v *types.Position) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetEndPosition(v)
	})
}

// UpdateEndPosition sets the "end_position" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateEndPosition() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateEndPosition()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *SecurityScanningResultUpsertOne) SetCreatedAt(v time.Time) *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertOne) UpdateCreatedAt() *SecurityScanningResultUpsertOne {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateCreatedAt()
	})
}

// Exec executes the query.
func (u *SecurityScanningResultUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for SecurityScanningResultCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *SecurityScanningResultUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *SecurityScanningResultUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: SecurityScanningResultUpsertOne.ID is not supported by MySQL driver. Use SecurityScanningResultUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *SecurityScanningResultUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// SecurityScanningResultCreateBulk is the builder for creating many SecurityScanningResult entities in bulk.
type SecurityScanningResultCreateBulk struct {
	config
	err      error
	builders []*SecurityScanningResultCreate
	conflict []sql.ConflictOption
}

// Save creates the SecurityScanningResult entities in the database.
func (ssrcb *SecurityScanningResultCreateBulk) Save(ctx context.Context) ([]*SecurityScanningResult, error) {
	if ssrcb.err != nil {
		return nil, ssrcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(ssrcb.builders))
	nodes := make([]*SecurityScanningResult, len(ssrcb.builders))
	mutators := make([]Mutator, len(ssrcb.builders))
	for i := range ssrcb.builders {
		func(i int, root context.Context) {
			builder := ssrcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*SecurityScanningResultMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, ssrcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = ssrcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, ssrcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, ssrcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (ssrcb *SecurityScanningResultCreateBulk) SaveX(ctx context.Context) []*SecurityScanningResult {
	v, err := ssrcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (ssrcb *SecurityScanningResultCreateBulk) Exec(ctx context.Context) error {
	_, err := ssrcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ssrcb *SecurityScanningResultCreateBulk) ExecX(ctx context.Context) {
	if err := ssrcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.SecurityScanningResult.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.SecurityScanningResultUpsert) {
//			SetSecurityScanningID(v+v).
//		}).
//		Exec(ctx)
func (ssrcb *SecurityScanningResultCreateBulk) OnConflict(opts ...sql.ConflictOption) *SecurityScanningResultUpsertBulk {
	ssrcb.conflict = opts
	return &SecurityScanningResultUpsertBulk{
		create: ssrcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.SecurityScanningResult.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (ssrcb *SecurityScanningResultCreateBulk) OnConflictColumns(columns ...string) *SecurityScanningResultUpsertBulk {
	ssrcb.conflict = append(ssrcb.conflict, sql.ConflictColumns(columns...))
	return &SecurityScanningResultUpsertBulk{
		create: ssrcb,
	}
}

// SecurityScanningResultUpsertBulk is the builder for "upsert"-ing
// a bulk of SecurityScanningResult nodes.
type SecurityScanningResultUpsertBulk struct {
	create *SecurityScanningResultCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.SecurityScanningResult.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(securityscanningresult.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *SecurityScanningResultUpsertBulk) UpdateNewValues() *SecurityScanningResultUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(securityscanningresult.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.SecurityScanningResult.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *SecurityScanningResultUpsertBulk) Ignore() *SecurityScanningResultUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *SecurityScanningResultUpsertBulk) DoNothing() *SecurityScanningResultUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the SecurityScanningResultCreateBulk.OnConflict
// documentation for more info.
func (u *SecurityScanningResultUpsertBulk) Update(set func(*SecurityScanningResultUpsert)) *SecurityScanningResultUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&SecurityScanningResultUpsert{UpdateSet: update})
	}))
	return u
}

// SetSecurityScanningID sets the "security_scanning_id" field.
func (u *SecurityScanningResultUpsertBulk) SetSecurityScanningID(v uuid.UUID) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetSecurityScanningID(v)
	})
}

// UpdateSecurityScanningID sets the "security_scanning_id" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateSecurityScanningID() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateSecurityScanningID()
	})
}

// SetCheckID sets the "check_id" field.
func (u *SecurityScanningResultUpsertBulk) SetCheckID(v string) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetCheckID(v)
	})
}

// UpdateCheckID sets the "check_id" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateCheckID() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateCheckID()
	})
}

// SetEngineKind sets the "engine_kind" field.
func (u *SecurityScanningResultUpsertBulk) SetEngineKind(v string) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetEngineKind(v)
	})
}

// UpdateEngineKind sets the "engine_kind" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateEngineKind() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateEngineKind()
	})
}

// SetLines sets the "lines" field.
func (u *SecurityScanningResultUpsertBulk) SetLines(v string) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetLines(v)
	})
}

// UpdateLines sets the "lines" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateLines() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateLines()
	})
}

// SetPath sets the "path" field.
func (u *SecurityScanningResultUpsertBulk) SetPath(v string) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetPath(v)
	})
}

// UpdatePath sets the "path" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdatePath() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdatePath()
	})
}

// SetMessage sets the "message" field.
func (u *SecurityScanningResultUpsertBulk) SetMessage(v string) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetMessage(v)
	})
}

// UpdateMessage sets the "message" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateMessage() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateMessage()
	})
}

// SetMessageZh sets the "message_zh" field.
func (u *SecurityScanningResultUpsertBulk) SetMessageZh(v string) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetMessageZh(v)
	})
}

// UpdateMessageZh sets the "message_zh" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateMessageZh() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateMessageZh()
	})
}

// SetSeverity sets the "severity" field.
func (u *SecurityScanningResultUpsertBulk) SetSeverity(v string) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetSeverity(v)
	})
}

// UpdateSeverity sets the "severity" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateSeverity() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateSeverity()
	})
}

// SetAbstractEn sets the "abstract_en" field.
func (u *SecurityScanningResultUpsertBulk) SetAbstractEn(v string) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetAbstractEn(v)
	})
}

// UpdateAbstractEn sets the "abstract_en" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateAbstractEn() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateAbstractEn()
	})
}

// SetAbstractZh sets the "abstract_zh" field.
func (u *SecurityScanningResultUpsertBulk) SetAbstractZh(v string) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetAbstractZh(v)
	})
}

// UpdateAbstractZh sets the "abstract_zh" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateAbstractZh() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateAbstractZh()
	})
}

// SetCategoryEn sets the "category_en" field.
func (u *SecurityScanningResultUpsertBulk) SetCategoryEn(v string) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetCategoryEn(v)
	})
}

// UpdateCategoryEn sets the "category_en" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateCategoryEn() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateCategoryEn()
	})
}

// SetCategoryZh sets the "category_zh" field.
func (u *SecurityScanningResultUpsertBulk) SetCategoryZh(v string) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetCategoryZh(v)
	})
}

// UpdateCategoryZh sets the "category_zh" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateCategoryZh() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateCategoryZh()
	})
}

// SetConfidence sets the "confidence" field.
func (u *SecurityScanningResultUpsertBulk) SetConfidence(v string) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetConfidence(v)
	})
}

// UpdateConfidence sets the "confidence" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateConfidence() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateConfidence()
	})
}

// SetCwe sets the "cwe" field.
func (u *SecurityScanningResultUpsertBulk) SetCwe(v []interface{}) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetCwe(v)
	})
}

// UpdateCwe sets the "cwe" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateCwe() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateCwe()
	})
}

// SetImpact sets the "impact" field.
func (u *SecurityScanningResultUpsertBulk) SetImpact(v string) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetImpact(v)
	})
}

// UpdateImpact sets the "impact" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateImpact() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateImpact()
	})
}

// SetOwasp sets the "owasp" field.
func (u *SecurityScanningResultUpsertBulk) SetOwasp(v []interface{}) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetOwasp(v)
	})
}

// UpdateOwasp sets the "owasp" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateOwasp() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateOwasp()
	})
}

// SetFileContent sets the "file_content" field.
func (u *SecurityScanningResultUpsertBulk) SetFileContent(v string) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetFileContent(v)
	})
}

// UpdateFileContent sets the "file_content" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateFileContent() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateFileContent()
	})
}

// SetStartPosition sets the "start_position" field.
func (u *SecurityScanningResultUpsertBulk) SetStartPosition(v *types.Position) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetStartPosition(v)
	})
}

// UpdateStartPosition sets the "start_position" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateStartPosition() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateStartPosition()
	})
}

// SetEndPosition sets the "end_position" field.
func (u *SecurityScanningResultUpsertBulk) SetEndPosition(v *types.Position) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetEndPosition(v)
	})
}

// UpdateEndPosition sets the "end_position" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateEndPosition() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateEndPosition()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *SecurityScanningResultUpsertBulk) SetCreatedAt(v time.Time) *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *SecurityScanningResultUpsertBulk) UpdateCreatedAt() *SecurityScanningResultUpsertBulk {
	return u.Update(func(s *SecurityScanningResultUpsert) {
		s.UpdateCreatedAt()
	})
}

// Exec executes the query.
func (u *SecurityScanningResultUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the SecurityScanningResultCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for SecurityScanningResultCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *SecurityScanningResultUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
