// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/dialect/sql/sqljson"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanning"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanningresult"
	"github.com/chaitin/MonkeyCode/backend/ent/types"
	"github.com/google/uuid"
)

// SecurityScanningResultUpdate is the builder for updating SecurityScanningResult entities.
type SecurityScanningResultUpdate struct {
	config
	hooks     []Hook
	mutation  *SecurityScanningResultMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the SecurityScanningResultUpdate builder.
func (ssru *SecurityScanningResultUpdate) Where(ps ...predicate.SecurityScanningResult) *SecurityScanningResultUpdate {
	ssru.mutation.Where(ps...)
	return ssru
}

// SetSecurityScanningID sets the "security_scanning_id" field.
func (ssru *SecurityScanningResultUpdate) SetSecurityScanningID(u uuid.UUID) *SecurityScanningResultUpdate {
	ssru.mutation.SetSecurityScanningID(u)
	return ssru
}

// SetNillableSecurityScanningID sets the "security_scanning_id" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableSecurityScanningID(u *uuid.UUID) *SecurityScanningResultUpdate {
	if u != nil {
		ssru.SetSecurityScanningID(*u)
	}
	return ssru
}

// SetCheckID sets the "check_id" field.
func (ssru *SecurityScanningResultUpdate) SetCheckID(s string) *SecurityScanningResultUpdate {
	ssru.mutation.SetCheckID(s)
	return ssru
}

// SetNillableCheckID sets the "check_id" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableCheckID(s *string) *SecurityScanningResultUpdate {
	if s != nil {
		ssru.SetCheckID(*s)
	}
	return ssru
}

// SetEngineKind sets the "engine_kind" field.
func (ssru *SecurityScanningResultUpdate) SetEngineKind(s string) *SecurityScanningResultUpdate {
	ssru.mutation.SetEngineKind(s)
	return ssru
}

// SetNillableEngineKind sets the "engine_kind" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableEngineKind(s *string) *SecurityScanningResultUpdate {
	if s != nil {
		ssru.SetEngineKind(*s)
	}
	return ssru
}

// SetLines sets the "lines" field.
func (ssru *SecurityScanningResultUpdate) SetLines(s string) *SecurityScanningResultUpdate {
	ssru.mutation.SetLines(s)
	return ssru
}

// SetNillableLines sets the "lines" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableLines(s *string) *SecurityScanningResultUpdate {
	if s != nil {
		ssru.SetLines(*s)
	}
	return ssru
}

// SetPath sets the "path" field.
func (ssru *SecurityScanningResultUpdate) SetPath(s string) *SecurityScanningResultUpdate {
	ssru.mutation.SetPath(s)
	return ssru
}

// SetNillablePath sets the "path" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillablePath(s *string) *SecurityScanningResultUpdate {
	if s != nil {
		ssru.SetPath(*s)
	}
	return ssru
}

// SetMessage sets the "message" field.
func (ssru *SecurityScanningResultUpdate) SetMessage(s string) *SecurityScanningResultUpdate {
	ssru.mutation.SetMessage(s)
	return ssru
}

// SetNillableMessage sets the "message" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableMessage(s *string) *SecurityScanningResultUpdate {
	if s != nil {
		ssru.SetMessage(*s)
	}
	return ssru
}

// SetMessageZh sets the "message_zh" field.
func (ssru *SecurityScanningResultUpdate) SetMessageZh(s string) *SecurityScanningResultUpdate {
	ssru.mutation.SetMessageZh(s)
	return ssru
}

// SetNillableMessageZh sets the "message_zh" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableMessageZh(s *string) *SecurityScanningResultUpdate {
	if s != nil {
		ssru.SetMessageZh(*s)
	}
	return ssru
}

// SetSeverity sets the "severity" field.
func (ssru *SecurityScanningResultUpdate) SetSeverity(s string) *SecurityScanningResultUpdate {
	ssru.mutation.SetSeverity(s)
	return ssru
}

// SetNillableSeverity sets the "severity" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableSeverity(s *string) *SecurityScanningResultUpdate {
	if s != nil {
		ssru.SetSeverity(*s)
	}
	return ssru
}

// SetAbstractEn sets the "abstract_en" field.
func (ssru *SecurityScanningResultUpdate) SetAbstractEn(s string) *SecurityScanningResultUpdate {
	ssru.mutation.SetAbstractEn(s)
	return ssru
}

// SetNillableAbstractEn sets the "abstract_en" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableAbstractEn(s *string) *SecurityScanningResultUpdate {
	if s != nil {
		ssru.SetAbstractEn(*s)
	}
	return ssru
}

// SetAbstractZh sets the "abstract_zh" field.
func (ssru *SecurityScanningResultUpdate) SetAbstractZh(s string) *SecurityScanningResultUpdate {
	ssru.mutation.SetAbstractZh(s)
	return ssru
}

// SetNillableAbstractZh sets the "abstract_zh" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableAbstractZh(s *string) *SecurityScanningResultUpdate {
	if s != nil {
		ssru.SetAbstractZh(*s)
	}
	return ssru
}

// SetCategoryEn sets the "category_en" field.
func (ssru *SecurityScanningResultUpdate) SetCategoryEn(s string) *SecurityScanningResultUpdate {
	ssru.mutation.SetCategoryEn(s)
	return ssru
}

// SetNillableCategoryEn sets the "category_en" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableCategoryEn(s *string) *SecurityScanningResultUpdate {
	if s != nil {
		ssru.SetCategoryEn(*s)
	}
	return ssru
}

// SetCategoryZh sets the "category_zh" field.
func (ssru *SecurityScanningResultUpdate) SetCategoryZh(s string) *SecurityScanningResultUpdate {
	ssru.mutation.SetCategoryZh(s)
	return ssru
}

// SetNillableCategoryZh sets the "category_zh" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableCategoryZh(s *string) *SecurityScanningResultUpdate {
	if s != nil {
		ssru.SetCategoryZh(*s)
	}
	return ssru
}

// SetConfidence sets the "confidence" field.
func (ssru *SecurityScanningResultUpdate) SetConfidence(s string) *SecurityScanningResultUpdate {
	ssru.mutation.SetConfidence(s)
	return ssru
}

// SetNillableConfidence sets the "confidence" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableConfidence(s *string) *SecurityScanningResultUpdate {
	if s != nil {
		ssru.SetConfidence(*s)
	}
	return ssru
}

// SetCwe sets the "cwe" field.
func (ssru *SecurityScanningResultUpdate) SetCwe(i []interface{}) *SecurityScanningResultUpdate {
	ssru.mutation.SetCwe(i)
	return ssru
}

// AppendCwe appends i to the "cwe" field.
func (ssru *SecurityScanningResultUpdate) AppendCwe(i []interface{}) *SecurityScanningResultUpdate {
	ssru.mutation.AppendCwe(i)
	return ssru
}

// SetImpact sets the "impact" field.
func (ssru *SecurityScanningResultUpdate) SetImpact(s string) *SecurityScanningResultUpdate {
	ssru.mutation.SetImpact(s)
	return ssru
}

// SetNillableImpact sets the "impact" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableImpact(s *string) *SecurityScanningResultUpdate {
	if s != nil {
		ssru.SetImpact(*s)
	}
	return ssru
}

// SetOwasp sets the "owasp" field.
func (ssru *SecurityScanningResultUpdate) SetOwasp(i []interface{}) *SecurityScanningResultUpdate {
	ssru.mutation.SetOwasp(i)
	return ssru
}

// AppendOwasp appends i to the "owasp" field.
func (ssru *SecurityScanningResultUpdate) AppendOwasp(i []interface{}) *SecurityScanningResultUpdate {
	ssru.mutation.AppendOwasp(i)
	return ssru
}

// SetFileContent sets the "file_content" field.
func (ssru *SecurityScanningResultUpdate) SetFileContent(s string) *SecurityScanningResultUpdate {
	ssru.mutation.SetFileContent(s)
	return ssru
}

// SetNillableFileContent sets the "file_content" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableFileContent(s *string) *SecurityScanningResultUpdate {
	if s != nil {
		ssru.SetFileContent(*s)
	}
	return ssru
}

// SetStartPosition sets the "start_position" field.
func (ssru *SecurityScanningResultUpdate) SetStartPosition(t *types.Position) *SecurityScanningResultUpdate {
	ssru.mutation.SetStartPosition(t)
	return ssru
}

// SetEndPosition sets the "end_position" field.
func (ssru *SecurityScanningResultUpdate) SetEndPosition(t *types.Position) *SecurityScanningResultUpdate {
	ssru.mutation.SetEndPosition(t)
	return ssru
}

// SetCreatedAt sets the "created_at" field.
func (ssru *SecurityScanningResultUpdate) SetCreatedAt(t time.Time) *SecurityScanningResultUpdate {
	ssru.mutation.SetCreatedAt(t)
	return ssru
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ssru *SecurityScanningResultUpdate) SetNillableCreatedAt(t *time.Time) *SecurityScanningResultUpdate {
	if t != nil {
		ssru.SetCreatedAt(*t)
	}
	return ssru
}

// SetSecurityScanning sets the "security_scanning" edge to the SecurityScanning entity.
func (ssru *SecurityScanningResultUpdate) SetSecurityScanning(s *SecurityScanning) *SecurityScanningResultUpdate {
	return ssru.SetSecurityScanningID(s.ID)
}

// Mutation returns the SecurityScanningResultMutation object of the builder.
func (ssru *SecurityScanningResultUpdate) Mutation() *SecurityScanningResultMutation {
	return ssru.mutation
}

// ClearSecurityScanning clears the "security_scanning" edge to the SecurityScanning entity.
func (ssru *SecurityScanningResultUpdate) ClearSecurityScanning() *SecurityScanningResultUpdate {
	ssru.mutation.ClearSecurityScanning()
	return ssru
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (ssru *SecurityScanningResultUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, ssru.sqlSave, ssru.mutation, ssru.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (ssru *SecurityScanningResultUpdate) SaveX(ctx context.Context) int {
	affected, err := ssru.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (ssru *SecurityScanningResultUpdate) Exec(ctx context.Context) error {
	_, err := ssru.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ssru *SecurityScanningResultUpdate) ExecX(ctx context.Context) {
	if err := ssru.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ssru *SecurityScanningResultUpdate) check() error {
	if ssru.mutation.SecurityScanningCleared() && len(ssru.mutation.SecurityScanningIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "SecurityScanningResult.security_scanning"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (ssru *SecurityScanningResultUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *SecurityScanningResultUpdate {
	ssru.modifiers = append(ssru.modifiers, modifiers...)
	return ssru
}

func (ssru *SecurityScanningResultUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := ssru.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(securityscanningresult.Table, securityscanningresult.Columns, sqlgraph.NewFieldSpec(securityscanningresult.FieldID, field.TypeUUID))
	if ps := ssru.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := ssru.mutation.CheckID(); ok {
		_spec.SetField(securityscanningresult.FieldCheckID, field.TypeString, value)
	}
	if value, ok := ssru.mutation.EngineKind(); ok {
		_spec.SetField(securityscanningresult.FieldEngineKind, field.TypeString, value)
	}
	if value, ok := ssru.mutation.Lines(); ok {
		_spec.SetField(securityscanningresult.FieldLines, field.TypeString, value)
	}
	if value, ok := ssru.mutation.Path(); ok {
		_spec.SetField(securityscanningresult.FieldPath, field.TypeString, value)
	}
	if value, ok := ssru.mutation.Message(); ok {
		_spec.SetField(securityscanningresult.FieldMessage, field.TypeString, value)
	}
	if value, ok := ssru.mutation.MessageZh(); ok {
		_spec.SetField(securityscanningresult.FieldMessageZh, field.TypeString, value)
	}
	if value, ok := ssru.mutation.Severity(); ok {
		_spec.SetField(securityscanningresult.FieldSeverity, field.TypeString, value)
	}
	if value, ok := ssru.mutation.AbstractEn(); ok {
		_spec.SetField(securityscanningresult.FieldAbstractEn, field.TypeString, value)
	}
	if value, ok := ssru.mutation.AbstractZh(); ok {
		_spec.SetField(securityscanningresult.FieldAbstractZh, field.TypeString, value)
	}
	if value, ok := ssru.mutation.CategoryEn(); ok {
		_spec.SetField(securityscanningresult.FieldCategoryEn, field.TypeString, value)
	}
	if value, ok := ssru.mutation.CategoryZh(); ok {
		_spec.SetField(securityscanningresult.FieldCategoryZh, field.TypeString, value)
	}
	if value, ok := ssru.mutation.Confidence(); ok {
		_spec.SetField(securityscanningresult.FieldConfidence, field.TypeString, value)
	}
	if value, ok := ssru.mutation.Cwe(); ok {
		_spec.SetField(securityscanningresult.FieldCwe, field.TypeJSON, value)
	}
	if value, ok := ssru.mutation.AppendedCwe(); ok {
		_spec.AddModifier(func(u *sql.UpdateBuilder) {
			sqljson.Append(u, securityscanningresult.FieldCwe, value)
		})
	}
	if value, ok := ssru.mutation.Impact(); ok {
		_spec.SetField(securityscanningresult.FieldImpact, field.TypeString, value)
	}
	if value, ok := ssru.mutation.Owasp(); ok {
		_spec.SetField(securityscanningresult.FieldOwasp, field.TypeJSON, value)
	}
	if value, ok := ssru.mutation.AppendedOwasp(); ok {
		_spec.AddModifier(func(u *sql.UpdateBuilder) {
			sqljson.Append(u, securityscanningresult.FieldOwasp, value)
		})
	}
	if value, ok := ssru.mutation.FileContent(); ok {
		_spec.SetField(securityscanningresult.FieldFileContent, field.TypeString, value)
	}
	if value, ok := ssru.mutation.StartPosition(); ok {
		_spec.SetField(securityscanningresult.FieldStartPosition, field.TypeJSON, value)
	}
	if value, ok := ssru.mutation.EndPosition(); ok {
		_spec.SetField(securityscanningresult.FieldEndPosition, field.TypeJSON, value)
	}
	if value, ok := ssru.mutation.CreatedAt(); ok {
		_spec.SetField(securityscanningresult.FieldCreatedAt, field.TypeTime, value)
	}
	if ssru.mutation.SecurityScanningCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanningresult.SecurityScanningTable,
			Columns: []string{securityscanningresult.SecurityScanningColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ssru.mutation.SecurityScanningIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanningresult.SecurityScanningTable,
			Columns: []string{securityscanningresult.SecurityScanningColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(ssru.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, ssru.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{securityscanningresult.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	ssru.mutation.done = true
	return n, nil
}

// SecurityScanningResultUpdateOne is the builder for updating a single SecurityScanningResult entity.
type SecurityScanningResultUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *SecurityScanningResultMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetSecurityScanningID sets the "security_scanning_id" field.
func (ssruo *SecurityScanningResultUpdateOne) SetSecurityScanningID(u uuid.UUID) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetSecurityScanningID(u)
	return ssruo
}

// SetNillableSecurityScanningID sets the "security_scanning_id" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableSecurityScanningID(u *uuid.UUID) *SecurityScanningResultUpdateOne {
	if u != nil {
		ssruo.SetSecurityScanningID(*u)
	}
	return ssruo
}

// SetCheckID sets the "check_id" field.
func (ssruo *SecurityScanningResultUpdateOne) SetCheckID(s string) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetCheckID(s)
	return ssruo
}

// SetNillableCheckID sets the "check_id" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableCheckID(s *string) *SecurityScanningResultUpdateOne {
	if s != nil {
		ssruo.SetCheckID(*s)
	}
	return ssruo
}

// SetEngineKind sets the "engine_kind" field.
func (ssruo *SecurityScanningResultUpdateOne) SetEngineKind(s string) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetEngineKind(s)
	return ssruo
}

// SetNillableEngineKind sets the "engine_kind" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableEngineKind(s *string) *SecurityScanningResultUpdateOne {
	if s != nil {
		ssruo.SetEngineKind(*s)
	}
	return ssruo
}

// SetLines sets the "lines" field.
func (ssruo *SecurityScanningResultUpdateOne) SetLines(s string) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetLines(s)
	return ssruo
}

// SetNillableLines sets the "lines" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableLines(s *string) *SecurityScanningResultUpdateOne {
	if s != nil {
		ssruo.SetLines(*s)
	}
	return ssruo
}

// SetPath sets the "path" field.
func (ssruo *SecurityScanningResultUpdateOne) SetPath(s string) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetPath(s)
	return ssruo
}

// SetNillablePath sets the "path" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillablePath(s *string) *SecurityScanningResultUpdateOne {
	if s != nil {
		ssruo.SetPath(*s)
	}
	return ssruo
}

// SetMessage sets the "message" field.
func (ssruo *SecurityScanningResultUpdateOne) SetMessage(s string) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetMessage(s)
	return ssruo
}

// SetNillableMessage sets the "message" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableMessage(s *string) *SecurityScanningResultUpdateOne {
	if s != nil {
		ssruo.SetMessage(*s)
	}
	return ssruo
}

// SetMessageZh sets the "message_zh" field.
func (ssruo *SecurityScanningResultUpdateOne) SetMessageZh(s string) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetMessageZh(s)
	return ssruo
}

// SetNillableMessageZh sets the "message_zh" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableMessageZh(s *string) *SecurityScanningResultUpdateOne {
	if s != nil {
		ssruo.SetMessageZh(*s)
	}
	return ssruo
}

// SetSeverity sets the "severity" field.
func (ssruo *SecurityScanningResultUpdateOne) SetSeverity(s string) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetSeverity(s)
	return ssruo
}

// SetNillableSeverity sets the "severity" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableSeverity(s *string) *SecurityScanningResultUpdateOne {
	if s != nil {
		ssruo.SetSeverity(*s)
	}
	return ssruo
}

// SetAbstractEn sets the "abstract_en" field.
func (ssruo *SecurityScanningResultUpdateOne) SetAbstractEn(s string) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetAbstractEn(s)
	return ssruo
}

// SetNillableAbstractEn sets the "abstract_en" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableAbstractEn(s *string) *SecurityScanningResultUpdateOne {
	if s != nil {
		ssruo.SetAbstractEn(*s)
	}
	return ssruo
}

// SetAbstractZh sets the "abstract_zh" field.
func (ssruo *SecurityScanningResultUpdateOne) SetAbstractZh(s string) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetAbstractZh(s)
	return ssruo
}

// SetNillableAbstractZh sets the "abstract_zh" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableAbstractZh(s *string) *SecurityScanningResultUpdateOne {
	if s != nil {
		ssruo.SetAbstractZh(*s)
	}
	return ssruo
}

// SetCategoryEn sets the "category_en" field.
func (ssruo *SecurityScanningResultUpdateOne) SetCategoryEn(s string) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetCategoryEn(s)
	return ssruo
}

// SetNillableCategoryEn sets the "category_en" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableCategoryEn(s *string) *SecurityScanningResultUpdateOne {
	if s != nil {
		ssruo.SetCategoryEn(*s)
	}
	return ssruo
}

// SetCategoryZh sets the "category_zh" field.
func (ssruo *SecurityScanningResultUpdateOne) SetCategoryZh(s string) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetCategoryZh(s)
	return ssruo
}

// SetNillableCategoryZh sets the "category_zh" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableCategoryZh(s *string) *SecurityScanningResultUpdateOne {
	if s != nil {
		ssruo.SetCategoryZh(*s)
	}
	return ssruo
}

// SetConfidence sets the "confidence" field.
func (ssruo *SecurityScanningResultUpdateOne) SetConfidence(s string) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetConfidence(s)
	return ssruo
}

// SetNillableConfidence sets the "confidence" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableConfidence(s *string) *SecurityScanningResultUpdateOne {
	if s != nil {
		ssruo.SetConfidence(*s)
	}
	return ssruo
}

// SetCwe sets the "cwe" field.
func (ssruo *SecurityScanningResultUpdateOne) SetCwe(i []interface{}) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetCwe(i)
	return ssruo
}

// AppendCwe appends i to the "cwe" field.
func (ssruo *SecurityScanningResultUpdateOne) AppendCwe(i []interface{}) *SecurityScanningResultUpdateOne {
	ssruo.mutation.AppendCwe(i)
	return ssruo
}

// SetImpact sets the "impact" field.
func (ssruo *SecurityScanningResultUpdateOne) SetImpact(s string) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetImpact(s)
	return ssruo
}

// SetNillableImpact sets the "impact" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableImpact(s *string) *SecurityScanningResultUpdateOne {
	if s != nil {
		ssruo.SetImpact(*s)
	}
	return ssruo
}

// SetOwasp sets the "owasp" field.
func (ssruo *SecurityScanningResultUpdateOne) SetOwasp(i []interface{}) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetOwasp(i)
	return ssruo
}

// AppendOwasp appends i to the "owasp" field.
func (ssruo *SecurityScanningResultUpdateOne) AppendOwasp(i []interface{}) *SecurityScanningResultUpdateOne {
	ssruo.mutation.AppendOwasp(i)
	return ssruo
}

// SetFileContent sets the "file_content" field.
func (ssruo *SecurityScanningResultUpdateOne) SetFileContent(s string) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetFileContent(s)
	return ssruo
}

// SetNillableFileContent sets the "file_content" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableFileContent(s *string) *SecurityScanningResultUpdateOne {
	if s != nil {
		ssruo.SetFileContent(*s)
	}
	return ssruo
}

// SetStartPosition sets the "start_position" field.
func (ssruo *SecurityScanningResultUpdateOne) SetStartPosition(t *types.Position) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetStartPosition(t)
	return ssruo
}

// SetEndPosition sets the "end_position" field.
func (ssruo *SecurityScanningResultUpdateOne) SetEndPosition(t *types.Position) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetEndPosition(t)
	return ssruo
}

// SetCreatedAt sets the "created_at" field.
func (ssruo *SecurityScanningResultUpdateOne) SetCreatedAt(t time.Time) *SecurityScanningResultUpdateOne {
	ssruo.mutation.SetCreatedAt(t)
	return ssruo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ssruo *SecurityScanningResultUpdateOne) SetNillableCreatedAt(t *time.Time) *SecurityScanningResultUpdateOne {
	if t != nil {
		ssruo.SetCreatedAt(*t)
	}
	return ssruo
}

// SetSecurityScanning sets the "security_scanning" edge to the SecurityScanning entity.
func (ssruo *SecurityScanningResultUpdateOne) SetSecurityScanning(s *SecurityScanning) *SecurityScanningResultUpdateOne {
	return ssruo.SetSecurityScanningID(s.ID)
}

// Mutation returns the SecurityScanningResultMutation object of the builder.
func (ssruo *SecurityScanningResultUpdateOne) Mutation() *SecurityScanningResultMutation {
	return ssruo.mutation
}

// ClearSecurityScanning clears the "security_scanning" edge to the SecurityScanning entity.
func (ssruo *SecurityScanningResultUpdateOne) ClearSecurityScanning() *SecurityScanningResultUpdateOne {
	ssruo.mutation.ClearSecurityScanning()
	return ssruo
}

// Where appends a list predicates to the SecurityScanningResultUpdate builder.
func (ssruo *SecurityScanningResultUpdateOne) Where(ps ...predicate.SecurityScanningResult) *SecurityScanningResultUpdateOne {
	ssruo.mutation.Where(ps...)
	return ssruo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (ssruo *SecurityScanningResultUpdateOne) Select(field string, fields ...string) *SecurityScanningResultUpdateOne {
	ssruo.fields = append([]string{field}, fields...)
	return ssruo
}

// Save executes the query and returns the updated SecurityScanningResult entity.
func (ssruo *SecurityScanningResultUpdateOne) Save(ctx context.Context) (*SecurityScanningResult, error) {
	return withHooks(ctx, ssruo.sqlSave, ssruo.mutation, ssruo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (ssruo *SecurityScanningResultUpdateOne) SaveX(ctx context.Context) *SecurityScanningResult {
	node, err := ssruo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (ssruo *SecurityScanningResultUpdateOne) Exec(ctx context.Context) error {
	_, err := ssruo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ssruo *SecurityScanningResultUpdateOne) ExecX(ctx context.Context) {
	if err := ssruo.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ssruo *SecurityScanningResultUpdateOne) check() error {
	if ssruo.mutation.SecurityScanningCleared() && len(ssruo.mutation.SecurityScanningIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "SecurityScanningResult.security_scanning"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (ssruo *SecurityScanningResultUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *SecurityScanningResultUpdateOne {
	ssruo.modifiers = append(ssruo.modifiers, modifiers...)
	return ssruo
}

func (ssruo *SecurityScanningResultUpdateOne) sqlSave(ctx context.Context) (_node *SecurityScanningResult, err error) {
	if err := ssruo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(securityscanningresult.Table, securityscanningresult.Columns, sqlgraph.NewFieldSpec(securityscanningresult.FieldID, field.TypeUUID))
	id, ok := ssruo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "SecurityScanningResult.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := ssruo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, securityscanningresult.FieldID)
		for _, f := range fields {
			if !securityscanningresult.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != securityscanningresult.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := ssruo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := ssruo.mutation.CheckID(); ok {
		_spec.SetField(securityscanningresult.FieldCheckID, field.TypeString, value)
	}
	if value, ok := ssruo.mutation.EngineKind(); ok {
		_spec.SetField(securityscanningresult.FieldEngineKind, field.TypeString, value)
	}
	if value, ok := ssruo.mutation.Lines(); ok {
		_spec.SetField(securityscanningresult.FieldLines, field.TypeString, value)
	}
	if value, ok := ssruo.mutation.Path(); ok {
		_spec.SetField(securityscanningresult.FieldPath, field.TypeString, value)
	}
	if value, ok := ssruo.mutation.Message(); ok {
		_spec.SetField(securityscanningresult.FieldMessage, field.TypeString, value)
	}
	if value, ok := ssruo.mutation.MessageZh(); ok {
		_spec.SetField(securityscanningresult.FieldMessageZh, field.TypeString, value)
	}
	if value, ok := ssruo.mutation.Severity(); ok {
		_spec.SetField(securityscanningresult.FieldSeverity, field.TypeString, value)
	}
	if value, ok := ssruo.mutation.AbstractEn(); ok {
		_spec.SetField(securityscanningresult.FieldAbstractEn, field.TypeString, value)
	}
	if value, ok := ssruo.mutation.AbstractZh(); ok {
		_spec.SetField(securityscanningresult.FieldAbstractZh, field.TypeString, value)
	}
	if value, ok := ssruo.mutation.CategoryEn(); ok {
		_spec.SetField(securityscanningresult.FieldCategoryEn, field.TypeString, value)
	}
	if value, ok := ssruo.mutation.CategoryZh(); ok {
		_spec.SetField(securityscanningresult.FieldCategoryZh, field.TypeString, value)
	}
	if value, ok := ssruo.mutation.Confidence(); ok {
		_spec.SetField(securityscanningresult.FieldConfidence, field.TypeString, value)
	}
	if value, ok := ssruo.mutation.Cwe(); ok {
		_spec.SetField(securityscanningresult.FieldCwe, field.TypeJSON, value)
	}
	if value, ok := ssruo.mutation.AppendedCwe(); ok {
		_spec.AddModifier(func(u *sql.UpdateBuilder) {
			sqljson.Append(u, securityscanningresult.FieldCwe, value)
		})
	}
	if value, ok := ssruo.mutation.Impact(); ok {
		_spec.SetField(securityscanningresult.FieldImpact, field.TypeString, value)
	}
	if value, ok := ssruo.mutation.Owasp(); ok {
		_spec.SetField(securityscanningresult.FieldOwasp, field.TypeJSON, value)
	}
	if value, ok := ssruo.mutation.AppendedOwasp(); ok {
		_spec.AddModifier(func(u *sql.UpdateBuilder) {
			sqljson.Append(u, securityscanningresult.FieldOwasp, value)
		})
	}
	if value, ok := ssruo.mutation.FileContent(); ok {
		_spec.SetField(securityscanningresult.FieldFileContent, field.TypeString, value)
	}
	if value, ok := ssruo.mutation.StartPosition(); ok {
		_spec.SetField(securityscanningresult.FieldStartPosition, field.TypeJSON, value)
	}
	if value, ok := ssruo.mutation.EndPosition(); ok {
		_spec.SetField(securityscanningresult.FieldEndPosition, field.TypeJSON, value)
	}
	if value, ok := ssruo.mutation.CreatedAt(); ok {
		_spec.SetField(securityscanningresult.FieldCreatedAt, field.TypeTime, value)
	}
	if ssruo.mutation.SecurityScanningCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanningresult.SecurityScanningTable,
			Columns: []string{securityscanningresult.SecurityScanningColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ssruo.mutation.SecurityScanningIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   securityscanningresult.SecurityScanningTable,
			Columns: []string{securityscanningresult.SecurityScanningColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(ssruo.modifiers...)
	_node = &SecurityScanningResult{config: ssruo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, ssruo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{securityscanningresult.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	ssruo.mutation.done = true
	return _node, nil
}
