// Code generated by ent, DO NOT EDIT.

package task

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/google/uuid"
)

// ID filters vertices based on their ID field.
func ID(id uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldID, id))
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldID, id))
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldID, id))
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldID, ids...))
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldID, ids...))
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldGT(FieldID, id))
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldGTE(FieldID, id))
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldLT(FieldID, id))
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldLTE(FieldID, id))
}

// TaskID applies equality check predicate on the "task_id" field. It's identical to TaskIDEQ.
func TaskID(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldTaskID, v))
}

// UserID applies equality check predicate on the "user_id" field. It's identical to UserIDEQ.
func UserID(v uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldUserID, v))
}

// ModelID applies equality check predicate on the "model_id" field. It's identical to ModelIDEQ.
func ModelID(v uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldModelID, v))
}

// RequestID applies equality check predicate on the "request_id" field. It's identical to RequestIDEQ.
func RequestID(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldRequestID, v))
}

// ModelType applies equality check predicate on the "model_type" field. It's identical to ModelTypeEQ.
func ModelType(v consts.ModelType) predicate.Task {
	vc := string(v)
	return predicate.Task(sql.FieldEQ(FieldModelType, vc))
}

// IsAccept applies equality check predicate on the "is_accept" field. It's identical to IsAcceptEQ.
func IsAccept(v bool) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldIsAccept, v))
}

// ProgramLanguage applies equality check predicate on the "program_language" field. It's identical to ProgramLanguageEQ.
func ProgramLanguage(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldProgramLanguage, v))
}

// WorkMode applies equality check predicate on the "work_mode" field. It's identical to WorkModeEQ.
func WorkMode(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldWorkMode, v))
}

// Prompt applies equality check predicate on the "prompt" field. It's identical to PromptEQ.
func Prompt(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldPrompt, v))
}

// Completion applies equality check predicate on the "completion" field. It's identical to CompletionEQ.
func Completion(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldCompletion, v))
}

// CodeLines applies equality check predicate on the "code_lines" field. It's identical to CodeLinesEQ.
func CodeLines(v int64) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldCodeLines, v))
}

// InputTokens applies equality check predicate on the "input_tokens" field. It's identical to InputTokensEQ.
func InputTokens(v int64) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldInputTokens, v))
}

// OutputTokens applies equality check predicate on the "output_tokens" field. It's identical to OutputTokensEQ.
func OutputTokens(v int64) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldOutputTokens, v))
}

// IsSuggested applies equality check predicate on the "is_suggested" field. It's identical to IsSuggestedEQ.
func IsSuggested(v bool) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldIsSuggested, v))
}

// SourceCode applies equality check predicate on the "source_code" field. It's identical to SourceCodeEQ.
func SourceCode(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldSourceCode, v))
}

// UserInput applies equality check predicate on the "user_input" field. It's identical to UserInputEQ.
func UserInput(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldUserInput, v))
}

// CreatedAt applies equality check predicate on the "created_at" field. It's identical to CreatedAtEQ.
func CreatedAt(v time.Time) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldCreatedAt, v))
}

// UpdatedAt applies equality check predicate on the "updated_at" field. It's identical to UpdatedAtEQ.
func UpdatedAt(v time.Time) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldUpdatedAt, v))
}

// TaskIDEQ applies the EQ predicate on the "task_id" field.
func TaskIDEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldTaskID, v))
}

// TaskIDNEQ applies the NEQ predicate on the "task_id" field.
func TaskIDNEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldTaskID, v))
}

// TaskIDIn applies the In predicate on the "task_id" field.
func TaskIDIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldTaskID, vs...))
}

// TaskIDNotIn applies the NotIn predicate on the "task_id" field.
func TaskIDNotIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldTaskID, vs...))
}

// TaskIDGT applies the GT predicate on the "task_id" field.
func TaskIDGT(v string) predicate.Task {
	return predicate.Task(sql.FieldGT(FieldTaskID, v))
}

// TaskIDGTE applies the GTE predicate on the "task_id" field.
func TaskIDGTE(v string) predicate.Task {
	return predicate.Task(sql.FieldGTE(FieldTaskID, v))
}

// TaskIDLT applies the LT predicate on the "task_id" field.
func TaskIDLT(v string) predicate.Task {
	return predicate.Task(sql.FieldLT(FieldTaskID, v))
}

// TaskIDLTE applies the LTE predicate on the "task_id" field.
func TaskIDLTE(v string) predicate.Task {
	return predicate.Task(sql.FieldLTE(FieldTaskID, v))
}

// TaskIDContains applies the Contains predicate on the "task_id" field.
func TaskIDContains(v string) predicate.Task {
	return predicate.Task(sql.FieldContains(FieldTaskID, v))
}

// TaskIDHasPrefix applies the HasPrefix predicate on the "task_id" field.
func TaskIDHasPrefix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasPrefix(FieldTaskID, v))
}

// TaskIDHasSuffix applies the HasSuffix predicate on the "task_id" field.
func TaskIDHasSuffix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasSuffix(FieldTaskID, v))
}

// TaskIDEqualFold applies the EqualFold predicate on the "task_id" field.
func TaskIDEqualFold(v string) predicate.Task {
	return predicate.Task(sql.FieldEqualFold(FieldTaskID, v))
}

// TaskIDContainsFold applies the ContainsFold predicate on the "task_id" field.
func TaskIDContainsFold(v string) predicate.Task {
	return predicate.Task(sql.FieldContainsFold(FieldTaskID, v))
}

// UserIDEQ applies the EQ predicate on the "user_id" field.
func UserIDEQ(v uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldUserID, v))
}

// UserIDNEQ applies the NEQ predicate on the "user_id" field.
func UserIDNEQ(v uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldUserID, v))
}

// UserIDIn applies the In predicate on the "user_id" field.
func UserIDIn(vs ...uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldUserID, vs...))
}

// UserIDNotIn applies the NotIn predicate on the "user_id" field.
func UserIDNotIn(vs ...uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldUserID, vs...))
}

// UserIDIsNil applies the IsNil predicate on the "user_id" field.
func UserIDIsNil() predicate.Task {
	return predicate.Task(sql.FieldIsNull(FieldUserID))
}

// UserIDNotNil applies the NotNil predicate on the "user_id" field.
func UserIDNotNil() predicate.Task {
	return predicate.Task(sql.FieldNotNull(FieldUserID))
}

// ModelIDEQ applies the EQ predicate on the "model_id" field.
func ModelIDEQ(v uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldModelID, v))
}

// ModelIDNEQ applies the NEQ predicate on the "model_id" field.
func ModelIDNEQ(v uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldModelID, v))
}

// ModelIDIn applies the In predicate on the "model_id" field.
func ModelIDIn(vs ...uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldModelID, vs...))
}

// ModelIDNotIn applies the NotIn predicate on the "model_id" field.
func ModelIDNotIn(vs ...uuid.UUID) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldModelID, vs...))
}

// ModelIDIsNil applies the IsNil predicate on the "model_id" field.
func ModelIDIsNil() predicate.Task {
	return predicate.Task(sql.FieldIsNull(FieldModelID))
}

// ModelIDNotNil applies the NotNil predicate on the "model_id" field.
func ModelIDNotNil() predicate.Task {
	return predicate.Task(sql.FieldNotNull(FieldModelID))
}

// RequestIDEQ applies the EQ predicate on the "request_id" field.
func RequestIDEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldRequestID, v))
}

// RequestIDNEQ applies the NEQ predicate on the "request_id" field.
func RequestIDNEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldRequestID, v))
}

// RequestIDIn applies the In predicate on the "request_id" field.
func RequestIDIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldRequestID, vs...))
}

// RequestIDNotIn applies the NotIn predicate on the "request_id" field.
func RequestIDNotIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldRequestID, vs...))
}

// RequestIDGT applies the GT predicate on the "request_id" field.
func RequestIDGT(v string) predicate.Task {
	return predicate.Task(sql.FieldGT(FieldRequestID, v))
}

// RequestIDGTE applies the GTE predicate on the "request_id" field.
func RequestIDGTE(v string) predicate.Task {
	return predicate.Task(sql.FieldGTE(FieldRequestID, v))
}

// RequestIDLT applies the LT predicate on the "request_id" field.
func RequestIDLT(v string) predicate.Task {
	return predicate.Task(sql.FieldLT(FieldRequestID, v))
}

// RequestIDLTE applies the LTE predicate on the "request_id" field.
func RequestIDLTE(v string) predicate.Task {
	return predicate.Task(sql.FieldLTE(FieldRequestID, v))
}

// RequestIDContains applies the Contains predicate on the "request_id" field.
func RequestIDContains(v string) predicate.Task {
	return predicate.Task(sql.FieldContains(FieldRequestID, v))
}

// RequestIDHasPrefix applies the HasPrefix predicate on the "request_id" field.
func RequestIDHasPrefix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasPrefix(FieldRequestID, v))
}

// RequestIDHasSuffix applies the HasSuffix predicate on the "request_id" field.
func RequestIDHasSuffix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasSuffix(FieldRequestID, v))
}

// RequestIDIsNil applies the IsNil predicate on the "request_id" field.
func RequestIDIsNil() predicate.Task {
	return predicate.Task(sql.FieldIsNull(FieldRequestID))
}

// RequestIDNotNil applies the NotNil predicate on the "request_id" field.
func RequestIDNotNil() predicate.Task {
	return predicate.Task(sql.FieldNotNull(FieldRequestID))
}

// RequestIDEqualFold applies the EqualFold predicate on the "request_id" field.
func RequestIDEqualFold(v string) predicate.Task {
	return predicate.Task(sql.FieldEqualFold(FieldRequestID, v))
}

// RequestIDContainsFold applies the ContainsFold predicate on the "request_id" field.
func RequestIDContainsFold(v string) predicate.Task {
	return predicate.Task(sql.FieldContainsFold(FieldRequestID, v))
}

// ModelTypeEQ applies the EQ predicate on the "model_type" field.
func ModelTypeEQ(v consts.ModelType) predicate.Task {
	vc := string(v)
	return predicate.Task(sql.FieldEQ(FieldModelType, vc))
}

// ModelTypeNEQ applies the NEQ predicate on the "model_type" field.
func ModelTypeNEQ(v consts.ModelType) predicate.Task {
	vc := string(v)
	return predicate.Task(sql.FieldNEQ(FieldModelType, vc))
}

// ModelTypeIn applies the In predicate on the "model_type" field.
func ModelTypeIn(vs ...consts.ModelType) predicate.Task {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.Task(sql.FieldIn(FieldModelType, v...))
}

// ModelTypeNotIn applies the NotIn predicate on the "model_type" field.
func ModelTypeNotIn(vs ...consts.ModelType) predicate.Task {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.Task(sql.FieldNotIn(FieldModelType, v...))
}

// ModelTypeGT applies the GT predicate on the "model_type" field.
func ModelTypeGT(v consts.ModelType) predicate.Task {
	vc := string(v)
	return predicate.Task(sql.FieldGT(FieldModelType, vc))
}

// ModelTypeGTE applies the GTE predicate on the "model_type" field.
func ModelTypeGTE(v consts.ModelType) predicate.Task {
	vc := string(v)
	return predicate.Task(sql.FieldGTE(FieldModelType, vc))
}

// ModelTypeLT applies the LT predicate on the "model_type" field.
func ModelTypeLT(v consts.ModelType) predicate.Task {
	vc := string(v)
	return predicate.Task(sql.FieldLT(FieldModelType, vc))
}

// ModelTypeLTE applies the LTE predicate on the "model_type" field.
func ModelTypeLTE(v consts.ModelType) predicate.Task {
	vc := string(v)
	return predicate.Task(sql.FieldLTE(FieldModelType, vc))
}

// ModelTypeContains applies the Contains predicate on the "model_type" field.
func ModelTypeContains(v consts.ModelType) predicate.Task {
	vc := string(v)
	return predicate.Task(sql.FieldContains(FieldModelType, vc))
}

// ModelTypeHasPrefix applies the HasPrefix predicate on the "model_type" field.
func ModelTypeHasPrefix(v consts.ModelType) predicate.Task {
	vc := string(v)
	return predicate.Task(sql.FieldHasPrefix(FieldModelType, vc))
}

// ModelTypeHasSuffix applies the HasSuffix predicate on the "model_type" field.
func ModelTypeHasSuffix(v consts.ModelType) predicate.Task {
	vc := string(v)
	return predicate.Task(sql.FieldHasSuffix(FieldModelType, vc))
}

// ModelTypeEqualFold applies the EqualFold predicate on the "model_type" field.
func ModelTypeEqualFold(v consts.ModelType) predicate.Task {
	vc := string(v)
	return predicate.Task(sql.FieldEqualFold(FieldModelType, vc))
}

// ModelTypeContainsFold applies the ContainsFold predicate on the "model_type" field.
func ModelTypeContainsFold(v consts.ModelType) predicate.Task {
	vc := string(v)
	return predicate.Task(sql.FieldContainsFold(FieldModelType, vc))
}

// IsAcceptEQ applies the EQ predicate on the "is_accept" field.
func IsAcceptEQ(v bool) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldIsAccept, v))
}

// IsAcceptNEQ applies the NEQ predicate on the "is_accept" field.
func IsAcceptNEQ(v bool) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldIsAccept, v))
}

// ProgramLanguageEQ applies the EQ predicate on the "program_language" field.
func ProgramLanguageEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldProgramLanguage, v))
}

// ProgramLanguageNEQ applies the NEQ predicate on the "program_language" field.
func ProgramLanguageNEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldProgramLanguage, v))
}

// ProgramLanguageIn applies the In predicate on the "program_language" field.
func ProgramLanguageIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldProgramLanguage, vs...))
}

// ProgramLanguageNotIn applies the NotIn predicate on the "program_language" field.
func ProgramLanguageNotIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldProgramLanguage, vs...))
}

// ProgramLanguageGT applies the GT predicate on the "program_language" field.
func ProgramLanguageGT(v string) predicate.Task {
	return predicate.Task(sql.FieldGT(FieldProgramLanguage, v))
}

// ProgramLanguageGTE applies the GTE predicate on the "program_language" field.
func ProgramLanguageGTE(v string) predicate.Task {
	return predicate.Task(sql.FieldGTE(FieldProgramLanguage, v))
}

// ProgramLanguageLT applies the LT predicate on the "program_language" field.
func ProgramLanguageLT(v string) predicate.Task {
	return predicate.Task(sql.FieldLT(FieldProgramLanguage, v))
}

// ProgramLanguageLTE applies the LTE predicate on the "program_language" field.
func ProgramLanguageLTE(v string) predicate.Task {
	return predicate.Task(sql.FieldLTE(FieldProgramLanguage, v))
}

// ProgramLanguageContains applies the Contains predicate on the "program_language" field.
func ProgramLanguageContains(v string) predicate.Task {
	return predicate.Task(sql.FieldContains(FieldProgramLanguage, v))
}

// ProgramLanguageHasPrefix applies the HasPrefix predicate on the "program_language" field.
func ProgramLanguageHasPrefix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasPrefix(FieldProgramLanguage, v))
}

// ProgramLanguageHasSuffix applies the HasSuffix predicate on the "program_language" field.
func ProgramLanguageHasSuffix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasSuffix(FieldProgramLanguage, v))
}

// ProgramLanguageIsNil applies the IsNil predicate on the "program_language" field.
func ProgramLanguageIsNil() predicate.Task {
	return predicate.Task(sql.FieldIsNull(FieldProgramLanguage))
}

// ProgramLanguageNotNil applies the NotNil predicate on the "program_language" field.
func ProgramLanguageNotNil() predicate.Task {
	return predicate.Task(sql.FieldNotNull(FieldProgramLanguage))
}

// ProgramLanguageEqualFold applies the EqualFold predicate on the "program_language" field.
func ProgramLanguageEqualFold(v string) predicate.Task {
	return predicate.Task(sql.FieldEqualFold(FieldProgramLanguage, v))
}

// ProgramLanguageContainsFold applies the ContainsFold predicate on the "program_language" field.
func ProgramLanguageContainsFold(v string) predicate.Task {
	return predicate.Task(sql.FieldContainsFold(FieldProgramLanguage, v))
}

// WorkModeEQ applies the EQ predicate on the "work_mode" field.
func WorkModeEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldWorkMode, v))
}

// WorkModeNEQ applies the NEQ predicate on the "work_mode" field.
func WorkModeNEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldWorkMode, v))
}

// WorkModeIn applies the In predicate on the "work_mode" field.
func WorkModeIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldWorkMode, vs...))
}

// WorkModeNotIn applies the NotIn predicate on the "work_mode" field.
func WorkModeNotIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldWorkMode, vs...))
}

// WorkModeGT applies the GT predicate on the "work_mode" field.
func WorkModeGT(v string) predicate.Task {
	return predicate.Task(sql.FieldGT(FieldWorkMode, v))
}

// WorkModeGTE applies the GTE predicate on the "work_mode" field.
func WorkModeGTE(v string) predicate.Task {
	return predicate.Task(sql.FieldGTE(FieldWorkMode, v))
}

// WorkModeLT applies the LT predicate on the "work_mode" field.
func WorkModeLT(v string) predicate.Task {
	return predicate.Task(sql.FieldLT(FieldWorkMode, v))
}

// WorkModeLTE applies the LTE predicate on the "work_mode" field.
func WorkModeLTE(v string) predicate.Task {
	return predicate.Task(sql.FieldLTE(FieldWorkMode, v))
}

// WorkModeContains applies the Contains predicate on the "work_mode" field.
func WorkModeContains(v string) predicate.Task {
	return predicate.Task(sql.FieldContains(FieldWorkMode, v))
}

// WorkModeHasPrefix applies the HasPrefix predicate on the "work_mode" field.
func WorkModeHasPrefix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasPrefix(FieldWorkMode, v))
}

// WorkModeHasSuffix applies the HasSuffix predicate on the "work_mode" field.
func WorkModeHasSuffix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasSuffix(FieldWorkMode, v))
}

// WorkModeIsNil applies the IsNil predicate on the "work_mode" field.
func WorkModeIsNil() predicate.Task {
	return predicate.Task(sql.FieldIsNull(FieldWorkMode))
}

// WorkModeNotNil applies the NotNil predicate on the "work_mode" field.
func WorkModeNotNil() predicate.Task {
	return predicate.Task(sql.FieldNotNull(FieldWorkMode))
}

// WorkModeEqualFold applies the EqualFold predicate on the "work_mode" field.
func WorkModeEqualFold(v string) predicate.Task {
	return predicate.Task(sql.FieldEqualFold(FieldWorkMode, v))
}

// WorkModeContainsFold applies the ContainsFold predicate on the "work_mode" field.
func WorkModeContainsFold(v string) predicate.Task {
	return predicate.Task(sql.FieldContainsFold(FieldWorkMode, v))
}

// PromptEQ applies the EQ predicate on the "prompt" field.
func PromptEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldPrompt, v))
}

// PromptNEQ applies the NEQ predicate on the "prompt" field.
func PromptNEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldPrompt, v))
}

// PromptIn applies the In predicate on the "prompt" field.
func PromptIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldPrompt, vs...))
}

// PromptNotIn applies the NotIn predicate on the "prompt" field.
func PromptNotIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldPrompt, vs...))
}

// PromptGT applies the GT predicate on the "prompt" field.
func PromptGT(v string) predicate.Task {
	return predicate.Task(sql.FieldGT(FieldPrompt, v))
}

// PromptGTE applies the GTE predicate on the "prompt" field.
func PromptGTE(v string) predicate.Task {
	return predicate.Task(sql.FieldGTE(FieldPrompt, v))
}

// PromptLT applies the LT predicate on the "prompt" field.
func PromptLT(v string) predicate.Task {
	return predicate.Task(sql.FieldLT(FieldPrompt, v))
}

// PromptLTE applies the LTE predicate on the "prompt" field.
func PromptLTE(v string) predicate.Task {
	return predicate.Task(sql.FieldLTE(FieldPrompt, v))
}

// PromptContains applies the Contains predicate on the "prompt" field.
func PromptContains(v string) predicate.Task {
	return predicate.Task(sql.FieldContains(FieldPrompt, v))
}

// PromptHasPrefix applies the HasPrefix predicate on the "prompt" field.
func PromptHasPrefix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasPrefix(FieldPrompt, v))
}

// PromptHasSuffix applies the HasSuffix predicate on the "prompt" field.
func PromptHasSuffix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasSuffix(FieldPrompt, v))
}

// PromptIsNil applies the IsNil predicate on the "prompt" field.
func PromptIsNil() predicate.Task {
	return predicate.Task(sql.FieldIsNull(FieldPrompt))
}

// PromptNotNil applies the NotNil predicate on the "prompt" field.
func PromptNotNil() predicate.Task {
	return predicate.Task(sql.FieldNotNull(FieldPrompt))
}

// PromptEqualFold applies the EqualFold predicate on the "prompt" field.
func PromptEqualFold(v string) predicate.Task {
	return predicate.Task(sql.FieldEqualFold(FieldPrompt, v))
}

// PromptContainsFold applies the ContainsFold predicate on the "prompt" field.
func PromptContainsFold(v string) predicate.Task {
	return predicate.Task(sql.FieldContainsFold(FieldPrompt, v))
}

// CompletionEQ applies the EQ predicate on the "completion" field.
func CompletionEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldCompletion, v))
}

// CompletionNEQ applies the NEQ predicate on the "completion" field.
func CompletionNEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldCompletion, v))
}

// CompletionIn applies the In predicate on the "completion" field.
func CompletionIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldCompletion, vs...))
}

// CompletionNotIn applies the NotIn predicate on the "completion" field.
func CompletionNotIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldCompletion, vs...))
}

// CompletionGT applies the GT predicate on the "completion" field.
func CompletionGT(v string) predicate.Task {
	return predicate.Task(sql.FieldGT(FieldCompletion, v))
}

// CompletionGTE applies the GTE predicate on the "completion" field.
func CompletionGTE(v string) predicate.Task {
	return predicate.Task(sql.FieldGTE(FieldCompletion, v))
}

// CompletionLT applies the LT predicate on the "completion" field.
func CompletionLT(v string) predicate.Task {
	return predicate.Task(sql.FieldLT(FieldCompletion, v))
}

// CompletionLTE applies the LTE predicate on the "completion" field.
func CompletionLTE(v string) predicate.Task {
	return predicate.Task(sql.FieldLTE(FieldCompletion, v))
}

// CompletionContains applies the Contains predicate on the "completion" field.
func CompletionContains(v string) predicate.Task {
	return predicate.Task(sql.FieldContains(FieldCompletion, v))
}

// CompletionHasPrefix applies the HasPrefix predicate on the "completion" field.
func CompletionHasPrefix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasPrefix(FieldCompletion, v))
}

// CompletionHasSuffix applies the HasSuffix predicate on the "completion" field.
func CompletionHasSuffix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasSuffix(FieldCompletion, v))
}

// CompletionIsNil applies the IsNil predicate on the "completion" field.
func CompletionIsNil() predicate.Task {
	return predicate.Task(sql.FieldIsNull(FieldCompletion))
}

// CompletionNotNil applies the NotNil predicate on the "completion" field.
func CompletionNotNil() predicate.Task {
	return predicate.Task(sql.FieldNotNull(FieldCompletion))
}

// CompletionEqualFold applies the EqualFold predicate on the "completion" field.
func CompletionEqualFold(v string) predicate.Task {
	return predicate.Task(sql.FieldEqualFold(FieldCompletion, v))
}

// CompletionContainsFold applies the ContainsFold predicate on the "completion" field.
func CompletionContainsFold(v string) predicate.Task {
	return predicate.Task(sql.FieldContainsFold(FieldCompletion, v))
}

// CodeLinesEQ applies the EQ predicate on the "code_lines" field.
func CodeLinesEQ(v int64) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldCodeLines, v))
}

// CodeLinesNEQ applies the NEQ predicate on the "code_lines" field.
func CodeLinesNEQ(v int64) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldCodeLines, v))
}

// CodeLinesIn applies the In predicate on the "code_lines" field.
func CodeLinesIn(vs ...int64) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldCodeLines, vs...))
}

// CodeLinesNotIn applies the NotIn predicate on the "code_lines" field.
func CodeLinesNotIn(vs ...int64) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldCodeLines, vs...))
}

// CodeLinesGT applies the GT predicate on the "code_lines" field.
func CodeLinesGT(v int64) predicate.Task {
	return predicate.Task(sql.FieldGT(FieldCodeLines, v))
}

// CodeLinesGTE applies the GTE predicate on the "code_lines" field.
func CodeLinesGTE(v int64) predicate.Task {
	return predicate.Task(sql.FieldGTE(FieldCodeLines, v))
}

// CodeLinesLT applies the LT predicate on the "code_lines" field.
func CodeLinesLT(v int64) predicate.Task {
	return predicate.Task(sql.FieldLT(FieldCodeLines, v))
}

// CodeLinesLTE applies the LTE predicate on the "code_lines" field.
func CodeLinesLTE(v int64) predicate.Task {
	return predicate.Task(sql.FieldLTE(FieldCodeLines, v))
}

// CodeLinesIsNil applies the IsNil predicate on the "code_lines" field.
func CodeLinesIsNil() predicate.Task {
	return predicate.Task(sql.FieldIsNull(FieldCodeLines))
}

// CodeLinesNotNil applies the NotNil predicate on the "code_lines" field.
func CodeLinesNotNil() predicate.Task {
	return predicate.Task(sql.FieldNotNull(FieldCodeLines))
}

// InputTokensEQ applies the EQ predicate on the "input_tokens" field.
func InputTokensEQ(v int64) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldInputTokens, v))
}

// InputTokensNEQ applies the NEQ predicate on the "input_tokens" field.
func InputTokensNEQ(v int64) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldInputTokens, v))
}

// InputTokensIn applies the In predicate on the "input_tokens" field.
func InputTokensIn(vs ...int64) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldInputTokens, vs...))
}

// InputTokensNotIn applies the NotIn predicate on the "input_tokens" field.
func InputTokensNotIn(vs ...int64) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldInputTokens, vs...))
}

// InputTokensGT applies the GT predicate on the "input_tokens" field.
func InputTokensGT(v int64) predicate.Task {
	return predicate.Task(sql.FieldGT(FieldInputTokens, v))
}

// InputTokensGTE applies the GTE predicate on the "input_tokens" field.
func InputTokensGTE(v int64) predicate.Task {
	return predicate.Task(sql.FieldGTE(FieldInputTokens, v))
}

// InputTokensLT applies the LT predicate on the "input_tokens" field.
func InputTokensLT(v int64) predicate.Task {
	return predicate.Task(sql.FieldLT(FieldInputTokens, v))
}

// InputTokensLTE applies the LTE predicate on the "input_tokens" field.
func InputTokensLTE(v int64) predicate.Task {
	return predicate.Task(sql.FieldLTE(FieldInputTokens, v))
}

// InputTokensIsNil applies the IsNil predicate on the "input_tokens" field.
func InputTokensIsNil() predicate.Task {
	return predicate.Task(sql.FieldIsNull(FieldInputTokens))
}

// InputTokensNotNil applies the NotNil predicate on the "input_tokens" field.
func InputTokensNotNil() predicate.Task {
	return predicate.Task(sql.FieldNotNull(FieldInputTokens))
}

// OutputTokensEQ applies the EQ predicate on the "output_tokens" field.
func OutputTokensEQ(v int64) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldOutputTokens, v))
}

// OutputTokensNEQ applies the NEQ predicate on the "output_tokens" field.
func OutputTokensNEQ(v int64) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldOutputTokens, v))
}

// OutputTokensIn applies the In predicate on the "output_tokens" field.
func OutputTokensIn(vs ...int64) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldOutputTokens, vs...))
}

// OutputTokensNotIn applies the NotIn predicate on the "output_tokens" field.
func OutputTokensNotIn(vs ...int64) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldOutputTokens, vs...))
}

// OutputTokensGT applies the GT predicate on the "output_tokens" field.
func OutputTokensGT(v int64) predicate.Task {
	return predicate.Task(sql.FieldGT(FieldOutputTokens, v))
}

// OutputTokensGTE applies the GTE predicate on the "output_tokens" field.
func OutputTokensGTE(v int64) predicate.Task {
	return predicate.Task(sql.FieldGTE(FieldOutputTokens, v))
}

// OutputTokensLT applies the LT predicate on the "output_tokens" field.
func OutputTokensLT(v int64) predicate.Task {
	return predicate.Task(sql.FieldLT(FieldOutputTokens, v))
}

// OutputTokensLTE applies the LTE predicate on the "output_tokens" field.
func OutputTokensLTE(v int64) predicate.Task {
	return predicate.Task(sql.FieldLTE(FieldOutputTokens, v))
}

// OutputTokensIsNil applies the IsNil predicate on the "output_tokens" field.
func OutputTokensIsNil() predicate.Task {
	return predicate.Task(sql.FieldIsNull(FieldOutputTokens))
}

// OutputTokensNotNil applies the NotNil predicate on the "output_tokens" field.
func OutputTokensNotNil() predicate.Task {
	return predicate.Task(sql.FieldNotNull(FieldOutputTokens))
}

// IsSuggestedEQ applies the EQ predicate on the "is_suggested" field.
func IsSuggestedEQ(v bool) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldIsSuggested, v))
}

// IsSuggestedNEQ applies the NEQ predicate on the "is_suggested" field.
func IsSuggestedNEQ(v bool) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldIsSuggested, v))
}

// SourceCodeEQ applies the EQ predicate on the "source_code" field.
func SourceCodeEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldSourceCode, v))
}

// SourceCodeNEQ applies the NEQ predicate on the "source_code" field.
func SourceCodeNEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldSourceCode, v))
}

// SourceCodeIn applies the In predicate on the "source_code" field.
func SourceCodeIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldSourceCode, vs...))
}

// SourceCodeNotIn applies the NotIn predicate on the "source_code" field.
func SourceCodeNotIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldSourceCode, vs...))
}

// SourceCodeGT applies the GT predicate on the "source_code" field.
func SourceCodeGT(v string) predicate.Task {
	return predicate.Task(sql.FieldGT(FieldSourceCode, v))
}

// SourceCodeGTE applies the GTE predicate on the "source_code" field.
func SourceCodeGTE(v string) predicate.Task {
	return predicate.Task(sql.FieldGTE(FieldSourceCode, v))
}

// SourceCodeLT applies the LT predicate on the "source_code" field.
func SourceCodeLT(v string) predicate.Task {
	return predicate.Task(sql.FieldLT(FieldSourceCode, v))
}

// SourceCodeLTE applies the LTE predicate on the "source_code" field.
func SourceCodeLTE(v string) predicate.Task {
	return predicate.Task(sql.FieldLTE(FieldSourceCode, v))
}

// SourceCodeContains applies the Contains predicate on the "source_code" field.
func SourceCodeContains(v string) predicate.Task {
	return predicate.Task(sql.FieldContains(FieldSourceCode, v))
}

// SourceCodeHasPrefix applies the HasPrefix predicate on the "source_code" field.
func SourceCodeHasPrefix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasPrefix(FieldSourceCode, v))
}

// SourceCodeHasSuffix applies the HasSuffix predicate on the "source_code" field.
func SourceCodeHasSuffix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasSuffix(FieldSourceCode, v))
}

// SourceCodeIsNil applies the IsNil predicate on the "source_code" field.
func SourceCodeIsNil() predicate.Task {
	return predicate.Task(sql.FieldIsNull(FieldSourceCode))
}

// SourceCodeNotNil applies the NotNil predicate on the "source_code" field.
func SourceCodeNotNil() predicate.Task {
	return predicate.Task(sql.FieldNotNull(FieldSourceCode))
}

// SourceCodeEqualFold applies the EqualFold predicate on the "source_code" field.
func SourceCodeEqualFold(v string) predicate.Task {
	return predicate.Task(sql.FieldEqualFold(FieldSourceCode, v))
}

// SourceCodeContainsFold applies the ContainsFold predicate on the "source_code" field.
func SourceCodeContainsFold(v string) predicate.Task {
	return predicate.Task(sql.FieldContainsFold(FieldSourceCode, v))
}

// CursorPositionIsNil applies the IsNil predicate on the "cursor_position" field.
func CursorPositionIsNil() predicate.Task {
	return predicate.Task(sql.FieldIsNull(FieldCursorPosition))
}

// CursorPositionNotNil applies the NotNil predicate on the "cursor_position" field.
func CursorPositionNotNil() predicate.Task {
	return predicate.Task(sql.FieldNotNull(FieldCursorPosition))
}

// UserInputEQ applies the EQ predicate on the "user_input" field.
func UserInputEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldUserInput, v))
}

// UserInputNEQ applies the NEQ predicate on the "user_input" field.
func UserInputNEQ(v string) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldUserInput, v))
}

// UserInputIn applies the In predicate on the "user_input" field.
func UserInputIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldUserInput, vs...))
}

// UserInputNotIn applies the NotIn predicate on the "user_input" field.
func UserInputNotIn(vs ...string) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldUserInput, vs...))
}

// UserInputGT applies the GT predicate on the "user_input" field.
func UserInputGT(v string) predicate.Task {
	return predicate.Task(sql.FieldGT(FieldUserInput, v))
}

// UserInputGTE applies the GTE predicate on the "user_input" field.
func UserInputGTE(v string) predicate.Task {
	return predicate.Task(sql.FieldGTE(FieldUserInput, v))
}

// UserInputLT applies the LT predicate on the "user_input" field.
func UserInputLT(v string) predicate.Task {
	return predicate.Task(sql.FieldLT(FieldUserInput, v))
}

// UserInputLTE applies the LTE predicate on the "user_input" field.
func UserInputLTE(v string) predicate.Task {
	return predicate.Task(sql.FieldLTE(FieldUserInput, v))
}

// UserInputContains applies the Contains predicate on the "user_input" field.
func UserInputContains(v string) predicate.Task {
	return predicate.Task(sql.FieldContains(FieldUserInput, v))
}

// UserInputHasPrefix applies the HasPrefix predicate on the "user_input" field.
func UserInputHasPrefix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasPrefix(FieldUserInput, v))
}

// UserInputHasSuffix applies the HasSuffix predicate on the "user_input" field.
func UserInputHasSuffix(v string) predicate.Task {
	return predicate.Task(sql.FieldHasSuffix(FieldUserInput, v))
}

// UserInputIsNil applies the IsNil predicate on the "user_input" field.
func UserInputIsNil() predicate.Task {
	return predicate.Task(sql.FieldIsNull(FieldUserInput))
}

// UserInputNotNil applies the NotNil predicate on the "user_input" field.
func UserInputNotNil() predicate.Task {
	return predicate.Task(sql.FieldNotNull(FieldUserInput))
}

// UserInputEqualFold applies the EqualFold predicate on the "user_input" field.
func UserInputEqualFold(v string) predicate.Task {
	return predicate.Task(sql.FieldEqualFold(FieldUserInput, v))
}

// UserInputContainsFold applies the ContainsFold predicate on the "user_input" field.
func UserInputContainsFold(v string) predicate.Task {
	return predicate.Task(sql.FieldContainsFold(FieldUserInput, v))
}

// CreatedAtEQ applies the EQ predicate on the "created_at" field.
func CreatedAtEQ(v time.Time) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldCreatedAt, v))
}

// CreatedAtNEQ applies the NEQ predicate on the "created_at" field.
func CreatedAtNEQ(v time.Time) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldCreatedAt, v))
}

// CreatedAtIn applies the In predicate on the "created_at" field.
func CreatedAtIn(vs ...time.Time) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldCreatedAt, vs...))
}

// CreatedAtNotIn applies the NotIn predicate on the "created_at" field.
func CreatedAtNotIn(vs ...time.Time) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldCreatedAt, vs...))
}

// CreatedAtGT applies the GT predicate on the "created_at" field.
func CreatedAtGT(v time.Time) predicate.Task {
	return predicate.Task(sql.FieldGT(FieldCreatedAt, v))
}

// CreatedAtGTE applies the GTE predicate on the "created_at" field.
func CreatedAtGTE(v time.Time) predicate.Task {
	return predicate.Task(sql.FieldGTE(FieldCreatedAt, v))
}

// CreatedAtLT applies the LT predicate on the "created_at" field.
func CreatedAtLT(v time.Time) predicate.Task {
	return predicate.Task(sql.FieldLT(FieldCreatedAt, v))
}

// CreatedAtLTE applies the LTE predicate on the "created_at" field.
func CreatedAtLTE(v time.Time) predicate.Task {
	return predicate.Task(sql.FieldLTE(FieldCreatedAt, v))
}

// UpdatedAtEQ applies the EQ predicate on the "updated_at" field.
func UpdatedAtEQ(v time.Time) predicate.Task {
	return predicate.Task(sql.FieldEQ(FieldUpdatedAt, v))
}

// UpdatedAtNEQ applies the NEQ predicate on the "updated_at" field.
func UpdatedAtNEQ(v time.Time) predicate.Task {
	return predicate.Task(sql.FieldNEQ(FieldUpdatedAt, v))
}

// UpdatedAtIn applies the In predicate on the "updated_at" field.
func UpdatedAtIn(vs ...time.Time) predicate.Task {
	return predicate.Task(sql.FieldIn(FieldUpdatedAt, vs...))
}

// UpdatedAtNotIn applies the NotIn predicate on the "updated_at" field.
func UpdatedAtNotIn(vs ...time.Time) predicate.Task {
	return predicate.Task(sql.FieldNotIn(FieldUpdatedAt, vs...))
}

// UpdatedAtGT applies the GT predicate on the "updated_at" field.
func UpdatedAtGT(v time.Time) predicate.Task {
	return predicate.Task(sql.FieldGT(FieldUpdatedAt, v))
}

// UpdatedAtGTE applies the GTE predicate on the "updated_at" field.
func UpdatedAtGTE(v time.Time) predicate.Task {
	return predicate.Task(sql.FieldGTE(FieldUpdatedAt, v))
}

// UpdatedAtLT applies the LT predicate on the "updated_at" field.
func UpdatedAtLT(v time.Time) predicate.Task {
	return predicate.Task(sql.FieldLT(FieldUpdatedAt, v))
}

// UpdatedAtLTE applies the LTE predicate on the "updated_at" field.
func UpdatedAtLTE(v time.Time) predicate.Task {
	return predicate.Task(sql.FieldLTE(FieldUpdatedAt, v))
}

// HasTaskRecords applies the HasEdge predicate on the "task_records" edge.
func HasTaskRecords() predicate.Task {
	return predicate.Task(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, TaskRecordsTable, TaskRecordsColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasTaskRecordsWith applies the HasEdge predicate on the "task_records" edge with a given conditions (other predicates).
func HasTaskRecordsWith(preds ...predicate.TaskRecord) predicate.Task {
	return predicate.Task(func(s *sql.Selector) {
		step := newTaskRecordsStep()
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// HasUser applies the HasEdge predicate on the "user" edge.
func HasUser() predicate.Task {
	return predicate.Task(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, UserTable, UserColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasUserWith applies the HasEdge predicate on the "user" edge with a given conditions (other predicates).
func HasUserWith(preds ...predicate.User) predicate.Task {
	return predicate.Task(func(s *sql.Selector) {
		step := newUserStep()
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// HasModel applies the HasEdge predicate on the "model" edge.
func HasModel() predicate.Task {
	return predicate.Task(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, ModelTable, ModelColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasModelWith applies the HasEdge predicate on the "model" edge with a given conditions (other predicates).
func HasModelWith(preds ...predicate.Model) predicate.Task {
	return predicate.Task(func(s *sql.Selector) {
		step := newModelStep()
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.Task) predicate.Task {
	return predicate.Task(sql.AndPredicates(predicates...))
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.Task) predicate.Task {
	return predicate.Task(sql.OrPredicates(predicates...))
}

// Not applies the not operator on the given predicate.
func Not(p predicate.Task) predicate.Task {
	return predicate.Task(sql.NotPredicates(p))
}
