// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/model"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/task"
	"github.com/chaitin/MonkeyCode/backend/db/taskrecord"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/google/uuid"
)

// TaskUpdate is the builder for updating Task entities.
type TaskUpdate struct {
	config
	hooks     []Hook
	mutation  *TaskMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the TaskUpdate builder.
func (tu *TaskUpdate) Where(ps ...predicate.Task) *TaskUpdate {
	tu.mutation.Where(ps...)
	return tu
}

// SetTaskID sets the "task_id" field.
func (tu *TaskUpdate) SetTaskID(s string) *TaskUpdate {
	tu.mutation.SetTaskID(s)
	return tu
}

// SetNillableTaskID sets the "task_id" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableTaskID(s *string) *TaskUpdate {
	if s != nil {
		tu.SetTaskID(*s)
	}
	return tu
}

// SetUserID sets the "user_id" field.
func (tu *TaskUpdate) SetUserID(u uuid.UUID) *TaskUpdate {
	tu.mutation.SetUserID(u)
	return tu
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableUserID(u *uuid.UUID) *TaskUpdate {
	if u != nil {
		tu.SetUserID(*u)
	}
	return tu
}

// ClearUserID clears the value of the "user_id" field.
func (tu *TaskUpdate) ClearUserID() *TaskUpdate {
	tu.mutation.ClearUserID()
	return tu
}

// SetModelID sets the "model_id" field.
func (tu *TaskUpdate) SetModelID(u uuid.UUID) *TaskUpdate {
	tu.mutation.SetModelID(u)
	return tu
}

// SetNillableModelID sets the "model_id" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableModelID(u *uuid.UUID) *TaskUpdate {
	if u != nil {
		tu.SetModelID(*u)
	}
	return tu
}

// ClearModelID clears the value of the "model_id" field.
func (tu *TaskUpdate) ClearModelID() *TaskUpdate {
	tu.mutation.ClearModelID()
	return tu
}

// SetRequestID sets the "request_id" field.
func (tu *TaskUpdate) SetRequestID(s string) *TaskUpdate {
	tu.mutation.SetRequestID(s)
	return tu
}

// SetNillableRequestID sets the "request_id" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableRequestID(s *string) *TaskUpdate {
	if s != nil {
		tu.SetRequestID(*s)
	}
	return tu
}

// ClearRequestID clears the value of the "request_id" field.
func (tu *TaskUpdate) ClearRequestID() *TaskUpdate {
	tu.mutation.ClearRequestID()
	return tu
}

// SetModelType sets the "model_type" field.
func (tu *TaskUpdate) SetModelType(ct consts.ModelType) *TaskUpdate {
	tu.mutation.SetModelType(ct)
	return tu
}

// SetNillableModelType sets the "model_type" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableModelType(ct *consts.ModelType) *TaskUpdate {
	if ct != nil {
		tu.SetModelType(*ct)
	}
	return tu
}

// SetIsAccept sets the "is_accept" field.
func (tu *TaskUpdate) SetIsAccept(b bool) *TaskUpdate {
	tu.mutation.SetIsAccept(b)
	return tu
}

// SetNillableIsAccept sets the "is_accept" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableIsAccept(b *bool) *TaskUpdate {
	if b != nil {
		tu.SetIsAccept(*b)
	}
	return tu
}

// SetProgramLanguage sets the "program_language" field.
func (tu *TaskUpdate) SetProgramLanguage(s string) *TaskUpdate {
	tu.mutation.SetProgramLanguage(s)
	return tu
}

// SetNillableProgramLanguage sets the "program_language" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableProgramLanguage(s *string) *TaskUpdate {
	if s != nil {
		tu.SetProgramLanguage(*s)
	}
	return tu
}

// ClearProgramLanguage clears the value of the "program_language" field.
func (tu *TaskUpdate) ClearProgramLanguage() *TaskUpdate {
	tu.mutation.ClearProgramLanguage()
	return tu
}

// SetWorkMode sets the "work_mode" field.
func (tu *TaskUpdate) SetWorkMode(s string) *TaskUpdate {
	tu.mutation.SetWorkMode(s)
	return tu
}

// SetNillableWorkMode sets the "work_mode" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableWorkMode(s *string) *TaskUpdate {
	if s != nil {
		tu.SetWorkMode(*s)
	}
	return tu
}

// ClearWorkMode clears the value of the "work_mode" field.
func (tu *TaskUpdate) ClearWorkMode() *TaskUpdate {
	tu.mutation.ClearWorkMode()
	return tu
}

// SetPrompt sets the "prompt" field.
func (tu *TaskUpdate) SetPrompt(s string) *TaskUpdate {
	tu.mutation.SetPrompt(s)
	return tu
}

// SetNillablePrompt sets the "prompt" field if the given value is not nil.
func (tu *TaskUpdate) SetNillablePrompt(s *string) *TaskUpdate {
	if s != nil {
		tu.SetPrompt(*s)
	}
	return tu
}

// ClearPrompt clears the value of the "prompt" field.
func (tu *TaskUpdate) ClearPrompt() *TaskUpdate {
	tu.mutation.ClearPrompt()
	return tu
}

// SetCompletion sets the "completion" field.
func (tu *TaskUpdate) SetCompletion(s string) *TaskUpdate {
	tu.mutation.SetCompletion(s)
	return tu
}

// SetNillableCompletion sets the "completion" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableCompletion(s *string) *TaskUpdate {
	if s != nil {
		tu.SetCompletion(*s)
	}
	return tu
}

// ClearCompletion clears the value of the "completion" field.
func (tu *TaskUpdate) ClearCompletion() *TaskUpdate {
	tu.mutation.ClearCompletion()
	return tu
}

// SetCodeLines sets the "code_lines" field.
func (tu *TaskUpdate) SetCodeLines(i int64) *TaskUpdate {
	tu.mutation.ResetCodeLines()
	tu.mutation.SetCodeLines(i)
	return tu
}

// SetNillableCodeLines sets the "code_lines" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableCodeLines(i *int64) *TaskUpdate {
	if i != nil {
		tu.SetCodeLines(*i)
	}
	return tu
}

// AddCodeLines adds i to the "code_lines" field.
func (tu *TaskUpdate) AddCodeLines(i int64) *TaskUpdate {
	tu.mutation.AddCodeLines(i)
	return tu
}

// ClearCodeLines clears the value of the "code_lines" field.
func (tu *TaskUpdate) ClearCodeLines() *TaskUpdate {
	tu.mutation.ClearCodeLines()
	return tu
}

// SetInputTokens sets the "input_tokens" field.
func (tu *TaskUpdate) SetInputTokens(i int64) *TaskUpdate {
	tu.mutation.ResetInputTokens()
	tu.mutation.SetInputTokens(i)
	return tu
}

// SetNillableInputTokens sets the "input_tokens" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableInputTokens(i *int64) *TaskUpdate {
	if i != nil {
		tu.SetInputTokens(*i)
	}
	return tu
}

// AddInputTokens adds i to the "input_tokens" field.
func (tu *TaskUpdate) AddInputTokens(i int64) *TaskUpdate {
	tu.mutation.AddInputTokens(i)
	return tu
}

// ClearInputTokens clears the value of the "input_tokens" field.
func (tu *TaskUpdate) ClearInputTokens() *TaskUpdate {
	tu.mutation.ClearInputTokens()
	return tu
}

// SetOutputTokens sets the "output_tokens" field.
func (tu *TaskUpdate) SetOutputTokens(i int64) *TaskUpdate {
	tu.mutation.ResetOutputTokens()
	tu.mutation.SetOutputTokens(i)
	return tu
}

// SetNillableOutputTokens sets the "output_tokens" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableOutputTokens(i *int64) *TaskUpdate {
	if i != nil {
		tu.SetOutputTokens(*i)
	}
	return tu
}

// AddOutputTokens adds i to the "output_tokens" field.
func (tu *TaskUpdate) AddOutputTokens(i int64) *TaskUpdate {
	tu.mutation.AddOutputTokens(i)
	return tu
}

// ClearOutputTokens clears the value of the "output_tokens" field.
func (tu *TaskUpdate) ClearOutputTokens() *TaskUpdate {
	tu.mutation.ClearOutputTokens()
	return tu
}

// SetIsSuggested sets the "is_suggested" field.
func (tu *TaskUpdate) SetIsSuggested(b bool) *TaskUpdate {
	tu.mutation.SetIsSuggested(b)
	return tu
}

// SetNillableIsSuggested sets the "is_suggested" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableIsSuggested(b *bool) *TaskUpdate {
	if b != nil {
		tu.SetIsSuggested(*b)
	}
	return tu
}

// SetSourceCode sets the "source_code" field.
func (tu *TaskUpdate) SetSourceCode(s string) *TaskUpdate {
	tu.mutation.SetSourceCode(s)
	return tu
}

// SetNillableSourceCode sets the "source_code" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableSourceCode(s *string) *TaskUpdate {
	if s != nil {
		tu.SetSourceCode(*s)
	}
	return tu
}

// ClearSourceCode clears the value of the "source_code" field.
func (tu *TaskUpdate) ClearSourceCode() *TaskUpdate {
	tu.mutation.ClearSourceCode()
	return tu
}

// SetCursorPosition sets the "cursor_position" field.
func (tu *TaskUpdate) SetCursorPosition(m map[string]interface{}) *TaskUpdate {
	tu.mutation.SetCursorPosition(m)
	return tu
}

// ClearCursorPosition clears the value of the "cursor_position" field.
func (tu *TaskUpdate) ClearCursorPosition() *TaskUpdate {
	tu.mutation.ClearCursorPosition()
	return tu
}

// SetUserInput sets the "user_input" field.
func (tu *TaskUpdate) SetUserInput(s string) *TaskUpdate {
	tu.mutation.SetUserInput(s)
	return tu
}

// SetNillableUserInput sets the "user_input" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableUserInput(s *string) *TaskUpdate {
	if s != nil {
		tu.SetUserInput(*s)
	}
	return tu
}

// ClearUserInput clears the value of the "user_input" field.
func (tu *TaskUpdate) ClearUserInput() *TaskUpdate {
	tu.mutation.ClearUserInput()
	return tu
}

// SetCreatedAt sets the "created_at" field.
func (tu *TaskUpdate) SetCreatedAt(t time.Time) *TaskUpdate {
	tu.mutation.SetCreatedAt(t)
	return tu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (tu *TaskUpdate) SetNillableCreatedAt(t *time.Time) *TaskUpdate {
	if t != nil {
		tu.SetCreatedAt(*t)
	}
	return tu
}

// SetUpdatedAt sets the "updated_at" field.
func (tu *TaskUpdate) SetUpdatedAt(t time.Time) *TaskUpdate {
	tu.mutation.SetUpdatedAt(t)
	return tu
}

// AddTaskRecordIDs adds the "task_records" edge to the TaskRecord entity by IDs.
func (tu *TaskUpdate) AddTaskRecordIDs(ids ...uuid.UUID) *TaskUpdate {
	tu.mutation.AddTaskRecordIDs(ids...)
	return tu
}

// AddTaskRecords adds the "task_records" edges to the TaskRecord entity.
func (tu *TaskUpdate) AddTaskRecords(t ...*TaskRecord) *TaskUpdate {
	ids := make([]uuid.UUID, len(t))
	for i := range t {
		ids[i] = t[i].ID
	}
	return tu.AddTaskRecordIDs(ids...)
}

// SetUser sets the "user" edge to the User entity.
func (tu *TaskUpdate) SetUser(u *User) *TaskUpdate {
	return tu.SetUserID(u.ID)
}

// SetModel sets the "model" edge to the Model entity.
func (tu *TaskUpdate) SetModel(m *Model) *TaskUpdate {
	return tu.SetModelID(m.ID)
}

// Mutation returns the TaskMutation object of the builder.
func (tu *TaskUpdate) Mutation() *TaskMutation {
	return tu.mutation
}

// ClearTaskRecords clears all "task_records" edges to the TaskRecord entity.
func (tu *TaskUpdate) ClearTaskRecords() *TaskUpdate {
	tu.mutation.ClearTaskRecords()
	return tu
}

// RemoveTaskRecordIDs removes the "task_records" edge to TaskRecord entities by IDs.
func (tu *TaskUpdate) RemoveTaskRecordIDs(ids ...uuid.UUID) *TaskUpdate {
	tu.mutation.RemoveTaskRecordIDs(ids...)
	return tu
}

// RemoveTaskRecords removes "task_records" edges to TaskRecord entities.
func (tu *TaskUpdate) RemoveTaskRecords(t ...*TaskRecord) *TaskUpdate {
	ids := make([]uuid.UUID, len(t))
	for i := range t {
		ids[i] = t[i].ID
	}
	return tu.RemoveTaskRecordIDs(ids...)
}

// ClearUser clears the "user" edge to the User entity.
func (tu *TaskUpdate) ClearUser() *TaskUpdate {
	tu.mutation.ClearUser()
	return tu
}

// ClearModel clears the "model" edge to the Model entity.
func (tu *TaskUpdate) ClearModel() *TaskUpdate {
	tu.mutation.ClearModel()
	return tu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (tu *TaskUpdate) Save(ctx context.Context) (int, error) {
	tu.defaults()
	return withHooks(ctx, tu.sqlSave, tu.mutation, tu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (tu *TaskUpdate) SaveX(ctx context.Context) int {
	affected, err := tu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (tu *TaskUpdate) Exec(ctx context.Context) error {
	_, err := tu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (tu *TaskUpdate) ExecX(ctx context.Context) {
	if err := tu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (tu *TaskUpdate) defaults() {
	if _, ok := tu.mutation.UpdatedAt(); !ok {
		v := task.UpdateDefaultUpdatedAt()
		tu.mutation.SetUpdatedAt(v)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (tu *TaskUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *TaskUpdate {
	tu.modifiers = append(tu.modifiers, modifiers...)
	return tu
}

func (tu *TaskUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(task.Table, task.Columns, sqlgraph.NewFieldSpec(task.FieldID, field.TypeUUID))
	if ps := tu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := tu.mutation.TaskID(); ok {
		_spec.SetField(task.FieldTaskID, field.TypeString, value)
	}
	if value, ok := tu.mutation.RequestID(); ok {
		_spec.SetField(task.FieldRequestID, field.TypeString, value)
	}
	if tu.mutation.RequestIDCleared() {
		_spec.ClearField(task.FieldRequestID, field.TypeString)
	}
	if value, ok := tu.mutation.ModelType(); ok {
		_spec.SetField(task.FieldModelType, field.TypeString, value)
	}
	if value, ok := tu.mutation.IsAccept(); ok {
		_spec.SetField(task.FieldIsAccept, field.TypeBool, value)
	}
	if value, ok := tu.mutation.ProgramLanguage(); ok {
		_spec.SetField(task.FieldProgramLanguage, field.TypeString, value)
	}
	if tu.mutation.ProgramLanguageCleared() {
		_spec.ClearField(task.FieldProgramLanguage, field.TypeString)
	}
	if value, ok := tu.mutation.WorkMode(); ok {
		_spec.SetField(task.FieldWorkMode, field.TypeString, value)
	}
	if tu.mutation.WorkModeCleared() {
		_spec.ClearField(task.FieldWorkMode, field.TypeString)
	}
	if value, ok := tu.mutation.Prompt(); ok {
		_spec.SetField(task.FieldPrompt, field.TypeString, value)
	}
	if tu.mutation.PromptCleared() {
		_spec.ClearField(task.FieldPrompt, field.TypeString)
	}
	if value, ok := tu.mutation.Completion(); ok {
		_spec.SetField(task.FieldCompletion, field.TypeString, value)
	}
	if tu.mutation.CompletionCleared() {
		_spec.ClearField(task.FieldCompletion, field.TypeString)
	}
	if value, ok := tu.mutation.CodeLines(); ok {
		_spec.SetField(task.FieldCodeLines, field.TypeInt64, value)
	}
	if value, ok := tu.mutation.AddedCodeLines(); ok {
		_spec.AddField(task.FieldCodeLines, field.TypeInt64, value)
	}
	if tu.mutation.CodeLinesCleared() {
		_spec.ClearField(task.FieldCodeLines, field.TypeInt64)
	}
	if value, ok := tu.mutation.InputTokens(); ok {
		_spec.SetField(task.FieldInputTokens, field.TypeInt64, value)
	}
	if value, ok := tu.mutation.AddedInputTokens(); ok {
		_spec.AddField(task.FieldInputTokens, field.TypeInt64, value)
	}
	if tu.mutation.InputTokensCleared() {
		_spec.ClearField(task.FieldInputTokens, field.TypeInt64)
	}
	if value, ok := tu.mutation.OutputTokens(); ok {
		_spec.SetField(task.FieldOutputTokens, field.TypeInt64, value)
	}
	if value, ok := tu.mutation.AddedOutputTokens(); ok {
		_spec.AddField(task.FieldOutputTokens, field.TypeInt64, value)
	}
	if tu.mutation.OutputTokensCleared() {
		_spec.ClearField(task.FieldOutputTokens, field.TypeInt64)
	}
	if value, ok := tu.mutation.IsSuggested(); ok {
		_spec.SetField(task.FieldIsSuggested, field.TypeBool, value)
	}
	if value, ok := tu.mutation.SourceCode(); ok {
		_spec.SetField(task.FieldSourceCode, field.TypeString, value)
	}
	if tu.mutation.SourceCodeCleared() {
		_spec.ClearField(task.FieldSourceCode, field.TypeString)
	}
	if value, ok := tu.mutation.CursorPosition(); ok {
		_spec.SetField(task.FieldCursorPosition, field.TypeJSON, value)
	}
	if tu.mutation.CursorPositionCleared() {
		_spec.ClearField(task.FieldCursorPosition, field.TypeJSON)
	}
	if value, ok := tu.mutation.UserInput(); ok {
		_spec.SetField(task.FieldUserInput, field.TypeString, value)
	}
	if tu.mutation.UserInputCleared() {
		_spec.ClearField(task.FieldUserInput, field.TypeString)
	}
	if value, ok := tu.mutation.CreatedAt(); ok {
		_spec.SetField(task.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := tu.mutation.UpdatedAt(); ok {
		_spec.SetField(task.FieldUpdatedAt, field.TypeTime, value)
	}
	if tu.mutation.TaskRecordsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   task.TaskRecordsTable,
			Columns: []string{task.TaskRecordsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(taskrecord.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := tu.mutation.RemovedTaskRecordsIDs(); len(nodes) > 0 && !tu.mutation.TaskRecordsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   task.TaskRecordsTable,
			Columns: []string{task.TaskRecordsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(taskrecord.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := tu.mutation.TaskRecordsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   task.TaskRecordsTable,
			Columns: []string{task.TaskRecordsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(taskrecord.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if tu.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   task.UserTable,
			Columns: []string{task.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := tu.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   task.UserTable,
			Columns: []string{task.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if tu.mutation.ModelCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   task.ModelTable,
			Columns: []string{task.ModelColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(model.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := tu.mutation.ModelIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   task.ModelTable,
			Columns: []string{task.ModelColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(model.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(tu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, tu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{task.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	tu.mutation.done = true
	return n, nil
}

// TaskUpdateOne is the builder for updating a single Task entity.
type TaskUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *TaskMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetTaskID sets the "task_id" field.
func (tuo *TaskUpdateOne) SetTaskID(s string) *TaskUpdateOne {
	tuo.mutation.SetTaskID(s)
	return tuo
}

// SetNillableTaskID sets the "task_id" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableTaskID(s *string) *TaskUpdateOne {
	if s != nil {
		tuo.SetTaskID(*s)
	}
	return tuo
}

// SetUserID sets the "user_id" field.
func (tuo *TaskUpdateOne) SetUserID(u uuid.UUID) *TaskUpdateOne {
	tuo.mutation.SetUserID(u)
	return tuo
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableUserID(u *uuid.UUID) *TaskUpdateOne {
	if u != nil {
		tuo.SetUserID(*u)
	}
	return tuo
}

// ClearUserID clears the value of the "user_id" field.
func (tuo *TaskUpdateOne) ClearUserID() *TaskUpdateOne {
	tuo.mutation.ClearUserID()
	return tuo
}

// SetModelID sets the "model_id" field.
func (tuo *TaskUpdateOne) SetModelID(u uuid.UUID) *TaskUpdateOne {
	tuo.mutation.SetModelID(u)
	return tuo
}

// SetNillableModelID sets the "model_id" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableModelID(u *uuid.UUID) *TaskUpdateOne {
	if u != nil {
		tuo.SetModelID(*u)
	}
	return tuo
}

// ClearModelID clears the value of the "model_id" field.
func (tuo *TaskUpdateOne) ClearModelID() *TaskUpdateOne {
	tuo.mutation.ClearModelID()
	return tuo
}

// SetRequestID sets the "request_id" field.
func (tuo *TaskUpdateOne) SetRequestID(s string) *TaskUpdateOne {
	tuo.mutation.SetRequestID(s)
	return tuo
}

// SetNillableRequestID sets the "request_id" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableRequestID(s *string) *TaskUpdateOne {
	if s != nil {
		tuo.SetRequestID(*s)
	}
	return tuo
}

// ClearRequestID clears the value of the "request_id" field.
func (tuo *TaskUpdateOne) ClearRequestID() *TaskUpdateOne {
	tuo.mutation.ClearRequestID()
	return tuo
}

// SetModelType sets the "model_type" field.
func (tuo *TaskUpdateOne) SetModelType(ct consts.ModelType) *TaskUpdateOne {
	tuo.mutation.SetModelType(ct)
	return tuo
}

// SetNillableModelType sets the "model_type" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableModelType(ct *consts.ModelType) *TaskUpdateOne {
	if ct != nil {
		tuo.SetModelType(*ct)
	}
	return tuo
}

// SetIsAccept sets the "is_accept" field.
func (tuo *TaskUpdateOne) SetIsAccept(b bool) *TaskUpdateOne {
	tuo.mutation.SetIsAccept(b)
	return tuo
}

// SetNillableIsAccept sets the "is_accept" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableIsAccept(b *bool) *TaskUpdateOne {
	if b != nil {
		tuo.SetIsAccept(*b)
	}
	return tuo
}

// SetProgramLanguage sets the "program_language" field.
func (tuo *TaskUpdateOne) SetProgramLanguage(s string) *TaskUpdateOne {
	tuo.mutation.SetProgramLanguage(s)
	return tuo
}

// SetNillableProgramLanguage sets the "program_language" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableProgramLanguage(s *string) *TaskUpdateOne {
	if s != nil {
		tuo.SetProgramLanguage(*s)
	}
	return tuo
}

// ClearProgramLanguage clears the value of the "program_language" field.
func (tuo *TaskUpdateOne) ClearProgramLanguage() *TaskUpdateOne {
	tuo.mutation.ClearProgramLanguage()
	return tuo
}

// SetWorkMode sets the "work_mode" field.
func (tuo *TaskUpdateOne) SetWorkMode(s string) *TaskUpdateOne {
	tuo.mutation.SetWorkMode(s)
	return tuo
}

// SetNillableWorkMode sets the "work_mode" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableWorkMode(s *string) *TaskUpdateOne {
	if s != nil {
		tuo.SetWorkMode(*s)
	}
	return tuo
}

// ClearWorkMode clears the value of the "work_mode" field.
func (tuo *TaskUpdateOne) ClearWorkMode() *TaskUpdateOne {
	tuo.mutation.ClearWorkMode()
	return tuo
}

// SetPrompt sets the "prompt" field.
func (tuo *TaskUpdateOne) SetPrompt(s string) *TaskUpdateOne {
	tuo.mutation.SetPrompt(s)
	return tuo
}

// SetNillablePrompt sets the "prompt" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillablePrompt(s *string) *TaskUpdateOne {
	if s != nil {
		tuo.SetPrompt(*s)
	}
	return tuo
}

// ClearPrompt clears the value of the "prompt" field.
func (tuo *TaskUpdateOne) ClearPrompt() *TaskUpdateOne {
	tuo.mutation.ClearPrompt()
	return tuo
}

// SetCompletion sets the "completion" field.
func (tuo *TaskUpdateOne) SetCompletion(s string) *TaskUpdateOne {
	tuo.mutation.SetCompletion(s)
	return tuo
}

// SetNillableCompletion sets the "completion" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableCompletion(s *string) *TaskUpdateOne {
	if s != nil {
		tuo.SetCompletion(*s)
	}
	return tuo
}

// ClearCompletion clears the value of the "completion" field.
func (tuo *TaskUpdateOne) ClearCompletion() *TaskUpdateOne {
	tuo.mutation.ClearCompletion()
	return tuo
}

// SetCodeLines sets the "code_lines" field.
func (tuo *TaskUpdateOne) SetCodeLines(i int64) *TaskUpdateOne {
	tuo.mutation.ResetCodeLines()
	tuo.mutation.SetCodeLines(i)
	return tuo
}

// SetNillableCodeLines sets the "code_lines" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableCodeLines(i *int64) *TaskUpdateOne {
	if i != nil {
		tuo.SetCodeLines(*i)
	}
	return tuo
}

// AddCodeLines adds i to the "code_lines" field.
func (tuo *TaskUpdateOne) AddCodeLines(i int64) *TaskUpdateOne {
	tuo.mutation.AddCodeLines(i)
	return tuo
}

// ClearCodeLines clears the value of the "code_lines" field.
func (tuo *TaskUpdateOne) ClearCodeLines() *TaskUpdateOne {
	tuo.mutation.ClearCodeLines()
	return tuo
}

// SetInputTokens sets the "input_tokens" field.
func (tuo *TaskUpdateOne) SetInputTokens(i int64) *TaskUpdateOne {
	tuo.mutation.ResetInputTokens()
	tuo.mutation.SetInputTokens(i)
	return tuo
}

// SetNillableInputTokens sets the "input_tokens" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableInputTokens(i *int64) *TaskUpdateOne {
	if i != nil {
		tuo.SetInputTokens(*i)
	}
	return tuo
}

// AddInputTokens adds i to the "input_tokens" field.
func (tuo *TaskUpdateOne) AddInputTokens(i int64) *TaskUpdateOne {
	tuo.mutation.AddInputTokens(i)
	return tuo
}

// ClearInputTokens clears the value of the "input_tokens" field.
func (tuo *TaskUpdateOne) ClearInputTokens() *TaskUpdateOne {
	tuo.mutation.ClearInputTokens()
	return tuo
}

// SetOutputTokens sets the "output_tokens" field.
func (tuo *TaskUpdateOne) SetOutputTokens(i int64) *TaskUpdateOne {
	tuo.mutation.ResetOutputTokens()
	tuo.mutation.SetOutputTokens(i)
	return tuo
}

// SetNillableOutputTokens sets the "output_tokens" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableOutputTokens(i *int64) *TaskUpdateOne {
	if i != nil {
		tuo.SetOutputTokens(*i)
	}
	return tuo
}

// AddOutputTokens adds i to the "output_tokens" field.
func (tuo *TaskUpdateOne) AddOutputTokens(i int64) *TaskUpdateOne {
	tuo.mutation.AddOutputTokens(i)
	return tuo
}

// ClearOutputTokens clears the value of the "output_tokens" field.
func (tuo *TaskUpdateOne) ClearOutputTokens() *TaskUpdateOne {
	tuo.mutation.ClearOutputTokens()
	return tuo
}

// SetIsSuggested sets the "is_suggested" field.
func (tuo *TaskUpdateOne) SetIsSuggested(b bool) *TaskUpdateOne {
	tuo.mutation.SetIsSuggested(b)
	return tuo
}

// SetNillableIsSuggested sets the "is_suggested" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableIsSuggested(b *bool) *TaskUpdateOne {
	if b != nil {
		tuo.SetIsSuggested(*b)
	}
	return tuo
}

// SetSourceCode sets the "source_code" field.
func (tuo *TaskUpdateOne) SetSourceCode(s string) *TaskUpdateOne {
	tuo.mutation.SetSourceCode(s)
	return tuo
}

// SetNillableSourceCode sets the "source_code" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableSourceCode(s *string) *TaskUpdateOne {
	if s != nil {
		tuo.SetSourceCode(*s)
	}
	return tuo
}

// ClearSourceCode clears the value of the "source_code" field.
func (tuo *TaskUpdateOne) ClearSourceCode() *TaskUpdateOne {
	tuo.mutation.ClearSourceCode()
	return tuo
}

// SetCursorPosition sets the "cursor_position" field.
func (tuo *TaskUpdateOne) SetCursorPosition(m map[string]interface{}) *TaskUpdateOne {
	tuo.mutation.SetCursorPosition(m)
	return tuo
}

// ClearCursorPosition clears the value of the "cursor_position" field.
func (tuo *TaskUpdateOne) ClearCursorPosition() *TaskUpdateOne {
	tuo.mutation.ClearCursorPosition()
	return tuo
}

// SetUserInput sets the "user_input" field.
func (tuo *TaskUpdateOne) SetUserInput(s string) *TaskUpdateOne {
	tuo.mutation.SetUserInput(s)
	return tuo
}

// SetNillableUserInput sets the "user_input" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableUserInput(s *string) *TaskUpdateOne {
	if s != nil {
		tuo.SetUserInput(*s)
	}
	return tuo
}

// ClearUserInput clears the value of the "user_input" field.
func (tuo *TaskUpdateOne) ClearUserInput() *TaskUpdateOne {
	tuo.mutation.ClearUserInput()
	return tuo
}

// SetCreatedAt sets the "created_at" field.
func (tuo *TaskUpdateOne) SetCreatedAt(t time.Time) *TaskUpdateOne {
	tuo.mutation.SetCreatedAt(t)
	return tuo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (tuo *TaskUpdateOne) SetNillableCreatedAt(t *time.Time) *TaskUpdateOne {
	if t != nil {
		tuo.SetCreatedAt(*t)
	}
	return tuo
}

// SetUpdatedAt sets the "updated_at" field.
func (tuo *TaskUpdateOne) SetUpdatedAt(t time.Time) *TaskUpdateOne {
	tuo.mutation.SetUpdatedAt(t)
	return tuo
}

// AddTaskRecordIDs adds the "task_records" edge to the TaskRecord entity by IDs.
func (tuo *TaskUpdateOne) AddTaskRecordIDs(ids ...uuid.UUID) *TaskUpdateOne {
	tuo.mutation.AddTaskRecordIDs(ids...)
	return tuo
}

// AddTaskRecords adds the "task_records" edges to the TaskRecord entity.
func (tuo *TaskUpdateOne) AddTaskRecords(t ...*TaskRecord) *TaskUpdateOne {
	ids := make([]uuid.UUID, len(t))
	for i := range t {
		ids[i] = t[i].ID
	}
	return tuo.AddTaskRecordIDs(ids...)
}

// SetUser sets the "user" edge to the User entity.
func (tuo *TaskUpdateOne) SetUser(u *User) *TaskUpdateOne {
	return tuo.SetUserID(u.ID)
}

// SetModel sets the "model" edge to the Model entity.
func (tuo *TaskUpdateOne) SetModel(m *Model) *TaskUpdateOne {
	return tuo.SetModelID(m.ID)
}

// Mutation returns the TaskMutation object of the builder.
func (tuo *TaskUpdateOne) Mutation() *TaskMutation {
	return tuo.mutation
}

// ClearTaskRecords clears all "task_records" edges to the TaskRecord entity.
func (tuo *TaskUpdateOne) ClearTaskRecords() *TaskUpdateOne {
	tuo.mutation.ClearTaskRecords()
	return tuo
}

// RemoveTaskRecordIDs removes the "task_records" edge to TaskRecord entities by IDs.
func (tuo *TaskUpdateOne) RemoveTaskRecordIDs(ids ...uuid.UUID) *TaskUpdateOne {
	tuo.mutation.RemoveTaskRecordIDs(ids...)
	return tuo
}

// RemoveTaskRecords removes "task_records" edges to TaskRecord entities.
func (tuo *TaskUpdateOne) RemoveTaskRecords(t ...*TaskRecord) *TaskUpdateOne {
	ids := make([]uuid.UUID, len(t))
	for i := range t {
		ids[i] = t[i].ID
	}
	return tuo.RemoveTaskRecordIDs(ids...)
}

// ClearUser clears the "user" edge to the User entity.
func (tuo *TaskUpdateOne) ClearUser() *TaskUpdateOne {
	tuo.mutation.ClearUser()
	return tuo
}

// ClearModel clears the "model" edge to the Model entity.
func (tuo *TaskUpdateOne) ClearModel() *TaskUpdateOne {
	tuo.mutation.ClearModel()
	return tuo
}

// Where appends a list predicates to the TaskUpdate builder.
func (tuo *TaskUpdateOne) Where(ps ...predicate.Task) *TaskUpdateOne {
	tuo.mutation.Where(ps...)
	return tuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (tuo *TaskUpdateOne) Select(field string, fields ...string) *TaskUpdateOne {
	tuo.fields = append([]string{field}, fields...)
	return tuo
}

// Save executes the query and returns the updated Task entity.
func (tuo *TaskUpdateOne) Save(ctx context.Context) (*Task, error) {
	tuo.defaults()
	return withHooks(ctx, tuo.sqlSave, tuo.mutation, tuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (tuo *TaskUpdateOne) SaveX(ctx context.Context) *Task {
	node, err := tuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (tuo *TaskUpdateOne) Exec(ctx context.Context) error {
	_, err := tuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (tuo *TaskUpdateOne) ExecX(ctx context.Context) {
	if err := tuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (tuo *TaskUpdateOne) defaults() {
	if _, ok := tuo.mutation.UpdatedAt(); !ok {
		v := task.UpdateDefaultUpdatedAt()
		tuo.mutation.SetUpdatedAt(v)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (tuo *TaskUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *TaskUpdateOne {
	tuo.modifiers = append(tuo.modifiers, modifiers...)
	return tuo
}

func (tuo *TaskUpdateOne) sqlSave(ctx context.Context) (_node *Task, err error) {
	_spec := sqlgraph.NewUpdateSpec(task.Table, task.Columns, sqlgraph.NewFieldSpec(task.FieldID, field.TypeUUID))
	id, ok := tuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "Task.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := tuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, task.FieldID)
		for _, f := range fields {
			if !task.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != task.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := tuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := tuo.mutation.TaskID(); ok {
		_spec.SetField(task.FieldTaskID, field.TypeString, value)
	}
	if value, ok := tuo.mutation.RequestID(); ok {
		_spec.SetField(task.FieldRequestID, field.TypeString, value)
	}
	if tuo.mutation.RequestIDCleared() {
		_spec.ClearField(task.FieldRequestID, field.TypeString)
	}
	if value, ok := tuo.mutation.ModelType(); ok {
		_spec.SetField(task.FieldModelType, field.TypeString, value)
	}
	if value, ok := tuo.mutation.IsAccept(); ok {
		_spec.SetField(task.FieldIsAccept, field.TypeBool, value)
	}
	if value, ok := tuo.mutation.ProgramLanguage(); ok {
		_spec.SetField(task.FieldProgramLanguage, field.TypeString, value)
	}
	if tuo.mutation.ProgramLanguageCleared() {
		_spec.ClearField(task.FieldProgramLanguage, field.TypeString)
	}
	if value, ok := tuo.mutation.WorkMode(); ok {
		_spec.SetField(task.FieldWorkMode, field.TypeString, value)
	}
	if tuo.mutation.WorkModeCleared() {
		_spec.ClearField(task.FieldWorkMode, field.TypeString)
	}
	if value, ok := tuo.mutation.Prompt(); ok {
		_spec.SetField(task.FieldPrompt, field.TypeString, value)
	}
	if tuo.mutation.PromptCleared() {
		_spec.ClearField(task.FieldPrompt, field.TypeString)
	}
	if value, ok := tuo.mutation.Completion(); ok {
		_spec.SetField(task.FieldCompletion, field.TypeString, value)
	}
	if tuo.mutation.CompletionCleared() {
		_spec.ClearField(task.FieldCompletion, field.TypeString)
	}
	if value, ok := tuo.mutation.CodeLines(); ok {
		_spec.SetField(task.FieldCodeLines, field.TypeInt64, value)
	}
	if value, ok := tuo.mutation.AddedCodeLines(); ok {
		_spec.AddField(task.FieldCodeLines, field.TypeInt64, value)
	}
	if tuo.mutation.CodeLinesCleared() {
		_spec.ClearField(task.FieldCodeLines, field.TypeInt64)
	}
	if value, ok := tuo.mutation.InputTokens(); ok {
		_spec.SetField(task.FieldInputTokens, field.TypeInt64, value)
	}
	if value, ok := tuo.mutation.AddedInputTokens(); ok {
		_spec.AddField(task.FieldInputTokens, field.TypeInt64, value)
	}
	if tuo.mutation.InputTokensCleared() {
		_spec.ClearField(task.FieldInputTokens, field.TypeInt64)
	}
	if value, ok := tuo.mutation.OutputTokens(); ok {
		_spec.SetField(task.FieldOutputTokens, field.TypeInt64, value)
	}
	if value, ok := tuo.mutation.AddedOutputTokens(); ok {
		_spec.AddField(task.FieldOutputTokens, field.TypeInt64, value)
	}
	if tuo.mutation.OutputTokensCleared() {
		_spec.ClearField(task.FieldOutputTokens, field.TypeInt64)
	}
	if value, ok := tuo.mutation.IsSuggested(); ok {
		_spec.SetField(task.FieldIsSuggested, field.TypeBool, value)
	}
	if value, ok := tuo.mutation.SourceCode(); ok {
		_spec.SetField(task.FieldSourceCode, field.TypeString, value)
	}
	if tuo.mutation.SourceCodeCleared() {
		_spec.ClearField(task.FieldSourceCode, field.TypeString)
	}
	if value, ok := tuo.mutation.CursorPosition(); ok {
		_spec.SetField(task.FieldCursorPosition, field.TypeJSON, value)
	}
	if tuo.mutation.CursorPositionCleared() {
		_spec.ClearField(task.FieldCursorPosition, field.TypeJSON)
	}
	if value, ok := tuo.mutation.UserInput(); ok {
		_spec.SetField(task.FieldUserInput, field.TypeString, value)
	}
	if tuo.mutation.UserInputCleared() {
		_spec.ClearField(task.FieldUserInput, field.TypeString)
	}
	if value, ok := tuo.mutation.CreatedAt(); ok {
		_spec.SetField(task.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := tuo.mutation.UpdatedAt(); ok {
		_spec.SetField(task.FieldUpdatedAt, field.TypeTime, value)
	}
	if tuo.mutation.TaskRecordsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   task.TaskRecordsTable,
			Columns: []string{task.TaskRecordsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(taskrecord.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := tuo.mutation.RemovedTaskRecordsIDs(); len(nodes) > 0 && !tuo.mutation.TaskRecordsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   task.TaskRecordsTable,
			Columns: []string{task.TaskRecordsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(taskrecord.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := tuo.mutation.TaskRecordsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   task.TaskRecordsTable,
			Columns: []string{task.TaskRecordsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(taskrecord.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if tuo.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   task.UserTable,
			Columns: []string{task.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := tuo.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   task.UserTable,
			Columns: []string{task.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if tuo.mutation.ModelCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   task.ModelTable,
			Columns: []string{task.ModelColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(model.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := tuo.mutation.ModelIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   task.ModelTable,
			Columns: []string{task.ModelColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(model.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(tuo.modifiers...)
	_node = &Task{config: tuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, tuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{task.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	tuo.mutation.done = true
	return _node, nil
}
