// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/task"
	"github.com/chaitin/MonkeyCode/backend/db/taskrecord"
	"github.com/google/uuid"
)

// TaskRecordCreate is the builder for creating a TaskRecord entity.
type TaskRecordCreate struct {
	config
	mutation *TaskRecordMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetTaskID sets the "task_id" field.
func (trc *TaskRecordCreate) SetTaskID(u uuid.UUID) *TaskRecordCreate {
	trc.mutation.SetTaskID(u)
	return trc
}

// SetNillableTaskID sets the "task_id" field if the given value is not nil.
func (trc *TaskRecordCreate) SetNillableTaskID(u *uuid.UUID) *TaskRecordCreate {
	if u != nil {
		trc.SetTaskID(*u)
	}
	return trc
}

// SetPrompt sets the "prompt" field.
func (trc *TaskRecordCreate) SetPrompt(s string) *TaskRecordCreate {
	trc.mutation.SetPrompt(s)
	return trc
}

// SetNillablePrompt sets the "prompt" field if the given value is not nil.
func (trc *TaskRecordCreate) SetNillablePrompt(s *string) *TaskRecordCreate {
	if s != nil {
		trc.SetPrompt(*s)
	}
	return trc
}

// SetRole sets the "role" field.
func (trc *TaskRecordCreate) SetRole(cr consts.ChatRole) *TaskRecordCreate {
	trc.mutation.SetRole(cr)
	return trc
}

// SetCompletion sets the "completion" field.
func (trc *TaskRecordCreate) SetCompletion(s string) *TaskRecordCreate {
	trc.mutation.SetCompletion(s)
	return trc
}

// SetNillableCompletion sets the "completion" field if the given value is not nil.
func (trc *TaskRecordCreate) SetNillableCompletion(s *string) *TaskRecordCreate {
	if s != nil {
		trc.SetCompletion(*s)
	}
	return trc
}

// SetOutputTokens sets the "output_tokens" field.
func (trc *TaskRecordCreate) SetOutputTokens(i int64) *TaskRecordCreate {
	trc.mutation.SetOutputTokens(i)
	return trc
}

// SetNillableOutputTokens sets the "output_tokens" field if the given value is not nil.
func (trc *TaskRecordCreate) SetNillableOutputTokens(i *int64) *TaskRecordCreate {
	if i != nil {
		trc.SetOutputTokens(*i)
	}
	return trc
}

// SetCodeLines sets the "code_lines" field.
func (trc *TaskRecordCreate) SetCodeLines(i int64) *TaskRecordCreate {
	trc.mutation.SetCodeLines(i)
	return trc
}

// SetNillableCodeLines sets the "code_lines" field if the given value is not nil.
func (trc *TaskRecordCreate) SetNillableCodeLines(i *int64) *TaskRecordCreate {
	if i != nil {
		trc.SetCodeLines(*i)
	}
	return trc
}

// SetCode sets the "code" field.
func (trc *TaskRecordCreate) SetCode(s string) *TaskRecordCreate {
	trc.mutation.SetCode(s)
	return trc
}

// SetNillableCode sets the "code" field if the given value is not nil.
func (trc *TaskRecordCreate) SetNillableCode(s *string) *TaskRecordCreate {
	if s != nil {
		trc.SetCode(*s)
	}
	return trc
}

// SetCreatedAt sets the "created_at" field.
func (trc *TaskRecordCreate) SetCreatedAt(t time.Time) *TaskRecordCreate {
	trc.mutation.SetCreatedAt(t)
	return trc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (trc *TaskRecordCreate) SetNillableCreatedAt(t *time.Time) *TaskRecordCreate {
	if t != nil {
		trc.SetCreatedAt(*t)
	}
	return trc
}

// SetUpdatedAt sets the "updated_at" field.
func (trc *TaskRecordCreate) SetUpdatedAt(t time.Time) *TaskRecordCreate {
	trc.mutation.SetUpdatedAt(t)
	return trc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (trc *TaskRecordCreate) SetNillableUpdatedAt(t *time.Time) *TaskRecordCreate {
	if t != nil {
		trc.SetUpdatedAt(*t)
	}
	return trc
}

// SetID sets the "id" field.
func (trc *TaskRecordCreate) SetID(u uuid.UUID) *TaskRecordCreate {
	trc.mutation.SetID(u)
	return trc
}

// SetTask sets the "task" edge to the Task entity.
func (trc *TaskRecordCreate) SetTask(t *Task) *TaskRecordCreate {
	return trc.SetTaskID(t.ID)
}

// Mutation returns the TaskRecordMutation object of the builder.
func (trc *TaskRecordCreate) Mutation() *TaskRecordMutation {
	return trc.mutation
}

// Save creates the TaskRecord in the database.
func (trc *TaskRecordCreate) Save(ctx context.Context) (*TaskRecord, error) {
	trc.defaults()
	return withHooks(ctx, trc.sqlSave, trc.mutation, trc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (trc *TaskRecordCreate) SaveX(ctx context.Context) *TaskRecord {
	v, err := trc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (trc *TaskRecordCreate) Exec(ctx context.Context) error {
	_, err := trc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (trc *TaskRecordCreate) ExecX(ctx context.Context) {
	if err := trc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (trc *TaskRecordCreate) defaults() {
	if _, ok := trc.mutation.OutputTokens(); !ok {
		v := taskrecord.DefaultOutputTokens
		trc.mutation.SetOutputTokens(v)
	}
	if _, ok := trc.mutation.CodeLines(); !ok {
		v := taskrecord.DefaultCodeLines
		trc.mutation.SetCodeLines(v)
	}
	if _, ok := trc.mutation.CreatedAt(); !ok {
		v := taskrecord.DefaultCreatedAt()
		trc.mutation.SetCreatedAt(v)
	}
	if _, ok := trc.mutation.UpdatedAt(); !ok {
		v := taskrecord.DefaultUpdatedAt()
		trc.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (trc *TaskRecordCreate) check() error {
	if _, ok := trc.mutation.Role(); !ok {
		return &ValidationError{Name: "role", err: errors.New(`db: missing required field "TaskRecord.role"`)}
	}
	if _, ok := trc.mutation.OutputTokens(); !ok {
		return &ValidationError{Name: "output_tokens", err: errors.New(`db: missing required field "TaskRecord.output_tokens"`)}
	}
	if _, ok := trc.mutation.CodeLines(); !ok {
		return &ValidationError{Name: "code_lines", err: errors.New(`db: missing required field "TaskRecord.code_lines"`)}
	}
	if _, ok := trc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "TaskRecord.created_at"`)}
	}
	if _, ok := trc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "TaskRecord.updated_at"`)}
	}
	return nil
}

func (trc *TaskRecordCreate) sqlSave(ctx context.Context) (*TaskRecord, error) {
	if err := trc.check(); err != nil {
		return nil, err
	}
	_node, _spec := trc.createSpec()
	if err := sqlgraph.CreateNode(ctx, trc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	trc.mutation.id = &_node.ID
	trc.mutation.done = true
	return _node, nil
}

func (trc *TaskRecordCreate) createSpec() (*TaskRecord, *sqlgraph.CreateSpec) {
	var (
		_node = &TaskRecord{config: trc.config}
		_spec = sqlgraph.NewCreateSpec(taskrecord.Table, sqlgraph.NewFieldSpec(taskrecord.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = trc.conflict
	if id, ok := trc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := trc.mutation.Prompt(); ok {
		_spec.SetField(taskrecord.FieldPrompt, field.TypeString, value)
		_node.Prompt = value
	}
	if value, ok := trc.mutation.Role(); ok {
		_spec.SetField(taskrecord.FieldRole, field.TypeString, value)
		_node.Role = value
	}
	if value, ok := trc.mutation.Completion(); ok {
		_spec.SetField(taskrecord.FieldCompletion, field.TypeString, value)
		_node.Completion = value
	}
	if value, ok := trc.mutation.OutputTokens(); ok {
		_spec.SetField(taskrecord.FieldOutputTokens, field.TypeInt64, value)
		_node.OutputTokens = value
	}
	if value, ok := trc.mutation.CodeLines(); ok {
		_spec.SetField(taskrecord.FieldCodeLines, field.TypeInt64, value)
		_node.CodeLines = value
	}
	if value, ok := trc.mutation.Code(); ok {
		_spec.SetField(taskrecord.FieldCode, field.TypeString, value)
		_node.Code = value
	}
	if value, ok := trc.mutation.CreatedAt(); ok {
		_spec.SetField(taskrecord.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := trc.mutation.UpdatedAt(); ok {
		_spec.SetField(taskrecord.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if nodes := trc.mutation.TaskIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   taskrecord.TaskTable,
			Columns: []string{taskrecord.TaskColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(task.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.TaskID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.TaskRecord.Create().
//		SetTaskID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.TaskRecordUpsert) {
//			SetTaskID(v+v).
//		}).
//		Exec(ctx)
func (trc *TaskRecordCreate) OnConflict(opts ...sql.ConflictOption) *TaskRecordUpsertOne {
	trc.conflict = opts
	return &TaskRecordUpsertOne{
		create: trc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.TaskRecord.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (trc *TaskRecordCreate) OnConflictColumns(columns ...string) *TaskRecordUpsertOne {
	trc.conflict = append(trc.conflict, sql.ConflictColumns(columns...))
	return &TaskRecordUpsertOne{
		create: trc,
	}
}

type (
	// TaskRecordUpsertOne is the builder for "upsert"-ing
	//  one TaskRecord node.
	TaskRecordUpsertOne struct {
		create *TaskRecordCreate
	}

	// TaskRecordUpsert is the "OnConflict" setter.
	TaskRecordUpsert struct {
		*sql.UpdateSet
	}
)

// SetTaskID sets the "task_id" field.
func (u *TaskRecordUpsert) SetTaskID(v uuid.UUID) *TaskRecordUpsert {
	u.Set(taskrecord.FieldTaskID, v)
	return u
}

// UpdateTaskID sets the "task_id" field to the value that was provided on create.
func (u *TaskRecordUpsert) UpdateTaskID() *TaskRecordUpsert {
	u.SetExcluded(taskrecord.FieldTaskID)
	return u
}

// ClearTaskID clears the value of the "task_id" field.
func (u *TaskRecordUpsert) ClearTaskID() *TaskRecordUpsert {
	u.SetNull(taskrecord.FieldTaskID)
	return u
}

// SetPrompt sets the "prompt" field.
func (u *TaskRecordUpsert) SetPrompt(v string) *TaskRecordUpsert {
	u.Set(taskrecord.FieldPrompt, v)
	return u
}

// UpdatePrompt sets the "prompt" field to the value that was provided on create.
func (u *TaskRecordUpsert) UpdatePrompt() *TaskRecordUpsert {
	u.SetExcluded(taskrecord.FieldPrompt)
	return u
}

// ClearPrompt clears the value of the "prompt" field.
func (u *TaskRecordUpsert) ClearPrompt() *TaskRecordUpsert {
	u.SetNull(taskrecord.FieldPrompt)
	return u
}

// SetRole sets the "role" field.
func (u *TaskRecordUpsert) SetRole(v consts.ChatRole) *TaskRecordUpsert {
	u.Set(taskrecord.FieldRole, v)
	return u
}

// UpdateRole sets the "role" field to the value that was provided on create.
func (u *TaskRecordUpsert) UpdateRole() *TaskRecordUpsert {
	u.SetExcluded(taskrecord.FieldRole)
	return u
}

// SetCompletion sets the "completion" field.
func (u *TaskRecordUpsert) SetCompletion(v string) *TaskRecordUpsert {
	u.Set(taskrecord.FieldCompletion, v)
	return u
}

// UpdateCompletion sets the "completion" field to the value that was provided on create.
func (u *TaskRecordUpsert) UpdateCompletion() *TaskRecordUpsert {
	u.SetExcluded(taskrecord.FieldCompletion)
	return u
}

// ClearCompletion clears the value of the "completion" field.
func (u *TaskRecordUpsert) ClearCompletion() *TaskRecordUpsert {
	u.SetNull(taskrecord.FieldCompletion)
	return u
}

// SetOutputTokens sets the "output_tokens" field.
func (u *TaskRecordUpsert) SetOutputTokens(v int64) *TaskRecordUpsert {
	u.Set(taskrecord.FieldOutputTokens, v)
	return u
}

// UpdateOutputTokens sets the "output_tokens" field to the value that was provided on create.
func (u *TaskRecordUpsert) UpdateOutputTokens() *TaskRecordUpsert {
	u.SetExcluded(taskrecord.FieldOutputTokens)
	return u
}

// AddOutputTokens adds v to the "output_tokens" field.
func (u *TaskRecordUpsert) AddOutputTokens(v int64) *TaskRecordUpsert {
	u.Add(taskrecord.FieldOutputTokens, v)
	return u
}

// SetCodeLines sets the "code_lines" field.
func (u *TaskRecordUpsert) SetCodeLines(v int64) *TaskRecordUpsert {
	u.Set(taskrecord.FieldCodeLines, v)
	return u
}

// UpdateCodeLines sets the "code_lines" field to the value that was provided on create.
func (u *TaskRecordUpsert) UpdateCodeLines() *TaskRecordUpsert {
	u.SetExcluded(taskrecord.FieldCodeLines)
	return u
}

// AddCodeLines adds v to the "code_lines" field.
func (u *TaskRecordUpsert) AddCodeLines(v int64) *TaskRecordUpsert {
	u.Add(taskrecord.FieldCodeLines, v)
	return u
}

// SetCode sets the "code" field.
func (u *TaskRecordUpsert) SetCode(v string) *TaskRecordUpsert {
	u.Set(taskrecord.FieldCode, v)
	return u
}

// UpdateCode sets the "code" field to the value that was provided on create.
func (u *TaskRecordUpsert) UpdateCode() *TaskRecordUpsert {
	u.SetExcluded(taskrecord.FieldCode)
	return u
}

// ClearCode clears the value of the "code" field.
func (u *TaskRecordUpsert) ClearCode() *TaskRecordUpsert {
	u.SetNull(taskrecord.FieldCode)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *TaskRecordUpsert) SetCreatedAt(v time.Time) *TaskRecordUpsert {
	u.Set(taskrecord.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *TaskRecordUpsert) UpdateCreatedAt() *TaskRecordUpsert {
	u.SetExcluded(taskrecord.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *TaskRecordUpsert) SetUpdatedAt(v time.Time) *TaskRecordUpsert {
	u.Set(taskrecord.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *TaskRecordUpsert) UpdateUpdatedAt() *TaskRecordUpsert {
	u.SetExcluded(taskrecord.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.TaskRecord.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(taskrecord.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *TaskRecordUpsertOne) UpdateNewValues() *TaskRecordUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(taskrecord.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.TaskRecord.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *TaskRecordUpsertOne) Ignore() *TaskRecordUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *TaskRecordUpsertOne) DoNothing() *TaskRecordUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the TaskRecordCreate.OnConflict
// documentation for more info.
func (u *TaskRecordUpsertOne) Update(set func(*TaskRecordUpsert)) *TaskRecordUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&TaskRecordUpsert{UpdateSet: update})
	}))
	return u
}

// SetTaskID sets the "task_id" field.
func (u *TaskRecordUpsertOne) SetTaskID(v uuid.UUID) *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetTaskID(v)
	})
}

// UpdateTaskID sets the "task_id" field to the value that was provided on create.
func (u *TaskRecordUpsertOne) UpdateTaskID() *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateTaskID()
	})
}

// ClearTaskID clears the value of the "task_id" field.
func (u *TaskRecordUpsertOne) ClearTaskID() *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.ClearTaskID()
	})
}

// SetPrompt sets the "prompt" field.
func (u *TaskRecordUpsertOne) SetPrompt(v string) *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetPrompt(v)
	})
}

// UpdatePrompt sets the "prompt" field to the value that was provided on create.
func (u *TaskRecordUpsertOne) UpdatePrompt() *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdatePrompt()
	})
}

// ClearPrompt clears the value of the "prompt" field.
func (u *TaskRecordUpsertOne) ClearPrompt() *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.ClearPrompt()
	})
}

// SetRole sets the "role" field.
func (u *TaskRecordUpsertOne) SetRole(v consts.ChatRole) *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetRole(v)
	})
}

// UpdateRole sets the "role" field to the value that was provided on create.
func (u *TaskRecordUpsertOne) UpdateRole() *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateRole()
	})
}

// SetCompletion sets the "completion" field.
func (u *TaskRecordUpsertOne) SetCompletion(v string) *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetCompletion(v)
	})
}

// UpdateCompletion sets the "completion" field to the value that was provided on create.
func (u *TaskRecordUpsertOne) UpdateCompletion() *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateCompletion()
	})
}

// ClearCompletion clears the value of the "completion" field.
func (u *TaskRecordUpsertOne) ClearCompletion() *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.ClearCompletion()
	})
}

// SetOutputTokens sets the "output_tokens" field.
func (u *TaskRecordUpsertOne) SetOutputTokens(v int64) *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetOutputTokens(v)
	})
}

// AddOutputTokens adds v to the "output_tokens" field.
func (u *TaskRecordUpsertOne) AddOutputTokens(v int64) *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.AddOutputTokens(v)
	})
}

// UpdateOutputTokens sets the "output_tokens" field to the value that was provided on create.
func (u *TaskRecordUpsertOne) UpdateOutputTokens() *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateOutputTokens()
	})
}

// SetCodeLines sets the "code_lines" field.
func (u *TaskRecordUpsertOne) SetCodeLines(v int64) *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetCodeLines(v)
	})
}

// AddCodeLines adds v to the "code_lines" field.
func (u *TaskRecordUpsertOne) AddCodeLines(v int64) *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.AddCodeLines(v)
	})
}

// UpdateCodeLines sets the "code_lines" field to the value that was provided on create.
func (u *TaskRecordUpsertOne) UpdateCodeLines() *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateCodeLines()
	})
}

// SetCode sets the "code" field.
func (u *TaskRecordUpsertOne) SetCode(v string) *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetCode(v)
	})
}

// UpdateCode sets the "code" field to the value that was provided on create.
func (u *TaskRecordUpsertOne) UpdateCode() *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateCode()
	})
}

// ClearCode clears the value of the "code" field.
func (u *TaskRecordUpsertOne) ClearCode() *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.ClearCode()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *TaskRecordUpsertOne) SetCreatedAt(v time.Time) *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *TaskRecordUpsertOne) UpdateCreatedAt() *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *TaskRecordUpsertOne) SetUpdatedAt(v time.Time) *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *TaskRecordUpsertOne) UpdateUpdatedAt() *TaskRecordUpsertOne {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *TaskRecordUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for TaskRecordCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *TaskRecordUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *TaskRecordUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: TaskRecordUpsertOne.ID is not supported by MySQL driver. Use TaskRecordUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *TaskRecordUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// TaskRecordCreateBulk is the builder for creating many TaskRecord entities in bulk.
type TaskRecordCreateBulk struct {
	config
	err      error
	builders []*TaskRecordCreate
	conflict []sql.ConflictOption
}

// Save creates the TaskRecord entities in the database.
func (trcb *TaskRecordCreateBulk) Save(ctx context.Context) ([]*TaskRecord, error) {
	if trcb.err != nil {
		return nil, trcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(trcb.builders))
	nodes := make([]*TaskRecord, len(trcb.builders))
	mutators := make([]Mutator, len(trcb.builders))
	for i := range trcb.builders {
		func(i int, root context.Context) {
			builder := trcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*TaskRecordMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, trcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = trcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, trcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, trcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (trcb *TaskRecordCreateBulk) SaveX(ctx context.Context) []*TaskRecord {
	v, err := trcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (trcb *TaskRecordCreateBulk) Exec(ctx context.Context) error {
	_, err := trcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (trcb *TaskRecordCreateBulk) ExecX(ctx context.Context) {
	if err := trcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.TaskRecord.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.TaskRecordUpsert) {
//			SetTaskID(v+v).
//		}).
//		Exec(ctx)
func (trcb *TaskRecordCreateBulk) OnConflict(opts ...sql.ConflictOption) *TaskRecordUpsertBulk {
	trcb.conflict = opts
	return &TaskRecordUpsertBulk{
		create: trcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.TaskRecord.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (trcb *TaskRecordCreateBulk) OnConflictColumns(columns ...string) *TaskRecordUpsertBulk {
	trcb.conflict = append(trcb.conflict, sql.ConflictColumns(columns...))
	return &TaskRecordUpsertBulk{
		create: trcb,
	}
}

// TaskRecordUpsertBulk is the builder for "upsert"-ing
// a bulk of TaskRecord nodes.
type TaskRecordUpsertBulk struct {
	create *TaskRecordCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.TaskRecord.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(taskrecord.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *TaskRecordUpsertBulk) UpdateNewValues() *TaskRecordUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(taskrecord.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.TaskRecord.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *TaskRecordUpsertBulk) Ignore() *TaskRecordUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *TaskRecordUpsertBulk) DoNothing() *TaskRecordUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the TaskRecordCreateBulk.OnConflict
// documentation for more info.
func (u *TaskRecordUpsertBulk) Update(set func(*TaskRecordUpsert)) *TaskRecordUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&TaskRecordUpsert{UpdateSet: update})
	}))
	return u
}

// SetTaskID sets the "task_id" field.
func (u *TaskRecordUpsertBulk) SetTaskID(v uuid.UUID) *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetTaskID(v)
	})
}

// UpdateTaskID sets the "task_id" field to the value that was provided on create.
func (u *TaskRecordUpsertBulk) UpdateTaskID() *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateTaskID()
	})
}

// ClearTaskID clears the value of the "task_id" field.
func (u *TaskRecordUpsertBulk) ClearTaskID() *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.ClearTaskID()
	})
}

// SetPrompt sets the "prompt" field.
func (u *TaskRecordUpsertBulk) SetPrompt(v string) *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetPrompt(v)
	})
}

// UpdatePrompt sets the "prompt" field to the value that was provided on create.
func (u *TaskRecordUpsertBulk) UpdatePrompt() *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdatePrompt()
	})
}

// ClearPrompt clears the value of the "prompt" field.
func (u *TaskRecordUpsertBulk) ClearPrompt() *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.ClearPrompt()
	})
}

// SetRole sets the "role" field.
func (u *TaskRecordUpsertBulk) SetRole(v consts.ChatRole) *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetRole(v)
	})
}

// UpdateRole sets the "role" field to the value that was provided on create.
func (u *TaskRecordUpsertBulk) UpdateRole() *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateRole()
	})
}

// SetCompletion sets the "completion" field.
func (u *TaskRecordUpsertBulk) SetCompletion(v string) *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetCompletion(v)
	})
}

// UpdateCompletion sets the "completion" field to the value that was provided on create.
func (u *TaskRecordUpsertBulk) UpdateCompletion() *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateCompletion()
	})
}

// ClearCompletion clears the value of the "completion" field.
func (u *TaskRecordUpsertBulk) ClearCompletion() *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.ClearCompletion()
	})
}

// SetOutputTokens sets the "output_tokens" field.
func (u *TaskRecordUpsertBulk) SetOutputTokens(v int64) *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetOutputTokens(v)
	})
}

// AddOutputTokens adds v to the "output_tokens" field.
func (u *TaskRecordUpsertBulk) AddOutputTokens(v int64) *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.AddOutputTokens(v)
	})
}

// UpdateOutputTokens sets the "output_tokens" field to the value that was provided on create.
func (u *TaskRecordUpsertBulk) UpdateOutputTokens() *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateOutputTokens()
	})
}

// SetCodeLines sets the "code_lines" field.
func (u *TaskRecordUpsertBulk) SetCodeLines(v int64) *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetCodeLines(v)
	})
}

// AddCodeLines adds v to the "code_lines" field.
func (u *TaskRecordUpsertBulk) AddCodeLines(v int64) *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.AddCodeLines(v)
	})
}

// UpdateCodeLines sets the "code_lines" field to the value that was provided on create.
func (u *TaskRecordUpsertBulk) UpdateCodeLines() *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateCodeLines()
	})
}

// SetCode sets the "code" field.
func (u *TaskRecordUpsertBulk) SetCode(v string) *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetCode(v)
	})
}

// UpdateCode sets the "code" field to the value that was provided on create.
func (u *TaskRecordUpsertBulk) UpdateCode() *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateCode()
	})
}

// ClearCode clears the value of the "code" field.
func (u *TaskRecordUpsertBulk) ClearCode() *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.ClearCode()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *TaskRecordUpsertBulk) SetCreatedAt(v time.Time) *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *TaskRecordUpsertBulk) UpdateCreatedAt() *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *TaskRecordUpsertBulk) SetUpdatedAt(v time.Time) *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *TaskRecordUpsertBulk) UpdateUpdatedAt() *TaskRecordUpsertBulk {
	return u.Update(func(s *TaskRecordUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *TaskRecordUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the TaskRecordCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for TaskRecordCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *TaskRecordUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
