// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent"
	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/task"
	"github.com/chaitin/MonkeyCode/backend/db/taskrecord"
	"github.com/google/uuid"
)

// TaskRecordQuery is the builder for querying TaskRecord entities.
type TaskRecordQuery struct {
	config
	ctx        *QueryContext
	order      []taskrecord.OrderOption
	inters     []Interceptor
	predicates []predicate.TaskRecord
	withTask   *TaskQuery
	modifiers  []func(*sql.Selector)
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the TaskRecordQuery builder.
func (trq *TaskRecordQuery) Where(ps ...predicate.TaskRecord) *TaskRecordQuery {
	trq.predicates = append(trq.predicates, ps...)
	return trq
}

// Limit the number of records to be returned by this query.
func (trq *TaskRecordQuery) Limit(limit int) *TaskRecordQuery {
	trq.ctx.Limit = &limit
	return trq
}

// Offset to start from.
func (trq *TaskRecordQuery) Offset(offset int) *TaskRecordQuery {
	trq.ctx.Offset = &offset
	return trq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (trq *TaskRecordQuery) Unique(unique bool) *TaskRecordQuery {
	trq.ctx.Unique = &unique
	return trq
}

// Order specifies how the records should be ordered.
func (trq *TaskRecordQuery) Order(o ...taskrecord.OrderOption) *TaskRecordQuery {
	trq.order = append(trq.order, o...)
	return trq
}

// QueryTask chains the current query on the "task" edge.
func (trq *TaskRecordQuery) QueryTask() *TaskQuery {
	query := (&TaskClient{config: trq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := trq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := trq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(taskrecord.Table, taskrecord.FieldID, selector),
			sqlgraph.To(task.Table, task.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, taskrecord.TaskTable, taskrecord.TaskColumn),
		)
		fromU = sqlgraph.SetNeighbors(trq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// First returns the first TaskRecord entity from the query.
// Returns a *NotFoundError when no TaskRecord was found.
func (trq *TaskRecordQuery) First(ctx context.Context) (*TaskRecord, error) {
	nodes, err := trq.Limit(1).All(setContextOp(ctx, trq.ctx, ent.OpQueryFirst))
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{taskrecord.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (trq *TaskRecordQuery) FirstX(ctx context.Context) *TaskRecord {
	node, err := trq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first TaskRecord ID from the query.
// Returns a *NotFoundError when no TaskRecord ID was found.
func (trq *TaskRecordQuery) FirstID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = trq.Limit(1).IDs(setContextOp(ctx, trq.ctx, ent.OpQueryFirstID)); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{taskrecord.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (trq *TaskRecordQuery) FirstIDX(ctx context.Context) uuid.UUID {
	id, err := trq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single TaskRecord entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one TaskRecord entity is found.
// Returns a *NotFoundError when no TaskRecord entities are found.
func (trq *TaskRecordQuery) Only(ctx context.Context) (*TaskRecord, error) {
	nodes, err := trq.Limit(2).All(setContextOp(ctx, trq.ctx, ent.OpQueryOnly))
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{taskrecord.Label}
	default:
		return nil, &NotSingularError{taskrecord.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (trq *TaskRecordQuery) OnlyX(ctx context.Context) *TaskRecord {
	node, err := trq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only TaskRecord ID in the query.
// Returns a *NotSingularError when more than one TaskRecord ID is found.
// Returns a *NotFoundError when no entities are found.
func (trq *TaskRecordQuery) OnlyID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = trq.Limit(2).IDs(setContextOp(ctx, trq.ctx, ent.OpQueryOnlyID)); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{taskrecord.Label}
	default:
		err = &NotSingularError{taskrecord.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (trq *TaskRecordQuery) OnlyIDX(ctx context.Context) uuid.UUID {
	id, err := trq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of TaskRecords.
func (trq *TaskRecordQuery) All(ctx context.Context) ([]*TaskRecord, error) {
	ctx = setContextOp(ctx, trq.ctx, ent.OpQueryAll)
	if err := trq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	qr := querierAll[[]*TaskRecord, *TaskRecordQuery]()
	return withInterceptors[[]*TaskRecord](ctx, trq, qr, trq.inters)
}

// AllX is like All, but panics if an error occurs.
func (trq *TaskRecordQuery) AllX(ctx context.Context) []*TaskRecord {
	nodes, err := trq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of TaskRecord IDs.
func (trq *TaskRecordQuery) IDs(ctx context.Context) (ids []uuid.UUID, err error) {
	if trq.ctx.Unique == nil && trq.path != nil {
		trq.Unique(true)
	}
	ctx = setContextOp(ctx, trq.ctx, ent.OpQueryIDs)
	if err = trq.Select(taskrecord.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (trq *TaskRecordQuery) IDsX(ctx context.Context) []uuid.UUID {
	ids, err := trq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (trq *TaskRecordQuery) Count(ctx context.Context) (int, error) {
	ctx = setContextOp(ctx, trq.ctx, ent.OpQueryCount)
	if err := trq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return withInterceptors[int](ctx, trq, querierCount[*TaskRecordQuery](), trq.inters)
}

// CountX is like Count, but panics if an error occurs.
func (trq *TaskRecordQuery) CountX(ctx context.Context) int {
	count, err := trq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (trq *TaskRecordQuery) Exist(ctx context.Context) (bool, error) {
	ctx = setContextOp(ctx, trq.ctx, ent.OpQueryExist)
	switch _, err := trq.FirstID(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("db: check existence: %w", err)
	default:
		return true, nil
	}
}

// ExistX is like Exist, but panics if an error occurs.
func (trq *TaskRecordQuery) ExistX(ctx context.Context) bool {
	exist, err := trq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the TaskRecordQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (trq *TaskRecordQuery) Clone() *TaskRecordQuery {
	if trq == nil {
		return nil
	}
	return &TaskRecordQuery{
		config:     trq.config,
		ctx:        trq.ctx.Clone(),
		order:      append([]taskrecord.OrderOption{}, trq.order...),
		inters:     append([]Interceptor{}, trq.inters...),
		predicates: append([]predicate.TaskRecord{}, trq.predicates...),
		withTask:   trq.withTask.Clone(),
		// clone intermediate query.
		sql:       trq.sql.Clone(),
		path:      trq.path,
		modifiers: append([]func(*sql.Selector){}, trq.modifiers...),
	}
}

// WithTask tells the query-builder to eager-load the nodes that are connected to
// the "task" edge. The optional arguments are used to configure the query builder of the edge.
func (trq *TaskRecordQuery) WithTask(opts ...func(*TaskQuery)) *TaskRecordQuery {
	query := (&TaskClient{config: trq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	trq.withTask = query
	return trq
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		TaskID uuid.UUID `json:"task_id,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.TaskRecord.Query().
//		GroupBy(taskrecord.FieldTaskID).
//		Aggregate(db.Count()).
//		Scan(ctx, &v)
func (trq *TaskRecordQuery) GroupBy(field string, fields ...string) *TaskRecordGroupBy {
	trq.ctx.Fields = append([]string{field}, fields...)
	grbuild := &TaskRecordGroupBy{build: trq}
	grbuild.flds = &trq.ctx.Fields
	grbuild.label = taskrecord.Label
	grbuild.scan = grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		TaskID uuid.UUID `json:"task_id,omitempty"`
//	}
//
//	client.TaskRecord.Query().
//		Select(taskrecord.FieldTaskID).
//		Scan(ctx, &v)
func (trq *TaskRecordQuery) Select(fields ...string) *TaskRecordSelect {
	trq.ctx.Fields = append(trq.ctx.Fields, fields...)
	sbuild := &TaskRecordSelect{TaskRecordQuery: trq}
	sbuild.label = taskrecord.Label
	sbuild.flds, sbuild.scan = &trq.ctx.Fields, sbuild.Scan
	return sbuild
}

// Aggregate returns a TaskRecordSelect configured with the given aggregations.
func (trq *TaskRecordQuery) Aggregate(fns ...AggregateFunc) *TaskRecordSelect {
	return trq.Select().Aggregate(fns...)
}

func (trq *TaskRecordQuery) prepareQuery(ctx context.Context) error {
	for _, inter := range trq.inters {
		if inter == nil {
			return fmt.Errorf("db: uninitialized interceptor (forgotten import db/runtime?)")
		}
		if trv, ok := inter.(Traverser); ok {
			if err := trv.Traverse(ctx, trq); err != nil {
				return err
			}
		}
	}
	for _, f := range trq.ctx.Fields {
		if !taskrecord.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
		}
	}
	if trq.path != nil {
		prev, err := trq.path(ctx)
		if err != nil {
			return err
		}
		trq.sql = prev
	}
	return nil
}

func (trq *TaskRecordQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*TaskRecord, error) {
	var (
		nodes       = []*TaskRecord{}
		_spec       = trq.querySpec()
		loadedTypes = [1]bool{
			trq.withTask != nil,
		}
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*TaskRecord).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &TaskRecord{config: trq.config}
		nodes = append(nodes, node)
		node.Edges.loadedTypes = loadedTypes
		return node.assignValues(columns, values)
	}
	if len(trq.modifiers) > 0 {
		_spec.Modifiers = trq.modifiers
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, trq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	if query := trq.withTask; query != nil {
		if err := trq.loadTask(ctx, query, nodes, nil,
			func(n *TaskRecord, e *Task) { n.Edges.Task = e }); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

func (trq *TaskRecordQuery) loadTask(ctx context.Context, query *TaskQuery, nodes []*TaskRecord, init func(*TaskRecord), assign func(*TaskRecord, *Task)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*TaskRecord)
	for i := range nodes {
		fk := nodes[i].TaskID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(task.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "task_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}

func (trq *TaskRecordQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := trq.querySpec()
	if len(trq.modifiers) > 0 {
		_spec.Modifiers = trq.modifiers
	}
	_spec.Node.Columns = trq.ctx.Fields
	if len(trq.ctx.Fields) > 0 {
		_spec.Unique = trq.ctx.Unique != nil && *trq.ctx.Unique
	}
	return sqlgraph.CountNodes(ctx, trq.driver, _spec)
}

func (trq *TaskRecordQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := sqlgraph.NewQuerySpec(taskrecord.Table, taskrecord.Columns, sqlgraph.NewFieldSpec(taskrecord.FieldID, field.TypeUUID))
	_spec.From = trq.sql
	if unique := trq.ctx.Unique; unique != nil {
		_spec.Unique = *unique
	} else if trq.path != nil {
		_spec.Unique = true
	}
	if fields := trq.ctx.Fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, taskrecord.FieldID)
		for i := range fields {
			if fields[i] != taskrecord.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
		if trq.withTask != nil {
			_spec.Node.AddColumnOnce(taskrecord.FieldTaskID)
		}
	}
	if ps := trq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := trq.ctx.Limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := trq.ctx.Offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := trq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (trq *TaskRecordQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(trq.driver.Dialect())
	t1 := builder.Table(taskrecord.Table)
	columns := trq.ctx.Fields
	if len(columns) == 0 {
		columns = taskrecord.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if trq.sql != nil {
		selector = trq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if trq.ctx.Unique != nil && *trq.ctx.Unique {
		selector.Distinct()
	}
	for _, m := range trq.modifiers {
		m(selector)
	}
	for _, p := range trq.predicates {
		p(selector)
	}
	for _, p := range trq.order {
		p(selector)
	}
	if offset := trq.ctx.Offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := trq.ctx.Limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// ForUpdate locks the selected rows against concurrent updates, and prevent them from being
// updated, deleted or "selected ... for update" by other sessions, until the transaction is
// either committed or rolled-back.
func (trq *TaskRecordQuery) ForUpdate(opts ...sql.LockOption) *TaskRecordQuery {
	if trq.driver.Dialect() == dialect.Postgres {
		trq.Unique(false)
	}
	trq.modifiers = append(trq.modifiers, func(s *sql.Selector) {
		s.ForUpdate(opts...)
	})
	return trq
}

// ForShare behaves similarly to ForUpdate, except that it acquires a shared mode lock
// on any rows that are read. Other sessions can read the rows, but cannot modify them
// until your transaction commits.
func (trq *TaskRecordQuery) ForShare(opts ...sql.LockOption) *TaskRecordQuery {
	if trq.driver.Dialect() == dialect.Postgres {
		trq.Unique(false)
	}
	trq.modifiers = append(trq.modifiers, func(s *sql.Selector) {
		s.ForShare(opts...)
	})
	return trq
}

// Modify adds a query modifier for attaching custom logic to queries.
func (trq *TaskRecordQuery) Modify(modifiers ...func(s *sql.Selector)) *TaskRecordSelect {
	trq.modifiers = append(trq.modifiers, modifiers...)
	return trq.Select()
}

// TaskRecordGroupBy is the group-by builder for TaskRecord entities.
type TaskRecordGroupBy struct {
	selector
	build *TaskRecordQuery
}

// Aggregate adds the given aggregation functions to the group-by query.
func (trgb *TaskRecordGroupBy) Aggregate(fns ...AggregateFunc) *TaskRecordGroupBy {
	trgb.fns = append(trgb.fns, fns...)
	return trgb
}

// Scan applies the selector query and scans the result into the given value.
func (trgb *TaskRecordGroupBy) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, trgb.build.ctx, ent.OpQueryGroupBy)
	if err := trgb.build.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*TaskRecordQuery, *TaskRecordGroupBy](ctx, trgb.build, trgb, trgb.build.inters, v)
}

func (trgb *TaskRecordGroupBy) sqlScan(ctx context.Context, root *TaskRecordQuery, v any) error {
	selector := root.sqlQuery(ctx).Select()
	aggregation := make([]string, 0, len(trgb.fns))
	for _, fn := range trgb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(*trgb.flds)+len(trgb.fns))
		for _, f := range *trgb.flds {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	selector.GroupBy(selector.Columns(*trgb.flds...)...)
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := trgb.build.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// TaskRecordSelect is the builder for selecting fields of TaskRecord entities.
type TaskRecordSelect struct {
	*TaskRecordQuery
	selector
}

// Aggregate adds the given aggregation functions to the selector query.
func (trs *TaskRecordSelect) Aggregate(fns ...AggregateFunc) *TaskRecordSelect {
	trs.fns = append(trs.fns, fns...)
	return trs
}

// Scan applies the selector query and scans the result into the given value.
func (trs *TaskRecordSelect) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, trs.ctx, ent.OpQuerySelect)
	if err := trs.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*TaskRecordQuery, *TaskRecordSelect](ctx, trs.TaskRecordQuery, trs, trs.inters, v)
}

func (trs *TaskRecordSelect) sqlScan(ctx context.Context, root *TaskRecordQuery, v any) error {
	selector := root.sqlQuery(ctx)
	aggregation := make([]string, 0, len(trs.fns))
	for _, fn := range trs.fns {
		aggregation = append(aggregation, fn(selector))
	}
	switch n := len(*trs.selector.flds); {
	case n == 0 && len(aggregation) > 0:
		selector.Select(aggregation...)
	case n != 0 && len(aggregation) > 0:
		selector.AppendSelect(aggregation...)
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := trs.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// Modify adds a query modifier for attaching custom logic to queries.
func (trs *TaskRecordSelect) Modify(modifiers ...func(s *sql.Selector)) *TaskRecordSelect {
	trs.modifiers = append(trs.modifiers, modifiers...)
	return trs
}
