// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	stdsql "database/sql"
	"fmt"
	"sync"

	"entgo.io/ent/dialect"
)

// Tx is a transactional client that is created by calling Client.Tx().
type Tx struct {
	config
	// AIEmployee is the client for interacting with the AIEmployee builders.
	AIEmployee *AIEmployeeClient
	// AITask is the client for interacting with the AITask builders.
	AITask *AITaskClient
	// Admin is the client for interacting with the Admin builders.
	Admin *AdminClient
	// AdminLoginHistory is the client for interacting with the AdminLoginHistory builders.
	AdminLoginHistory *AdminLoginHistoryClient
	// AdminRole is the client for interacting with the AdminRole builders.
	AdminRole *AdminRoleClient
	// ApiKey is the client for interacting with the ApiKey builders.
	ApiKey *ApiKeyClient
	// BillingPlan is the client for interacting with the BillingPlan builders.
	BillingPlan *BillingPlanClient
	// BillingQuota is the client for interacting with the BillingQuota builders.
	BillingQuota *BillingQuotaClient
	// BillingRecord is the client for interacting with the BillingRecord builders.
	BillingRecord *BillingRecordClient
	// BillingUsage is the client for interacting with the BillingUsage builders.
	BillingUsage *BillingUsageClient
	// CodeSnippet is the client for interacting with the CodeSnippet builders.
	CodeSnippet *CodeSnippetClient
	// Extension is the client for interacting with the Extension builders.
	Extension *ExtensionClient
	// InviteCode is the client for interacting with the InviteCode builders.
	InviteCode *InviteCodeClient
	// License is the client for interacting with the License builders.
	License *LicenseClient
	// Model is the client for interacting with the Model builders.
	Model *ModelClient
	// ModelProvider is the client for interacting with the ModelProvider builders.
	ModelProvider *ModelProviderClient
	// ModelProviderModel is the client for interacting with the ModelProviderModel builders.
	ModelProviderModel *ModelProviderModelClient
	// Role is the client for interacting with the Role builders.
	Role *RoleClient
	// SecurityScanning is the client for interacting with the SecurityScanning builders.
	SecurityScanning *SecurityScanningClient
	// SecurityScanningResult is the client for interacting with the SecurityScanningResult builders.
	SecurityScanningResult *SecurityScanningResultClient
	// Setting is the client for interacting with the Setting builders.
	Setting *SettingClient
	// Task is the client for interacting with the Task builders.
	Task *TaskClient
	// TaskRecord is the client for interacting with the TaskRecord builders.
	TaskRecord *TaskRecordClient
	// User is the client for interacting with the User builders.
	User *UserClient
	// UserGroup is the client for interacting with the UserGroup builders.
	UserGroup *UserGroupClient
	// UserGroupAdmin is the client for interacting with the UserGroupAdmin builders.
	UserGroupAdmin *UserGroupAdminClient
	// UserGroupUser is the client for interacting with the UserGroupUser builders.
	UserGroupUser *UserGroupUserClient
	// UserIdentity is the client for interacting with the UserIdentity builders.
	UserIdentity *UserIdentityClient
	// UserLoginHistory is the client for interacting with the UserLoginHistory builders.
	UserLoginHistory *UserLoginHistoryClient
	// Workspace is the client for interacting with the Workspace builders.
	Workspace *WorkspaceClient
	// WorkspaceFile is the client for interacting with the WorkspaceFile builders.
	WorkspaceFile *WorkspaceFileClient

	// lazily loaded.
	client     *Client
	clientOnce sync.Once
	// ctx lives for the life of the transaction. It is
	// the same context used by the underlying connection.
	ctx context.Context
}

type (
	// Committer is the interface that wraps the Commit method.
	Committer interface {
		Commit(context.Context, *Tx) error
	}

	// The CommitFunc type is an adapter to allow the use of ordinary
	// function as a Committer. If f is a function with the appropriate
	// signature, CommitFunc(f) is a Committer that calls f.
	CommitFunc func(context.Context, *Tx) error

	// CommitHook defines the "commit middleware". A function that gets a Committer
	// and returns a Committer. For example:
	//
	//	hook := func(next ent.Committer) ent.Committer {
	//		return ent.CommitFunc(func(ctx context.Context, tx *ent.Tx) error {
	//			// Do some stuff before.
	//			if err := next.Commit(ctx, tx); err != nil {
	//				return err
	//			}
	//			// Do some stuff after.
	//			return nil
	//		})
	//	}
	//
	CommitHook func(Committer) Committer
)

// Commit calls f(ctx, m).
func (f CommitFunc) Commit(ctx context.Context, tx *Tx) error {
	return f(ctx, tx)
}

// Commit commits the transaction.
func (tx *Tx) Commit() error {
	txDriver := tx.config.driver.(*txDriver)
	var fn Committer = CommitFunc(func(context.Context, *Tx) error {
		return txDriver.tx.Commit()
	})
	txDriver.mu.Lock()
	hooks := append([]CommitHook(nil), txDriver.onCommit...)
	txDriver.mu.Unlock()
	for i := len(hooks) - 1; i >= 0; i-- {
		fn = hooks[i](fn)
	}
	return fn.Commit(tx.ctx, tx)
}

// OnCommit adds a hook to call on commit.
func (tx *Tx) OnCommit(f CommitHook) {
	txDriver := tx.config.driver.(*txDriver)
	txDriver.mu.Lock()
	txDriver.onCommit = append(txDriver.onCommit, f)
	txDriver.mu.Unlock()
}

type (
	// Rollbacker is the interface that wraps the Rollback method.
	Rollbacker interface {
		Rollback(context.Context, *Tx) error
	}

	// The RollbackFunc type is an adapter to allow the use of ordinary
	// function as a Rollbacker. If f is a function with the appropriate
	// signature, RollbackFunc(f) is a Rollbacker that calls f.
	RollbackFunc func(context.Context, *Tx) error

	// RollbackHook defines the "rollback middleware". A function that gets a Rollbacker
	// and returns a Rollbacker. For example:
	//
	//	hook := func(next ent.Rollbacker) ent.Rollbacker {
	//		return ent.RollbackFunc(func(ctx context.Context, tx *ent.Tx) error {
	//			// Do some stuff before.
	//			if err := next.Rollback(ctx, tx); err != nil {
	//				return err
	//			}
	//			// Do some stuff after.
	//			return nil
	//		})
	//	}
	//
	RollbackHook func(Rollbacker) Rollbacker
)

// Rollback calls f(ctx, m).
func (f RollbackFunc) Rollback(ctx context.Context, tx *Tx) error {
	return f(ctx, tx)
}

// Rollback rollbacks the transaction.
func (tx *Tx) Rollback() error {
	txDriver := tx.config.driver.(*txDriver)
	var fn Rollbacker = RollbackFunc(func(context.Context, *Tx) error {
		return txDriver.tx.Rollback()
	})
	txDriver.mu.Lock()
	hooks := append([]RollbackHook(nil), txDriver.onRollback...)
	txDriver.mu.Unlock()
	for i := len(hooks) - 1; i >= 0; i-- {
		fn = hooks[i](fn)
	}
	return fn.Rollback(tx.ctx, tx)
}

// OnRollback adds a hook to call on rollback.
func (tx *Tx) OnRollback(f RollbackHook) {
	txDriver := tx.config.driver.(*txDriver)
	txDriver.mu.Lock()
	txDriver.onRollback = append(txDriver.onRollback, f)
	txDriver.mu.Unlock()
}

// Client returns a Client that binds to current transaction.
func (tx *Tx) Client() *Client {
	tx.clientOnce.Do(func() {
		tx.client = &Client{config: tx.config}
		tx.client.init()
	})
	return tx.client
}

func (tx *Tx) init() {
	tx.AIEmployee = NewAIEmployeeClient(tx.config)
	tx.AITask = NewAITaskClient(tx.config)
	tx.Admin = NewAdminClient(tx.config)
	tx.AdminLoginHistory = NewAdminLoginHistoryClient(tx.config)
	tx.AdminRole = NewAdminRoleClient(tx.config)
	tx.ApiKey = NewApiKeyClient(tx.config)
	tx.BillingPlan = NewBillingPlanClient(tx.config)
	tx.BillingQuota = NewBillingQuotaClient(tx.config)
	tx.BillingRecord = NewBillingRecordClient(tx.config)
	tx.BillingUsage = NewBillingUsageClient(tx.config)
	tx.CodeSnippet = NewCodeSnippetClient(tx.config)
	tx.Extension = NewExtensionClient(tx.config)
	tx.InviteCode = NewInviteCodeClient(tx.config)
	tx.License = NewLicenseClient(tx.config)
	tx.Model = NewModelClient(tx.config)
	tx.ModelProvider = NewModelProviderClient(tx.config)
	tx.ModelProviderModel = NewModelProviderModelClient(tx.config)
	tx.Role = NewRoleClient(tx.config)
	tx.SecurityScanning = NewSecurityScanningClient(tx.config)
	tx.SecurityScanningResult = NewSecurityScanningResultClient(tx.config)
	tx.Setting = NewSettingClient(tx.config)
	tx.Task = NewTaskClient(tx.config)
	tx.TaskRecord = NewTaskRecordClient(tx.config)
	tx.User = NewUserClient(tx.config)
	tx.UserGroup = NewUserGroupClient(tx.config)
	tx.UserGroupAdmin = NewUserGroupAdminClient(tx.config)
	tx.UserGroupUser = NewUserGroupUserClient(tx.config)
	tx.UserIdentity = NewUserIdentityClient(tx.config)
	tx.UserLoginHistory = NewUserLoginHistoryClient(tx.config)
	tx.Workspace = NewWorkspaceClient(tx.config)
	tx.WorkspaceFile = NewWorkspaceFileClient(tx.config)
}

// txDriver wraps the given dialect.Tx with a nop dialect.Driver implementation.
// The idea is to support transactions without adding any extra code to the builders.
// When a builder calls to driver.Tx(), it gets the same dialect.Tx instance.
// Commit and Rollback are nop for the internal builders and the user must call one
// of them in order to commit or rollback the transaction.
//
// If a closed transaction is embedded in one of the generated entities, and the entity
// applies a query, for example: AIEmployee.QueryXXX(), the query will be executed
// through the driver which created this transaction.
//
// Note that txDriver is not goroutine safe.
type txDriver struct {
	// the driver we started the transaction from.
	drv dialect.Driver
	// tx is the underlying transaction.
	tx dialect.Tx
	// completion hooks.
	mu         sync.Mutex
	onCommit   []CommitHook
	onRollback []RollbackHook
}

// newTx creates a new transactional driver.
func newTx(ctx context.Context, drv dialect.Driver) (*txDriver, error) {
	tx, err := drv.Tx(ctx)
	if err != nil {
		return nil, err
	}
	return &txDriver{tx: tx, drv: drv}, nil
}

// Tx returns the transaction wrapper (txDriver) to avoid Commit or Rollback calls
// from the internal builders. Should be called only by the internal builders.
func (tx *txDriver) Tx(context.Context) (dialect.Tx, error) { return tx, nil }

// Dialect returns the dialect of the driver we started the transaction from.
func (tx *txDriver) Dialect() string { return tx.drv.Dialect() }

// Close is a nop close.
func (*txDriver) Close() error { return nil }

// Commit is a nop commit for the internal builders.
// User must call `Tx.Commit` in order to commit the transaction.
func (*txDriver) Commit() error { return nil }

// Rollback is a nop rollback for the internal builders.
// User must call `Tx.Rollback` in order to rollback the transaction.
func (*txDriver) Rollback() error { return nil }

// Exec calls tx.Exec.
func (tx *txDriver) Exec(ctx context.Context, query string, args, v any) error {
	return tx.tx.Exec(ctx, query, args, v)
}

// Query calls tx.Query.
func (tx *txDriver) Query(ctx context.Context, query string, args, v any) error {
	return tx.tx.Query(ctx, query, args, v)
}

var _ dialect.Driver = (*txDriver)(nil)

// ExecContext allows calling the underlying ExecContext method of the transaction if it is supported by it.
// See, database/sql#Tx.ExecContext for more information.
func (tx *txDriver) ExecContext(ctx context.Context, query string, args ...any) (stdsql.Result, error) {
	ex, ok := tx.tx.(interface {
		ExecContext(context.Context, string, ...any) (stdsql.Result, error)
	})
	if !ok {
		return nil, fmt.Errorf("Tx.ExecContext is not supported")
	}
	return ex.ExecContext(ctx, query, args...)
}

// QueryContext allows calling the underlying QueryContext method of the transaction if it is supported by it.
// See, database/sql#Tx.QueryContext for more information.
func (tx *txDriver) QueryContext(ctx context.Context, query string, args ...any) (*stdsql.Rows, error) {
	q, ok := tx.tx.(interface {
		QueryContext(context.Context, string, ...any) (*stdsql.Rows, error)
	})
	if !ok {
		return nil, fmt.Errorf("Tx.QueryContext is not supported")
	}
	return q.QueryContext(ctx, query, args...)
}
