// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/google/uuid"
)

// User is the model entity for the User schema.
type User struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// DeletedAt holds the value of the "deleted_at" field.
	DeletedAt time.Time `json:"deleted_at,omitempty"`
	// Username holds the value of the "username" field.
	Username string `json:"username,omitempty"`
	// Password holds the value of the "password" field.
	Password string `json:"password,omitempty"`
	// Email holds the value of the "email" field.
	Email string `json:"email,omitempty"`
	// AvatarURL holds the value of the "avatar_url" field.
	AvatarURL string `json:"avatar_url,omitempty"`
	// Platform holds the value of the "platform" field.
	Platform consts.UserPlatform `json:"platform,omitempty"`
	// Status holds the value of the "status" field.
	Status consts.UserStatus `json:"status,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the UserQuery when eager-loading is set.
	Edges        UserEdges `json:"edges"`
	selectValues sql.SelectValues
}

// UserEdges holds the relations/edges for other nodes in the graph.
type UserEdges struct {
	// LoginHistories holds the value of the login_histories edge.
	LoginHistories []*UserLoginHistory `json:"login_histories,omitempty"`
	// Models holds the value of the models edge.
	Models []*Model `json:"models,omitempty"`
	// Tasks holds the value of the tasks edge.
	Tasks []*Task `json:"tasks,omitempty"`
	// Identities holds the value of the identities edge.
	Identities []*UserIdentity `json:"identities,omitempty"`
	// Workspaces holds the value of the workspaces edge.
	Workspaces []*Workspace `json:"workspaces,omitempty"`
	// WorkspaceFiles holds the value of the workspace_files edge.
	WorkspaceFiles []*WorkspaceFile `json:"workspace_files,omitempty"`
	// APIKeys holds the value of the api_keys edge.
	APIKeys []*ApiKey `json:"api_keys,omitempty"`
	// SecurityScannings holds the value of the security_scannings edge.
	SecurityScannings []*SecurityScanning `json:"security_scannings,omitempty"`
	// Aiemployees holds the value of the aiemployees edge.
	Aiemployees []*AIEmployee `json:"aiemployees,omitempty"`
	// Groups holds the value of the groups edge.
	Groups []*UserGroup `json:"groups,omitempty"`
	// UserGroups holds the value of the user_groups edge.
	UserGroups []*UserGroupUser `json:"user_groups,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [11]bool
}

// LoginHistoriesOrErr returns the LoginHistories value or an error if the edge
// was not loaded in eager-loading.
func (e UserEdges) LoginHistoriesOrErr() ([]*UserLoginHistory, error) {
	if e.loadedTypes[0] {
		return e.LoginHistories, nil
	}
	return nil, &NotLoadedError{edge: "login_histories"}
}

// ModelsOrErr returns the Models value or an error if the edge
// was not loaded in eager-loading.
func (e UserEdges) ModelsOrErr() ([]*Model, error) {
	if e.loadedTypes[1] {
		return e.Models, nil
	}
	return nil, &NotLoadedError{edge: "models"}
}

// TasksOrErr returns the Tasks value or an error if the edge
// was not loaded in eager-loading.
func (e UserEdges) TasksOrErr() ([]*Task, error) {
	if e.loadedTypes[2] {
		return e.Tasks, nil
	}
	return nil, &NotLoadedError{edge: "tasks"}
}

// IdentitiesOrErr returns the Identities value or an error if the edge
// was not loaded in eager-loading.
func (e UserEdges) IdentitiesOrErr() ([]*UserIdentity, error) {
	if e.loadedTypes[3] {
		return e.Identities, nil
	}
	return nil, &NotLoadedError{edge: "identities"}
}

// WorkspacesOrErr returns the Workspaces value or an error if the edge
// was not loaded in eager-loading.
func (e UserEdges) WorkspacesOrErr() ([]*Workspace, error) {
	if e.loadedTypes[4] {
		return e.Workspaces, nil
	}
	return nil, &NotLoadedError{edge: "workspaces"}
}

// WorkspaceFilesOrErr returns the WorkspaceFiles value or an error if the edge
// was not loaded in eager-loading.
func (e UserEdges) WorkspaceFilesOrErr() ([]*WorkspaceFile, error) {
	if e.loadedTypes[5] {
		return e.WorkspaceFiles, nil
	}
	return nil, &NotLoadedError{edge: "workspace_files"}
}

// APIKeysOrErr returns the APIKeys value or an error if the edge
// was not loaded in eager-loading.
func (e UserEdges) APIKeysOrErr() ([]*ApiKey, error) {
	if e.loadedTypes[6] {
		return e.APIKeys, nil
	}
	return nil, &NotLoadedError{edge: "api_keys"}
}

// SecurityScanningsOrErr returns the SecurityScannings value or an error if the edge
// was not loaded in eager-loading.
func (e UserEdges) SecurityScanningsOrErr() ([]*SecurityScanning, error) {
	if e.loadedTypes[7] {
		return e.SecurityScannings, nil
	}
	return nil, &NotLoadedError{edge: "security_scannings"}
}

// AiemployeesOrErr returns the Aiemployees value or an error if the edge
// was not loaded in eager-loading.
func (e UserEdges) AiemployeesOrErr() ([]*AIEmployee, error) {
	if e.loadedTypes[8] {
		return e.Aiemployees, nil
	}
	return nil, &NotLoadedError{edge: "aiemployees"}
}

// GroupsOrErr returns the Groups value or an error if the edge
// was not loaded in eager-loading.
func (e UserEdges) GroupsOrErr() ([]*UserGroup, error) {
	if e.loadedTypes[9] {
		return e.Groups, nil
	}
	return nil, &NotLoadedError{edge: "groups"}
}

// UserGroupsOrErr returns the UserGroups value or an error if the edge
// was not loaded in eager-loading.
func (e UserEdges) UserGroupsOrErr() ([]*UserGroupUser, error) {
	if e.loadedTypes[10] {
		return e.UserGroups, nil
	}
	return nil, &NotLoadedError{edge: "user_groups"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*User) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case user.FieldUsername, user.FieldPassword, user.FieldEmail, user.FieldAvatarURL, user.FieldPlatform, user.FieldStatus:
			values[i] = new(sql.NullString)
		case user.FieldDeletedAt, user.FieldCreatedAt, user.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		case user.FieldID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the User fields.
func (u *User) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case user.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				u.ID = *value
			}
		case user.FieldDeletedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field deleted_at", values[i])
			} else if value.Valid {
				u.DeletedAt = value.Time
			}
		case user.FieldUsername:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field username", values[i])
			} else if value.Valid {
				u.Username = value.String
			}
		case user.FieldPassword:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field password", values[i])
			} else if value.Valid {
				u.Password = value.String
			}
		case user.FieldEmail:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field email", values[i])
			} else if value.Valid {
				u.Email = value.String
			}
		case user.FieldAvatarURL:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field avatar_url", values[i])
			} else if value.Valid {
				u.AvatarURL = value.String
			}
		case user.FieldPlatform:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field platform", values[i])
			} else if value.Valid {
				u.Platform = consts.UserPlatform(value.String)
			}
		case user.FieldStatus:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field status", values[i])
			} else if value.Valid {
				u.Status = consts.UserStatus(value.String)
			}
		case user.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				u.CreatedAt = value.Time
			}
		case user.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				u.UpdatedAt = value.Time
			}
		default:
			u.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the User.
// This includes values selected through modifiers, order, etc.
func (u *User) Value(name string) (ent.Value, error) {
	return u.selectValues.Get(name)
}

// QueryLoginHistories queries the "login_histories" edge of the User entity.
func (u *User) QueryLoginHistories() *UserLoginHistoryQuery {
	return NewUserClient(u.config).QueryLoginHistories(u)
}

// QueryModels queries the "models" edge of the User entity.
func (u *User) QueryModels() *ModelQuery {
	return NewUserClient(u.config).QueryModels(u)
}

// QueryTasks queries the "tasks" edge of the User entity.
func (u *User) QueryTasks() *TaskQuery {
	return NewUserClient(u.config).QueryTasks(u)
}

// QueryIdentities queries the "identities" edge of the User entity.
func (u *User) QueryIdentities() *UserIdentityQuery {
	return NewUserClient(u.config).QueryIdentities(u)
}

// QueryWorkspaces queries the "workspaces" edge of the User entity.
func (u *User) QueryWorkspaces() *WorkspaceQuery {
	return NewUserClient(u.config).QueryWorkspaces(u)
}

// QueryWorkspaceFiles queries the "workspace_files" edge of the User entity.
func (u *User) QueryWorkspaceFiles() *WorkspaceFileQuery {
	return NewUserClient(u.config).QueryWorkspaceFiles(u)
}

// QueryAPIKeys queries the "api_keys" edge of the User entity.
func (u *User) QueryAPIKeys() *ApiKeyQuery {
	return NewUserClient(u.config).QueryAPIKeys(u)
}

// QuerySecurityScannings queries the "security_scannings" edge of the User entity.
func (u *User) QuerySecurityScannings() *SecurityScanningQuery {
	return NewUserClient(u.config).QuerySecurityScannings(u)
}

// QueryAiemployees queries the "aiemployees" edge of the User entity.
func (u *User) QueryAiemployees() *AIEmployeeQuery {
	return NewUserClient(u.config).QueryAiemployees(u)
}

// QueryGroups queries the "groups" edge of the User entity.
func (u *User) QueryGroups() *UserGroupQuery {
	return NewUserClient(u.config).QueryGroups(u)
}

// QueryUserGroups queries the "user_groups" edge of the User entity.
func (u *User) QueryUserGroups() *UserGroupUserQuery {
	return NewUserClient(u.config).QueryUserGroups(u)
}

// Update returns a builder for updating this User.
// Note that you need to call User.Unwrap() before calling this method if this User
// was returned from a transaction, and the transaction was committed or rolled back.
func (u *User) Update() *UserUpdateOne {
	return NewUserClient(u.config).UpdateOne(u)
}

// Unwrap unwraps the User entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (u *User) Unwrap() *User {
	_tx, ok := u.config.driver.(*txDriver)
	if !ok {
		panic("db: User is not a transactional entity")
	}
	u.config.driver = _tx.drv
	return u
}

// String implements the fmt.Stringer.
func (u *User) String() string {
	var builder strings.Builder
	builder.WriteString("User(")
	builder.WriteString(fmt.Sprintf("id=%v, ", u.ID))
	builder.WriteString("deleted_at=")
	builder.WriteString(u.DeletedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("username=")
	builder.WriteString(u.Username)
	builder.WriteString(", ")
	builder.WriteString("password=")
	builder.WriteString(u.Password)
	builder.WriteString(", ")
	builder.WriteString("email=")
	builder.WriteString(u.Email)
	builder.WriteString(", ")
	builder.WriteString("avatar_url=")
	builder.WriteString(u.AvatarURL)
	builder.WriteString(", ")
	builder.WriteString("platform=")
	builder.WriteString(fmt.Sprintf("%v", u.Platform))
	builder.WriteString(", ")
	builder.WriteString("status=")
	builder.WriteString(fmt.Sprintf("%v", u.Status))
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(u.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(u.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// Users is a parsable slice of User.
type Users []*User
