// Code generated by ent, DO NOT EDIT.

package usergroup

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the usergroup type in the database.
	Label = "user_group"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldAdminID holds the string denoting the admin_id field in the database.
	FieldAdminID = "admin_id"
	// FieldName holds the string denoting the name field in the database.
	FieldName = "name"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// EdgeOwner holds the string denoting the owner edge name in mutations.
	EdgeOwner = "owner"
	// EdgeUsers holds the string denoting the users edge name in mutations.
	EdgeUsers = "users"
	// EdgeAdmins holds the string denoting the admins edge name in mutations.
	EdgeAdmins = "admins"
	// EdgeUserGroups holds the string denoting the user_groups edge name in mutations.
	EdgeUserGroups = "user_groups"
	// EdgeUserGroupAdmins holds the string denoting the user_group_admins edge name in mutations.
	EdgeUserGroupAdmins = "user_group_admins"
	// Table holds the table name of the usergroup in the database.
	Table = "user_groups"
	// OwnerTable is the table that holds the owner relation/edge.
	OwnerTable = "user_groups"
	// OwnerInverseTable is the table name for the Admin entity.
	// It exists in this package in order to avoid circular dependency with the "admin" package.
	OwnerInverseTable = "admins"
	// OwnerColumn is the table column denoting the owner relation/edge.
	OwnerColumn = "admin_id"
	// UsersTable is the table that holds the users relation/edge. The primary key declared below.
	UsersTable = "user_group_users"
	// UsersInverseTable is the table name for the User entity.
	// It exists in this package in order to avoid circular dependency with the "user" package.
	UsersInverseTable = "users"
	// AdminsTable is the table that holds the admins relation/edge. The primary key declared below.
	AdminsTable = "user_group_admins"
	// AdminsInverseTable is the table name for the Admin entity.
	// It exists in this package in order to avoid circular dependency with the "admin" package.
	AdminsInverseTable = "admins"
	// UserGroupsTable is the table that holds the user_groups relation/edge.
	UserGroupsTable = "user_group_users"
	// UserGroupsInverseTable is the table name for the UserGroupUser entity.
	// It exists in this package in order to avoid circular dependency with the "usergroupuser" package.
	UserGroupsInverseTable = "user_group_users"
	// UserGroupsColumn is the table column denoting the user_groups relation/edge.
	UserGroupsColumn = "user_group_id"
	// UserGroupAdminsTable is the table that holds the user_group_admins relation/edge.
	UserGroupAdminsTable = "user_group_admins"
	// UserGroupAdminsInverseTable is the table name for the UserGroupAdmin entity.
	// It exists in this package in order to avoid circular dependency with the "usergroupadmin" package.
	UserGroupAdminsInverseTable = "user_group_admins"
	// UserGroupAdminsColumn is the table column denoting the user_group_admins relation/edge.
	UserGroupAdminsColumn = "user_group_id"
)

// Columns holds all SQL columns for usergroup fields.
var Columns = []string{
	FieldID,
	FieldAdminID,
	FieldName,
	FieldCreatedAt,
}

var (
	// UsersPrimaryKey and UsersColumn2 are the table columns denoting the
	// primary key for the users relation (M2M).
	UsersPrimaryKey = []string{"user_group_id", "user_id"}
	// AdminsPrimaryKey and AdminsColumn2 are the table columns denoting the
	// primary key for the admins relation (M2M).
	AdminsPrimaryKey = []string{"user_group_id", "admin_id"}
)

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// NameValidator is a validator for the "name" field. It is called by the builders before save.
	NameValidator func(string) error
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
)

// OrderOption defines the ordering options for the UserGroup queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByAdminID orders the results by the admin_id field.
func ByAdminID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAdminID, opts...).ToFunc()
}

// ByName orders the results by the name field.
func ByName(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldName, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByOwnerField orders the results by owner field.
func ByOwnerField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newOwnerStep(), sql.OrderByField(field, opts...))
	}
}

// ByUsersCount orders the results by users count.
func ByUsersCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newUsersStep(), opts...)
	}
}

// ByUsers orders the results by users terms.
func ByUsers(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newUsersStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByAdminsCount orders the results by admins count.
func ByAdminsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newAdminsStep(), opts...)
	}
}

// ByAdmins orders the results by admins terms.
func ByAdmins(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newAdminsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByUserGroupsCount orders the results by user_groups count.
func ByUserGroupsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newUserGroupsStep(), opts...)
	}
}

// ByUserGroups orders the results by user_groups terms.
func ByUserGroups(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newUserGroupsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByUserGroupAdminsCount orders the results by user_group_admins count.
func ByUserGroupAdminsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newUserGroupAdminsStep(), opts...)
	}
}

// ByUserGroupAdmins orders the results by user_group_admins terms.
func ByUserGroupAdmins(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newUserGroupAdminsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}
func newOwnerStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(OwnerInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, OwnerTable, OwnerColumn),
	)
}
func newUsersStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(UsersInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2M, false, UsersTable, UsersPrimaryKey...),
	)
}
func newAdminsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(AdminsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2M, false, AdminsTable, AdminsPrimaryKey...),
	)
}
func newUserGroupsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(UserGroupsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, true, UserGroupsTable, UserGroupsColumn),
	)
}
func newUserGroupAdminsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(UserGroupAdminsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, true, UserGroupAdminsTable, UserGroupAdminsColumn),
	)
}
