// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/usergroup"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupadmin"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupuser"
	"github.com/google/uuid"
)

// UserGroupCreate is the builder for creating a UserGroup entity.
type UserGroupCreate struct {
	config
	mutation *UserGroupMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetAdminID sets the "admin_id" field.
func (ugc *UserGroupCreate) SetAdminID(u uuid.UUID) *UserGroupCreate {
	ugc.mutation.SetAdminID(u)
	return ugc
}

// SetName sets the "name" field.
func (ugc *UserGroupCreate) SetName(s string) *UserGroupCreate {
	ugc.mutation.SetName(s)
	return ugc
}

// SetCreatedAt sets the "created_at" field.
func (ugc *UserGroupCreate) SetCreatedAt(t time.Time) *UserGroupCreate {
	ugc.mutation.SetCreatedAt(t)
	return ugc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ugc *UserGroupCreate) SetNillableCreatedAt(t *time.Time) *UserGroupCreate {
	if t != nil {
		ugc.SetCreatedAt(*t)
	}
	return ugc
}

// SetID sets the "id" field.
func (ugc *UserGroupCreate) SetID(u uuid.UUID) *UserGroupCreate {
	ugc.mutation.SetID(u)
	return ugc
}

// SetOwnerID sets the "owner" edge to the Admin entity by ID.
func (ugc *UserGroupCreate) SetOwnerID(id uuid.UUID) *UserGroupCreate {
	ugc.mutation.SetOwnerID(id)
	return ugc
}

// SetOwner sets the "owner" edge to the Admin entity.
func (ugc *UserGroupCreate) SetOwner(a *Admin) *UserGroupCreate {
	return ugc.SetOwnerID(a.ID)
}

// AddUserIDs adds the "users" edge to the User entity by IDs.
func (ugc *UserGroupCreate) AddUserIDs(ids ...uuid.UUID) *UserGroupCreate {
	ugc.mutation.AddUserIDs(ids...)
	return ugc
}

// AddUsers adds the "users" edges to the User entity.
func (ugc *UserGroupCreate) AddUsers(u ...*User) *UserGroupCreate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return ugc.AddUserIDs(ids...)
}

// AddAdminIDs adds the "admins" edge to the Admin entity by IDs.
func (ugc *UserGroupCreate) AddAdminIDs(ids ...uuid.UUID) *UserGroupCreate {
	ugc.mutation.AddAdminIDs(ids...)
	return ugc
}

// AddAdmins adds the "admins" edges to the Admin entity.
func (ugc *UserGroupCreate) AddAdmins(a ...*Admin) *UserGroupCreate {
	ids := make([]uuid.UUID, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return ugc.AddAdminIDs(ids...)
}

// AddUserGroupIDs adds the "user_groups" edge to the UserGroupUser entity by IDs.
func (ugc *UserGroupCreate) AddUserGroupIDs(ids ...uuid.UUID) *UserGroupCreate {
	ugc.mutation.AddUserGroupIDs(ids...)
	return ugc
}

// AddUserGroups adds the "user_groups" edges to the UserGroupUser entity.
func (ugc *UserGroupCreate) AddUserGroups(u ...*UserGroupUser) *UserGroupCreate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return ugc.AddUserGroupIDs(ids...)
}

// AddUserGroupAdminIDs adds the "user_group_admins" edge to the UserGroupAdmin entity by IDs.
func (ugc *UserGroupCreate) AddUserGroupAdminIDs(ids ...uuid.UUID) *UserGroupCreate {
	ugc.mutation.AddUserGroupAdminIDs(ids...)
	return ugc
}

// AddUserGroupAdmins adds the "user_group_admins" edges to the UserGroupAdmin entity.
func (ugc *UserGroupCreate) AddUserGroupAdmins(u ...*UserGroupAdmin) *UserGroupCreate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return ugc.AddUserGroupAdminIDs(ids...)
}

// Mutation returns the UserGroupMutation object of the builder.
func (ugc *UserGroupCreate) Mutation() *UserGroupMutation {
	return ugc.mutation
}

// Save creates the UserGroup in the database.
func (ugc *UserGroupCreate) Save(ctx context.Context) (*UserGroup, error) {
	ugc.defaults()
	return withHooks(ctx, ugc.sqlSave, ugc.mutation, ugc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (ugc *UserGroupCreate) SaveX(ctx context.Context) *UserGroup {
	v, err := ugc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (ugc *UserGroupCreate) Exec(ctx context.Context) error {
	_, err := ugc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ugc *UserGroupCreate) ExecX(ctx context.Context) {
	if err := ugc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (ugc *UserGroupCreate) defaults() {
	if _, ok := ugc.mutation.CreatedAt(); !ok {
		v := usergroup.DefaultCreatedAt()
		ugc.mutation.SetCreatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ugc *UserGroupCreate) check() error {
	if _, ok := ugc.mutation.AdminID(); !ok {
		return &ValidationError{Name: "admin_id", err: errors.New(`db: missing required field "UserGroup.admin_id"`)}
	}
	if _, ok := ugc.mutation.Name(); !ok {
		return &ValidationError{Name: "name", err: errors.New(`db: missing required field "UserGroup.name"`)}
	}
	if v, ok := ugc.mutation.Name(); ok {
		if err := usergroup.NameValidator(v); err != nil {
			return &ValidationError{Name: "name", err: fmt.Errorf(`db: validator failed for field "UserGroup.name": %w`, err)}
		}
	}
	if _, ok := ugc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "UserGroup.created_at"`)}
	}
	if len(ugc.mutation.OwnerIDs()) == 0 {
		return &ValidationError{Name: "owner", err: errors.New(`db: missing required edge "UserGroup.owner"`)}
	}
	return nil
}

func (ugc *UserGroupCreate) sqlSave(ctx context.Context) (*UserGroup, error) {
	if err := ugc.check(); err != nil {
		return nil, err
	}
	_node, _spec := ugc.createSpec()
	if err := sqlgraph.CreateNode(ctx, ugc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	ugc.mutation.id = &_node.ID
	ugc.mutation.done = true
	return _node, nil
}

func (ugc *UserGroupCreate) createSpec() (*UserGroup, *sqlgraph.CreateSpec) {
	var (
		_node = &UserGroup{config: ugc.config}
		_spec = sqlgraph.NewCreateSpec(usergroup.Table, sqlgraph.NewFieldSpec(usergroup.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = ugc.conflict
	if id, ok := ugc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := ugc.mutation.Name(); ok {
		_spec.SetField(usergroup.FieldName, field.TypeString, value)
		_node.Name = value
	}
	if value, ok := ugc.mutation.CreatedAt(); ok {
		_spec.SetField(usergroup.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if nodes := ugc.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   usergroup.OwnerTable,
			Columns: []string{usergroup.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.AdminID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := ugc.mutation.UsersIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   usergroup.UsersTable,
			Columns: usergroup.UsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := ugc.mutation.AdminsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   usergroup.AdminsTable,
			Columns: usergroup.AdminsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := ugc.mutation.UserGroupsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   usergroup.UserGroupsTable,
			Columns: []string{usergroup.UserGroupsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupuser.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := ugc.mutation.UserGroupAdminsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   usergroup.UserGroupAdminsTable,
			Columns: []string{usergroup.UserGroupAdminsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupadmin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.UserGroup.Create().
//		SetAdminID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.UserGroupUpsert) {
//			SetAdminID(v+v).
//		}).
//		Exec(ctx)
func (ugc *UserGroupCreate) OnConflict(opts ...sql.ConflictOption) *UserGroupUpsertOne {
	ugc.conflict = opts
	return &UserGroupUpsertOne{
		create: ugc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.UserGroup.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (ugc *UserGroupCreate) OnConflictColumns(columns ...string) *UserGroupUpsertOne {
	ugc.conflict = append(ugc.conflict, sql.ConflictColumns(columns...))
	return &UserGroupUpsertOne{
		create: ugc,
	}
}

type (
	// UserGroupUpsertOne is the builder for "upsert"-ing
	//  one UserGroup node.
	UserGroupUpsertOne struct {
		create *UserGroupCreate
	}

	// UserGroupUpsert is the "OnConflict" setter.
	UserGroupUpsert struct {
		*sql.UpdateSet
	}
)

// SetAdminID sets the "admin_id" field.
func (u *UserGroupUpsert) SetAdminID(v uuid.UUID) *UserGroupUpsert {
	u.Set(usergroup.FieldAdminID, v)
	return u
}

// UpdateAdminID sets the "admin_id" field to the value that was provided on create.
func (u *UserGroupUpsert) UpdateAdminID() *UserGroupUpsert {
	u.SetExcluded(usergroup.FieldAdminID)
	return u
}

// SetName sets the "name" field.
func (u *UserGroupUpsert) SetName(v string) *UserGroupUpsert {
	u.Set(usergroup.FieldName, v)
	return u
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *UserGroupUpsert) UpdateName() *UserGroupUpsert {
	u.SetExcluded(usergroup.FieldName)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *UserGroupUpsert) SetCreatedAt(v time.Time) *UserGroupUpsert {
	u.Set(usergroup.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *UserGroupUpsert) UpdateCreatedAt() *UserGroupUpsert {
	u.SetExcluded(usergroup.FieldCreatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.UserGroup.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(usergroup.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *UserGroupUpsertOne) UpdateNewValues() *UserGroupUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(usergroup.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.UserGroup.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *UserGroupUpsertOne) Ignore() *UserGroupUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *UserGroupUpsertOne) DoNothing() *UserGroupUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the UserGroupCreate.OnConflict
// documentation for more info.
func (u *UserGroupUpsertOne) Update(set func(*UserGroupUpsert)) *UserGroupUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&UserGroupUpsert{UpdateSet: update})
	}))
	return u
}

// SetAdminID sets the "admin_id" field.
func (u *UserGroupUpsertOne) SetAdminID(v uuid.UUID) *UserGroupUpsertOne {
	return u.Update(func(s *UserGroupUpsert) {
		s.SetAdminID(v)
	})
}

// UpdateAdminID sets the "admin_id" field to the value that was provided on create.
func (u *UserGroupUpsertOne) UpdateAdminID() *UserGroupUpsertOne {
	return u.Update(func(s *UserGroupUpsert) {
		s.UpdateAdminID()
	})
}

// SetName sets the "name" field.
func (u *UserGroupUpsertOne) SetName(v string) *UserGroupUpsertOne {
	return u.Update(func(s *UserGroupUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *UserGroupUpsertOne) UpdateName() *UserGroupUpsertOne {
	return u.Update(func(s *UserGroupUpsert) {
		s.UpdateName()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *UserGroupUpsertOne) SetCreatedAt(v time.Time) *UserGroupUpsertOne {
	return u.Update(func(s *UserGroupUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *UserGroupUpsertOne) UpdateCreatedAt() *UserGroupUpsertOne {
	return u.Update(func(s *UserGroupUpsert) {
		s.UpdateCreatedAt()
	})
}

// Exec executes the query.
func (u *UserGroupUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for UserGroupCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *UserGroupUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *UserGroupUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: UserGroupUpsertOne.ID is not supported by MySQL driver. Use UserGroupUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *UserGroupUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// UserGroupCreateBulk is the builder for creating many UserGroup entities in bulk.
type UserGroupCreateBulk struct {
	config
	err      error
	builders []*UserGroupCreate
	conflict []sql.ConflictOption
}

// Save creates the UserGroup entities in the database.
func (ugcb *UserGroupCreateBulk) Save(ctx context.Context) ([]*UserGroup, error) {
	if ugcb.err != nil {
		return nil, ugcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(ugcb.builders))
	nodes := make([]*UserGroup, len(ugcb.builders))
	mutators := make([]Mutator, len(ugcb.builders))
	for i := range ugcb.builders {
		func(i int, root context.Context) {
			builder := ugcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*UserGroupMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, ugcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = ugcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, ugcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, ugcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (ugcb *UserGroupCreateBulk) SaveX(ctx context.Context) []*UserGroup {
	v, err := ugcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (ugcb *UserGroupCreateBulk) Exec(ctx context.Context) error {
	_, err := ugcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ugcb *UserGroupCreateBulk) ExecX(ctx context.Context) {
	if err := ugcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.UserGroup.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.UserGroupUpsert) {
//			SetAdminID(v+v).
//		}).
//		Exec(ctx)
func (ugcb *UserGroupCreateBulk) OnConflict(opts ...sql.ConflictOption) *UserGroupUpsertBulk {
	ugcb.conflict = opts
	return &UserGroupUpsertBulk{
		create: ugcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.UserGroup.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (ugcb *UserGroupCreateBulk) OnConflictColumns(columns ...string) *UserGroupUpsertBulk {
	ugcb.conflict = append(ugcb.conflict, sql.ConflictColumns(columns...))
	return &UserGroupUpsertBulk{
		create: ugcb,
	}
}

// UserGroupUpsertBulk is the builder for "upsert"-ing
// a bulk of UserGroup nodes.
type UserGroupUpsertBulk struct {
	create *UserGroupCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.UserGroup.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(usergroup.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *UserGroupUpsertBulk) UpdateNewValues() *UserGroupUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(usergroup.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.UserGroup.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *UserGroupUpsertBulk) Ignore() *UserGroupUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *UserGroupUpsertBulk) DoNothing() *UserGroupUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the UserGroupCreateBulk.OnConflict
// documentation for more info.
func (u *UserGroupUpsertBulk) Update(set func(*UserGroupUpsert)) *UserGroupUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&UserGroupUpsert{UpdateSet: update})
	}))
	return u
}

// SetAdminID sets the "admin_id" field.
func (u *UserGroupUpsertBulk) SetAdminID(v uuid.UUID) *UserGroupUpsertBulk {
	return u.Update(func(s *UserGroupUpsert) {
		s.SetAdminID(v)
	})
}

// UpdateAdminID sets the "admin_id" field to the value that was provided on create.
func (u *UserGroupUpsertBulk) UpdateAdminID() *UserGroupUpsertBulk {
	return u.Update(func(s *UserGroupUpsert) {
		s.UpdateAdminID()
	})
}

// SetName sets the "name" field.
func (u *UserGroupUpsertBulk) SetName(v string) *UserGroupUpsertBulk {
	return u.Update(func(s *UserGroupUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *UserGroupUpsertBulk) UpdateName() *UserGroupUpsertBulk {
	return u.Update(func(s *UserGroupUpsert) {
		s.UpdateName()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *UserGroupUpsertBulk) SetCreatedAt(v time.Time) *UserGroupUpsertBulk {
	return u.Update(func(s *UserGroupUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *UserGroupUpsertBulk) UpdateCreatedAt() *UserGroupUpsertBulk {
	return u.Update(func(s *UserGroupUpsert) {
		s.UpdateCreatedAt()
	})
}

// Exec executes the query.
func (u *UserGroupUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the UserGroupCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for UserGroupCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *UserGroupUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
