// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/usergroup"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupadmin"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupuser"
	"github.com/google/uuid"
)

// UserGroupUpdate is the builder for updating UserGroup entities.
type UserGroupUpdate struct {
	config
	hooks     []Hook
	mutation  *UserGroupMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the UserGroupUpdate builder.
func (ugu *UserGroupUpdate) Where(ps ...predicate.UserGroup) *UserGroupUpdate {
	ugu.mutation.Where(ps...)
	return ugu
}

// SetAdminID sets the "admin_id" field.
func (ugu *UserGroupUpdate) SetAdminID(u uuid.UUID) *UserGroupUpdate {
	ugu.mutation.SetAdminID(u)
	return ugu
}

// SetNillableAdminID sets the "admin_id" field if the given value is not nil.
func (ugu *UserGroupUpdate) SetNillableAdminID(u *uuid.UUID) *UserGroupUpdate {
	if u != nil {
		ugu.SetAdminID(*u)
	}
	return ugu
}

// SetName sets the "name" field.
func (ugu *UserGroupUpdate) SetName(s string) *UserGroupUpdate {
	ugu.mutation.SetName(s)
	return ugu
}

// SetNillableName sets the "name" field if the given value is not nil.
func (ugu *UserGroupUpdate) SetNillableName(s *string) *UserGroupUpdate {
	if s != nil {
		ugu.SetName(*s)
	}
	return ugu
}

// SetCreatedAt sets the "created_at" field.
func (ugu *UserGroupUpdate) SetCreatedAt(t time.Time) *UserGroupUpdate {
	ugu.mutation.SetCreatedAt(t)
	return ugu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ugu *UserGroupUpdate) SetNillableCreatedAt(t *time.Time) *UserGroupUpdate {
	if t != nil {
		ugu.SetCreatedAt(*t)
	}
	return ugu
}

// SetOwnerID sets the "owner" edge to the Admin entity by ID.
func (ugu *UserGroupUpdate) SetOwnerID(id uuid.UUID) *UserGroupUpdate {
	ugu.mutation.SetOwnerID(id)
	return ugu
}

// SetOwner sets the "owner" edge to the Admin entity.
func (ugu *UserGroupUpdate) SetOwner(a *Admin) *UserGroupUpdate {
	return ugu.SetOwnerID(a.ID)
}

// AddUserIDs adds the "users" edge to the User entity by IDs.
func (ugu *UserGroupUpdate) AddUserIDs(ids ...uuid.UUID) *UserGroupUpdate {
	ugu.mutation.AddUserIDs(ids...)
	return ugu
}

// AddUsers adds the "users" edges to the User entity.
func (ugu *UserGroupUpdate) AddUsers(u ...*User) *UserGroupUpdate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return ugu.AddUserIDs(ids...)
}

// AddAdminIDs adds the "admins" edge to the Admin entity by IDs.
func (ugu *UserGroupUpdate) AddAdminIDs(ids ...uuid.UUID) *UserGroupUpdate {
	ugu.mutation.AddAdminIDs(ids...)
	return ugu
}

// AddAdmins adds the "admins" edges to the Admin entity.
func (ugu *UserGroupUpdate) AddAdmins(a ...*Admin) *UserGroupUpdate {
	ids := make([]uuid.UUID, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return ugu.AddAdminIDs(ids...)
}

// AddUserGroupIDs adds the "user_groups" edge to the UserGroupUser entity by IDs.
func (ugu *UserGroupUpdate) AddUserGroupIDs(ids ...uuid.UUID) *UserGroupUpdate {
	ugu.mutation.AddUserGroupIDs(ids...)
	return ugu
}

// AddUserGroups adds the "user_groups" edges to the UserGroupUser entity.
func (ugu *UserGroupUpdate) AddUserGroups(u ...*UserGroupUser) *UserGroupUpdate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return ugu.AddUserGroupIDs(ids...)
}

// AddUserGroupAdminIDs adds the "user_group_admins" edge to the UserGroupAdmin entity by IDs.
func (ugu *UserGroupUpdate) AddUserGroupAdminIDs(ids ...uuid.UUID) *UserGroupUpdate {
	ugu.mutation.AddUserGroupAdminIDs(ids...)
	return ugu
}

// AddUserGroupAdmins adds the "user_group_admins" edges to the UserGroupAdmin entity.
func (ugu *UserGroupUpdate) AddUserGroupAdmins(u ...*UserGroupAdmin) *UserGroupUpdate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return ugu.AddUserGroupAdminIDs(ids...)
}

// Mutation returns the UserGroupMutation object of the builder.
func (ugu *UserGroupUpdate) Mutation() *UserGroupMutation {
	return ugu.mutation
}

// ClearOwner clears the "owner" edge to the Admin entity.
func (ugu *UserGroupUpdate) ClearOwner() *UserGroupUpdate {
	ugu.mutation.ClearOwner()
	return ugu
}

// ClearUsers clears all "users" edges to the User entity.
func (ugu *UserGroupUpdate) ClearUsers() *UserGroupUpdate {
	ugu.mutation.ClearUsers()
	return ugu
}

// RemoveUserIDs removes the "users" edge to User entities by IDs.
func (ugu *UserGroupUpdate) RemoveUserIDs(ids ...uuid.UUID) *UserGroupUpdate {
	ugu.mutation.RemoveUserIDs(ids...)
	return ugu
}

// RemoveUsers removes "users" edges to User entities.
func (ugu *UserGroupUpdate) RemoveUsers(u ...*User) *UserGroupUpdate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return ugu.RemoveUserIDs(ids...)
}

// ClearAdmins clears all "admins" edges to the Admin entity.
func (ugu *UserGroupUpdate) ClearAdmins() *UserGroupUpdate {
	ugu.mutation.ClearAdmins()
	return ugu
}

// RemoveAdminIDs removes the "admins" edge to Admin entities by IDs.
func (ugu *UserGroupUpdate) RemoveAdminIDs(ids ...uuid.UUID) *UserGroupUpdate {
	ugu.mutation.RemoveAdminIDs(ids...)
	return ugu
}

// RemoveAdmins removes "admins" edges to Admin entities.
func (ugu *UserGroupUpdate) RemoveAdmins(a ...*Admin) *UserGroupUpdate {
	ids := make([]uuid.UUID, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return ugu.RemoveAdminIDs(ids...)
}

// ClearUserGroups clears all "user_groups" edges to the UserGroupUser entity.
func (ugu *UserGroupUpdate) ClearUserGroups() *UserGroupUpdate {
	ugu.mutation.ClearUserGroups()
	return ugu
}

// RemoveUserGroupIDs removes the "user_groups" edge to UserGroupUser entities by IDs.
func (ugu *UserGroupUpdate) RemoveUserGroupIDs(ids ...uuid.UUID) *UserGroupUpdate {
	ugu.mutation.RemoveUserGroupIDs(ids...)
	return ugu
}

// RemoveUserGroups removes "user_groups" edges to UserGroupUser entities.
func (ugu *UserGroupUpdate) RemoveUserGroups(u ...*UserGroupUser) *UserGroupUpdate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return ugu.RemoveUserGroupIDs(ids...)
}

// ClearUserGroupAdmins clears all "user_group_admins" edges to the UserGroupAdmin entity.
func (ugu *UserGroupUpdate) ClearUserGroupAdmins() *UserGroupUpdate {
	ugu.mutation.ClearUserGroupAdmins()
	return ugu
}

// RemoveUserGroupAdminIDs removes the "user_group_admins" edge to UserGroupAdmin entities by IDs.
func (ugu *UserGroupUpdate) RemoveUserGroupAdminIDs(ids ...uuid.UUID) *UserGroupUpdate {
	ugu.mutation.RemoveUserGroupAdminIDs(ids...)
	return ugu
}

// RemoveUserGroupAdmins removes "user_group_admins" edges to UserGroupAdmin entities.
func (ugu *UserGroupUpdate) RemoveUserGroupAdmins(u ...*UserGroupAdmin) *UserGroupUpdate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return ugu.RemoveUserGroupAdminIDs(ids...)
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (ugu *UserGroupUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, ugu.sqlSave, ugu.mutation, ugu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (ugu *UserGroupUpdate) SaveX(ctx context.Context) int {
	affected, err := ugu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (ugu *UserGroupUpdate) Exec(ctx context.Context) error {
	_, err := ugu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ugu *UserGroupUpdate) ExecX(ctx context.Context) {
	if err := ugu.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ugu *UserGroupUpdate) check() error {
	if v, ok := ugu.mutation.Name(); ok {
		if err := usergroup.NameValidator(v); err != nil {
			return &ValidationError{Name: "name", err: fmt.Errorf(`db: validator failed for field "UserGroup.name": %w`, err)}
		}
	}
	if ugu.mutation.OwnerCleared() && len(ugu.mutation.OwnerIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "UserGroup.owner"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (ugu *UserGroupUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *UserGroupUpdate {
	ugu.modifiers = append(ugu.modifiers, modifiers...)
	return ugu
}

func (ugu *UserGroupUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := ugu.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(usergroup.Table, usergroup.Columns, sqlgraph.NewFieldSpec(usergroup.FieldID, field.TypeUUID))
	if ps := ugu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := ugu.mutation.Name(); ok {
		_spec.SetField(usergroup.FieldName, field.TypeString, value)
	}
	if value, ok := ugu.mutation.CreatedAt(); ok {
		_spec.SetField(usergroup.FieldCreatedAt, field.TypeTime, value)
	}
	if ugu.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   usergroup.OwnerTable,
			Columns: []string{usergroup.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugu.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   usergroup.OwnerTable,
			Columns: []string{usergroup.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if ugu.mutation.UsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   usergroup.UsersTable,
			Columns: usergroup.UsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugu.mutation.RemovedUsersIDs(); len(nodes) > 0 && !ugu.mutation.UsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   usergroup.UsersTable,
			Columns: usergroup.UsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugu.mutation.UsersIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   usergroup.UsersTable,
			Columns: usergroup.UsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if ugu.mutation.AdminsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   usergroup.AdminsTable,
			Columns: usergroup.AdminsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugu.mutation.RemovedAdminsIDs(); len(nodes) > 0 && !ugu.mutation.AdminsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   usergroup.AdminsTable,
			Columns: usergroup.AdminsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugu.mutation.AdminsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   usergroup.AdminsTable,
			Columns: usergroup.AdminsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if ugu.mutation.UserGroupsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   usergroup.UserGroupsTable,
			Columns: []string{usergroup.UserGroupsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupuser.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugu.mutation.RemovedUserGroupsIDs(); len(nodes) > 0 && !ugu.mutation.UserGroupsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   usergroup.UserGroupsTable,
			Columns: []string{usergroup.UserGroupsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupuser.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugu.mutation.UserGroupsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   usergroup.UserGroupsTable,
			Columns: []string{usergroup.UserGroupsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupuser.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if ugu.mutation.UserGroupAdminsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   usergroup.UserGroupAdminsTable,
			Columns: []string{usergroup.UserGroupAdminsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupadmin.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugu.mutation.RemovedUserGroupAdminsIDs(); len(nodes) > 0 && !ugu.mutation.UserGroupAdminsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   usergroup.UserGroupAdminsTable,
			Columns: []string{usergroup.UserGroupAdminsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupadmin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugu.mutation.UserGroupAdminsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   usergroup.UserGroupAdminsTable,
			Columns: []string{usergroup.UserGroupAdminsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupadmin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(ugu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, ugu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{usergroup.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	ugu.mutation.done = true
	return n, nil
}

// UserGroupUpdateOne is the builder for updating a single UserGroup entity.
type UserGroupUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *UserGroupMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetAdminID sets the "admin_id" field.
func (uguo *UserGroupUpdateOne) SetAdminID(u uuid.UUID) *UserGroupUpdateOne {
	uguo.mutation.SetAdminID(u)
	return uguo
}

// SetNillableAdminID sets the "admin_id" field if the given value is not nil.
func (uguo *UserGroupUpdateOne) SetNillableAdminID(u *uuid.UUID) *UserGroupUpdateOne {
	if u != nil {
		uguo.SetAdminID(*u)
	}
	return uguo
}

// SetName sets the "name" field.
func (uguo *UserGroupUpdateOne) SetName(s string) *UserGroupUpdateOne {
	uguo.mutation.SetName(s)
	return uguo
}

// SetNillableName sets the "name" field if the given value is not nil.
func (uguo *UserGroupUpdateOne) SetNillableName(s *string) *UserGroupUpdateOne {
	if s != nil {
		uguo.SetName(*s)
	}
	return uguo
}

// SetCreatedAt sets the "created_at" field.
func (uguo *UserGroupUpdateOne) SetCreatedAt(t time.Time) *UserGroupUpdateOne {
	uguo.mutation.SetCreatedAt(t)
	return uguo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (uguo *UserGroupUpdateOne) SetNillableCreatedAt(t *time.Time) *UserGroupUpdateOne {
	if t != nil {
		uguo.SetCreatedAt(*t)
	}
	return uguo
}

// SetOwnerID sets the "owner" edge to the Admin entity by ID.
func (uguo *UserGroupUpdateOne) SetOwnerID(id uuid.UUID) *UserGroupUpdateOne {
	uguo.mutation.SetOwnerID(id)
	return uguo
}

// SetOwner sets the "owner" edge to the Admin entity.
func (uguo *UserGroupUpdateOne) SetOwner(a *Admin) *UserGroupUpdateOne {
	return uguo.SetOwnerID(a.ID)
}

// AddUserIDs adds the "users" edge to the User entity by IDs.
func (uguo *UserGroupUpdateOne) AddUserIDs(ids ...uuid.UUID) *UserGroupUpdateOne {
	uguo.mutation.AddUserIDs(ids...)
	return uguo
}

// AddUsers adds the "users" edges to the User entity.
func (uguo *UserGroupUpdateOne) AddUsers(u ...*User) *UserGroupUpdateOne {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uguo.AddUserIDs(ids...)
}

// AddAdminIDs adds the "admins" edge to the Admin entity by IDs.
func (uguo *UserGroupUpdateOne) AddAdminIDs(ids ...uuid.UUID) *UserGroupUpdateOne {
	uguo.mutation.AddAdminIDs(ids...)
	return uguo
}

// AddAdmins adds the "admins" edges to the Admin entity.
func (uguo *UserGroupUpdateOne) AddAdmins(a ...*Admin) *UserGroupUpdateOne {
	ids := make([]uuid.UUID, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return uguo.AddAdminIDs(ids...)
}

// AddUserGroupIDs adds the "user_groups" edge to the UserGroupUser entity by IDs.
func (uguo *UserGroupUpdateOne) AddUserGroupIDs(ids ...uuid.UUID) *UserGroupUpdateOne {
	uguo.mutation.AddUserGroupIDs(ids...)
	return uguo
}

// AddUserGroups adds the "user_groups" edges to the UserGroupUser entity.
func (uguo *UserGroupUpdateOne) AddUserGroups(u ...*UserGroupUser) *UserGroupUpdateOne {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uguo.AddUserGroupIDs(ids...)
}

// AddUserGroupAdminIDs adds the "user_group_admins" edge to the UserGroupAdmin entity by IDs.
func (uguo *UserGroupUpdateOne) AddUserGroupAdminIDs(ids ...uuid.UUID) *UserGroupUpdateOne {
	uguo.mutation.AddUserGroupAdminIDs(ids...)
	return uguo
}

// AddUserGroupAdmins adds the "user_group_admins" edges to the UserGroupAdmin entity.
func (uguo *UserGroupUpdateOne) AddUserGroupAdmins(u ...*UserGroupAdmin) *UserGroupUpdateOne {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uguo.AddUserGroupAdminIDs(ids...)
}

// Mutation returns the UserGroupMutation object of the builder.
func (uguo *UserGroupUpdateOne) Mutation() *UserGroupMutation {
	return uguo.mutation
}

// ClearOwner clears the "owner" edge to the Admin entity.
func (uguo *UserGroupUpdateOne) ClearOwner() *UserGroupUpdateOne {
	uguo.mutation.ClearOwner()
	return uguo
}

// ClearUsers clears all "users" edges to the User entity.
func (uguo *UserGroupUpdateOne) ClearUsers() *UserGroupUpdateOne {
	uguo.mutation.ClearUsers()
	return uguo
}

// RemoveUserIDs removes the "users" edge to User entities by IDs.
func (uguo *UserGroupUpdateOne) RemoveUserIDs(ids ...uuid.UUID) *UserGroupUpdateOne {
	uguo.mutation.RemoveUserIDs(ids...)
	return uguo
}

// RemoveUsers removes "users" edges to User entities.
func (uguo *UserGroupUpdateOne) RemoveUsers(u ...*User) *UserGroupUpdateOne {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uguo.RemoveUserIDs(ids...)
}

// ClearAdmins clears all "admins" edges to the Admin entity.
func (uguo *UserGroupUpdateOne) ClearAdmins() *UserGroupUpdateOne {
	uguo.mutation.ClearAdmins()
	return uguo
}

// RemoveAdminIDs removes the "admins" edge to Admin entities by IDs.
func (uguo *UserGroupUpdateOne) RemoveAdminIDs(ids ...uuid.UUID) *UserGroupUpdateOne {
	uguo.mutation.RemoveAdminIDs(ids...)
	return uguo
}

// RemoveAdmins removes "admins" edges to Admin entities.
func (uguo *UserGroupUpdateOne) RemoveAdmins(a ...*Admin) *UserGroupUpdateOne {
	ids := make([]uuid.UUID, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return uguo.RemoveAdminIDs(ids...)
}

// ClearUserGroups clears all "user_groups" edges to the UserGroupUser entity.
func (uguo *UserGroupUpdateOne) ClearUserGroups() *UserGroupUpdateOne {
	uguo.mutation.ClearUserGroups()
	return uguo
}

// RemoveUserGroupIDs removes the "user_groups" edge to UserGroupUser entities by IDs.
func (uguo *UserGroupUpdateOne) RemoveUserGroupIDs(ids ...uuid.UUID) *UserGroupUpdateOne {
	uguo.mutation.RemoveUserGroupIDs(ids...)
	return uguo
}

// RemoveUserGroups removes "user_groups" edges to UserGroupUser entities.
func (uguo *UserGroupUpdateOne) RemoveUserGroups(u ...*UserGroupUser) *UserGroupUpdateOne {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uguo.RemoveUserGroupIDs(ids...)
}

// ClearUserGroupAdmins clears all "user_group_admins" edges to the UserGroupAdmin entity.
func (uguo *UserGroupUpdateOne) ClearUserGroupAdmins() *UserGroupUpdateOne {
	uguo.mutation.ClearUserGroupAdmins()
	return uguo
}

// RemoveUserGroupAdminIDs removes the "user_group_admins" edge to UserGroupAdmin entities by IDs.
func (uguo *UserGroupUpdateOne) RemoveUserGroupAdminIDs(ids ...uuid.UUID) *UserGroupUpdateOne {
	uguo.mutation.RemoveUserGroupAdminIDs(ids...)
	return uguo
}

// RemoveUserGroupAdmins removes "user_group_admins" edges to UserGroupAdmin entities.
func (uguo *UserGroupUpdateOne) RemoveUserGroupAdmins(u ...*UserGroupAdmin) *UserGroupUpdateOne {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uguo.RemoveUserGroupAdminIDs(ids...)
}

// Where appends a list predicates to the UserGroupUpdate builder.
func (uguo *UserGroupUpdateOne) Where(ps ...predicate.UserGroup) *UserGroupUpdateOne {
	uguo.mutation.Where(ps...)
	return uguo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (uguo *UserGroupUpdateOne) Select(field string, fields ...string) *UserGroupUpdateOne {
	uguo.fields = append([]string{field}, fields...)
	return uguo
}

// Save executes the query and returns the updated UserGroup entity.
func (uguo *UserGroupUpdateOne) Save(ctx context.Context) (*UserGroup, error) {
	return withHooks(ctx, uguo.sqlSave, uguo.mutation, uguo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (uguo *UserGroupUpdateOne) SaveX(ctx context.Context) *UserGroup {
	node, err := uguo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (uguo *UserGroupUpdateOne) Exec(ctx context.Context) error {
	_, err := uguo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uguo *UserGroupUpdateOne) ExecX(ctx context.Context) {
	if err := uguo.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (uguo *UserGroupUpdateOne) check() error {
	if v, ok := uguo.mutation.Name(); ok {
		if err := usergroup.NameValidator(v); err != nil {
			return &ValidationError{Name: "name", err: fmt.Errorf(`db: validator failed for field "UserGroup.name": %w`, err)}
		}
	}
	if uguo.mutation.OwnerCleared() && len(uguo.mutation.OwnerIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "UserGroup.owner"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (uguo *UserGroupUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *UserGroupUpdateOne {
	uguo.modifiers = append(uguo.modifiers, modifiers...)
	return uguo
}

func (uguo *UserGroupUpdateOne) sqlSave(ctx context.Context) (_node *UserGroup, err error) {
	if err := uguo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(usergroup.Table, usergroup.Columns, sqlgraph.NewFieldSpec(usergroup.FieldID, field.TypeUUID))
	id, ok := uguo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "UserGroup.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := uguo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, usergroup.FieldID)
		for _, f := range fields {
			if !usergroup.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != usergroup.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := uguo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := uguo.mutation.Name(); ok {
		_spec.SetField(usergroup.FieldName, field.TypeString, value)
	}
	if value, ok := uguo.mutation.CreatedAt(); ok {
		_spec.SetField(usergroup.FieldCreatedAt, field.TypeTime, value)
	}
	if uguo.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   usergroup.OwnerTable,
			Columns: []string{usergroup.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguo.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   usergroup.OwnerTable,
			Columns: []string{usergroup.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if uguo.mutation.UsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   usergroup.UsersTable,
			Columns: usergroup.UsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguo.mutation.RemovedUsersIDs(); len(nodes) > 0 && !uguo.mutation.UsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   usergroup.UsersTable,
			Columns: usergroup.UsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguo.mutation.UsersIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   usergroup.UsersTable,
			Columns: usergroup.UsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if uguo.mutation.AdminsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   usergroup.AdminsTable,
			Columns: usergroup.AdminsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguo.mutation.RemovedAdminsIDs(); len(nodes) > 0 && !uguo.mutation.AdminsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   usergroup.AdminsTable,
			Columns: usergroup.AdminsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguo.mutation.AdminsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   usergroup.AdminsTable,
			Columns: usergroup.AdminsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if uguo.mutation.UserGroupsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   usergroup.UserGroupsTable,
			Columns: []string{usergroup.UserGroupsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupuser.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguo.mutation.RemovedUserGroupsIDs(); len(nodes) > 0 && !uguo.mutation.UserGroupsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   usergroup.UserGroupsTable,
			Columns: []string{usergroup.UserGroupsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupuser.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguo.mutation.UserGroupsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   usergroup.UserGroupsTable,
			Columns: []string{usergroup.UserGroupsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupuser.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if uguo.mutation.UserGroupAdminsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   usergroup.UserGroupAdminsTable,
			Columns: []string{usergroup.UserGroupAdminsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupadmin.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguo.mutation.RemovedUserGroupAdminsIDs(); len(nodes) > 0 && !uguo.mutation.UserGroupAdminsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   usergroup.UserGroupAdminsTable,
			Columns: []string{usergroup.UserGroupAdminsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupadmin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguo.mutation.UserGroupAdminsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   usergroup.UserGroupAdminsTable,
			Columns: []string{usergroup.UserGroupAdminsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupadmin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(uguo.modifiers...)
	_node = &UserGroup{config: uguo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, uguo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{usergroup.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	uguo.mutation.done = true
	return _node, nil
}
