// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/usergroup"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupadmin"
	"github.com/google/uuid"
)

// UserGroupAdmin is the model entity for the UserGroupAdmin schema.
type UserGroupAdmin struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// UserGroupID holds the value of the "user_group_id" field.
	UserGroupID uuid.UUID `json:"user_group_id,omitempty"`
	// AdminID holds the value of the "admin_id" field.
	AdminID uuid.UUID `json:"admin_id,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the UserGroupAdminQuery when eager-loading is set.
	Edges        UserGroupAdminEdges `json:"edges"`
	selectValues sql.SelectValues
}

// UserGroupAdminEdges holds the relations/edges for other nodes in the graph.
type UserGroupAdminEdges struct {
	// UserGroup holds the value of the user_group edge.
	UserGroup *UserGroup `json:"user_group,omitempty"`
	// Admin holds the value of the admin edge.
	Admin *Admin `json:"admin,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [2]bool
}

// UserGroupOrErr returns the UserGroup value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e UserGroupAdminEdges) UserGroupOrErr() (*UserGroup, error) {
	if e.UserGroup != nil {
		return e.UserGroup, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: usergroup.Label}
	}
	return nil, &NotLoadedError{edge: "user_group"}
}

// AdminOrErr returns the Admin value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e UserGroupAdminEdges) AdminOrErr() (*Admin, error) {
	if e.Admin != nil {
		return e.Admin, nil
	} else if e.loadedTypes[1] {
		return nil, &NotFoundError{label: admin.Label}
	}
	return nil, &NotLoadedError{edge: "admin"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*UserGroupAdmin) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case usergroupadmin.FieldID, usergroupadmin.FieldUserGroupID, usergroupadmin.FieldAdminID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the UserGroupAdmin fields.
func (uga *UserGroupAdmin) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case usergroupadmin.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				uga.ID = *value
			}
		case usergroupadmin.FieldUserGroupID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field user_group_id", values[i])
			} else if value != nil {
				uga.UserGroupID = *value
			}
		case usergroupadmin.FieldAdminID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field admin_id", values[i])
			} else if value != nil {
				uga.AdminID = *value
			}
		default:
			uga.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the UserGroupAdmin.
// This includes values selected through modifiers, order, etc.
func (uga *UserGroupAdmin) Value(name string) (ent.Value, error) {
	return uga.selectValues.Get(name)
}

// QueryUserGroup queries the "user_group" edge of the UserGroupAdmin entity.
func (uga *UserGroupAdmin) QueryUserGroup() *UserGroupQuery {
	return NewUserGroupAdminClient(uga.config).QueryUserGroup(uga)
}

// QueryAdmin queries the "admin" edge of the UserGroupAdmin entity.
func (uga *UserGroupAdmin) QueryAdmin() *AdminQuery {
	return NewUserGroupAdminClient(uga.config).QueryAdmin(uga)
}

// Update returns a builder for updating this UserGroupAdmin.
// Note that you need to call UserGroupAdmin.Unwrap() before calling this method if this UserGroupAdmin
// was returned from a transaction, and the transaction was committed or rolled back.
func (uga *UserGroupAdmin) Update() *UserGroupAdminUpdateOne {
	return NewUserGroupAdminClient(uga.config).UpdateOne(uga)
}

// Unwrap unwraps the UserGroupAdmin entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (uga *UserGroupAdmin) Unwrap() *UserGroupAdmin {
	_tx, ok := uga.config.driver.(*txDriver)
	if !ok {
		panic("db: UserGroupAdmin is not a transactional entity")
	}
	uga.config.driver = _tx.drv
	return uga
}

// String implements the fmt.Stringer.
func (uga *UserGroupAdmin) String() string {
	var builder strings.Builder
	builder.WriteString("UserGroupAdmin(")
	builder.WriteString(fmt.Sprintf("id=%v, ", uga.ID))
	builder.WriteString("user_group_id=")
	builder.WriteString(fmt.Sprintf("%v", uga.UserGroupID))
	builder.WriteString(", ")
	builder.WriteString("admin_id=")
	builder.WriteString(fmt.Sprintf("%v", uga.AdminID))
	builder.WriteByte(')')
	return builder.String()
}

// UserGroupAdmins is a parsable slice of UserGroupAdmin.
type UserGroupAdmins []*UserGroupAdmin
