// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupadmin"
)

// UserGroupAdminDelete is the builder for deleting a UserGroupAdmin entity.
type UserGroupAdminDelete struct {
	config
	hooks    []Hook
	mutation *UserGroupAdminMutation
}

// Where appends a list predicates to the UserGroupAdminDelete builder.
func (ugad *UserGroupAdminDelete) Where(ps ...predicate.UserGroupAdmin) *UserGroupAdminDelete {
	ugad.mutation.Where(ps...)
	return ugad
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (ugad *UserGroupAdminDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, ugad.sqlExec, ugad.mutation, ugad.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (ugad *UserGroupAdminDelete) ExecX(ctx context.Context) int {
	n, err := ugad.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (ugad *UserGroupAdminDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(usergroupadmin.Table, sqlgraph.NewFieldSpec(usergroupadmin.FieldID, field.TypeUUID))
	if ps := ugad.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, ugad.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	ugad.mutation.done = true
	return affected, err
}

// UserGroupAdminDeleteOne is the builder for deleting a single UserGroupAdmin entity.
type UserGroupAdminDeleteOne struct {
	ugad *UserGroupAdminDelete
}

// Where appends a list predicates to the UserGroupAdminDelete builder.
func (ugado *UserGroupAdminDeleteOne) Where(ps ...predicate.UserGroupAdmin) *UserGroupAdminDeleteOne {
	ugado.ugad.mutation.Where(ps...)
	return ugado
}

// Exec executes the deletion query.
func (ugado *UserGroupAdminDeleteOne) Exec(ctx context.Context) error {
	n, err := ugado.ugad.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{usergroupadmin.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (ugado *UserGroupAdminDeleteOne) ExecX(ctx context.Context) {
	if err := ugado.Exec(ctx); err != nil {
		panic(err)
	}
}
