// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/usergroup"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupadmin"
	"github.com/google/uuid"
)

// UserGroupAdminUpdate is the builder for updating UserGroupAdmin entities.
type UserGroupAdminUpdate struct {
	config
	hooks     []Hook
	mutation  *UserGroupAdminMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the UserGroupAdminUpdate builder.
func (ugau *UserGroupAdminUpdate) Where(ps ...predicate.UserGroupAdmin) *UserGroupAdminUpdate {
	ugau.mutation.Where(ps...)
	return ugau
}

// SetUserGroupID sets the "user_group_id" field.
func (ugau *UserGroupAdminUpdate) SetUserGroupID(u uuid.UUID) *UserGroupAdminUpdate {
	ugau.mutation.SetUserGroupID(u)
	return ugau
}

// SetNillableUserGroupID sets the "user_group_id" field if the given value is not nil.
func (ugau *UserGroupAdminUpdate) SetNillableUserGroupID(u *uuid.UUID) *UserGroupAdminUpdate {
	if u != nil {
		ugau.SetUserGroupID(*u)
	}
	return ugau
}

// SetAdminID sets the "admin_id" field.
func (ugau *UserGroupAdminUpdate) SetAdminID(u uuid.UUID) *UserGroupAdminUpdate {
	ugau.mutation.SetAdminID(u)
	return ugau
}

// SetNillableAdminID sets the "admin_id" field if the given value is not nil.
func (ugau *UserGroupAdminUpdate) SetNillableAdminID(u *uuid.UUID) *UserGroupAdminUpdate {
	if u != nil {
		ugau.SetAdminID(*u)
	}
	return ugau
}

// SetUserGroup sets the "user_group" edge to the UserGroup entity.
func (ugau *UserGroupAdminUpdate) SetUserGroup(u *UserGroup) *UserGroupAdminUpdate {
	return ugau.SetUserGroupID(u.ID)
}

// SetAdmin sets the "admin" edge to the Admin entity.
func (ugau *UserGroupAdminUpdate) SetAdmin(a *Admin) *UserGroupAdminUpdate {
	return ugau.SetAdminID(a.ID)
}

// Mutation returns the UserGroupAdminMutation object of the builder.
func (ugau *UserGroupAdminUpdate) Mutation() *UserGroupAdminMutation {
	return ugau.mutation
}

// ClearUserGroup clears the "user_group" edge to the UserGroup entity.
func (ugau *UserGroupAdminUpdate) ClearUserGroup() *UserGroupAdminUpdate {
	ugau.mutation.ClearUserGroup()
	return ugau
}

// ClearAdmin clears the "admin" edge to the Admin entity.
func (ugau *UserGroupAdminUpdate) ClearAdmin() *UserGroupAdminUpdate {
	ugau.mutation.ClearAdmin()
	return ugau
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (ugau *UserGroupAdminUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, ugau.sqlSave, ugau.mutation, ugau.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (ugau *UserGroupAdminUpdate) SaveX(ctx context.Context) int {
	affected, err := ugau.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (ugau *UserGroupAdminUpdate) Exec(ctx context.Context) error {
	_, err := ugau.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ugau *UserGroupAdminUpdate) ExecX(ctx context.Context) {
	if err := ugau.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ugau *UserGroupAdminUpdate) check() error {
	if ugau.mutation.UserGroupCleared() && len(ugau.mutation.UserGroupIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "UserGroupAdmin.user_group"`)
	}
	if ugau.mutation.AdminCleared() && len(ugau.mutation.AdminIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "UserGroupAdmin.admin"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (ugau *UserGroupAdminUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *UserGroupAdminUpdate {
	ugau.modifiers = append(ugau.modifiers, modifiers...)
	return ugau
}

func (ugau *UserGroupAdminUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := ugau.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(usergroupadmin.Table, usergroupadmin.Columns, sqlgraph.NewFieldSpec(usergroupadmin.FieldID, field.TypeUUID))
	if ps := ugau.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if ugau.mutation.UserGroupCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupadmin.UserGroupTable,
			Columns: []string{usergroupadmin.UserGroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroup.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugau.mutation.UserGroupIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupadmin.UserGroupTable,
			Columns: []string{usergroupadmin.UserGroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroup.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if ugau.mutation.AdminCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupadmin.AdminTable,
			Columns: []string{usergroupadmin.AdminColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugau.mutation.AdminIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupadmin.AdminTable,
			Columns: []string{usergroupadmin.AdminColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(ugau.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, ugau.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{usergroupadmin.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	ugau.mutation.done = true
	return n, nil
}

// UserGroupAdminUpdateOne is the builder for updating a single UserGroupAdmin entity.
type UserGroupAdminUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *UserGroupAdminMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetUserGroupID sets the "user_group_id" field.
func (ugauo *UserGroupAdminUpdateOne) SetUserGroupID(u uuid.UUID) *UserGroupAdminUpdateOne {
	ugauo.mutation.SetUserGroupID(u)
	return ugauo
}

// SetNillableUserGroupID sets the "user_group_id" field if the given value is not nil.
func (ugauo *UserGroupAdminUpdateOne) SetNillableUserGroupID(u *uuid.UUID) *UserGroupAdminUpdateOne {
	if u != nil {
		ugauo.SetUserGroupID(*u)
	}
	return ugauo
}

// SetAdminID sets the "admin_id" field.
func (ugauo *UserGroupAdminUpdateOne) SetAdminID(u uuid.UUID) *UserGroupAdminUpdateOne {
	ugauo.mutation.SetAdminID(u)
	return ugauo
}

// SetNillableAdminID sets the "admin_id" field if the given value is not nil.
func (ugauo *UserGroupAdminUpdateOne) SetNillableAdminID(u *uuid.UUID) *UserGroupAdminUpdateOne {
	if u != nil {
		ugauo.SetAdminID(*u)
	}
	return ugauo
}

// SetUserGroup sets the "user_group" edge to the UserGroup entity.
func (ugauo *UserGroupAdminUpdateOne) SetUserGroup(u *UserGroup) *UserGroupAdminUpdateOne {
	return ugauo.SetUserGroupID(u.ID)
}

// SetAdmin sets the "admin" edge to the Admin entity.
func (ugauo *UserGroupAdminUpdateOne) SetAdmin(a *Admin) *UserGroupAdminUpdateOne {
	return ugauo.SetAdminID(a.ID)
}

// Mutation returns the UserGroupAdminMutation object of the builder.
func (ugauo *UserGroupAdminUpdateOne) Mutation() *UserGroupAdminMutation {
	return ugauo.mutation
}

// ClearUserGroup clears the "user_group" edge to the UserGroup entity.
func (ugauo *UserGroupAdminUpdateOne) ClearUserGroup() *UserGroupAdminUpdateOne {
	ugauo.mutation.ClearUserGroup()
	return ugauo
}

// ClearAdmin clears the "admin" edge to the Admin entity.
func (ugauo *UserGroupAdminUpdateOne) ClearAdmin() *UserGroupAdminUpdateOne {
	ugauo.mutation.ClearAdmin()
	return ugauo
}

// Where appends a list predicates to the UserGroupAdminUpdate builder.
func (ugauo *UserGroupAdminUpdateOne) Where(ps ...predicate.UserGroupAdmin) *UserGroupAdminUpdateOne {
	ugauo.mutation.Where(ps...)
	return ugauo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (ugauo *UserGroupAdminUpdateOne) Select(field string, fields ...string) *UserGroupAdminUpdateOne {
	ugauo.fields = append([]string{field}, fields...)
	return ugauo
}

// Save executes the query and returns the updated UserGroupAdmin entity.
func (ugauo *UserGroupAdminUpdateOne) Save(ctx context.Context) (*UserGroupAdmin, error) {
	return withHooks(ctx, ugauo.sqlSave, ugauo.mutation, ugauo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (ugauo *UserGroupAdminUpdateOne) SaveX(ctx context.Context) *UserGroupAdmin {
	node, err := ugauo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (ugauo *UserGroupAdminUpdateOne) Exec(ctx context.Context) error {
	_, err := ugauo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ugauo *UserGroupAdminUpdateOne) ExecX(ctx context.Context) {
	if err := ugauo.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ugauo *UserGroupAdminUpdateOne) check() error {
	if ugauo.mutation.UserGroupCleared() && len(ugauo.mutation.UserGroupIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "UserGroupAdmin.user_group"`)
	}
	if ugauo.mutation.AdminCleared() && len(ugauo.mutation.AdminIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "UserGroupAdmin.admin"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (ugauo *UserGroupAdminUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *UserGroupAdminUpdateOne {
	ugauo.modifiers = append(ugauo.modifiers, modifiers...)
	return ugauo
}

func (ugauo *UserGroupAdminUpdateOne) sqlSave(ctx context.Context) (_node *UserGroupAdmin, err error) {
	if err := ugauo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(usergroupadmin.Table, usergroupadmin.Columns, sqlgraph.NewFieldSpec(usergroupadmin.FieldID, field.TypeUUID))
	id, ok := ugauo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "UserGroupAdmin.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := ugauo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, usergroupadmin.FieldID)
		for _, f := range fields {
			if !usergroupadmin.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != usergroupadmin.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := ugauo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if ugauo.mutation.UserGroupCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupadmin.UserGroupTable,
			Columns: []string{usergroupadmin.UserGroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroup.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugauo.mutation.UserGroupIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupadmin.UserGroupTable,
			Columns: []string{usergroupadmin.UserGroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroup.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if ugauo.mutation.AdminCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupadmin.AdminTable,
			Columns: []string{usergroupadmin.AdminColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugauo.mutation.AdminIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroupadmin.AdminTable,
			Columns: []string{usergroupadmin.AdminColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(ugauo.modifiers...)
	_node = &UserGroupAdmin{config: ugauo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, ugauo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{usergroupadmin.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	ugauo.mutation.done = true
	return _node, nil
}
