// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupuser"
)

// UserGroupUserDelete is the builder for deleting a UserGroupUser entity.
type UserGroupUserDelete struct {
	config
	hooks    []Hook
	mutation *UserGroupUserMutation
}

// Where appends a list predicates to the UserGroupUserDelete builder.
func (ugud *UserGroupUserDelete) Where(ps ...predicate.UserGroupUser) *UserGroupUserDelete {
	ugud.mutation.Where(ps...)
	return ugud
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (ugud *UserGroupUserDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, ugud.sqlExec, ugud.mutation, ugud.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (ugud *UserGroupUserDelete) ExecX(ctx context.Context) int {
	n, err := ugud.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (ugud *UserGroupUserDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(usergroupuser.Table, sqlgraph.NewFieldSpec(usergroupuser.FieldID, field.TypeUUID))
	if ps := ugud.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, ugud.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	ugud.mutation.done = true
	return affected, err
}

// UserGroupUserDeleteOne is the builder for deleting a single UserGroupUser entity.
type UserGroupUserDeleteOne struct {
	ugud *UserGroupUserDelete
}

// Where appends a list predicates to the UserGroupUserDelete builder.
func (ugudo *UserGroupUserDeleteOne) Where(ps ...predicate.UserGroupUser) *UserGroupUserDeleteOne {
	ugudo.ugud.mutation.Where(ps...)
	return ugudo
}

// Exec executes the deletion query.
func (ugudo *UserGroupUserDeleteOne) Exec(ctx context.Context) error {
	n, err := ugudo.ugud.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{usergroupuser.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (ugudo *UserGroupUserDeleteOne) ExecX(ctx context.Context) {
	if err := ugudo.Exec(ctx); err != nil {
		panic(err)
	}
}
