// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent"
	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/usergroup"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupuser"
	"github.com/google/uuid"
)

// UserGroupUserQuery is the builder for querying UserGroupUser entities.
type UserGroupUserQuery struct {
	config
	ctx           *QueryContext
	order         []usergroupuser.OrderOption
	inters        []Interceptor
	predicates    []predicate.UserGroupUser
	withUserGroup *UserGroupQuery
	withUser      *UserQuery
	modifiers     []func(*sql.Selector)
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the UserGroupUserQuery builder.
func (uguq *UserGroupUserQuery) Where(ps ...predicate.UserGroupUser) *UserGroupUserQuery {
	uguq.predicates = append(uguq.predicates, ps...)
	return uguq
}

// Limit the number of records to be returned by this query.
func (uguq *UserGroupUserQuery) Limit(limit int) *UserGroupUserQuery {
	uguq.ctx.Limit = &limit
	return uguq
}

// Offset to start from.
func (uguq *UserGroupUserQuery) Offset(offset int) *UserGroupUserQuery {
	uguq.ctx.Offset = &offset
	return uguq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (uguq *UserGroupUserQuery) Unique(unique bool) *UserGroupUserQuery {
	uguq.ctx.Unique = &unique
	return uguq
}

// Order specifies how the records should be ordered.
func (uguq *UserGroupUserQuery) Order(o ...usergroupuser.OrderOption) *UserGroupUserQuery {
	uguq.order = append(uguq.order, o...)
	return uguq
}

// QueryUserGroup chains the current query on the "user_group" edge.
func (uguq *UserGroupUserQuery) QueryUserGroup() *UserGroupQuery {
	query := (&UserGroupClient{config: uguq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := uguq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := uguq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(usergroupuser.Table, usergroupuser.FieldID, selector),
			sqlgraph.To(usergroup.Table, usergroup.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, usergroupuser.UserGroupTable, usergroupuser.UserGroupColumn),
		)
		fromU = sqlgraph.SetNeighbors(uguq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// QueryUser chains the current query on the "user" edge.
func (uguq *UserGroupUserQuery) QueryUser() *UserQuery {
	query := (&UserClient{config: uguq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := uguq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := uguq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(usergroupuser.Table, usergroupuser.FieldID, selector),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, usergroupuser.UserTable, usergroupuser.UserColumn),
		)
		fromU = sqlgraph.SetNeighbors(uguq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// First returns the first UserGroupUser entity from the query.
// Returns a *NotFoundError when no UserGroupUser was found.
func (uguq *UserGroupUserQuery) First(ctx context.Context) (*UserGroupUser, error) {
	nodes, err := uguq.Limit(1).All(setContextOp(ctx, uguq.ctx, ent.OpQueryFirst))
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{usergroupuser.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (uguq *UserGroupUserQuery) FirstX(ctx context.Context) *UserGroupUser {
	node, err := uguq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first UserGroupUser ID from the query.
// Returns a *NotFoundError when no UserGroupUser ID was found.
func (uguq *UserGroupUserQuery) FirstID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = uguq.Limit(1).IDs(setContextOp(ctx, uguq.ctx, ent.OpQueryFirstID)); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{usergroupuser.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (uguq *UserGroupUserQuery) FirstIDX(ctx context.Context) uuid.UUID {
	id, err := uguq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single UserGroupUser entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one UserGroupUser entity is found.
// Returns a *NotFoundError when no UserGroupUser entities are found.
func (uguq *UserGroupUserQuery) Only(ctx context.Context) (*UserGroupUser, error) {
	nodes, err := uguq.Limit(2).All(setContextOp(ctx, uguq.ctx, ent.OpQueryOnly))
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{usergroupuser.Label}
	default:
		return nil, &NotSingularError{usergroupuser.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (uguq *UserGroupUserQuery) OnlyX(ctx context.Context) *UserGroupUser {
	node, err := uguq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only UserGroupUser ID in the query.
// Returns a *NotSingularError when more than one UserGroupUser ID is found.
// Returns a *NotFoundError when no entities are found.
func (uguq *UserGroupUserQuery) OnlyID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = uguq.Limit(2).IDs(setContextOp(ctx, uguq.ctx, ent.OpQueryOnlyID)); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{usergroupuser.Label}
	default:
		err = &NotSingularError{usergroupuser.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (uguq *UserGroupUserQuery) OnlyIDX(ctx context.Context) uuid.UUID {
	id, err := uguq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of UserGroupUsers.
func (uguq *UserGroupUserQuery) All(ctx context.Context) ([]*UserGroupUser, error) {
	ctx = setContextOp(ctx, uguq.ctx, ent.OpQueryAll)
	if err := uguq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	qr := querierAll[[]*UserGroupUser, *UserGroupUserQuery]()
	return withInterceptors[[]*UserGroupUser](ctx, uguq, qr, uguq.inters)
}

// AllX is like All, but panics if an error occurs.
func (uguq *UserGroupUserQuery) AllX(ctx context.Context) []*UserGroupUser {
	nodes, err := uguq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of UserGroupUser IDs.
func (uguq *UserGroupUserQuery) IDs(ctx context.Context) (ids []uuid.UUID, err error) {
	if uguq.ctx.Unique == nil && uguq.path != nil {
		uguq.Unique(true)
	}
	ctx = setContextOp(ctx, uguq.ctx, ent.OpQueryIDs)
	if err = uguq.Select(usergroupuser.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (uguq *UserGroupUserQuery) IDsX(ctx context.Context) []uuid.UUID {
	ids, err := uguq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (uguq *UserGroupUserQuery) Count(ctx context.Context) (int, error) {
	ctx = setContextOp(ctx, uguq.ctx, ent.OpQueryCount)
	if err := uguq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return withInterceptors[int](ctx, uguq, querierCount[*UserGroupUserQuery](), uguq.inters)
}

// CountX is like Count, but panics if an error occurs.
func (uguq *UserGroupUserQuery) CountX(ctx context.Context) int {
	count, err := uguq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (uguq *UserGroupUserQuery) Exist(ctx context.Context) (bool, error) {
	ctx = setContextOp(ctx, uguq.ctx, ent.OpQueryExist)
	switch _, err := uguq.FirstID(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("db: check existence: %w", err)
	default:
		return true, nil
	}
}

// ExistX is like Exist, but panics if an error occurs.
func (uguq *UserGroupUserQuery) ExistX(ctx context.Context) bool {
	exist, err := uguq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the UserGroupUserQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (uguq *UserGroupUserQuery) Clone() *UserGroupUserQuery {
	if uguq == nil {
		return nil
	}
	return &UserGroupUserQuery{
		config:        uguq.config,
		ctx:           uguq.ctx.Clone(),
		order:         append([]usergroupuser.OrderOption{}, uguq.order...),
		inters:        append([]Interceptor{}, uguq.inters...),
		predicates:    append([]predicate.UserGroupUser{}, uguq.predicates...),
		withUserGroup: uguq.withUserGroup.Clone(),
		withUser:      uguq.withUser.Clone(),
		// clone intermediate query.
		sql:       uguq.sql.Clone(),
		path:      uguq.path,
		modifiers: append([]func(*sql.Selector){}, uguq.modifiers...),
	}
}

// WithUserGroup tells the query-builder to eager-load the nodes that are connected to
// the "user_group" edge. The optional arguments are used to configure the query builder of the edge.
func (uguq *UserGroupUserQuery) WithUserGroup(opts ...func(*UserGroupQuery)) *UserGroupUserQuery {
	query := (&UserGroupClient{config: uguq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	uguq.withUserGroup = query
	return uguq
}

// WithUser tells the query-builder to eager-load the nodes that are connected to
// the "user" edge. The optional arguments are used to configure the query builder of the edge.
func (uguq *UserGroupUserQuery) WithUser(opts ...func(*UserQuery)) *UserGroupUserQuery {
	query := (&UserClient{config: uguq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	uguq.withUser = query
	return uguq
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		UserGroupID uuid.UUID `json:"user_group_id,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.UserGroupUser.Query().
//		GroupBy(usergroupuser.FieldUserGroupID).
//		Aggregate(db.Count()).
//		Scan(ctx, &v)
func (uguq *UserGroupUserQuery) GroupBy(field string, fields ...string) *UserGroupUserGroupBy {
	uguq.ctx.Fields = append([]string{field}, fields...)
	grbuild := &UserGroupUserGroupBy{build: uguq}
	grbuild.flds = &uguq.ctx.Fields
	grbuild.label = usergroupuser.Label
	grbuild.scan = grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		UserGroupID uuid.UUID `json:"user_group_id,omitempty"`
//	}
//
//	client.UserGroupUser.Query().
//		Select(usergroupuser.FieldUserGroupID).
//		Scan(ctx, &v)
func (uguq *UserGroupUserQuery) Select(fields ...string) *UserGroupUserSelect {
	uguq.ctx.Fields = append(uguq.ctx.Fields, fields...)
	sbuild := &UserGroupUserSelect{UserGroupUserQuery: uguq}
	sbuild.label = usergroupuser.Label
	sbuild.flds, sbuild.scan = &uguq.ctx.Fields, sbuild.Scan
	return sbuild
}

// Aggregate returns a UserGroupUserSelect configured with the given aggregations.
func (uguq *UserGroupUserQuery) Aggregate(fns ...AggregateFunc) *UserGroupUserSelect {
	return uguq.Select().Aggregate(fns...)
}

func (uguq *UserGroupUserQuery) prepareQuery(ctx context.Context) error {
	for _, inter := range uguq.inters {
		if inter == nil {
			return fmt.Errorf("db: uninitialized interceptor (forgotten import db/runtime?)")
		}
		if trv, ok := inter.(Traverser); ok {
			if err := trv.Traverse(ctx, uguq); err != nil {
				return err
			}
		}
	}
	for _, f := range uguq.ctx.Fields {
		if !usergroupuser.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
		}
	}
	if uguq.path != nil {
		prev, err := uguq.path(ctx)
		if err != nil {
			return err
		}
		uguq.sql = prev
	}
	return nil
}

func (uguq *UserGroupUserQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*UserGroupUser, error) {
	var (
		nodes       = []*UserGroupUser{}
		_spec       = uguq.querySpec()
		loadedTypes = [2]bool{
			uguq.withUserGroup != nil,
			uguq.withUser != nil,
		}
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*UserGroupUser).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &UserGroupUser{config: uguq.config}
		nodes = append(nodes, node)
		node.Edges.loadedTypes = loadedTypes
		return node.assignValues(columns, values)
	}
	if len(uguq.modifiers) > 0 {
		_spec.Modifiers = uguq.modifiers
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, uguq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	if query := uguq.withUserGroup; query != nil {
		if err := uguq.loadUserGroup(ctx, query, nodes, nil,
			func(n *UserGroupUser, e *UserGroup) { n.Edges.UserGroup = e }); err != nil {
			return nil, err
		}
	}
	if query := uguq.withUser; query != nil {
		if err := uguq.loadUser(ctx, query, nodes, nil,
			func(n *UserGroupUser, e *User) { n.Edges.User = e }); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

func (uguq *UserGroupUserQuery) loadUserGroup(ctx context.Context, query *UserGroupQuery, nodes []*UserGroupUser, init func(*UserGroupUser), assign func(*UserGroupUser, *UserGroup)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*UserGroupUser)
	for i := range nodes {
		fk := nodes[i].UserGroupID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(usergroup.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "user_group_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}
func (uguq *UserGroupUserQuery) loadUser(ctx context.Context, query *UserQuery, nodes []*UserGroupUser, init func(*UserGroupUser), assign func(*UserGroupUser, *User)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*UserGroupUser)
	for i := range nodes {
		fk := nodes[i].UserID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(user.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "user_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}

func (uguq *UserGroupUserQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := uguq.querySpec()
	if len(uguq.modifiers) > 0 {
		_spec.Modifiers = uguq.modifiers
	}
	_spec.Node.Columns = uguq.ctx.Fields
	if len(uguq.ctx.Fields) > 0 {
		_spec.Unique = uguq.ctx.Unique != nil && *uguq.ctx.Unique
	}
	return sqlgraph.CountNodes(ctx, uguq.driver, _spec)
}

func (uguq *UserGroupUserQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := sqlgraph.NewQuerySpec(usergroupuser.Table, usergroupuser.Columns, sqlgraph.NewFieldSpec(usergroupuser.FieldID, field.TypeUUID))
	_spec.From = uguq.sql
	if unique := uguq.ctx.Unique; unique != nil {
		_spec.Unique = *unique
	} else if uguq.path != nil {
		_spec.Unique = true
	}
	if fields := uguq.ctx.Fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, usergroupuser.FieldID)
		for i := range fields {
			if fields[i] != usergroupuser.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
		if uguq.withUserGroup != nil {
			_spec.Node.AddColumnOnce(usergroupuser.FieldUserGroupID)
		}
		if uguq.withUser != nil {
			_spec.Node.AddColumnOnce(usergroupuser.FieldUserID)
		}
	}
	if ps := uguq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := uguq.ctx.Limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := uguq.ctx.Offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := uguq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (uguq *UserGroupUserQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(uguq.driver.Dialect())
	t1 := builder.Table(usergroupuser.Table)
	columns := uguq.ctx.Fields
	if len(columns) == 0 {
		columns = usergroupuser.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if uguq.sql != nil {
		selector = uguq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if uguq.ctx.Unique != nil && *uguq.ctx.Unique {
		selector.Distinct()
	}
	for _, m := range uguq.modifiers {
		m(selector)
	}
	for _, p := range uguq.predicates {
		p(selector)
	}
	for _, p := range uguq.order {
		p(selector)
	}
	if offset := uguq.ctx.Offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := uguq.ctx.Limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// ForUpdate locks the selected rows against concurrent updates, and prevent them from being
// updated, deleted or "selected ... for update" by other sessions, until the transaction is
// either committed or rolled-back.
func (uguq *UserGroupUserQuery) ForUpdate(opts ...sql.LockOption) *UserGroupUserQuery {
	if uguq.driver.Dialect() == dialect.Postgres {
		uguq.Unique(false)
	}
	uguq.modifiers = append(uguq.modifiers, func(s *sql.Selector) {
		s.ForUpdate(opts...)
	})
	return uguq
}

// ForShare behaves similarly to ForUpdate, except that it acquires a shared mode lock
// on any rows that are read. Other sessions can read the rows, but cannot modify them
// until your transaction commits.
func (uguq *UserGroupUserQuery) ForShare(opts ...sql.LockOption) *UserGroupUserQuery {
	if uguq.driver.Dialect() == dialect.Postgres {
		uguq.Unique(false)
	}
	uguq.modifiers = append(uguq.modifiers, func(s *sql.Selector) {
		s.ForShare(opts...)
	})
	return uguq
}

// Modify adds a query modifier for attaching custom logic to queries.
func (uguq *UserGroupUserQuery) Modify(modifiers ...func(s *sql.Selector)) *UserGroupUserSelect {
	uguq.modifiers = append(uguq.modifiers, modifiers...)
	return uguq.Select()
}

// UserGroupUserGroupBy is the group-by builder for UserGroupUser entities.
type UserGroupUserGroupBy struct {
	selector
	build *UserGroupUserQuery
}

// Aggregate adds the given aggregation functions to the group-by query.
func (ugugb *UserGroupUserGroupBy) Aggregate(fns ...AggregateFunc) *UserGroupUserGroupBy {
	ugugb.fns = append(ugugb.fns, fns...)
	return ugugb
}

// Scan applies the selector query and scans the result into the given value.
func (ugugb *UserGroupUserGroupBy) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, ugugb.build.ctx, ent.OpQueryGroupBy)
	if err := ugugb.build.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*UserGroupUserQuery, *UserGroupUserGroupBy](ctx, ugugb.build, ugugb, ugugb.build.inters, v)
}

func (ugugb *UserGroupUserGroupBy) sqlScan(ctx context.Context, root *UserGroupUserQuery, v any) error {
	selector := root.sqlQuery(ctx).Select()
	aggregation := make([]string, 0, len(ugugb.fns))
	for _, fn := range ugugb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(*ugugb.flds)+len(ugugb.fns))
		for _, f := range *ugugb.flds {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	selector.GroupBy(selector.Columns(*ugugb.flds...)...)
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := ugugb.build.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// UserGroupUserSelect is the builder for selecting fields of UserGroupUser entities.
type UserGroupUserSelect struct {
	*UserGroupUserQuery
	selector
}

// Aggregate adds the given aggregation functions to the selector query.
func (ugus *UserGroupUserSelect) Aggregate(fns ...AggregateFunc) *UserGroupUserSelect {
	ugus.fns = append(ugus.fns, fns...)
	return ugus
}

// Scan applies the selector query and scans the result into the given value.
func (ugus *UserGroupUserSelect) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, ugus.ctx, ent.OpQuerySelect)
	if err := ugus.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*UserGroupUserQuery, *UserGroupUserSelect](ctx, ugus.UserGroupUserQuery, ugus, ugus.inters, v)
}

func (ugus *UserGroupUserSelect) sqlScan(ctx context.Context, root *UserGroupUserQuery, v any) error {
	selector := root.sqlQuery(ctx)
	aggregation := make([]string, 0, len(ugus.fns))
	for _, fn := range ugus.fns {
		aggregation = append(aggregation, fn(selector))
	}
	switch n := len(*ugus.selector.flds); {
	case n == 0 && len(aggregation) > 0:
		selector.Select(aggregation...)
	case n != 0 && len(aggregation) > 0:
		selector.AppendSelect(aggregation...)
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := ugus.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// Modify adds a query modifier for attaching custom logic to queries.
func (ugus *UserGroupUserSelect) Modify(modifiers ...func(s *sql.Selector)) *UserGroupUserSelect {
	ugus.modifiers = append(ugus.modifiers, modifiers...)
	return ugus
}
