// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/useridentity"
	"github.com/google/uuid"
)

// UserIdentity is the model entity for the UserIdentity schema.
type UserIdentity struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// DeletedAt holds the value of the "deleted_at" field.
	DeletedAt time.Time `json:"deleted_at,omitempty"`
	// UserID holds the value of the "user_id" field.
	UserID uuid.UUID `json:"user_id,omitempty"`
	// Platform holds the value of the "platform" field.
	Platform consts.UserPlatform `json:"platform,omitempty"`
	// IdentityID holds the value of the "identity_id" field.
	IdentityID string `json:"identity_id,omitempty"`
	// UnionID holds the value of the "union_id" field.
	UnionID string `json:"union_id,omitempty"`
	// Nickname holds the value of the "nickname" field.
	Nickname string `json:"nickname,omitempty"`
	// Email holds the value of the "email" field.
	Email string `json:"email,omitempty"`
	// AvatarURL holds the value of the "avatar_url" field.
	AvatarURL string `json:"avatar_url,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the UserIdentityQuery when eager-loading is set.
	Edges        UserIdentityEdges `json:"edges"`
	selectValues sql.SelectValues
}

// UserIdentityEdges holds the relations/edges for other nodes in the graph.
type UserIdentityEdges struct {
	// User holds the value of the user edge.
	User *User `json:"user,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [1]bool
}

// UserOrErr returns the User value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e UserIdentityEdges) UserOrErr() (*User, error) {
	if e.User != nil {
		return e.User, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: user.Label}
	}
	return nil, &NotLoadedError{edge: "user"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*UserIdentity) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case useridentity.FieldPlatform, useridentity.FieldIdentityID, useridentity.FieldUnionID, useridentity.FieldNickname, useridentity.FieldEmail, useridentity.FieldAvatarURL:
			values[i] = new(sql.NullString)
		case useridentity.FieldDeletedAt, useridentity.FieldCreatedAt:
			values[i] = new(sql.NullTime)
		case useridentity.FieldID, useridentity.FieldUserID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the UserIdentity fields.
func (ui *UserIdentity) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case useridentity.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				ui.ID = *value
			}
		case useridentity.FieldDeletedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field deleted_at", values[i])
			} else if value.Valid {
				ui.DeletedAt = value.Time
			}
		case useridentity.FieldUserID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field user_id", values[i])
			} else if value != nil {
				ui.UserID = *value
			}
		case useridentity.FieldPlatform:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field platform", values[i])
			} else if value.Valid {
				ui.Platform = consts.UserPlatform(value.String)
			}
		case useridentity.FieldIdentityID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field identity_id", values[i])
			} else if value.Valid {
				ui.IdentityID = value.String
			}
		case useridentity.FieldUnionID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field union_id", values[i])
			} else if value.Valid {
				ui.UnionID = value.String
			}
		case useridentity.FieldNickname:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field nickname", values[i])
			} else if value.Valid {
				ui.Nickname = value.String
			}
		case useridentity.FieldEmail:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field email", values[i])
			} else if value.Valid {
				ui.Email = value.String
			}
		case useridentity.FieldAvatarURL:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field avatar_url", values[i])
			} else if value.Valid {
				ui.AvatarURL = value.String
			}
		case useridentity.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				ui.CreatedAt = value.Time
			}
		default:
			ui.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the UserIdentity.
// This includes values selected through modifiers, order, etc.
func (ui *UserIdentity) Value(name string) (ent.Value, error) {
	return ui.selectValues.Get(name)
}

// QueryUser queries the "user" edge of the UserIdentity entity.
func (ui *UserIdentity) QueryUser() *UserQuery {
	return NewUserIdentityClient(ui.config).QueryUser(ui)
}

// Update returns a builder for updating this UserIdentity.
// Note that you need to call UserIdentity.Unwrap() before calling this method if this UserIdentity
// was returned from a transaction, and the transaction was committed or rolled back.
func (ui *UserIdentity) Update() *UserIdentityUpdateOne {
	return NewUserIdentityClient(ui.config).UpdateOne(ui)
}

// Unwrap unwraps the UserIdentity entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (ui *UserIdentity) Unwrap() *UserIdentity {
	_tx, ok := ui.config.driver.(*txDriver)
	if !ok {
		panic("db: UserIdentity is not a transactional entity")
	}
	ui.config.driver = _tx.drv
	return ui
}

// String implements the fmt.Stringer.
func (ui *UserIdentity) String() string {
	var builder strings.Builder
	builder.WriteString("UserIdentity(")
	builder.WriteString(fmt.Sprintf("id=%v, ", ui.ID))
	builder.WriteString("deleted_at=")
	builder.WriteString(ui.DeletedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("user_id=")
	builder.WriteString(fmt.Sprintf("%v", ui.UserID))
	builder.WriteString(", ")
	builder.WriteString("platform=")
	builder.WriteString(fmt.Sprintf("%v", ui.Platform))
	builder.WriteString(", ")
	builder.WriteString("identity_id=")
	builder.WriteString(ui.IdentityID)
	builder.WriteString(", ")
	builder.WriteString("union_id=")
	builder.WriteString(ui.UnionID)
	builder.WriteString(", ")
	builder.WriteString("nickname=")
	builder.WriteString(ui.Nickname)
	builder.WriteString(", ")
	builder.WriteString("email=")
	builder.WriteString(ui.Email)
	builder.WriteString(", ")
	builder.WriteString("avatar_url=")
	builder.WriteString(ui.AvatarURL)
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(ui.CreatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// UserIdentities is a parsable slice of UserIdentity.
type UserIdentities []*UserIdentity
