// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/useridentity"
	"github.com/google/uuid"
)

// UserIdentityUpdate is the builder for updating UserIdentity entities.
type UserIdentityUpdate struct {
	config
	hooks     []Hook
	mutation  *UserIdentityMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the UserIdentityUpdate builder.
func (uiu *UserIdentityUpdate) Where(ps ...predicate.UserIdentity) *UserIdentityUpdate {
	uiu.mutation.Where(ps...)
	return uiu
}

// SetDeletedAt sets the "deleted_at" field.
func (uiu *UserIdentityUpdate) SetDeletedAt(t time.Time) *UserIdentityUpdate {
	uiu.mutation.SetDeletedAt(t)
	return uiu
}

// SetNillableDeletedAt sets the "deleted_at" field if the given value is not nil.
func (uiu *UserIdentityUpdate) SetNillableDeletedAt(t *time.Time) *UserIdentityUpdate {
	if t != nil {
		uiu.SetDeletedAt(*t)
	}
	return uiu
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (uiu *UserIdentityUpdate) ClearDeletedAt() *UserIdentityUpdate {
	uiu.mutation.ClearDeletedAt()
	return uiu
}

// SetUserID sets the "user_id" field.
func (uiu *UserIdentityUpdate) SetUserID(u uuid.UUID) *UserIdentityUpdate {
	uiu.mutation.SetUserID(u)
	return uiu
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (uiu *UserIdentityUpdate) SetNillableUserID(u *uuid.UUID) *UserIdentityUpdate {
	if u != nil {
		uiu.SetUserID(*u)
	}
	return uiu
}

// ClearUserID clears the value of the "user_id" field.
func (uiu *UserIdentityUpdate) ClearUserID() *UserIdentityUpdate {
	uiu.mutation.ClearUserID()
	return uiu
}

// SetPlatform sets the "platform" field.
func (uiu *UserIdentityUpdate) SetPlatform(cp consts.UserPlatform) *UserIdentityUpdate {
	uiu.mutation.SetPlatform(cp)
	return uiu
}

// SetNillablePlatform sets the "platform" field if the given value is not nil.
func (uiu *UserIdentityUpdate) SetNillablePlatform(cp *consts.UserPlatform) *UserIdentityUpdate {
	if cp != nil {
		uiu.SetPlatform(*cp)
	}
	return uiu
}

// SetIdentityID sets the "identity_id" field.
func (uiu *UserIdentityUpdate) SetIdentityID(s string) *UserIdentityUpdate {
	uiu.mutation.SetIdentityID(s)
	return uiu
}

// SetNillableIdentityID sets the "identity_id" field if the given value is not nil.
func (uiu *UserIdentityUpdate) SetNillableIdentityID(s *string) *UserIdentityUpdate {
	if s != nil {
		uiu.SetIdentityID(*s)
	}
	return uiu
}

// SetUnionID sets the "union_id" field.
func (uiu *UserIdentityUpdate) SetUnionID(s string) *UserIdentityUpdate {
	uiu.mutation.SetUnionID(s)
	return uiu
}

// SetNillableUnionID sets the "union_id" field if the given value is not nil.
func (uiu *UserIdentityUpdate) SetNillableUnionID(s *string) *UserIdentityUpdate {
	if s != nil {
		uiu.SetUnionID(*s)
	}
	return uiu
}

// ClearUnionID clears the value of the "union_id" field.
func (uiu *UserIdentityUpdate) ClearUnionID() *UserIdentityUpdate {
	uiu.mutation.ClearUnionID()
	return uiu
}

// SetNickname sets the "nickname" field.
func (uiu *UserIdentityUpdate) SetNickname(s string) *UserIdentityUpdate {
	uiu.mutation.SetNickname(s)
	return uiu
}

// SetNillableNickname sets the "nickname" field if the given value is not nil.
func (uiu *UserIdentityUpdate) SetNillableNickname(s *string) *UserIdentityUpdate {
	if s != nil {
		uiu.SetNickname(*s)
	}
	return uiu
}

// ClearNickname clears the value of the "nickname" field.
func (uiu *UserIdentityUpdate) ClearNickname() *UserIdentityUpdate {
	uiu.mutation.ClearNickname()
	return uiu
}

// SetEmail sets the "email" field.
func (uiu *UserIdentityUpdate) SetEmail(s string) *UserIdentityUpdate {
	uiu.mutation.SetEmail(s)
	return uiu
}

// SetNillableEmail sets the "email" field if the given value is not nil.
func (uiu *UserIdentityUpdate) SetNillableEmail(s *string) *UserIdentityUpdate {
	if s != nil {
		uiu.SetEmail(*s)
	}
	return uiu
}

// ClearEmail clears the value of the "email" field.
func (uiu *UserIdentityUpdate) ClearEmail() *UserIdentityUpdate {
	uiu.mutation.ClearEmail()
	return uiu
}

// SetAvatarURL sets the "avatar_url" field.
func (uiu *UserIdentityUpdate) SetAvatarURL(s string) *UserIdentityUpdate {
	uiu.mutation.SetAvatarURL(s)
	return uiu
}

// SetNillableAvatarURL sets the "avatar_url" field if the given value is not nil.
func (uiu *UserIdentityUpdate) SetNillableAvatarURL(s *string) *UserIdentityUpdate {
	if s != nil {
		uiu.SetAvatarURL(*s)
	}
	return uiu
}

// ClearAvatarURL clears the value of the "avatar_url" field.
func (uiu *UserIdentityUpdate) ClearAvatarURL() *UserIdentityUpdate {
	uiu.mutation.ClearAvatarURL()
	return uiu
}

// SetCreatedAt sets the "created_at" field.
func (uiu *UserIdentityUpdate) SetCreatedAt(t time.Time) *UserIdentityUpdate {
	uiu.mutation.SetCreatedAt(t)
	return uiu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (uiu *UserIdentityUpdate) SetNillableCreatedAt(t *time.Time) *UserIdentityUpdate {
	if t != nil {
		uiu.SetCreatedAt(*t)
	}
	return uiu
}

// SetUser sets the "user" edge to the User entity.
func (uiu *UserIdentityUpdate) SetUser(u *User) *UserIdentityUpdate {
	return uiu.SetUserID(u.ID)
}

// Mutation returns the UserIdentityMutation object of the builder.
func (uiu *UserIdentityUpdate) Mutation() *UserIdentityMutation {
	return uiu.mutation
}

// ClearUser clears the "user" edge to the User entity.
func (uiu *UserIdentityUpdate) ClearUser() *UserIdentityUpdate {
	uiu.mutation.ClearUser()
	return uiu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (uiu *UserIdentityUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, uiu.sqlSave, uiu.mutation, uiu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (uiu *UserIdentityUpdate) SaveX(ctx context.Context) int {
	affected, err := uiu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (uiu *UserIdentityUpdate) Exec(ctx context.Context) error {
	_, err := uiu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uiu *UserIdentityUpdate) ExecX(ctx context.Context) {
	if err := uiu.Exec(ctx); err != nil {
		panic(err)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (uiu *UserIdentityUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *UserIdentityUpdate {
	uiu.modifiers = append(uiu.modifiers, modifiers...)
	return uiu
}

func (uiu *UserIdentityUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(useridentity.Table, useridentity.Columns, sqlgraph.NewFieldSpec(useridentity.FieldID, field.TypeUUID))
	if ps := uiu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := uiu.mutation.DeletedAt(); ok {
		_spec.SetField(useridentity.FieldDeletedAt, field.TypeTime, value)
	}
	if uiu.mutation.DeletedAtCleared() {
		_spec.ClearField(useridentity.FieldDeletedAt, field.TypeTime)
	}
	if value, ok := uiu.mutation.Platform(); ok {
		_spec.SetField(useridentity.FieldPlatform, field.TypeString, value)
	}
	if value, ok := uiu.mutation.IdentityID(); ok {
		_spec.SetField(useridentity.FieldIdentityID, field.TypeString, value)
	}
	if value, ok := uiu.mutation.UnionID(); ok {
		_spec.SetField(useridentity.FieldUnionID, field.TypeString, value)
	}
	if uiu.mutation.UnionIDCleared() {
		_spec.ClearField(useridentity.FieldUnionID, field.TypeString)
	}
	if value, ok := uiu.mutation.Nickname(); ok {
		_spec.SetField(useridentity.FieldNickname, field.TypeString, value)
	}
	if uiu.mutation.NicknameCleared() {
		_spec.ClearField(useridentity.FieldNickname, field.TypeString)
	}
	if value, ok := uiu.mutation.Email(); ok {
		_spec.SetField(useridentity.FieldEmail, field.TypeString, value)
	}
	if uiu.mutation.EmailCleared() {
		_spec.ClearField(useridentity.FieldEmail, field.TypeString)
	}
	if value, ok := uiu.mutation.AvatarURL(); ok {
		_spec.SetField(useridentity.FieldAvatarURL, field.TypeString, value)
	}
	if uiu.mutation.AvatarURLCleared() {
		_spec.ClearField(useridentity.FieldAvatarURL, field.TypeString)
	}
	if value, ok := uiu.mutation.CreatedAt(); ok {
		_spec.SetField(useridentity.FieldCreatedAt, field.TypeTime, value)
	}
	if uiu.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   useridentity.UserTable,
			Columns: []string{useridentity.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uiu.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   useridentity.UserTable,
			Columns: []string{useridentity.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(uiu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, uiu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{useridentity.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	uiu.mutation.done = true
	return n, nil
}

// UserIdentityUpdateOne is the builder for updating a single UserIdentity entity.
type UserIdentityUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *UserIdentityMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetDeletedAt sets the "deleted_at" field.
func (uiuo *UserIdentityUpdateOne) SetDeletedAt(t time.Time) *UserIdentityUpdateOne {
	uiuo.mutation.SetDeletedAt(t)
	return uiuo
}

// SetNillableDeletedAt sets the "deleted_at" field if the given value is not nil.
func (uiuo *UserIdentityUpdateOne) SetNillableDeletedAt(t *time.Time) *UserIdentityUpdateOne {
	if t != nil {
		uiuo.SetDeletedAt(*t)
	}
	return uiuo
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (uiuo *UserIdentityUpdateOne) ClearDeletedAt() *UserIdentityUpdateOne {
	uiuo.mutation.ClearDeletedAt()
	return uiuo
}

// SetUserID sets the "user_id" field.
func (uiuo *UserIdentityUpdateOne) SetUserID(u uuid.UUID) *UserIdentityUpdateOne {
	uiuo.mutation.SetUserID(u)
	return uiuo
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (uiuo *UserIdentityUpdateOne) SetNillableUserID(u *uuid.UUID) *UserIdentityUpdateOne {
	if u != nil {
		uiuo.SetUserID(*u)
	}
	return uiuo
}

// ClearUserID clears the value of the "user_id" field.
func (uiuo *UserIdentityUpdateOne) ClearUserID() *UserIdentityUpdateOne {
	uiuo.mutation.ClearUserID()
	return uiuo
}

// SetPlatform sets the "platform" field.
func (uiuo *UserIdentityUpdateOne) SetPlatform(cp consts.UserPlatform) *UserIdentityUpdateOne {
	uiuo.mutation.SetPlatform(cp)
	return uiuo
}

// SetNillablePlatform sets the "platform" field if the given value is not nil.
func (uiuo *UserIdentityUpdateOne) SetNillablePlatform(cp *consts.UserPlatform) *UserIdentityUpdateOne {
	if cp != nil {
		uiuo.SetPlatform(*cp)
	}
	return uiuo
}

// SetIdentityID sets the "identity_id" field.
func (uiuo *UserIdentityUpdateOne) SetIdentityID(s string) *UserIdentityUpdateOne {
	uiuo.mutation.SetIdentityID(s)
	return uiuo
}

// SetNillableIdentityID sets the "identity_id" field if the given value is not nil.
func (uiuo *UserIdentityUpdateOne) SetNillableIdentityID(s *string) *UserIdentityUpdateOne {
	if s != nil {
		uiuo.SetIdentityID(*s)
	}
	return uiuo
}

// SetUnionID sets the "union_id" field.
func (uiuo *UserIdentityUpdateOne) SetUnionID(s string) *UserIdentityUpdateOne {
	uiuo.mutation.SetUnionID(s)
	return uiuo
}

// SetNillableUnionID sets the "union_id" field if the given value is not nil.
func (uiuo *UserIdentityUpdateOne) SetNillableUnionID(s *string) *UserIdentityUpdateOne {
	if s != nil {
		uiuo.SetUnionID(*s)
	}
	return uiuo
}

// ClearUnionID clears the value of the "union_id" field.
func (uiuo *UserIdentityUpdateOne) ClearUnionID() *UserIdentityUpdateOne {
	uiuo.mutation.ClearUnionID()
	return uiuo
}

// SetNickname sets the "nickname" field.
func (uiuo *UserIdentityUpdateOne) SetNickname(s string) *UserIdentityUpdateOne {
	uiuo.mutation.SetNickname(s)
	return uiuo
}

// SetNillableNickname sets the "nickname" field if the given value is not nil.
func (uiuo *UserIdentityUpdateOne) SetNillableNickname(s *string) *UserIdentityUpdateOne {
	if s != nil {
		uiuo.SetNickname(*s)
	}
	return uiuo
}

// ClearNickname clears the value of the "nickname" field.
func (uiuo *UserIdentityUpdateOne) ClearNickname() *UserIdentityUpdateOne {
	uiuo.mutation.ClearNickname()
	return uiuo
}

// SetEmail sets the "email" field.
func (uiuo *UserIdentityUpdateOne) SetEmail(s string) *UserIdentityUpdateOne {
	uiuo.mutation.SetEmail(s)
	return uiuo
}

// SetNillableEmail sets the "email" field if the given value is not nil.
func (uiuo *UserIdentityUpdateOne) SetNillableEmail(s *string) *UserIdentityUpdateOne {
	if s != nil {
		uiuo.SetEmail(*s)
	}
	return uiuo
}

// ClearEmail clears the value of the "email" field.
func (uiuo *UserIdentityUpdateOne) ClearEmail() *UserIdentityUpdateOne {
	uiuo.mutation.ClearEmail()
	return uiuo
}

// SetAvatarURL sets the "avatar_url" field.
func (uiuo *UserIdentityUpdateOne) SetAvatarURL(s string) *UserIdentityUpdateOne {
	uiuo.mutation.SetAvatarURL(s)
	return uiuo
}

// SetNillableAvatarURL sets the "avatar_url" field if the given value is not nil.
func (uiuo *UserIdentityUpdateOne) SetNillableAvatarURL(s *string) *UserIdentityUpdateOne {
	if s != nil {
		uiuo.SetAvatarURL(*s)
	}
	return uiuo
}

// ClearAvatarURL clears the value of the "avatar_url" field.
func (uiuo *UserIdentityUpdateOne) ClearAvatarURL() *UserIdentityUpdateOne {
	uiuo.mutation.ClearAvatarURL()
	return uiuo
}

// SetCreatedAt sets the "created_at" field.
func (uiuo *UserIdentityUpdateOne) SetCreatedAt(t time.Time) *UserIdentityUpdateOne {
	uiuo.mutation.SetCreatedAt(t)
	return uiuo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (uiuo *UserIdentityUpdateOne) SetNillableCreatedAt(t *time.Time) *UserIdentityUpdateOne {
	if t != nil {
		uiuo.SetCreatedAt(*t)
	}
	return uiuo
}

// SetUser sets the "user" edge to the User entity.
func (uiuo *UserIdentityUpdateOne) SetUser(u *User) *UserIdentityUpdateOne {
	return uiuo.SetUserID(u.ID)
}

// Mutation returns the UserIdentityMutation object of the builder.
func (uiuo *UserIdentityUpdateOne) Mutation() *UserIdentityMutation {
	return uiuo.mutation
}

// ClearUser clears the "user" edge to the User entity.
func (uiuo *UserIdentityUpdateOne) ClearUser() *UserIdentityUpdateOne {
	uiuo.mutation.ClearUser()
	return uiuo
}

// Where appends a list predicates to the UserIdentityUpdate builder.
func (uiuo *UserIdentityUpdateOne) Where(ps ...predicate.UserIdentity) *UserIdentityUpdateOne {
	uiuo.mutation.Where(ps...)
	return uiuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (uiuo *UserIdentityUpdateOne) Select(field string, fields ...string) *UserIdentityUpdateOne {
	uiuo.fields = append([]string{field}, fields...)
	return uiuo
}

// Save executes the query and returns the updated UserIdentity entity.
func (uiuo *UserIdentityUpdateOne) Save(ctx context.Context) (*UserIdentity, error) {
	return withHooks(ctx, uiuo.sqlSave, uiuo.mutation, uiuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (uiuo *UserIdentityUpdateOne) SaveX(ctx context.Context) *UserIdentity {
	node, err := uiuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (uiuo *UserIdentityUpdateOne) Exec(ctx context.Context) error {
	_, err := uiuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uiuo *UserIdentityUpdateOne) ExecX(ctx context.Context) {
	if err := uiuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (uiuo *UserIdentityUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *UserIdentityUpdateOne {
	uiuo.modifiers = append(uiuo.modifiers, modifiers...)
	return uiuo
}

func (uiuo *UserIdentityUpdateOne) sqlSave(ctx context.Context) (_node *UserIdentity, err error) {
	_spec := sqlgraph.NewUpdateSpec(useridentity.Table, useridentity.Columns, sqlgraph.NewFieldSpec(useridentity.FieldID, field.TypeUUID))
	id, ok := uiuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "UserIdentity.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := uiuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, useridentity.FieldID)
		for _, f := range fields {
			if !useridentity.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != useridentity.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := uiuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := uiuo.mutation.DeletedAt(); ok {
		_spec.SetField(useridentity.FieldDeletedAt, field.TypeTime, value)
	}
	if uiuo.mutation.DeletedAtCleared() {
		_spec.ClearField(useridentity.FieldDeletedAt, field.TypeTime)
	}
	if value, ok := uiuo.mutation.Platform(); ok {
		_spec.SetField(useridentity.FieldPlatform, field.TypeString, value)
	}
	if value, ok := uiuo.mutation.IdentityID(); ok {
		_spec.SetField(useridentity.FieldIdentityID, field.TypeString, value)
	}
	if value, ok := uiuo.mutation.UnionID(); ok {
		_spec.SetField(useridentity.FieldUnionID, field.TypeString, value)
	}
	if uiuo.mutation.UnionIDCleared() {
		_spec.ClearField(useridentity.FieldUnionID, field.TypeString)
	}
	if value, ok := uiuo.mutation.Nickname(); ok {
		_spec.SetField(useridentity.FieldNickname, field.TypeString, value)
	}
	if uiuo.mutation.NicknameCleared() {
		_spec.ClearField(useridentity.FieldNickname, field.TypeString)
	}
	if value, ok := uiuo.mutation.Email(); ok {
		_spec.SetField(useridentity.FieldEmail, field.TypeString, value)
	}
	if uiuo.mutation.EmailCleared() {
		_spec.ClearField(useridentity.FieldEmail, field.TypeString)
	}
	if value, ok := uiuo.mutation.AvatarURL(); ok {
		_spec.SetField(useridentity.FieldAvatarURL, field.TypeString, value)
	}
	if uiuo.mutation.AvatarURLCleared() {
		_spec.ClearField(useridentity.FieldAvatarURL, field.TypeString)
	}
	if value, ok := uiuo.mutation.CreatedAt(); ok {
		_spec.SetField(useridentity.FieldCreatedAt, field.TypeTime, value)
	}
	if uiuo.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   useridentity.UserTable,
			Columns: []string{useridentity.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uiuo.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   useridentity.UserTable,
			Columns: []string{useridentity.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(uiuo.modifiers...)
	_node = &UserIdentity{config: uiuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, uiuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{useridentity.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	uiuo.mutation.done = true
	return _node, nil
}
