// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/userloginhistory"
	"github.com/google/uuid"
)

// UserLoginHistory is the model entity for the UserLoginHistory schema.
type UserLoginHistory struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// UserID holds the value of the "user_id" field.
	UserID uuid.UUID `json:"user_id,omitempty"`
	// IP holds the value of the "ip" field.
	IP string `json:"ip,omitempty"`
	// Country holds the value of the "country" field.
	Country string `json:"country,omitempty"`
	// Province holds the value of the "province" field.
	Province string `json:"province,omitempty"`
	// City holds the value of the "city" field.
	City string `json:"city,omitempty"`
	// Isp holds the value of the "isp" field.
	Isp string `json:"isp,omitempty"`
	// Asn holds the value of the "asn" field.
	Asn string `json:"asn,omitempty"`
	// ClientVersion holds the value of the "client_version" field.
	ClientVersion string `json:"client_version,omitempty"`
	// OsType holds the value of the "os_type" field.
	OsType consts.OSType `json:"os_type,omitempty"`
	// OsRelease holds the value of the "os_release" field.
	OsRelease consts.OSRelease `json:"os_release,omitempty"`
	// Hostname holds the value of the "hostname" field.
	Hostname string `json:"hostname,omitempty"`
	// ClientID holds the value of the "client_id" field.
	ClientID string `json:"client_id,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the UserLoginHistoryQuery when eager-loading is set.
	Edges        UserLoginHistoryEdges `json:"edges"`
	selectValues sql.SelectValues
}

// UserLoginHistoryEdges holds the relations/edges for other nodes in the graph.
type UserLoginHistoryEdges struct {
	// Owner holds the value of the owner edge.
	Owner *User `json:"owner,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [1]bool
}

// OwnerOrErr returns the Owner value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e UserLoginHistoryEdges) OwnerOrErr() (*User, error) {
	if e.Owner != nil {
		return e.Owner, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: user.Label}
	}
	return nil, &NotLoadedError{edge: "owner"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*UserLoginHistory) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case userloginhistory.FieldIP, userloginhistory.FieldCountry, userloginhistory.FieldProvince, userloginhistory.FieldCity, userloginhistory.FieldIsp, userloginhistory.FieldAsn, userloginhistory.FieldClientVersion, userloginhistory.FieldOsType, userloginhistory.FieldOsRelease, userloginhistory.FieldHostname, userloginhistory.FieldClientID:
			values[i] = new(sql.NullString)
		case userloginhistory.FieldCreatedAt:
			values[i] = new(sql.NullTime)
		case userloginhistory.FieldID, userloginhistory.FieldUserID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the UserLoginHistory fields.
func (ulh *UserLoginHistory) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case userloginhistory.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				ulh.ID = *value
			}
		case userloginhistory.FieldUserID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field user_id", values[i])
			} else if value != nil {
				ulh.UserID = *value
			}
		case userloginhistory.FieldIP:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field ip", values[i])
			} else if value.Valid {
				ulh.IP = value.String
			}
		case userloginhistory.FieldCountry:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field country", values[i])
			} else if value.Valid {
				ulh.Country = value.String
			}
		case userloginhistory.FieldProvince:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field province", values[i])
			} else if value.Valid {
				ulh.Province = value.String
			}
		case userloginhistory.FieldCity:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field city", values[i])
			} else if value.Valid {
				ulh.City = value.String
			}
		case userloginhistory.FieldIsp:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field isp", values[i])
			} else if value.Valid {
				ulh.Isp = value.String
			}
		case userloginhistory.FieldAsn:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field asn", values[i])
			} else if value.Valid {
				ulh.Asn = value.String
			}
		case userloginhistory.FieldClientVersion:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field client_version", values[i])
			} else if value.Valid {
				ulh.ClientVersion = value.String
			}
		case userloginhistory.FieldOsType:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field os_type", values[i])
			} else if value.Valid {
				ulh.OsType = consts.OSType(value.String)
			}
		case userloginhistory.FieldOsRelease:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field os_release", values[i])
			} else if value.Valid {
				ulh.OsRelease = consts.OSRelease(value.String)
			}
		case userloginhistory.FieldHostname:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field hostname", values[i])
			} else if value.Valid {
				ulh.Hostname = value.String
			}
		case userloginhistory.FieldClientID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field client_id", values[i])
			} else if value.Valid {
				ulh.ClientID = value.String
			}
		case userloginhistory.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				ulh.CreatedAt = value.Time
			}
		default:
			ulh.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the UserLoginHistory.
// This includes values selected through modifiers, order, etc.
func (ulh *UserLoginHistory) Value(name string) (ent.Value, error) {
	return ulh.selectValues.Get(name)
}

// QueryOwner queries the "owner" edge of the UserLoginHistory entity.
func (ulh *UserLoginHistory) QueryOwner() *UserQuery {
	return NewUserLoginHistoryClient(ulh.config).QueryOwner(ulh)
}

// Update returns a builder for updating this UserLoginHistory.
// Note that you need to call UserLoginHistory.Unwrap() before calling this method if this UserLoginHistory
// was returned from a transaction, and the transaction was committed or rolled back.
func (ulh *UserLoginHistory) Update() *UserLoginHistoryUpdateOne {
	return NewUserLoginHistoryClient(ulh.config).UpdateOne(ulh)
}

// Unwrap unwraps the UserLoginHistory entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (ulh *UserLoginHistory) Unwrap() *UserLoginHistory {
	_tx, ok := ulh.config.driver.(*txDriver)
	if !ok {
		panic("db: UserLoginHistory is not a transactional entity")
	}
	ulh.config.driver = _tx.drv
	return ulh
}

// String implements the fmt.Stringer.
func (ulh *UserLoginHistory) String() string {
	var builder strings.Builder
	builder.WriteString("UserLoginHistory(")
	builder.WriteString(fmt.Sprintf("id=%v, ", ulh.ID))
	builder.WriteString("user_id=")
	builder.WriteString(fmt.Sprintf("%v", ulh.UserID))
	builder.WriteString(", ")
	builder.WriteString("ip=")
	builder.WriteString(ulh.IP)
	builder.WriteString(", ")
	builder.WriteString("country=")
	builder.WriteString(ulh.Country)
	builder.WriteString(", ")
	builder.WriteString("province=")
	builder.WriteString(ulh.Province)
	builder.WriteString(", ")
	builder.WriteString("city=")
	builder.WriteString(ulh.City)
	builder.WriteString(", ")
	builder.WriteString("isp=")
	builder.WriteString(ulh.Isp)
	builder.WriteString(", ")
	builder.WriteString("asn=")
	builder.WriteString(ulh.Asn)
	builder.WriteString(", ")
	builder.WriteString("client_version=")
	builder.WriteString(ulh.ClientVersion)
	builder.WriteString(", ")
	builder.WriteString("os_type=")
	builder.WriteString(fmt.Sprintf("%v", ulh.OsType))
	builder.WriteString(", ")
	builder.WriteString("os_release=")
	builder.WriteString(fmt.Sprintf("%v", ulh.OsRelease))
	builder.WriteString(", ")
	builder.WriteString("hostname=")
	builder.WriteString(ulh.Hostname)
	builder.WriteString(", ")
	builder.WriteString("client_id=")
	builder.WriteString(ulh.ClientID)
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(ulh.CreatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// UserLoginHistories is a parsable slice of UserLoginHistory.
type UserLoginHistories []*UserLoginHistory
