// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/userloginhistory"
)

// UserLoginHistoryDelete is the builder for deleting a UserLoginHistory entity.
type UserLoginHistoryDelete struct {
	config
	hooks    []Hook
	mutation *UserLoginHistoryMutation
}

// Where appends a list predicates to the UserLoginHistoryDelete builder.
func (ulhd *UserLoginHistoryDelete) Where(ps ...predicate.UserLoginHistory) *UserLoginHistoryDelete {
	ulhd.mutation.Where(ps...)
	return ulhd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (ulhd *UserLoginHistoryDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, ulhd.sqlExec, ulhd.mutation, ulhd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (ulhd *UserLoginHistoryDelete) ExecX(ctx context.Context) int {
	n, err := ulhd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (ulhd *UserLoginHistoryDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(userloginhistory.Table, sqlgraph.NewFieldSpec(userloginhistory.FieldID, field.TypeUUID))
	if ps := ulhd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, ulhd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	ulhd.mutation.done = true
	return affected, err
}

// UserLoginHistoryDeleteOne is the builder for deleting a single UserLoginHistory entity.
type UserLoginHistoryDeleteOne struct {
	ulhd *UserLoginHistoryDelete
}

// Where appends a list predicates to the UserLoginHistoryDelete builder.
func (ulhdo *UserLoginHistoryDeleteOne) Where(ps ...predicate.UserLoginHistory) *UserLoginHistoryDeleteOne {
	ulhdo.ulhd.mutation.Where(ps...)
	return ulhdo
}

// Exec executes the deletion query.
func (ulhdo *UserLoginHistoryDeleteOne) Exec(ctx context.Context) error {
	n, err := ulhdo.ulhd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{userloginhistory.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (ulhdo *UserLoginHistoryDeleteOne) ExecX(ctx context.Context) {
	if err := ulhdo.Exec(ctx); err != nil {
		panic(err)
	}
}
