// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent"
	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/userloginhistory"
	"github.com/google/uuid"
)

// UserLoginHistoryQuery is the builder for querying UserLoginHistory entities.
type UserLoginHistoryQuery struct {
	config
	ctx        *QueryContext
	order      []userloginhistory.OrderOption
	inters     []Interceptor
	predicates []predicate.UserLoginHistory
	withOwner  *UserQuery
	modifiers  []func(*sql.Selector)
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the UserLoginHistoryQuery builder.
func (ulhq *UserLoginHistoryQuery) Where(ps ...predicate.UserLoginHistory) *UserLoginHistoryQuery {
	ulhq.predicates = append(ulhq.predicates, ps...)
	return ulhq
}

// Limit the number of records to be returned by this query.
func (ulhq *UserLoginHistoryQuery) Limit(limit int) *UserLoginHistoryQuery {
	ulhq.ctx.Limit = &limit
	return ulhq
}

// Offset to start from.
func (ulhq *UserLoginHistoryQuery) Offset(offset int) *UserLoginHistoryQuery {
	ulhq.ctx.Offset = &offset
	return ulhq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (ulhq *UserLoginHistoryQuery) Unique(unique bool) *UserLoginHistoryQuery {
	ulhq.ctx.Unique = &unique
	return ulhq
}

// Order specifies how the records should be ordered.
func (ulhq *UserLoginHistoryQuery) Order(o ...userloginhistory.OrderOption) *UserLoginHistoryQuery {
	ulhq.order = append(ulhq.order, o...)
	return ulhq
}

// QueryOwner chains the current query on the "owner" edge.
func (ulhq *UserLoginHistoryQuery) QueryOwner() *UserQuery {
	query := (&UserClient{config: ulhq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := ulhq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := ulhq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(userloginhistory.Table, userloginhistory.FieldID, selector),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, userloginhistory.OwnerTable, userloginhistory.OwnerColumn),
		)
		fromU = sqlgraph.SetNeighbors(ulhq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// First returns the first UserLoginHistory entity from the query.
// Returns a *NotFoundError when no UserLoginHistory was found.
func (ulhq *UserLoginHistoryQuery) First(ctx context.Context) (*UserLoginHistory, error) {
	nodes, err := ulhq.Limit(1).All(setContextOp(ctx, ulhq.ctx, ent.OpQueryFirst))
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{userloginhistory.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (ulhq *UserLoginHistoryQuery) FirstX(ctx context.Context) *UserLoginHistory {
	node, err := ulhq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first UserLoginHistory ID from the query.
// Returns a *NotFoundError when no UserLoginHistory ID was found.
func (ulhq *UserLoginHistoryQuery) FirstID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = ulhq.Limit(1).IDs(setContextOp(ctx, ulhq.ctx, ent.OpQueryFirstID)); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{userloginhistory.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (ulhq *UserLoginHistoryQuery) FirstIDX(ctx context.Context) uuid.UUID {
	id, err := ulhq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single UserLoginHistory entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one UserLoginHistory entity is found.
// Returns a *NotFoundError when no UserLoginHistory entities are found.
func (ulhq *UserLoginHistoryQuery) Only(ctx context.Context) (*UserLoginHistory, error) {
	nodes, err := ulhq.Limit(2).All(setContextOp(ctx, ulhq.ctx, ent.OpQueryOnly))
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{userloginhistory.Label}
	default:
		return nil, &NotSingularError{userloginhistory.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (ulhq *UserLoginHistoryQuery) OnlyX(ctx context.Context) *UserLoginHistory {
	node, err := ulhq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only UserLoginHistory ID in the query.
// Returns a *NotSingularError when more than one UserLoginHistory ID is found.
// Returns a *NotFoundError when no entities are found.
func (ulhq *UserLoginHistoryQuery) OnlyID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = ulhq.Limit(2).IDs(setContextOp(ctx, ulhq.ctx, ent.OpQueryOnlyID)); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{userloginhistory.Label}
	default:
		err = &NotSingularError{userloginhistory.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (ulhq *UserLoginHistoryQuery) OnlyIDX(ctx context.Context) uuid.UUID {
	id, err := ulhq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of UserLoginHistories.
func (ulhq *UserLoginHistoryQuery) All(ctx context.Context) ([]*UserLoginHistory, error) {
	ctx = setContextOp(ctx, ulhq.ctx, ent.OpQueryAll)
	if err := ulhq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	qr := querierAll[[]*UserLoginHistory, *UserLoginHistoryQuery]()
	return withInterceptors[[]*UserLoginHistory](ctx, ulhq, qr, ulhq.inters)
}

// AllX is like All, but panics if an error occurs.
func (ulhq *UserLoginHistoryQuery) AllX(ctx context.Context) []*UserLoginHistory {
	nodes, err := ulhq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of UserLoginHistory IDs.
func (ulhq *UserLoginHistoryQuery) IDs(ctx context.Context) (ids []uuid.UUID, err error) {
	if ulhq.ctx.Unique == nil && ulhq.path != nil {
		ulhq.Unique(true)
	}
	ctx = setContextOp(ctx, ulhq.ctx, ent.OpQueryIDs)
	if err = ulhq.Select(userloginhistory.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (ulhq *UserLoginHistoryQuery) IDsX(ctx context.Context) []uuid.UUID {
	ids, err := ulhq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (ulhq *UserLoginHistoryQuery) Count(ctx context.Context) (int, error) {
	ctx = setContextOp(ctx, ulhq.ctx, ent.OpQueryCount)
	if err := ulhq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return withInterceptors[int](ctx, ulhq, querierCount[*UserLoginHistoryQuery](), ulhq.inters)
}

// CountX is like Count, but panics if an error occurs.
func (ulhq *UserLoginHistoryQuery) CountX(ctx context.Context) int {
	count, err := ulhq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (ulhq *UserLoginHistoryQuery) Exist(ctx context.Context) (bool, error) {
	ctx = setContextOp(ctx, ulhq.ctx, ent.OpQueryExist)
	switch _, err := ulhq.FirstID(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("db: check existence: %w", err)
	default:
		return true, nil
	}
}

// ExistX is like Exist, but panics if an error occurs.
func (ulhq *UserLoginHistoryQuery) ExistX(ctx context.Context) bool {
	exist, err := ulhq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the UserLoginHistoryQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (ulhq *UserLoginHistoryQuery) Clone() *UserLoginHistoryQuery {
	if ulhq == nil {
		return nil
	}
	return &UserLoginHistoryQuery{
		config:     ulhq.config,
		ctx:        ulhq.ctx.Clone(),
		order:      append([]userloginhistory.OrderOption{}, ulhq.order...),
		inters:     append([]Interceptor{}, ulhq.inters...),
		predicates: append([]predicate.UserLoginHistory{}, ulhq.predicates...),
		withOwner:  ulhq.withOwner.Clone(),
		// clone intermediate query.
		sql:       ulhq.sql.Clone(),
		path:      ulhq.path,
		modifiers: append([]func(*sql.Selector){}, ulhq.modifiers...),
	}
}

// WithOwner tells the query-builder to eager-load the nodes that are connected to
// the "owner" edge. The optional arguments are used to configure the query builder of the edge.
func (ulhq *UserLoginHistoryQuery) WithOwner(opts ...func(*UserQuery)) *UserLoginHistoryQuery {
	query := (&UserClient{config: ulhq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	ulhq.withOwner = query
	return ulhq
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		UserID uuid.UUID `json:"user_id,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.UserLoginHistory.Query().
//		GroupBy(userloginhistory.FieldUserID).
//		Aggregate(db.Count()).
//		Scan(ctx, &v)
func (ulhq *UserLoginHistoryQuery) GroupBy(field string, fields ...string) *UserLoginHistoryGroupBy {
	ulhq.ctx.Fields = append([]string{field}, fields...)
	grbuild := &UserLoginHistoryGroupBy{build: ulhq}
	grbuild.flds = &ulhq.ctx.Fields
	grbuild.label = userloginhistory.Label
	grbuild.scan = grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		UserID uuid.UUID `json:"user_id,omitempty"`
//	}
//
//	client.UserLoginHistory.Query().
//		Select(userloginhistory.FieldUserID).
//		Scan(ctx, &v)
func (ulhq *UserLoginHistoryQuery) Select(fields ...string) *UserLoginHistorySelect {
	ulhq.ctx.Fields = append(ulhq.ctx.Fields, fields...)
	sbuild := &UserLoginHistorySelect{UserLoginHistoryQuery: ulhq}
	sbuild.label = userloginhistory.Label
	sbuild.flds, sbuild.scan = &ulhq.ctx.Fields, sbuild.Scan
	return sbuild
}

// Aggregate returns a UserLoginHistorySelect configured with the given aggregations.
func (ulhq *UserLoginHistoryQuery) Aggregate(fns ...AggregateFunc) *UserLoginHistorySelect {
	return ulhq.Select().Aggregate(fns...)
}

func (ulhq *UserLoginHistoryQuery) prepareQuery(ctx context.Context) error {
	for _, inter := range ulhq.inters {
		if inter == nil {
			return fmt.Errorf("db: uninitialized interceptor (forgotten import db/runtime?)")
		}
		if trv, ok := inter.(Traverser); ok {
			if err := trv.Traverse(ctx, ulhq); err != nil {
				return err
			}
		}
	}
	for _, f := range ulhq.ctx.Fields {
		if !userloginhistory.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
		}
	}
	if ulhq.path != nil {
		prev, err := ulhq.path(ctx)
		if err != nil {
			return err
		}
		ulhq.sql = prev
	}
	return nil
}

func (ulhq *UserLoginHistoryQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*UserLoginHistory, error) {
	var (
		nodes       = []*UserLoginHistory{}
		_spec       = ulhq.querySpec()
		loadedTypes = [1]bool{
			ulhq.withOwner != nil,
		}
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*UserLoginHistory).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &UserLoginHistory{config: ulhq.config}
		nodes = append(nodes, node)
		node.Edges.loadedTypes = loadedTypes
		return node.assignValues(columns, values)
	}
	if len(ulhq.modifiers) > 0 {
		_spec.Modifiers = ulhq.modifiers
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, ulhq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	if query := ulhq.withOwner; query != nil {
		if err := ulhq.loadOwner(ctx, query, nodes, nil,
			func(n *UserLoginHistory, e *User) { n.Edges.Owner = e }); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

func (ulhq *UserLoginHistoryQuery) loadOwner(ctx context.Context, query *UserQuery, nodes []*UserLoginHistory, init func(*UserLoginHistory), assign func(*UserLoginHistory, *User)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*UserLoginHistory)
	for i := range nodes {
		fk := nodes[i].UserID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(user.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "user_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}

func (ulhq *UserLoginHistoryQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := ulhq.querySpec()
	if len(ulhq.modifiers) > 0 {
		_spec.Modifiers = ulhq.modifiers
	}
	_spec.Node.Columns = ulhq.ctx.Fields
	if len(ulhq.ctx.Fields) > 0 {
		_spec.Unique = ulhq.ctx.Unique != nil && *ulhq.ctx.Unique
	}
	return sqlgraph.CountNodes(ctx, ulhq.driver, _spec)
}

func (ulhq *UserLoginHistoryQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := sqlgraph.NewQuerySpec(userloginhistory.Table, userloginhistory.Columns, sqlgraph.NewFieldSpec(userloginhistory.FieldID, field.TypeUUID))
	_spec.From = ulhq.sql
	if unique := ulhq.ctx.Unique; unique != nil {
		_spec.Unique = *unique
	} else if ulhq.path != nil {
		_spec.Unique = true
	}
	if fields := ulhq.ctx.Fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, userloginhistory.FieldID)
		for i := range fields {
			if fields[i] != userloginhistory.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
		if ulhq.withOwner != nil {
			_spec.Node.AddColumnOnce(userloginhistory.FieldUserID)
		}
	}
	if ps := ulhq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := ulhq.ctx.Limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := ulhq.ctx.Offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := ulhq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (ulhq *UserLoginHistoryQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(ulhq.driver.Dialect())
	t1 := builder.Table(userloginhistory.Table)
	columns := ulhq.ctx.Fields
	if len(columns) == 0 {
		columns = userloginhistory.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if ulhq.sql != nil {
		selector = ulhq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if ulhq.ctx.Unique != nil && *ulhq.ctx.Unique {
		selector.Distinct()
	}
	for _, m := range ulhq.modifiers {
		m(selector)
	}
	for _, p := range ulhq.predicates {
		p(selector)
	}
	for _, p := range ulhq.order {
		p(selector)
	}
	if offset := ulhq.ctx.Offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := ulhq.ctx.Limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// ForUpdate locks the selected rows against concurrent updates, and prevent them from being
// updated, deleted or "selected ... for update" by other sessions, until the transaction is
// either committed or rolled-back.
func (ulhq *UserLoginHistoryQuery) ForUpdate(opts ...sql.LockOption) *UserLoginHistoryQuery {
	if ulhq.driver.Dialect() == dialect.Postgres {
		ulhq.Unique(false)
	}
	ulhq.modifiers = append(ulhq.modifiers, func(s *sql.Selector) {
		s.ForUpdate(opts...)
	})
	return ulhq
}

// ForShare behaves similarly to ForUpdate, except that it acquires a shared mode lock
// on any rows that are read. Other sessions can read the rows, but cannot modify them
// until your transaction commits.
func (ulhq *UserLoginHistoryQuery) ForShare(opts ...sql.LockOption) *UserLoginHistoryQuery {
	if ulhq.driver.Dialect() == dialect.Postgres {
		ulhq.Unique(false)
	}
	ulhq.modifiers = append(ulhq.modifiers, func(s *sql.Selector) {
		s.ForShare(opts...)
	})
	return ulhq
}

// Modify adds a query modifier for attaching custom logic to queries.
func (ulhq *UserLoginHistoryQuery) Modify(modifiers ...func(s *sql.Selector)) *UserLoginHistorySelect {
	ulhq.modifiers = append(ulhq.modifiers, modifiers...)
	return ulhq.Select()
}

// UserLoginHistoryGroupBy is the group-by builder for UserLoginHistory entities.
type UserLoginHistoryGroupBy struct {
	selector
	build *UserLoginHistoryQuery
}

// Aggregate adds the given aggregation functions to the group-by query.
func (ulhgb *UserLoginHistoryGroupBy) Aggregate(fns ...AggregateFunc) *UserLoginHistoryGroupBy {
	ulhgb.fns = append(ulhgb.fns, fns...)
	return ulhgb
}

// Scan applies the selector query and scans the result into the given value.
func (ulhgb *UserLoginHistoryGroupBy) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, ulhgb.build.ctx, ent.OpQueryGroupBy)
	if err := ulhgb.build.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*UserLoginHistoryQuery, *UserLoginHistoryGroupBy](ctx, ulhgb.build, ulhgb, ulhgb.build.inters, v)
}

func (ulhgb *UserLoginHistoryGroupBy) sqlScan(ctx context.Context, root *UserLoginHistoryQuery, v any) error {
	selector := root.sqlQuery(ctx).Select()
	aggregation := make([]string, 0, len(ulhgb.fns))
	for _, fn := range ulhgb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(*ulhgb.flds)+len(ulhgb.fns))
		for _, f := range *ulhgb.flds {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	selector.GroupBy(selector.Columns(*ulhgb.flds...)...)
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := ulhgb.build.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// UserLoginHistorySelect is the builder for selecting fields of UserLoginHistory entities.
type UserLoginHistorySelect struct {
	*UserLoginHistoryQuery
	selector
}

// Aggregate adds the given aggregation functions to the selector query.
func (ulhs *UserLoginHistorySelect) Aggregate(fns ...AggregateFunc) *UserLoginHistorySelect {
	ulhs.fns = append(ulhs.fns, fns...)
	return ulhs
}

// Scan applies the selector query and scans the result into the given value.
func (ulhs *UserLoginHistorySelect) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, ulhs.ctx, ent.OpQuerySelect)
	if err := ulhs.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*UserLoginHistoryQuery, *UserLoginHistorySelect](ctx, ulhs.UserLoginHistoryQuery, ulhs, ulhs.inters, v)
}

func (ulhs *UserLoginHistorySelect) sqlScan(ctx context.Context, root *UserLoginHistoryQuery, v any) error {
	selector := root.sqlQuery(ctx)
	aggregation := make([]string, 0, len(ulhs.fns))
	for _, fn := range ulhs.fns {
		aggregation = append(aggregation, fn(selector))
	}
	switch n := len(*ulhs.selector.flds); {
	case n == 0 && len(aggregation) > 0:
		selector.Select(aggregation...)
	case n != 0 && len(aggregation) > 0:
		selector.AppendSelect(aggregation...)
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := ulhs.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// Modify adds a query modifier for attaching custom logic to queries.
func (ulhs *UserLoginHistorySelect) Modify(modifiers ...func(s *sql.Selector)) *UserLoginHistorySelect {
	ulhs.modifiers = append(ulhs.modifiers, modifiers...)
	return ulhs
}
