// Code generated by ent, DO NOT EDIT.

package db

import (
	"encoding/json"
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/workspace"
	"github.com/google/uuid"
)

// Workspace is the model entity for the Workspace schema.
type Workspace struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// 工作区所有者ID
	UserID uuid.UUID `json:"user_id,omitempty"`
	// 工作区名称
	Name string `json:"name,omitempty"`
	// 工作区描述
	Description string `json:"description,omitempty"`
	// 工作区根路径
	RootPath string `json:"root_path,omitempty"`
	// 工作区设置
	Settings map[string]interface{} `json:"settings,omitempty"`
	// 最后访问时间
	LastAccessedAt time.Time `json:"last_accessed_at,omitempty"`
	// 创建时间
	CreatedAt time.Time `json:"created_at,omitempty"`
	// 更新时间
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the WorkspaceQuery when eager-loading is set.
	Edges        WorkspaceEdges `json:"edges"`
	selectValues sql.SelectValues
}

// WorkspaceEdges holds the relations/edges for other nodes in the graph.
type WorkspaceEdges struct {
	// Owner holds the value of the owner edge.
	Owner *User `json:"owner,omitempty"`
	// Files holds the value of the files edge.
	Files []*WorkspaceFile `json:"files,omitempty"`
	// SecurityScannings holds the value of the security_scannings edge.
	SecurityScannings []*SecurityScanning `json:"security_scannings,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [3]bool
}

// OwnerOrErr returns the Owner value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e WorkspaceEdges) OwnerOrErr() (*User, error) {
	if e.Owner != nil {
		return e.Owner, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: user.Label}
	}
	return nil, &NotLoadedError{edge: "owner"}
}

// FilesOrErr returns the Files value or an error if the edge
// was not loaded in eager-loading.
func (e WorkspaceEdges) FilesOrErr() ([]*WorkspaceFile, error) {
	if e.loadedTypes[1] {
		return e.Files, nil
	}
	return nil, &NotLoadedError{edge: "files"}
}

// SecurityScanningsOrErr returns the SecurityScannings value or an error if the edge
// was not loaded in eager-loading.
func (e WorkspaceEdges) SecurityScanningsOrErr() ([]*SecurityScanning, error) {
	if e.loadedTypes[2] {
		return e.SecurityScannings, nil
	}
	return nil, &NotLoadedError{edge: "security_scannings"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Workspace) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case workspace.FieldSettings:
			values[i] = new([]byte)
		case workspace.FieldName, workspace.FieldDescription, workspace.FieldRootPath:
			values[i] = new(sql.NullString)
		case workspace.FieldLastAccessedAt, workspace.FieldCreatedAt, workspace.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		case workspace.FieldID, workspace.FieldUserID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Workspace fields.
func (w *Workspace) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case workspace.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				w.ID = *value
			}
		case workspace.FieldUserID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field user_id", values[i])
			} else if value != nil {
				w.UserID = *value
			}
		case workspace.FieldName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field name", values[i])
			} else if value.Valid {
				w.Name = value.String
			}
		case workspace.FieldDescription:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field description", values[i])
			} else if value.Valid {
				w.Description = value.String
			}
		case workspace.FieldRootPath:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field root_path", values[i])
			} else if value.Valid {
				w.RootPath = value.String
			}
		case workspace.FieldSettings:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field settings", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &w.Settings); err != nil {
					return fmt.Errorf("unmarshal field settings: %w", err)
				}
			}
		case workspace.FieldLastAccessedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field last_accessed_at", values[i])
			} else if value.Valid {
				w.LastAccessedAt = value.Time
			}
		case workspace.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				w.CreatedAt = value.Time
			}
		case workspace.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				w.UpdatedAt = value.Time
			}
		default:
			w.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the Workspace.
// This includes values selected through modifiers, order, etc.
func (w *Workspace) Value(name string) (ent.Value, error) {
	return w.selectValues.Get(name)
}

// QueryOwner queries the "owner" edge of the Workspace entity.
func (w *Workspace) QueryOwner() *UserQuery {
	return NewWorkspaceClient(w.config).QueryOwner(w)
}

// QueryFiles queries the "files" edge of the Workspace entity.
func (w *Workspace) QueryFiles() *WorkspaceFileQuery {
	return NewWorkspaceClient(w.config).QueryFiles(w)
}

// QuerySecurityScannings queries the "security_scannings" edge of the Workspace entity.
func (w *Workspace) QuerySecurityScannings() *SecurityScanningQuery {
	return NewWorkspaceClient(w.config).QuerySecurityScannings(w)
}

// Update returns a builder for updating this Workspace.
// Note that you need to call Workspace.Unwrap() before calling this method if this Workspace
// was returned from a transaction, and the transaction was committed or rolled back.
func (w *Workspace) Update() *WorkspaceUpdateOne {
	return NewWorkspaceClient(w.config).UpdateOne(w)
}

// Unwrap unwraps the Workspace entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (w *Workspace) Unwrap() *Workspace {
	_tx, ok := w.config.driver.(*txDriver)
	if !ok {
		panic("db: Workspace is not a transactional entity")
	}
	w.config.driver = _tx.drv
	return w
}

// String implements the fmt.Stringer.
func (w *Workspace) String() string {
	var builder strings.Builder
	builder.WriteString("Workspace(")
	builder.WriteString(fmt.Sprintf("id=%v, ", w.ID))
	builder.WriteString("user_id=")
	builder.WriteString(fmt.Sprintf("%v", w.UserID))
	builder.WriteString(", ")
	builder.WriteString("name=")
	builder.WriteString(w.Name)
	builder.WriteString(", ")
	builder.WriteString("description=")
	builder.WriteString(w.Description)
	builder.WriteString(", ")
	builder.WriteString("root_path=")
	builder.WriteString(w.RootPath)
	builder.WriteString(", ")
	builder.WriteString("settings=")
	builder.WriteString(fmt.Sprintf("%v", w.Settings))
	builder.WriteString(", ")
	builder.WriteString("last_accessed_at=")
	builder.WriteString(w.LastAccessedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(w.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(w.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// Workspaces is a parsable slice of Workspace.
type Workspaces []*Workspace
