// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanning"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/workspace"
	"github.com/chaitin/MonkeyCode/backend/db/workspacefile"
	"github.com/google/uuid"
)

// WorkspaceCreate is the builder for creating a Workspace entity.
type WorkspaceCreate struct {
	config
	mutation *WorkspaceMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetUserID sets the "user_id" field.
func (wc *WorkspaceCreate) SetUserID(u uuid.UUID) *WorkspaceCreate {
	wc.mutation.SetUserID(u)
	return wc
}

// SetName sets the "name" field.
func (wc *WorkspaceCreate) SetName(s string) *WorkspaceCreate {
	wc.mutation.SetName(s)
	return wc
}

// SetNillableName sets the "name" field if the given value is not nil.
func (wc *WorkspaceCreate) SetNillableName(s *string) *WorkspaceCreate {
	if s != nil {
		wc.SetName(*s)
	}
	return wc
}

// SetDescription sets the "description" field.
func (wc *WorkspaceCreate) SetDescription(s string) *WorkspaceCreate {
	wc.mutation.SetDescription(s)
	return wc
}

// SetNillableDescription sets the "description" field if the given value is not nil.
func (wc *WorkspaceCreate) SetNillableDescription(s *string) *WorkspaceCreate {
	if s != nil {
		wc.SetDescription(*s)
	}
	return wc
}

// SetRootPath sets the "root_path" field.
func (wc *WorkspaceCreate) SetRootPath(s string) *WorkspaceCreate {
	wc.mutation.SetRootPath(s)
	return wc
}

// SetSettings sets the "settings" field.
func (wc *WorkspaceCreate) SetSettings(m map[string]interface{}) *WorkspaceCreate {
	wc.mutation.SetSettings(m)
	return wc
}

// SetLastAccessedAt sets the "last_accessed_at" field.
func (wc *WorkspaceCreate) SetLastAccessedAt(t time.Time) *WorkspaceCreate {
	wc.mutation.SetLastAccessedAt(t)
	return wc
}

// SetNillableLastAccessedAt sets the "last_accessed_at" field if the given value is not nil.
func (wc *WorkspaceCreate) SetNillableLastAccessedAt(t *time.Time) *WorkspaceCreate {
	if t != nil {
		wc.SetLastAccessedAt(*t)
	}
	return wc
}

// SetCreatedAt sets the "created_at" field.
func (wc *WorkspaceCreate) SetCreatedAt(t time.Time) *WorkspaceCreate {
	wc.mutation.SetCreatedAt(t)
	return wc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (wc *WorkspaceCreate) SetNillableCreatedAt(t *time.Time) *WorkspaceCreate {
	if t != nil {
		wc.SetCreatedAt(*t)
	}
	return wc
}

// SetUpdatedAt sets the "updated_at" field.
func (wc *WorkspaceCreate) SetUpdatedAt(t time.Time) *WorkspaceCreate {
	wc.mutation.SetUpdatedAt(t)
	return wc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (wc *WorkspaceCreate) SetNillableUpdatedAt(t *time.Time) *WorkspaceCreate {
	if t != nil {
		wc.SetUpdatedAt(*t)
	}
	return wc
}

// SetID sets the "id" field.
func (wc *WorkspaceCreate) SetID(u uuid.UUID) *WorkspaceCreate {
	wc.mutation.SetID(u)
	return wc
}

// SetOwnerID sets the "owner" edge to the User entity by ID.
func (wc *WorkspaceCreate) SetOwnerID(id uuid.UUID) *WorkspaceCreate {
	wc.mutation.SetOwnerID(id)
	return wc
}

// SetOwner sets the "owner" edge to the User entity.
func (wc *WorkspaceCreate) SetOwner(u *User) *WorkspaceCreate {
	return wc.SetOwnerID(u.ID)
}

// AddFileIDs adds the "files" edge to the WorkspaceFile entity by IDs.
func (wc *WorkspaceCreate) AddFileIDs(ids ...uuid.UUID) *WorkspaceCreate {
	wc.mutation.AddFileIDs(ids...)
	return wc
}

// AddFiles adds the "files" edges to the WorkspaceFile entity.
func (wc *WorkspaceCreate) AddFiles(w ...*WorkspaceFile) *WorkspaceCreate {
	ids := make([]uuid.UUID, len(w))
	for i := range w {
		ids[i] = w[i].ID
	}
	return wc.AddFileIDs(ids...)
}

// AddSecurityScanningIDs adds the "security_scannings" edge to the SecurityScanning entity by IDs.
func (wc *WorkspaceCreate) AddSecurityScanningIDs(ids ...uuid.UUID) *WorkspaceCreate {
	wc.mutation.AddSecurityScanningIDs(ids...)
	return wc
}

// AddSecurityScannings adds the "security_scannings" edges to the SecurityScanning entity.
func (wc *WorkspaceCreate) AddSecurityScannings(s ...*SecurityScanning) *WorkspaceCreate {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return wc.AddSecurityScanningIDs(ids...)
}

// Mutation returns the WorkspaceMutation object of the builder.
func (wc *WorkspaceCreate) Mutation() *WorkspaceMutation {
	return wc.mutation
}

// Save creates the Workspace in the database.
func (wc *WorkspaceCreate) Save(ctx context.Context) (*Workspace, error) {
	wc.defaults()
	return withHooks(ctx, wc.sqlSave, wc.mutation, wc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (wc *WorkspaceCreate) SaveX(ctx context.Context) *Workspace {
	v, err := wc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (wc *WorkspaceCreate) Exec(ctx context.Context) error {
	_, err := wc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (wc *WorkspaceCreate) ExecX(ctx context.Context) {
	if err := wc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (wc *WorkspaceCreate) defaults() {
	if _, ok := wc.mutation.LastAccessedAt(); !ok {
		v := workspace.DefaultLastAccessedAt()
		wc.mutation.SetLastAccessedAt(v)
	}
	if _, ok := wc.mutation.CreatedAt(); !ok {
		v := workspace.DefaultCreatedAt()
		wc.mutation.SetCreatedAt(v)
	}
	if _, ok := wc.mutation.UpdatedAt(); !ok {
		v := workspace.DefaultUpdatedAt()
		wc.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (wc *WorkspaceCreate) check() error {
	if _, ok := wc.mutation.UserID(); !ok {
		return &ValidationError{Name: "user_id", err: errors.New(`db: missing required field "Workspace.user_id"`)}
	}
	if _, ok := wc.mutation.RootPath(); !ok {
		return &ValidationError{Name: "root_path", err: errors.New(`db: missing required field "Workspace.root_path"`)}
	}
	if v, ok := wc.mutation.RootPath(); ok {
		if err := workspace.RootPathValidator(v); err != nil {
			return &ValidationError{Name: "root_path", err: fmt.Errorf(`db: validator failed for field "Workspace.root_path": %w`, err)}
		}
	}
	if _, ok := wc.mutation.LastAccessedAt(); !ok {
		return &ValidationError{Name: "last_accessed_at", err: errors.New(`db: missing required field "Workspace.last_accessed_at"`)}
	}
	if _, ok := wc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "Workspace.created_at"`)}
	}
	if _, ok := wc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "Workspace.updated_at"`)}
	}
	if len(wc.mutation.OwnerIDs()) == 0 {
		return &ValidationError{Name: "owner", err: errors.New(`db: missing required edge "Workspace.owner"`)}
	}
	return nil
}

func (wc *WorkspaceCreate) sqlSave(ctx context.Context) (*Workspace, error) {
	if err := wc.check(); err != nil {
		return nil, err
	}
	_node, _spec := wc.createSpec()
	if err := sqlgraph.CreateNode(ctx, wc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	wc.mutation.id = &_node.ID
	wc.mutation.done = true
	return _node, nil
}

func (wc *WorkspaceCreate) createSpec() (*Workspace, *sqlgraph.CreateSpec) {
	var (
		_node = &Workspace{config: wc.config}
		_spec = sqlgraph.NewCreateSpec(workspace.Table, sqlgraph.NewFieldSpec(workspace.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = wc.conflict
	if id, ok := wc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := wc.mutation.Name(); ok {
		_spec.SetField(workspace.FieldName, field.TypeString, value)
		_node.Name = value
	}
	if value, ok := wc.mutation.Description(); ok {
		_spec.SetField(workspace.FieldDescription, field.TypeString, value)
		_node.Description = value
	}
	if value, ok := wc.mutation.RootPath(); ok {
		_spec.SetField(workspace.FieldRootPath, field.TypeString, value)
		_node.RootPath = value
	}
	if value, ok := wc.mutation.Settings(); ok {
		_spec.SetField(workspace.FieldSettings, field.TypeJSON, value)
		_node.Settings = value
	}
	if value, ok := wc.mutation.LastAccessedAt(); ok {
		_spec.SetField(workspace.FieldLastAccessedAt, field.TypeTime, value)
		_node.LastAccessedAt = value
	}
	if value, ok := wc.mutation.CreatedAt(); ok {
		_spec.SetField(workspace.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := wc.mutation.UpdatedAt(); ok {
		_spec.SetField(workspace.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if nodes := wc.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspace.OwnerTable,
			Columns: []string{workspace.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.UserID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := wc.mutation.FilesIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspace.FilesTable,
			Columns: []string{workspace.FilesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := wc.mutation.SecurityScanningsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspace.SecurityScanningsTable,
			Columns: []string{workspace.SecurityScanningsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(securityscanning.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Workspace.Create().
//		SetUserID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.WorkspaceUpsert) {
//			SetUserID(v+v).
//		}).
//		Exec(ctx)
func (wc *WorkspaceCreate) OnConflict(opts ...sql.ConflictOption) *WorkspaceUpsertOne {
	wc.conflict = opts
	return &WorkspaceUpsertOne{
		create: wc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Workspace.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (wc *WorkspaceCreate) OnConflictColumns(columns ...string) *WorkspaceUpsertOne {
	wc.conflict = append(wc.conflict, sql.ConflictColumns(columns...))
	return &WorkspaceUpsertOne{
		create: wc,
	}
}

type (
	// WorkspaceUpsertOne is the builder for "upsert"-ing
	//  one Workspace node.
	WorkspaceUpsertOne struct {
		create *WorkspaceCreate
	}

	// WorkspaceUpsert is the "OnConflict" setter.
	WorkspaceUpsert struct {
		*sql.UpdateSet
	}
)

// SetUserID sets the "user_id" field.
func (u *WorkspaceUpsert) SetUserID(v uuid.UUID) *WorkspaceUpsert {
	u.Set(workspace.FieldUserID, v)
	return u
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *WorkspaceUpsert) UpdateUserID() *WorkspaceUpsert {
	u.SetExcluded(workspace.FieldUserID)
	return u
}

// SetName sets the "name" field.
func (u *WorkspaceUpsert) SetName(v string) *WorkspaceUpsert {
	u.Set(workspace.FieldName, v)
	return u
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *WorkspaceUpsert) UpdateName() *WorkspaceUpsert {
	u.SetExcluded(workspace.FieldName)
	return u
}

// ClearName clears the value of the "name" field.
func (u *WorkspaceUpsert) ClearName() *WorkspaceUpsert {
	u.SetNull(workspace.FieldName)
	return u
}

// SetDescription sets the "description" field.
func (u *WorkspaceUpsert) SetDescription(v string) *WorkspaceUpsert {
	u.Set(workspace.FieldDescription, v)
	return u
}

// UpdateDescription sets the "description" field to the value that was provided on create.
func (u *WorkspaceUpsert) UpdateDescription() *WorkspaceUpsert {
	u.SetExcluded(workspace.FieldDescription)
	return u
}

// ClearDescription clears the value of the "description" field.
func (u *WorkspaceUpsert) ClearDescription() *WorkspaceUpsert {
	u.SetNull(workspace.FieldDescription)
	return u
}

// SetRootPath sets the "root_path" field.
func (u *WorkspaceUpsert) SetRootPath(v string) *WorkspaceUpsert {
	u.Set(workspace.FieldRootPath, v)
	return u
}

// UpdateRootPath sets the "root_path" field to the value that was provided on create.
func (u *WorkspaceUpsert) UpdateRootPath() *WorkspaceUpsert {
	u.SetExcluded(workspace.FieldRootPath)
	return u
}

// SetSettings sets the "settings" field.
func (u *WorkspaceUpsert) SetSettings(v map[string]interface{}) *WorkspaceUpsert {
	u.Set(workspace.FieldSettings, v)
	return u
}

// UpdateSettings sets the "settings" field to the value that was provided on create.
func (u *WorkspaceUpsert) UpdateSettings() *WorkspaceUpsert {
	u.SetExcluded(workspace.FieldSettings)
	return u
}

// ClearSettings clears the value of the "settings" field.
func (u *WorkspaceUpsert) ClearSettings() *WorkspaceUpsert {
	u.SetNull(workspace.FieldSettings)
	return u
}

// SetLastAccessedAt sets the "last_accessed_at" field.
func (u *WorkspaceUpsert) SetLastAccessedAt(v time.Time) *WorkspaceUpsert {
	u.Set(workspace.FieldLastAccessedAt, v)
	return u
}

// UpdateLastAccessedAt sets the "last_accessed_at" field to the value that was provided on create.
func (u *WorkspaceUpsert) UpdateLastAccessedAt() *WorkspaceUpsert {
	u.SetExcluded(workspace.FieldLastAccessedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *WorkspaceUpsert) SetUpdatedAt(v time.Time) *WorkspaceUpsert {
	u.Set(workspace.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *WorkspaceUpsert) UpdateUpdatedAt() *WorkspaceUpsert {
	u.SetExcluded(workspace.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.Workspace.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(workspace.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *WorkspaceUpsertOne) UpdateNewValues() *WorkspaceUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(workspace.FieldID)
		}
		if _, exists := u.create.mutation.CreatedAt(); exists {
			s.SetIgnore(workspace.FieldCreatedAt)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Workspace.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *WorkspaceUpsertOne) Ignore() *WorkspaceUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *WorkspaceUpsertOne) DoNothing() *WorkspaceUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the WorkspaceCreate.OnConflict
// documentation for more info.
func (u *WorkspaceUpsertOne) Update(set func(*WorkspaceUpsert)) *WorkspaceUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&WorkspaceUpsert{UpdateSet: update})
	}))
	return u
}

// SetUserID sets the "user_id" field.
func (u *WorkspaceUpsertOne) SetUserID(v uuid.UUID) *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *WorkspaceUpsertOne) UpdateUserID() *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.UpdateUserID()
	})
}

// SetName sets the "name" field.
func (u *WorkspaceUpsertOne) SetName(v string) *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *WorkspaceUpsertOne) UpdateName() *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.UpdateName()
	})
}

// ClearName clears the value of the "name" field.
func (u *WorkspaceUpsertOne) ClearName() *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.ClearName()
	})
}

// SetDescription sets the "description" field.
func (u *WorkspaceUpsertOne) SetDescription(v string) *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.SetDescription(v)
	})
}

// UpdateDescription sets the "description" field to the value that was provided on create.
func (u *WorkspaceUpsertOne) UpdateDescription() *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.UpdateDescription()
	})
}

// ClearDescription clears the value of the "description" field.
func (u *WorkspaceUpsertOne) ClearDescription() *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.ClearDescription()
	})
}

// SetRootPath sets the "root_path" field.
func (u *WorkspaceUpsertOne) SetRootPath(v string) *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.SetRootPath(v)
	})
}

// UpdateRootPath sets the "root_path" field to the value that was provided on create.
func (u *WorkspaceUpsertOne) UpdateRootPath() *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.UpdateRootPath()
	})
}

// SetSettings sets the "settings" field.
func (u *WorkspaceUpsertOne) SetSettings(v map[string]interface{}) *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.SetSettings(v)
	})
}

// UpdateSettings sets the "settings" field to the value that was provided on create.
func (u *WorkspaceUpsertOne) UpdateSettings() *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.UpdateSettings()
	})
}

// ClearSettings clears the value of the "settings" field.
func (u *WorkspaceUpsertOne) ClearSettings() *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.ClearSettings()
	})
}

// SetLastAccessedAt sets the "last_accessed_at" field.
func (u *WorkspaceUpsertOne) SetLastAccessedAt(v time.Time) *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.SetLastAccessedAt(v)
	})
}

// UpdateLastAccessedAt sets the "last_accessed_at" field to the value that was provided on create.
func (u *WorkspaceUpsertOne) UpdateLastAccessedAt() *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.UpdateLastAccessedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *WorkspaceUpsertOne) SetUpdatedAt(v time.Time) *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *WorkspaceUpsertOne) UpdateUpdatedAt() *WorkspaceUpsertOne {
	return u.Update(func(s *WorkspaceUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *WorkspaceUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for WorkspaceCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *WorkspaceUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *WorkspaceUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: WorkspaceUpsertOne.ID is not supported by MySQL driver. Use WorkspaceUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *WorkspaceUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// WorkspaceCreateBulk is the builder for creating many Workspace entities in bulk.
type WorkspaceCreateBulk struct {
	config
	err      error
	builders []*WorkspaceCreate
	conflict []sql.ConflictOption
}

// Save creates the Workspace entities in the database.
func (wcb *WorkspaceCreateBulk) Save(ctx context.Context) ([]*Workspace, error) {
	if wcb.err != nil {
		return nil, wcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(wcb.builders))
	nodes := make([]*Workspace, len(wcb.builders))
	mutators := make([]Mutator, len(wcb.builders))
	for i := range wcb.builders {
		func(i int, root context.Context) {
			builder := wcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*WorkspaceMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, wcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = wcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, wcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, wcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (wcb *WorkspaceCreateBulk) SaveX(ctx context.Context) []*Workspace {
	v, err := wcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (wcb *WorkspaceCreateBulk) Exec(ctx context.Context) error {
	_, err := wcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (wcb *WorkspaceCreateBulk) ExecX(ctx context.Context) {
	if err := wcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Workspace.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.WorkspaceUpsert) {
//			SetUserID(v+v).
//		}).
//		Exec(ctx)
func (wcb *WorkspaceCreateBulk) OnConflict(opts ...sql.ConflictOption) *WorkspaceUpsertBulk {
	wcb.conflict = opts
	return &WorkspaceUpsertBulk{
		create: wcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Workspace.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (wcb *WorkspaceCreateBulk) OnConflictColumns(columns ...string) *WorkspaceUpsertBulk {
	wcb.conflict = append(wcb.conflict, sql.ConflictColumns(columns...))
	return &WorkspaceUpsertBulk{
		create: wcb,
	}
}

// WorkspaceUpsertBulk is the builder for "upsert"-ing
// a bulk of Workspace nodes.
type WorkspaceUpsertBulk struct {
	create *WorkspaceCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.Workspace.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(workspace.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *WorkspaceUpsertBulk) UpdateNewValues() *WorkspaceUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(workspace.FieldID)
			}
			if _, exists := b.mutation.CreatedAt(); exists {
				s.SetIgnore(workspace.FieldCreatedAt)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Workspace.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *WorkspaceUpsertBulk) Ignore() *WorkspaceUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *WorkspaceUpsertBulk) DoNothing() *WorkspaceUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the WorkspaceCreateBulk.OnConflict
// documentation for more info.
func (u *WorkspaceUpsertBulk) Update(set func(*WorkspaceUpsert)) *WorkspaceUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&WorkspaceUpsert{UpdateSet: update})
	}))
	return u
}

// SetUserID sets the "user_id" field.
func (u *WorkspaceUpsertBulk) SetUserID(v uuid.UUID) *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *WorkspaceUpsertBulk) UpdateUserID() *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.UpdateUserID()
	})
}

// SetName sets the "name" field.
func (u *WorkspaceUpsertBulk) SetName(v string) *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *WorkspaceUpsertBulk) UpdateName() *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.UpdateName()
	})
}

// ClearName clears the value of the "name" field.
func (u *WorkspaceUpsertBulk) ClearName() *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.ClearName()
	})
}

// SetDescription sets the "description" field.
func (u *WorkspaceUpsertBulk) SetDescription(v string) *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.SetDescription(v)
	})
}

// UpdateDescription sets the "description" field to the value that was provided on create.
func (u *WorkspaceUpsertBulk) UpdateDescription() *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.UpdateDescription()
	})
}

// ClearDescription clears the value of the "description" field.
func (u *WorkspaceUpsertBulk) ClearDescription() *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.ClearDescription()
	})
}

// SetRootPath sets the "root_path" field.
func (u *WorkspaceUpsertBulk) SetRootPath(v string) *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.SetRootPath(v)
	})
}

// UpdateRootPath sets the "root_path" field to the value that was provided on create.
func (u *WorkspaceUpsertBulk) UpdateRootPath() *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.UpdateRootPath()
	})
}

// SetSettings sets the "settings" field.
func (u *WorkspaceUpsertBulk) SetSettings(v map[string]interface{}) *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.SetSettings(v)
	})
}

// UpdateSettings sets the "settings" field to the value that was provided on create.
func (u *WorkspaceUpsertBulk) UpdateSettings() *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.UpdateSettings()
	})
}

// ClearSettings clears the value of the "settings" field.
func (u *WorkspaceUpsertBulk) ClearSettings() *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.ClearSettings()
	})
}

// SetLastAccessedAt sets the "last_accessed_at" field.
func (u *WorkspaceUpsertBulk) SetLastAccessedAt(v time.Time) *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.SetLastAccessedAt(v)
	})
}

// UpdateLastAccessedAt sets the "last_accessed_at" field to the value that was provided on create.
func (u *WorkspaceUpsertBulk) UpdateLastAccessedAt() *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.UpdateLastAccessedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *WorkspaceUpsertBulk) SetUpdatedAt(v time.Time) *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *WorkspaceUpsertBulk) UpdateUpdatedAt() *WorkspaceUpsertBulk {
	return u.Update(func(s *WorkspaceUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *WorkspaceUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the WorkspaceCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for WorkspaceCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *WorkspaceUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
