// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/workspace"
	"github.com/chaitin/MonkeyCode/backend/db/workspacefile"
	"github.com/google/uuid"
)

// WorkspaceFile is the model entity for the WorkspaceFile schema.
type WorkspaceFile struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// 关联的用户ID
	UserID uuid.UUID `json:"user_id,omitempty"`
	// 关联的工作区ID
	WorkspaceID uuid.UUID `json:"workspace_id,omitempty"`
	// 文件在工作区中的相对路径
	Path string `json:"path,omitempty"`
	// 文件内容
	Content string `json:"content,omitempty"`
	// 文件内容的 SHA-256 哈希值
	Hash string `json:"hash,omitempty"`
	// 代码语言类型，如 go, typescript, python
	Language string `json:"language,omitempty"`
	// 文件大小（字节）
	Size int64 `json:"size,omitempty"`
	// 创建时间
	CreatedAt time.Time `json:"created_at,omitempty"`
	// 更新时间
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the WorkspaceFileQuery when eager-loading is set.
	Edges        WorkspaceFileEdges `json:"edges"`
	selectValues sql.SelectValues
}

// WorkspaceFileEdges holds the relations/edges for other nodes in the graph.
type WorkspaceFileEdges struct {
	// Owner holds the value of the owner edge.
	Owner *User `json:"owner,omitempty"`
	// Workspace holds the value of the workspace edge.
	Workspace *Workspace `json:"workspace,omitempty"`
	// Snippets holds the value of the snippets edge.
	Snippets []*CodeSnippet `json:"snippets,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [3]bool
}

// OwnerOrErr returns the Owner value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e WorkspaceFileEdges) OwnerOrErr() (*User, error) {
	if e.Owner != nil {
		return e.Owner, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: user.Label}
	}
	return nil, &NotLoadedError{edge: "owner"}
}

// WorkspaceOrErr returns the Workspace value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e WorkspaceFileEdges) WorkspaceOrErr() (*Workspace, error) {
	if e.Workspace != nil {
		return e.Workspace, nil
	} else if e.loadedTypes[1] {
		return nil, &NotFoundError{label: workspace.Label}
	}
	return nil, &NotLoadedError{edge: "workspace"}
}

// SnippetsOrErr returns the Snippets value or an error if the edge
// was not loaded in eager-loading.
func (e WorkspaceFileEdges) SnippetsOrErr() ([]*CodeSnippet, error) {
	if e.loadedTypes[2] {
		return e.Snippets, nil
	}
	return nil, &NotLoadedError{edge: "snippets"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*WorkspaceFile) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case workspacefile.FieldSize:
			values[i] = new(sql.NullInt64)
		case workspacefile.FieldPath, workspacefile.FieldContent, workspacefile.FieldHash, workspacefile.FieldLanguage:
			values[i] = new(sql.NullString)
		case workspacefile.FieldCreatedAt, workspacefile.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		case workspacefile.FieldID, workspacefile.FieldUserID, workspacefile.FieldWorkspaceID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the WorkspaceFile fields.
func (wf *WorkspaceFile) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case workspacefile.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				wf.ID = *value
			}
		case workspacefile.FieldUserID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field user_id", values[i])
			} else if value != nil {
				wf.UserID = *value
			}
		case workspacefile.FieldWorkspaceID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field workspace_id", values[i])
			} else if value != nil {
				wf.WorkspaceID = *value
			}
		case workspacefile.FieldPath:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field path", values[i])
			} else if value.Valid {
				wf.Path = value.String
			}
		case workspacefile.FieldContent:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field content", values[i])
			} else if value.Valid {
				wf.Content = value.String
			}
		case workspacefile.FieldHash:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field hash", values[i])
			} else if value.Valid {
				wf.Hash = value.String
			}
		case workspacefile.FieldLanguage:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field language", values[i])
			} else if value.Valid {
				wf.Language = value.String
			}
		case workspacefile.FieldSize:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field size", values[i])
			} else if value.Valid {
				wf.Size = value.Int64
			}
		case workspacefile.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				wf.CreatedAt = value.Time
			}
		case workspacefile.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				wf.UpdatedAt = value.Time
			}
		default:
			wf.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the WorkspaceFile.
// This includes values selected through modifiers, order, etc.
func (wf *WorkspaceFile) Value(name string) (ent.Value, error) {
	return wf.selectValues.Get(name)
}

// QueryOwner queries the "owner" edge of the WorkspaceFile entity.
func (wf *WorkspaceFile) QueryOwner() *UserQuery {
	return NewWorkspaceFileClient(wf.config).QueryOwner(wf)
}

// QueryWorkspace queries the "workspace" edge of the WorkspaceFile entity.
func (wf *WorkspaceFile) QueryWorkspace() *WorkspaceQuery {
	return NewWorkspaceFileClient(wf.config).QueryWorkspace(wf)
}

// QuerySnippets queries the "snippets" edge of the WorkspaceFile entity.
func (wf *WorkspaceFile) QuerySnippets() *CodeSnippetQuery {
	return NewWorkspaceFileClient(wf.config).QuerySnippets(wf)
}

// Update returns a builder for updating this WorkspaceFile.
// Note that you need to call WorkspaceFile.Unwrap() before calling this method if this WorkspaceFile
// was returned from a transaction, and the transaction was committed or rolled back.
func (wf *WorkspaceFile) Update() *WorkspaceFileUpdateOne {
	return NewWorkspaceFileClient(wf.config).UpdateOne(wf)
}

// Unwrap unwraps the WorkspaceFile entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (wf *WorkspaceFile) Unwrap() *WorkspaceFile {
	_tx, ok := wf.config.driver.(*txDriver)
	if !ok {
		panic("db: WorkspaceFile is not a transactional entity")
	}
	wf.config.driver = _tx.drv
	return wf
}

// String implements the fmt.Stringer.
func (wf *WorkspaceFile) String() string {
	var builder strings.Builder
	builder.WriteString("WorkspaceFile(")
	builder.WriteString(fmt.Sprintf("id=%v, ", wf.ID))
	builder.WriteString("user_id=")
	builder.WriteString(fmt.Sprintf("%v", wf.UserID))
	builder.WriteString(", ")
	builder.WriteString("workspace_id=")
	builder.WriteString(fmt.Sprintf("%v", wf.WorkspaceID))
	builder.WriteString(", ")
	builder.WriteString("path=")
	builder.WriteString(wf.Path)
	builder.WriteString(", ")
	builder.WriteString("content=")
	builder.WriteString(wf.Content)
	builder.WriteString(", ")
	builder.WriteString("hash=")
	builder.WriteString(wf.Hash)
	builder.WriteString(", ")
	builder.WriteString("language=")
	builder.WriteString(wf.Language)
	builder.WriteString(", ")
	builder.WriteString("size=")
	builder.WriteString(fmt.Sprintf("%v", wf.Size))
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(wf.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(wf.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// WorkspaceFiles is a parsable slice of WorkspaceFile.
type WorkspaceFiles []*WorkspaceFile
