// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/codesnippet"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/workspace"
	"github.com/chaitin/MonkeyCode/backend/db/workspacefile"
	"github.com/google/uuid"
)

// WorkspaceFileCreate is the builder for creating a WorkspaceFile entity.
type WorkspaceFileCreate struct {
	config
	mutation *WorkspaceFileMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetUserID sets the "user_id" field.
func (wfc *WorkspaceFileCreate) SetUserID(u uuid.UUID) *WorkspaceFileCreate {
	wfc.mutation.SetUserID(u)
	return wfc
}

// SetWorkspaceID sets the "workspace_id" field.
func (wfc *WorkspaceFileCreate) SetWorkspaceID(u uuid.UUID) *WorkspaceFileCreate {
	wfc.mutation.SetWorkspaceID(u)
	return wfc
}

// SetPath sets the "path" field.
func (wfc *WorkspaceFileCreate) SetPath(s string) *WorkspaceFileCreate {
	wfc.mutation.SetPath(s)
	return wfc
}

// SetContent sets the "content" field.
func (wfc *WorkspaceFileCreate) SetContent(s string) *WorkspaceFileCreate {
	wfc.mutation.SetContent(s)
	return wfc
}

// SetNillableContent sets the "content" field if the given value is not nil.
func (wfc *WorkspaceFileCreate) SetNillableContent(s *string) *WorkspaceFileCreate {
	if s != nil {
		wfc.SetContent(*s)
	}
	return wfc
}

// SetHash sets the "hash" field.
func (wfc *WorkspaceFileCreate) SetHash(s string) *WorkspaceFileCreate {
	wfc.mutation.SetHash(s)
	return wfc
}

// SetLanguage sets the "language" field.
func (wfc *WorkspaceFileCreate) SetLanguage(s string) *WorkspaceFileCreate {
	wfc.mutation.SetLanguage(s)
	return wfc
}

// SetNillableLanguage sets the "language" field if the given value is not nil.
func (wfc *WorkspaceFileCreate) SetNillableLanguage(s *string) *WorkspaceFileCreate {
	if s != nil {
		wfc.SetLanguage(*s)
	}
	return wfc
}

// SetSize sets the "size" field.
func (wfc *WorkspaceFileCreate) SetSize(i int64) *WorkspaceFileCreate {
	wfc.mutation.SetSize(i)
	return wfc
}

// SetNillableSize sets the "size" field if the given value is not nil.
func (wfc *WorkspaceFileCreate) SetNillableSize(i *int64) *WorkspaceFileCreate {
	if i != nil {
		wfc.SetSize(*i)
	}
	return wfc
}

// SetCreatedAt sets the "created_at" field.
func (wfc *WorkspaceFileCreate) SetCreatedAt(t time.Time) *WorkspaceFileCreate {
	wfc.mutation.SetCreatedAt(t)
	return wfc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (wfc *WorkspaceFileCreate) SetNillableCreatedAt(t *time.Time) *WorkspaceFileCreate {
	if t != nil {
		wfc.SetCreatedAt(*t)
	}
	return wfc
}

// SetUpdatedAt sets the "updated_at" field.
func (wfc *WorkspaceFileCreate) SetUpdatedAt(t time.Time) *WorkspaceFileCreate {
	wfc.mutation.SetUpdatedAt(t)
	return wfc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (wfc *WorkspaceFileCreate) SetNillableUpdatedAt(t *time.Time) *WorkspaceFileCreate {
	if t != nil {
		wfc.SetUpdatedAt(*t)
	}
	return wfc
}

// SetID sets the "id" field.
func (wfc *WorkspaceFileCreate) SetID(u uuid.UUID) *WorkspaceFileCreate {
	wfc.mutation.SetID(u)
	return wfc
}

// SetOwnerID sets the "owner" edge to the User entity by ID.
func (wfc *WorkspaceFileCreate) SetOwnerID(id uuid.UUID) *WorkspaceFileCreate {
	wfc.mutation.SetOwnerID(id)
	return wfc
}

// SetOwner sets the "owner" edge to the User entity.
func (wfc *WorkspaceFileCreate) SetOwner(u *User) *WorkspaceFileCreate {
	return wfc.SetOwnerID(u.ID)
}

// SetWorkspace sets the "workspace" edge to the Workspace entity.
func (wfc *WorkspaceFileCreate) SetWorkspace(w *Workspace) *WorkspaceFileCreate {
	return wfc.SetWorkspaceID(w.ID)
}

// AddSnippetIDs adds the "snippets" edge to the CodeSnippet entity by IDs.
func (wfc *WorkspaceFileCreate) AddSnippetIDs(ids ...uuid.UUID) *WorkspaceFileCreate {
	wfc.mutation.AddSnippetIDs(ids...)
	return wfc
}

// AddSnippets adds the "snippets" edges to the CodeSnippet entity.
func (wfc *WorkspaceFileCreate) AddSnippets(c ...*CodeSnippet) *WorkspaceFileCreate {
	ids := make([]uuid.UUID, len(c))
	for i := range c {
		ids[i] = c[i].ID
	}
	return wfc.AddSnippetIDs(ids...)
}

// Mutation returns the WorkspaceFileMutation object of the builder.
func (wfc *WorkspaceFileCreate) Mutation() *WorkspaceFileMutation {
	return wfc.mutation
}

// Save creates the WorkspaceFile in the database.
func (wfc *WorkspaceFileCreate) Save(ctx context.Context) (*WorkspaceFile, error) {
	wfc.defaults()
	return withHooks(ctx, wfc.sqlSave, wfc.mutation, wfc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (wfc *WorkspaceFileCreate) SaveX(ctx context.Context) *WorkspaceFile {
	v, err := wfc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (wfc *WorkspaceFileCreate) Exec(ctx context.Context) error {
	_, err := wfc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (wfc *WorkspaceFileCreate) ExecX(ctx context.Context) {
	if err := wfc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (wfc *WorkspaceFileCreate) defaults() {
	if _, ok := wfc.mutation.Size(); !ok {
		v := workspacefile.DefaultSize
		wfc.mutation.SetSize(v)
	}
	if _, ok := wfc.mutation.CreatedAt(); !ok {
		v := workspacefile.DefaultCreatedAt()
		wfc.mutation.SetCreatedAt(v)
	}
	if _, ok := wfc.mutation.UpdatedAt(); !ok {
		v := workspacefile.DefaultUpdatedAt()
		wfc.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (wfc *WorkspaceFileCreate) check() error {
	if _, ok := wfc.mutation.UserID(); !ok {
		return &ValidationError{Name: "user_id", err: errors.New(`db: missing required field "WorkspaceFile.user_id"`)}
	}
	if _, ok := wfc.mutation.WorkspaceID(); !ok {
		return &ValidationError{Name: "workspace_id", err: errors.New(`db: missing required field "WorkspaceFile.workspace_id"`)}
	}
	if _, ok := wfc.mutation.Path(); !ok {
		return &ValidationError{Name: "path", err: errors.New(`db: missing required field "WorkspaceFile.path"`)}
	}
	if v, ok := wfc.mutation.Path(); ok {
		if err := workspacefile.PathValidator(v); err != nil {
			return &ValidationError{Name: "path", err: fmt.Errorf(`db: validator failed for field "WorkspaceFile.path": %w`, err)}
		}
	}
	if _, ok := wfc.mutation.Hash(); !ok {
		return &ValidationError{Name: "hash", err: errors.New(`db: missing required field "WorkspaceFile.hash"`)}
	}
	if v, ok := wfc.mutation.Hash(); ok {
		if err := workspacefile.HashValidator(v); err != nil {
			return &ValidationError{Name: "hash", err: fmt.Errorf(`db: validator failed for field "WorkspaceFile.hash": %w`, err)}
		}
	}
	if _, ok := wfc.mutation.Size(); !ok {
		return &ValidationError{Name: "size", err: errors.New(`db: missing required field "WorkspaceFile.size"`)}
	}
	if _, ok := wfc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "WorkspaceFile.created_at"`)}
	}
	if _, ok := wfc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "WorkspaceFile.updated_at"`)}
	}
	if len(wfc.mutation.OwnerIDs()) == 0 {
		return &ValidationError{Name: "owner", err: errors.New(`db: missing required edge "WorkspaceFile.owner"`)}
	}
	if len(wfc.mutation.WorkspaceIDs()) == 0 {
		return &ValidationError{Name: "workspace", err: errors.New(`db: missing required edge "WorkspaceFile.workspace"`)}
	}
	return nil
}

func (wfc *WorkspaceFileCreate) sqlSave(ctx context.Context) (*WorkspaceFile, error) {
	if err := wfc.check(); err != nil {
		return nil, err
	}
	_node, _spec := wfc.createSpec()
	if err := sqlgraph.CreateNode(ctx, wfc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	wfc.mutation.id = &_node.ID
	wfc.mutation.done = true
	return _node, nil
}

func (wfc *WorkspaceFileCreate) createSpec() (*WorkspaceFile, *sqlgraph.CreateSpec) {
	var (
		_node = &WorkspaceFile{config: wfc.config}
		_spec = sqlgraph.NewCreateSpec(workspacefile.Table, sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = wfc.conflict
	if id, ok := wfc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := wfc.mutation.Path(); ok {
		_spec.SetField(workspacefile.FieldPath, field.TypeString, value)
		_node.Path = value
	}
	if value, ok := wfc.mutation.Content(); ok {
		_spec.SetField(workspacefile.FieldContent, field.TypeString, value)
		_node.Content = value
	}
	if value, ok := wfc.mutation.Hash(); ok {
		_spec.SetField(workspacefile.FieldHash, field.TypeString, value)
		_node.Hash = value
	}
	if value, ok := wfc.mutation.Language(); ok {
		_spec.SetField(workspacefile.FieldLanguage, field.TypeString, value)
		_node.Language = value
	}
	if value, ok := wfc.mutation.Size(); ok {
		_spec.SetField(workspacefile.FieldSize, field.TypeInt64, value)
		_node.Size = value
	}
	if value, ok := wfc.mutation.CreatedAt(); ok {
		_spec.SetField(workspacefile.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := wfc.mutation.UpdatedAt(); ok {
		_spec.SetField(workspacefile.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if nodes := wfc.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspacefile.OwnerTable,
			Columns: []string{workspacefile.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.UserID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := wfc.mutation.WorkspaceIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspacefile.WorkspaceTable,
			Columns: []string{workspacefile.WorkspaceColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspace.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.WorkspaceID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := wfc.mutation.SnippetsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspacefile.SnippetsTable,
			Columns: []string{workspacefile.SnippetsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(codesnippet.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.WorkspaceFile.Create().
//		SetUserID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.WorkspaceFileUpsert) {
//			SetUserID(v+v).
//		}).
//		Exec(ctx)
func (wfc *WorkspaceFileCreate) OnConflict(opts ...sql.ConflictOption) *WorkspaceFileUpsertOne {
	wfc.conflict = opts
	return &WorkspaceFileUpsertOne{
		create: wfc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.WorkspaceFile.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (wfc *WorkspaceFileCreate) OnConflictColumns(columns ...string) *WorkspaceFileUpsertOne {
	wfc.conflict = append(wfc.conflict, sql.ConflictColumns(columns...))
	return &WorkspaceFileUpsertOne{
		create: wfc,
	}
}

type (
	// WorkspaceFileUpsertOne is the builder for "upsert"-ing
	//  one WorkspaceFile node.
	WorkspaceFileUpsertOne struct {
		create *WorkspaceFileCreate
	}

	// WorkspaceFileUpsert is the "OnConflict" setter.
	WorkspaceFileUpsert struct {
		*sql.UpdateSet
	}
)

// SetUserID sets the "user_id" field.
func (u *WorkspaceFileUpsert) SetUserID(v uuid.UUID) *WorkspaceFileUpsert {
	u.Set(workspacefile.FieldUserID, v)
	return u
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *WorkspaceFileUpsert) UpdateUserID() *WorkspaceFileUpsert {
	u.SetExcluded(workspacefile.FieldUserID)
	return u
}

// SetWorkspaceID sets the "workspace_id" field.
func (u *WorkspaceFileUpsert) SetWorkspaceID(v uuid.UUID) *WorkspaceFileUpsert {
	u.Set(workspacefile.FieldWorkspaceID, v)
	return u
}

// UpdateWorkspaceID sets the "workspace_id" field to the value that was provided on create.
func (u *WorkspaceFileUpsert) UpdateWorkspaceID() *WorkspaceFileUpsert {
	u.SetExcluded(workspacefile.FieldWorkspaceID)
	return u
}

// SetPath sets the "path" field.
func (u *WorkspaceFileUpsert) SetPath(v string) *WorkspaceFileUpsert {
	u.Set(workspacefile.FieldPath, v)
	return u
}

// UpdatePath sets the "path" field to the value that was provided on create.
func (u *WorkspaceFileUpsert) UpdatePath() *WorkspaceFileUpsert {
	u.SetExcluded(workspacefile.FieldPath)
	return u
}

// SetContent sets the "content" field.
func (u *WorkspaceFileUpsert) SetContent(v string) *WorkspaceFileUpsert {
	u.Set(workspacefile.FieldContent, v)
	return u
}

// UpdateContent sets the "content" field to the value that was provided on create.
func (u *WorkspaceFileUpsert) UpdateContent() *WorkspaceFileUpsert {
	u.SetExcluded(workspacefile.FieldContent)
	return u
}

// ClearContent clears the value of the "content" field.
func (u *WorkspaceFileUpsert) ClearContent() *WorkspaceFileUpsert {
	u.SetNull(workspacefile.FieldContent)
	return u
}

// SetHash sets the "hash" field.
func (u *WorkspaceFileUpsert) SetHash(v string) *WorkspaceFileUpsert {
	u.Set(workspacefile.FieldHash, v)
	return u
}

// UpdateHash sets the "hash" field to the value that was provided on create.
func (u *WorkspaceFileUpsert) UpdateHash() *WorkspaceFileUpsert {
	u.SetExcluded(workspacefile.FieldHash)
	return u
}

// SetLanguage sets the "language" field.
func (u *WorkspaceFileUpsert) SetLanguage(v string) *WorkspaceFileUpsert {
	u.Set(workspacefile.FieldLanguage, v)
	return u
}

// UpdateLanguage sets the "language" field to the value that was provided on create.
func (u *WorkspaceFileUpsert) UpdateLanguage() *WorkspaceFileUpsert {
	u.SetExcluded(workspacefile.FieldLanguage)
	return u
}

// ClearLanguage clears the value of the "language" field.
func (u *WorkspaceFileUpsert) ClearLanguage() *WorkspaceFileUpsert {
	u.SetNull(workspacefile.FieldLanguage)
	return u
}

// SetSize sets the "size" field.
func (u *WorkspaceFileUpsert) SetSize(v int64) *WorkspaceFileUpsert {
	u.Set(workspacefile.FieldSize, v)
	return u
}

// UpdateSize sets the "size" field to the value that was provided on create.
func (u *WorkspaceFileUpsert) UpdateSize() *WorkspaceFileUpsert {
	u.SetExcluded(workspacefile.FieldSize)
	return u
}

// AddSize adds v to the "size" field.
func (u *WorkspaceFileUpsert) AddSize(v int64) *WorkspaceFileUpsert {
	u.Add(workspacefile.FieldSize, v)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *WorkspaceFileUpsert) SetUpdatedAt(v time.Time) *WorkspaceFileUpsert {
	u.Set(workspacefile.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *WorkspaceFileUpsert) UpdateUpdatedAt() *WorkspaceFileUpsert {
	u.SetExcluded(workspacefile.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.WorkspaceFile.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(workspacefile.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *WorkspaceFileUpsertOne) UpdateNewValues() *WorkspaceFileUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(workspacefile.FieldID)
		}
		if _, exists := u.create.mutation.CreatedAt(); exists {
			s.SetIgnore(workspacefile.FieldCreatedAt)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.WorkspaceFile.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *WorkspaceFileUpsertOne) Ignore() *WorkspaceFileUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *WorkspaceFileUpsertOne) DoNothing() *WorkspaceFileUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the WorkspaceFileCreate.OnConflict
// documentation for more info.
func (u *WorkspaceFileUpsertOne) Update(set func(*WorkspaceFileUpsert)) *WorkspaceFileUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&WorkspaceFileUpsert{UpdateSet: update})
	}))
	return u
}

// SetUserID sets the "user_id" field.
func (u *WorkspaceFileUpsertOne) SetUserID(v uuid.UUID) *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *WorkspaceFileUpsertOne) UpdateUserID() *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdateUserID()
	})
}

// SetWorkspaceID sets the "workspace_id" field.
func (u *WorkspaceFileUpsertOne) SetWorkspaceID(v uuid.UUID) *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetWorkspaceID(v)
	})
}

// UpdateWorkspaceID sets the "workspace_id" field to the value that was provided on create.
func (u *WorkspaceFileUpsertOne) UpdateWorkspaceID() *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdateWorkspaceID()
	})
}

// SetPath sets the "path" field.
func (u *WorkspaceFileUpsertOne) SetPath(v string) *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetPath(v)
	})
}

// UpdatePath sets the "path" field to the value that was provided on create.
func (u *WorkspaceFileUpsertOne) UpdatePath() *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdatePath()
	})
}

// SetContent sets the "content" field.
func (u *WorkspaceFileUpsertOne) SetContent(v string) *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetContent(v)
	})
}

// UpdateContent sets the "content" field to the value that was provided on create.
func (u *WorkspaceFileUpsertOne) UpdateContent() *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdateContent()
	})
}

// ClearContent clears the value of the "content" field.
func (u *WorkspaceFileUpsertOne) ClearContent() *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.ClearContent()
	})
}

// SetHash sets the "hash" field.
func (u *WorkspaceFileUpsertOne) SetHash(v string) *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetHash(v)
	})
}

// UpdateHash sets the "hash" field to the value that was provided on create.
func (u *WorkspaceFileUpsertOne) UpdateHash() *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdateHash()
	})
}

// SetLanguage sets the "language" field.
func (u *WorkspaceFileUpsertOne) SetLanguage(v string) *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetLanguage(v)
	})
}

// UpdateLanguage sets the "language" field to the value that was provided on create.
func (u *WorkspaceFileUpsertOne) UpdateLanguage() *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdateLanguage()
	})
}

// ClearLanguage clears the value of the "language" field.
func (u *WorkspaceFileUpsertOne) ClearLanguage() *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.ClearLanguage()
	})
}

// SetSize sets the "size" field.
func (u *WorkspaceFileUpsertOne) SetSize(v int64) *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetSize(v)
	})
}

// AddSize adds v to the "size" field.
func (u *WorkspaceFileUpsertOne) AddSize(v int64) *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.AddSize(v)
	})
}

// UpdateSize sets the "size" field to the value that was provided on create.
func (u *WorkspaceFileUpsertOne) UpdateSize() *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdateSize()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *WorkspaceFileUpsertOne) SetUpdatedAt(v time.Time) *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *WorkspaceFileUpsertOne) UpdateUpdatedAt() *WorkspaceFileUpsertOne {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *WorkspaceFileUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for WorkspaceFileCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *WorkspaceFileUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *WorkspaceFileUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: WorkspaceFileUpsertOne.ID is not supported by MySQL driver. Use WorkspaceFileUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *WorkspaceFileUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// WorkspaceFileCreateBulk is the builder for creating many WorkspaceFile entities in bulk.
type WorkspaceFileCreateBulk struct {
	config
	err      error
	builders []*WorkspaceFileCreate
	conflict []sql.ConflictOption
}

// Save creates the WorkspaceFile entities in the database.
func (wfcb *WorkspaceFileCreateBulk) Save(ctx context.Context) ([]*WorkspaceFile, error) {
	if wfcb.err != nil {
		return nil, wfcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(wfcb.builders))
	nodes := make([]*WorkspaceFile, len(wfcb.builders))
	mutators := make([]Mutator, len(wfcb.builders))
	for i := range wfcb.builders {
		func(i int, root context.Context) {
			builder := wfcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*WorkspaceFileMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, wfcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = wfcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, wfcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, wfcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (wfcb *WorkspaceFileCreateBulk) SaveX(ctx context.Context) []*WorkspaceFile {
	v, err := wfcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (wfcb *WorkspaceFileCreateBulk) Exec(ctx context.Context) error {
	_, err := wfcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (wfcb *WorkspaceFileCreateBulk) ExecX(ctx context.Context) {
	if err := wfcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.WorkspaceFile.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.WorkspaceFileUpsert) {
//			SetUserID(v+v).
//		}).
//		Exec(ctx)
func (wfcb *WorkspaceFileCreateBulk) OnConflict(opts ...sql.ConflictOption) *WorkspaceFileUpsertBulk {
	wfcb.conflict = opts
	return &WorkspaceFileUpsertBulk{
		create: wfcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.WorkspaceFile.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (wfcb *WorkspaceFileCreateBulk) OnConflictColumns(columns ...string) *WorkspaceFileUpsertBulk {
	wfcb.conflict = append(wfcb.conflict, sql.ConflictColumns(columns...))
	return &WorkspaceFileUpsertBulk{
		create: wfcb,
	}
}

// WorkspaceFileUpsertBulk is the builder for "upsert"-ing
// a bulk of WorkspaceFile nodes.
type WorkspaceFileUpsertBulk struct {
	create *WorkspaceFileCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.WorkspaceFile.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(workspacefile.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *WorkspaceFileUpsertBulk) UpdateNewValues() *WorkspaceFileUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(workspacefile.FieldID)
			}
			if _, exists := b.mutation.CreatedAt(); exists {
				s.SetIgnore(workspacefile.FieldCreatedAt)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.WorkspaceFile.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *WorkspaceFileUpsertBulk) Ignore() *WorkspaceFileUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *WorkspaceFileUpsertBulk) DoNothing() *WorkspaceFileUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the WorkspaceFileCreateBulk.OnConflict
// documentation for more info.
func (u *WorkspaceFileUpsertBulk) Update(set func(*WorkspaceFileUpsert)) *WorkspaceFileUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&WorkspaceFileUpsert{UpdateSet: update})
	}))
	return u
}

// SetUserID sets the "user_id" field.
func (u *WorkspaceFileUpsertBulk) SetUserID(v uuid.UUID) *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *WorkspaceFileUpsertBulk) UpdateUserID() *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdateUserID()
	})
}

// SetWorkspaceID sets the "workspace_id" field.
func (u *WorkspaceFileUpsertBulk) SetWorkspaceID(v uuid.UUID) *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetWorkspaceID(v)
	})
}

// UpdateWorkspaceID sets the "workspace_id" field to the value that was provided on create.
func (u *WorkspaceFileUpsertBulk) UpdateWorkspaceID() *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdateWorkspaceID()
	})
}

// SetPath sets the "path" field.
func (u *WorkspaceFileUpsertBulk) SetPath(v string) *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetPath(v)
	})
}

// UpdatePath sets the "path" field to the value that was provided on create.
func (u *WorkspaceFileUpsertBulk) UpdatePath() *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdatePath()
	})
}

// SetContent sets the "content" field.
func (u *WorkspaceFileUpsertBulk) SetContent(v string) *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetContent(v)
	})
}

// UpdateContent sets the "content" field to the value that was provided on create.
func (u *WorkspaceFileUpsertBulk) UpdateContent() *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdateContent()
	})
}

// ClearContent clears the value of the "content" field.
func (u *WorkspaceFileUpsertBulk) ClearContent() *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.ClearContent()
	})
}

// SetHash sets the "hash" field.
func (u *WorkspaceFileUpsertBulk) SetHash(v string) *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetHash(v)
	})
}

// UpdateHash sets the "hash" field to the value that was provided on create.
func (u *WorkspaceFileUpsertBulk) UpdateHash() *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdateHash()
	})
}

// SetLanguage sets the "language" field.
func (u *WorkspaceFileUpsertBulk) SetLanguage(v string) *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetLanguage(v)
	})
}

// UpdateLanguage sets the "language" field to the value that was provided on create.
func (u *WorkspaceFileUpsertBulk) UpdateLanguage() *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdateLanguage()
	})
}

// ClearLanguage clears the value of the "language" field.
func (u *WorkspaceFileUpsertBulk) ClearLanguage() *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.ClearLanguage()
	})
}

// SetSize sets the "size" field.
func (u *WorkspaceFileUpsertBulk) SetSize(v int64) *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetSize(v)
	})
}

// AddSize adds v to the "size" field.
func (u *WorkspaceFileUpsertBulk) AddSize(v int64) *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.AddSize(v)
	})
}

// UpdateSize sets the "size" field to the value that was provided on create.
func (u *WorkspaceFileUpsertBulk) UpdateSize() *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdateSize()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *WorkspaceFileUpsertBulk) SetUpdatedAt(v time.Time) *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *WorkspaceFileUpsertBulk) UpdateUpdatedAt() *WorkspaceFileUpsertBulk {
	return u.Update(func(s *WorkspaceFileUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *WorkspaceFileUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the WorkspaceFileCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for WorkspaceFileCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *WorkspaceFileUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
