// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/workspacefile"
)

// WorkspaceFileDelete is the builder for deleting a WorkspaceFile entity.
type WorkspaceFileDelete struct {
	config
	hooks    []Hook
	mutation *WorkspaceFileMutation
}

// Where appends a list predicates to the WorkspaceFileDelete builder.
func (wfd *WorkspaceFileDelete) Where(ps ...predicate.WorkspaceFile) *WorkspaceFileDelete {
	wfd.mutation.Where(ps...)
	return wfd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (wfd *WorkspaceFileDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, wfd.sqlExec, wfd.mutation, wfd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (wfd *WorkspaceFileDelete) ExecX(ctx context.Context) int {
	n, err := wfd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (wfd *WorkspaceFileDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(workspacefile.Table, sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID))
	if ps := wfd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, wfd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	wfd.mutation.done = true
	return affected, err
}

// WorkspaceFileDeleteOne is the builder for deleting a single WorkspaceFile entity.
type WorkspaceFileDeleteOne struct {
	wfd *WorkspaceFileDelete
}

// Where appends a list predicates to the WorkspaceFileDelete builder.
func (wfdo *WorkspaceFileDeleteOne) Where(ps ...predicate.WorkspaceFile) *WorkspaceFileDeleteOne {
	wfdo.wfd.mutation.Where(ps...)
	return wfdo
}

// Exec executes the deletion query.
func (wfdo *WorkspaceFileDeleteOne) Exec(ctx context.Context) error {
	n, err := wfdo.wfd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{workspacefile.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (wfdo *WorkspaceFileDeleteOne) ExecX(ctx context.Context) {
	if err := wfdo.Exec(ctx); err != nil {
		panic(err)
	}
}
