// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/codesnippet"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/workspace"
	"github.com/chaitin/MonkeyCode/backend/db/workspacefile"
	"github.com/google/uuid"
)

// WorkspaceFileUpdate is the builder for updating WorkspaceFile entities.
type WorkspaceFileUpdate struct {
	config
	hooks     []Hook
	mutation  *WorkspaceFileMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the WorkspaceFileUpdate builder.
func (wfu *WorkspaceFileUpdate) Where(ps ...predicate.WorkspaceFile) *WorkspaceFileUpdate {
	wfu.mutation.Where(ps...)
	return wfu
}

// SetUserID sets the "user_id" field.
func (wfu *WorkspaceFileUpdate) SetUserID(u uuid.UUID) *WorkspaceFileUpdate {
	wfu.mutation.SetUserID(u)
	return wfu
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (wfu *WorkspaceFileUpdate) SetNillableUserID(u *uuid.UUID) *WorkspaceFileUpdate {
	if u != nil {
		wfu.SetUserID(*u)
	}
	return wfu
}

// SetWorkspaceID sets the "workspace_id" field.
func (wfu *WorkspaceFileUpdate) SetWorkspaceID(u uuid.UUID) *WorkspaceFileUpdate {
	wfu.mutation.SetWorkspaceID(u)
	return wfu
}

// SetNillableWorkspaceID sets the "workspace_id" field if the given value is not nil.
func (wfu *WorkspaceFileUpdate) SetNillableWorkspaceID(u *uuid.UUID) *WorkspaceFileUpdate {
	if u != nil {
		wfu.SetWorkspaceID(*u)
	}
	return wfu
}

// SetPath sets the "path" field.
func (wfu *WorkspaceFileUpdate) SetPath(s string) *WorkspaceFileUpdate {
	wfu.mutation.SetPath(s)
	return wfu
}

// SetNillablePath sets the "path" field if the given value is not nil.
func (wfu *WorkspaceFileUpdate) SetNillablePath(s *string) *WorkspaceFileUpdate {
	if s != nil {
		wfu.SetPath(*s)
	}
	return wfu
}

// SetContent sets the "content" field.
func (wfu *WorkspaceFileUpdate) SetContent(s string) *WorkspaceFileUpdate {
	wfu.mutation.SetContent(s)
	return wfu
}

// SetNillableContent sets the "content" field if the given value is not nil.
func (wfu *WorkspaceFileUpdate) SetNillableContent(s *string) *WorkspaceFileUpdate {
	if s != nil {
		wfu.SetContent(*s)
	}
	return wfu
}

// ClearContent clears the value of the "content" field.
func (wfu *WorkspaceFileUpdate) ClearContent() *WorkspaceFileUpdate {
	wfu.mutation.ClearContent()
	return wfu
}

// SetHash sets the "hash" field.
func (wfu *WorkspaceFileUpdate) SetHash(s string) *WorkspaceFileUpdate {
	wfu.mutation.SetHash(s)
	return wfu
}

// SetNillableHash sets the "hash" field if the given value is not nil.
func (wfu *WorkspaceFileUpdate) SetNillableHash(s *string) *WorkspaceFileUpdate {
	if s != nil {
		wfu.SetHash(*s)
	}
	return wfu
}

// SetLanguage sets the "language" field.
func (wfu *WorkspaceFileUpdate) SetLanguage(s string) *WorkspaceFileUpdate {
	wfu.mutation.SetLanguage(s)
	return wfu
}

// SetNillableLanguage sets the "language" field if the given value is not nil.
func (wfu *WorkspaceFileUpdate) SetNillableLanguage(s *string) *WorkspaceFileUpdate {
	if s != nil {
		wfu.SetLanguage(*s)
	}
	return wfu
}

// ClearLanguage clears the value of the "language" field.
func (wfu *WorkspaceFileUpdate) ClearLanguage() *WorkspaceFileUpdate {
	wfu.mutation.ClearLanguage()
	return wfu
}

// SetSize sets the "size" field.
func (wfu *WorkspaceFileUpdate) SetSize(i int64) *WorkspaceFileUpdate {
	wfu.mutation.ResetSize()
	wfu.mutation.SetSize(i)
	return wfu
}

// SetNillableSize sets the "size" field if the given value is not nil.
func (wfu *WorkspaceFileUpdate) SetNillableSize(i *int64) *WorkspaceFileUpdate {
	if i != nil {
		wfu.SetSize(*i)
	}
	return wfu
}

// AddSize adds i to the "size" field.
func (wfu *WorkspaceFileUpdate) AddSize(i int64) *WorkspaceFileUpdate {
	wfu.mutation.AddSize(i)
	return wfu
}

// SetUpdatedAt sets the "updated_at" field.
func (wfu *WorkspaceFileUpdate) SetUpdatedAt(t time.Time) *WorkspaceFileUpdate {
	wfu.mutation.SetUpdatedAt(t)
	return wfu
}

// SetOwnerID sets the "owner" edge to the User entity by ID.
func (wfu *WorkspaceFileUpdate) SetOwnerID(id uuid.UUID) *WorkspaceFileUpdate {
	wfu.mutation.SetOwnerID(id)
	return wfu
}

// SetOwner sets the "owner" edge to the User entity.
func (wfu *WorkspaceFileUpdate) SetOwner(u *User) *WorkspaceFileUpdate {
	return wfu.SetOwnerID(u.ID)
}

// SetWorkspace sets the "workspace" edge to the Workspace entity.
func (wfu *WorkspaceFileUpdate) SetWorkspace(w *Workspace) *WorkspaceFileUpdate {
	return wfu.SetWorkspaceID(w.ID)
}

// AddSnippetIDs adds the "snippets" edge to the CodeSnippet entity by IDs.
func (wfu *WorkspaceFileUpdate) AddSnippetIDs(ids ...uuid.UUID) *WorkspaceFileUpdate {
	wfu.mutation.AddSnippetIDs(ids...)
	return wfu
}

// AddSnippets adds the "snippets" edges to the CodeSnippet entity.
func (wfu *WorkspaceFileUpdate) AddSnippets(c ...*CodeSnippet) *WorkspaceFileUpdate {
	ids := make([]uuid.UUID, len(c))
	for i := range c {
		ids[i] = c[i].ID
	}
	return wfu.AddSnippetIDs(ids...)
}

// Mutation returns the WorkspaceFileMutation object of the builder.
func (wfu *WorkspaceFileUpdate) Mutation() *WorkspaceFileMutation {
	return wfu.mutation
}

// ClearOwner clears the "owner" edge to the User entity.
func (wfu *WorkspaceFileUpdate) ClearOwner() *WorkspaceFileUpdate {
	wfu.mutation.ClearOwner()
	return wfu
}

// ClearWorkspace clears the "workspace" edge to the Workspace entity.
func (wfu *WorkspaceFileUpdate) ClearWorkspace() *WorkspaceFileUpdate {
	wfu.mutation.ClearWorkspace()
	return wfu
}

// ClearSnippets clears all "snippets" edges to the CodeSnippet entity.
func (wfu *WorkspaceFileUpdate) ClearSnippets() *WorkspaceFileUpdate {
	wfu.mutation.ClearSnippets()
	return wfu
}

// RemoveSnippetIDs removes the "snippets" edge to CodeSnippet entities by IDs.
func (wfu *WorkspaceFileUpdate) RemoveSnippetIDs(ids ...uuid.UUID) *WorkspaceFileUpdate {
	wfu.mutation.RemoveSnippetIDs(ids...)
	return wfu
}

// RemoveSnippets removes "snippets" edges to CodeSnippet entities.
func (wfu *WorkspaceFileUpdate) RemoveSnippets(c ...*CodeSnippet) *WorkspaceFileUpdate {
	ids := make([]uuid.UUID, len(c))
	for i := range c {
		ids[i] = c[i].ID
	}
	return wfu.RemoveSnippetIDs(ids...)
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (wfu *WorkspaceFileUpdate) Save(ctx context.Context) (int, error) {
	wfu.defaults()
	return withHooks(ctx, wfu.sqlSave, wfu.mutation, wfu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (wfu *WorkspaceFileUpdate) SaveX(ctx context.Context) int {
	affected, err := wfu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (wfu *WorkspaceFileUpdate) Exec(ctx context.Context) error {
	_, err := wfu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (wfu *WorkspaceFileUpdate) ExecX(ctx context.Context) {
	if err := wfu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (wfu *WorkspaceFileUpdate) defaults() {
	if _, ok := wfu.mutation.UpdatedAt(); !ok {
		v := workspacefile.UpdateDefaultUpdatedAt()
		wfu.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (wfu *WorkspaceFileUpdate) check() error {
	if v, ok := wfu.mutation.Path(); ok {
		if err := workspacefile.PathValidator(v); err != nil {
			return &ValidationError{Name: "path", err: fmt.Errorf(`db: validator failed for field "WorkspaceFile.path": %w`, err)}
		}
	}
	if v, ok := wfu.mutation.Hash(); ok {
		if err := workspacefile.HashValidator(v); err != nil {
			return &ValidationError{Name: "hash", err: fmt.Errorf(`db: validator failed for field "WorkspaceFile.hash": %w`, err)}
		}
	}
	if wfu.mutation.OwnerCleared() && len(wfu.mutation.OwnerIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "WorkspaceFile.owner"`)
	}
	if wfu.mutation.WorkspaceCleared() && len(wfu.mutation.WorkspaceIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "WorkspaceFile.workspace"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (wfu *WorkspaceFileUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *WorkspaceFileUpdate {
	wfu.modifiers = append(wfu.modifiers, modifiers...)
	return wfu
}

func (wfu *WorkspaceFileUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := wfu.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(workspacefile.Table, workspacefile.Columns, sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID))
	if ps := wfu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := wfu.mutation.Path(); ok {
		_spec.SetField(workspacefile.FieldPath, field.TypeString, value)
	}
	if value, ok := wfu.mutation.Content(); ok {
		_spec.SetField(workspacefile.FieldContent, field.TypeString, value)
	}
	if wfu.mutation.ContentCleared() {
		_spec.ClearField(workspacefile.FieldContent, field.TypeString)
	}
	if value, ok := wfu.mutation.Hash(); ok {
		_spec.SetField(workspacefile.FieldHash, field.TypeString, value)
	}
	if value, ok := wfu.mutation.Language(); ok {
		_spec.SetField(workspacefile.FieldLanguage, field.TypeString, value)
	}
	if wfu.mutation.LanguageCleared() {
		_spec.ClearField(workspacefile.FieldLanguage, field.TypeString)
	}
	if value, ok := wfu.mutation.Size(); ok {
		_spec.SetField(workspacefile.FieldSize, field.TypeInt64, value)
	}
	if value, ok := wfu.mutation.AddedSize(); ok {
		_spec.AddField(workspacefile.FieldSize, field.TypeInt64, value)
	}
	if value, ok := wfu.mutation.UpdatedAt(); ok {
		_spec.SetField(workspacefile.FieldUpdatedAt, field.TypeTime, value)
	}
	if wfu.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspacefile.OwnerTable,
			Columns: []string{workspacefile.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wfu.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspacefile.OwnerTable,
			Columns: []string{workspacefile.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if wfu.mutation.WorkspaceCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspacefile.WorkspaceTable,
			Columns: []string{workspacefile.WorkspaceColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspace.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wfu.mutation.WorkspaceIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspacefile.WorkspaceTable,
			Columns: []string{workspacefile.WorkspaceColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspace.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if wfu.mutation.SnippetsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspacefile.SnippetsTable,
			Columns: []string{workspacefile.SnippetsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(codesnippet.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wfu.mutation.RemovedSnippetsIDs(); len(nodes) > 0 && !wfu.mutation.SnippetsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspacefile.SnippetsTable,
			Columns: []string{workspacefile.SnippetsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(codesnippet.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wfu.mutation.SnippetsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspacefile.SnippetsTable,
			Columns: []string{workspacefile.SnippetsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(codesnippet.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(wfu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, wfu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{workspacefile.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	wfu.mutation.done = true
	return n, nil
}

// WorkspaceFileUpdateOne is the builder for updating a single WorkspaceFile entity.
type WorkspaceFileUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *WorkspaceFileMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetUserID sets the "user_id" field.
func (wfuo *WorkspaceFileUpdateOne) SetUserID(u uuid.UUID) *WorkspaceFileUpdateOne {
	wfuo.mutation.SetUserID(u)
	return wfuo
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (wfuo *WorkspaceFileUpdateOne) SetNillableUserID(u *uuid.UUID) *WorkspaceFileUpdateOne {
	if u != nil {
		wfuo.SetUserID(*u)
	}
	return wfuo
}

// SetWorkspaceID sets the "workspace_id" field.
func (wfuo *WorkspaceFileUpdateOne) SetWorkspaceID(u uuid.UUID) *WorkspaceFileUpdateOne {
	wfuo.mutation.SetWorkspaceID(u)
	return wfuo
}

// SetNillableWorkspaceID sets the "workspace_id" field if the given value is not nil.
func (wfuo *WorkspaceFileUpdateOne) SetNillableWorkspaceID(u *uuid.UUID) *WorkspaceFileUpdateOne {
	if u != nil {
		wfuo.SetWorkspaceID(*u)
	}
	return wfuo
}

// SetPath sets the "path" field.
func (wfuo *WorkspaceFileUpdateOne) SetPath(s string) *WorkspaceFileUpdateOne {
	wfuo.mutation.SetPath(s)
	return wfuo
}

// SetNillablePath sets the "path" field if the given value is not nil.
func (wfuo *WorkspaceFileUpdateOne) SetNillablePath(s *string) *WorkspaceFileUpdateOne {
	if s != nil {
		wfuo.SetPath(*s)
	}
	return wfuo
}

// SetContent sets the "content" field.
func (wfuo *WorkspaceFileUpdateOne) SetContent(s string) *WorkspaceFileUpdateOne {
	wfuo.mutation.SetContent(s)
	return wfuo
}

// SetNillableContent sets the "content" field if the given value is not nil.
func (wfuo *WorkspaceFileUpdateOne) SetNillableContent(s *string) *WorkspaceFileUpdateOne {
	if s != nil {
		wfuo.SetContent(*s)
	}
	return wfuo
}

// ClearContent clears the value of the "content" field.
func (wfuo *WorkspaceFileUpdateOne) ClearContent() *WorkspaceFileUpdateOne {
	wfuo.mutation.ClearContent()
	return wfuo
}

// SetHash sets the "hash" field.
func (wfuo *WorkspaceFileUpdateOne) SetHash(s string) *WorkspaceFileUpdateOne {
	wfuo.mutation.SetHash(s)
	return wfuo
}

// SetNillableHash sets the "hash" field if the given value is not nil.
func (wfuo *WorkspaceFileUpdateOne) SetNillableHash(s *string) *WorkspaceFileUpdateOne {
	if s != nil {
		wfuo.SetHash(*s)
	}
	return wfuo
}

// SetLanguage sets the "language" field.
func (wfuo *WorkspaceFileUpdateOne) SetLanguage(s string) *WorkspaceFileUpdateOne {
	wfuo.mutation.SetLanguage(s)
	return wfuo
}

// SetNillableLanguage sets the "language" field if the given value is not nil.
func (wfuo *WorkspaceFileUpdateOne) SetNillableLanguage(s *string) *WorkspaceFileUpdateOne {
	if s != nil {
		wfuo.SetLanguage(*s)
	}
	return wfuo
}

// ClearLanguage clears the value of the "language" field.
func (wfuo *WorkspaceFileUpdateOne) ClearLanguage() *WorkspaceFileUpdateOne {
	wfuo.mutation.ClearLanguage()
	return wfuo
}

// SetSize sets the "size" field.
func (wfuo *WorkspaceFileUpdateOne) SetSize(i int64) *WorkspaceFileUpdateOne {
	wfuo.mutation.ResetSize()
	wfuo.mutation.SetSize(i)
	return wfuo
}

// SetNillableSize sets the "size" field if the given value is not nil.
func (wfuo *WorkspaceFileUpdateOne) SetNillableSize(i *int64) *WorkspaceFileUpdateOne {
	if i != nil {
		wfuo.SetSize(*i)
	}
	return wfuo
}

// AddSize adds i to the "size" field.
func (wfuo *WorkspaceFileUpdateOne) AddSize(i int64) *WorkspaceFileUpdateOne {
	wfuo.mutation.AddSize(i)
	return wfuo
}

// SetUpdatedAt sets the "updated_at" field.
func (wfuo *WorkspaceFileUpdateOne) SetUpdatedAt(t time.Time) *WorkspaceFileUpdateOne {
	wfuo.mutation.SetUpdatedAt(t)
	return wfuo
}

// SetOwnerID sets the "owner" edge to the User entity by ID.
func (wfuo *WorkspaceFileUpdateOne) SetOwnerID(id uuid.UUID) *WorkspaceFileUpdateOne {
	wfuo.mutation.SetOwnerID(id)
	return wfuo
}

// SetOwner sets the "owner" edge to the User entity.
func (wfuo *WorkspaceFileUpdateOne) SetOwner(u *User) *WorkspaceFileUpdateOne {
	return wfuo.SetOwnerID(u.ID)
}

// SetWorkspace sets the "workspace" edge to the Workspace entity.
func (wfuo *WorkspaceFileUpdateOne) SetWorkspace(w *Workspace) *WorkspaceFileUpdateOne {
	return wfuo.SetWorkspaceID(w.ID)
}

// AddSnippetIDs adds the "snippets" edge to the CodeSnippet entity by IDs.
func (wfuo *WorkspaceFileUpdateOne) AddSnippetIDs(ids ...uuid.UUID) *WorkspaceFileUpdateOne {
	wfuo.mutation.AddSnippetIDs(ids...)
	return wfuo
}

// AddSnippets adds the "snippets" edges to the CodeSnippet entity.
func (wfuo *WorkspaceFileUpdateOne) AddSnippets(c ...*CodeSnippet) *WorkspaceFileUpdateOne {
	ids := make([]uuid.UUID, len(c))
	for i := range c {
		ids[i] = c[i].ID
	}
	return wfuo.AddSnippetIDs(ids...)
}

// Mutation returns the WorkspaceFileMutation object of the builder.
func (wfuo *WorkspaceFileUpdateOne) Mutation() *WorkspaceFileMutation {
	return wfuo.mutation
}

// ClearOwner clears the "owner" edge to the User entity.
func (wfuo *WorkspaceFileUpdateOne) ClearOwner() *WorkspaceFileUpdateOne {
	wfuo.mutation.ClearOwner()
	return wfuo
}

// ClearWorkspace clears the "workspace" edge to the Workspace entity.
func (wfuo *WorkspaceFileUpdateOne) ClearWorkspace() *WorkspaceFileUpdateOne {
	wfuo.mutation.ClearWorkspace()
	return wfuo
}

// ClearSnippets clears all "snippets" edges to the CodeSnippet entity.
func (wfuo *WorkspaceFileUpdateOne) ClearSnippets() *WorkspaceFileUpdateOne {
	wfuo.mutation.ClearSnippets()
	return wfuo
}

// RemoveSnippetIDs removes the "snippets" edge to CodeSnippet entities by IDs.
func (wfuo *WorkspaceFileUpdateOne) RemoveSnippetIDs(ids ...uuid.UUID) *WorkspaceFileUpdateOne {
	wfuo.mutation.RemoveSnippetIDs(ids...)
	return wfuo
}

// RemoveSnippets removes "snippets" edges to CodeSnippet entities.
func (wfuo *WorkspaceFileUpdateOne) RemoveSnippets(c ...*CodeSnippet) *WorkspaceFileUpdateOne {
	ids := make([]uuid.UUID, len(c))
	for i := range c {
		ids[i] = c[i].ID
	}
	return wfuo.RemoveSnippetIDs(ids...)
}

// Where appends a list predicates to the WorkspaceFileUpdate builder.
func (wfuo *WorkspaceFileUpdateOne) Where(ps ...predicate.WorkspaceFile) *WorkspaceFileUpdateOne {
	wfuo.mutation.Where(ps...)
	return wfuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (wfuo *WorkspaceFileUpdateOne) Select(field string, fields ...string) *WorkspaceFileUpdateOne {
	wfuo.fields = append([]string{field}, fields...)
	return wfuo
}

// Save executes the query and returns the updated WorkspaceFile entity.
func (wfuo *WorkspaceFileUpdateOne) Save(ctx context.Context) (*WorkspaceFile, error) {
	wfuo.defaults()
	return withHooks(ctx, wfuo.sqlSave, wfuo.mutation, wfuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (wfuo *WorkspaceFileUpdateOne) SaveX(ctx context.Context) *WorkspaceFile {
	node, err := wfuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (wfuo *WorkspaceFileUpdateOne) Exec(ctx context.Context) error {
	_, err := wfuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (wfuo *WorkspaceFileUpdateOne) ExecX(ctx context.Context) {
	if err := wfuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (wfuo *WorkspaceFileUpdateOne) defaults() {
	if _, ok := wfuo.mutation.UpdatedAt(); !ok {
		v := workspacefile.UpdateDefaultUpdatedAt()
		wfuo.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (wfuo *WorkspaceFileUpdateOne) check() error {
	if v, ok := wfuo.mutation.Path(); ok {
		if err := workspacefile.PathValidator(v); err != nil {
			return &ValidationError{Name: "path", err: fmt.Errorf(`db: validator failed for field "WorkspaceFile.path": %w`, err)}
		}
	}
	if v, ok := wfuo.mutation.Hash(); ok {
		if err := workspacefile.HashValidator(v); err != nil {
			return &ValidationError{Name: "hash", err: fmt.Errorf(`db: validator failed for field "WorkspaceFile.hash": %w`, err)}
		}
	}
	if wfuo.mutation.OwnerCleared() && len(wfuo.mutation.OwnerIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "WorkspaceFile.owner"`)
	}
	if wfuo.mutation.WorkspaceCleared() && len(wfuo.mutation.WorkspaceIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "WorkspaceFile.workspace"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (wfuo *WorkspaceFileUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *WorkspaceFileUpdateOne {
	wfuo.modifiers = append(wfuo.modifiers, modifiers...)
	return wfuo
}

func (wfuo *WorkspaceFileUpdateOne) sqlSave(ctx context.Context) (_node *WorkspaceFile, err error) {
	if err := wfuo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(workspacefile.Table, workspacefile.Columns, sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID))
	id, ok := wfuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "WorkspaceFile.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := wfuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, workspacefile.FieldID)
		for _, f := range fields {
			if !workspacefile.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != workspacefile.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := wfuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := wfuo.mutation.Path(); ok {
		_spec.SetField(workspacefile.FieldPath, field.TypeString, value)
	}
	if value, ok := wfuo.mutation.Content(); ok {
		_spec.SetField(workspacefile.FieldContent, field.TypeString, value)
	}
	if wfuo.mutation.ContentCleared() {
		_spec.ClearField(workspacefile.FieldContent, field.TypeString)
	}
	if value, ok := wfuo.mutation.Hash(); ok {
		_spec.SetField(workspacefile.FieldHash, field.TypeString, value)
	}
	if value, ok := wfuo.mutation.Language(); ok {
		_spec.SetField(workspacefile.FieldLanguage, field.TypeString, value)
	}
	if wfuo.mutation.LanguageCleared() {
		_spec.ClearField(workspacefile.FieldLanguage, field.TypeString)
	}
	if value, ok := wfuo.mutation.Size(); ok {
		_spec.SetField(workspacefile.FieldSize, field.TypeInt64, value)
	}
	if value, ok := wfuo.mutation.AddedSize(); ok {
		_spec.AddField(workspacefile.FieldSize, field.TypeInt64, value)
	}
	if value, ok := wfuo.mutation.UpdatedAt(); ok {
		_spec.SetField(workspacefile.FieldUpdatedAt, field.TypeTime, value)
	}
	if wfuo.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspacefile.OwnerTable,
			Columns: []string{workspacefile.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wfuo.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspacefile.OwnerTable,
			Columns: []string{workspacefile.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if wfuo.mutation.WorkspaceCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspacefile.WorkspaceTable,
			Columns: []string{workspacefile.WorkspaceColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspace.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wfuo.mutation.WorkspaceIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   workspacefile.WorkspaceTable,
			Columns: []string{workspacefile.WorkspaceColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspace.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if wfuo.mutation.SnippetsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspacefile.SnippetsTable,
			Columns: []string{workspacefile.SnippetsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(codesnippet.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wfuo.mutation.RemovedSnippetsIDs(); len(nodes) > 0 && !wfuo.mutation.SnippetsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspacefile.SnippetsTable,
			Columns: []string{workspacefile.SnippetsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(codesnippet.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := wfuo.mutation.SnippetsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   workspacefile.SnippetsTable,
			Columns: []string{workspacefile.SnippetsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(codesnippet.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(wfuo.modifiers...)
	_node = &WorkspaceFile{config: wfuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, wfuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{workspacefile.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	wfuo.mutation.done = true
	return _node, nil
}
