# Highlight.js

Highlight.js highlights syntax in code examples on blogs, forums and,
in fact, on any web page. It's very easy to use because it works
automatically: finds blocks of code, detects a language, highlights it.

Autodetection can be fine tuned when it fails by itself (see "Heuristics").


## Basic usage

Link the library and a stylesheet from your page and hook highlighting to
the page load event:

```html
<link rel="stylesheet" href="styles/default.css">
<script src="highlight.pack.js"></script>
<script>hljs.initHighlightingOnLoad();</script>
```

This will highlight all code on the page marked up as `<pre><code> .. </code></pre>`.
If you use different markup or need to apply highlighting dynamically, read
"Custom initialization" below.

- You can download your own customized version of "highlight.pack.js" or
  use the hosted one as described on the download page:
  <http://softwaremaniacs.org/soft/highlight/en/download/>

- Style themes are available in the download package or as hosted files.
  To create a custom style for your site see the class reference in the file
  [classref.txt][cr] from the downloaded package.

[cr]: http://github.com/isagalaev/highlight.js/blob/master/classref.txt


## Tab replacement

You can replace TAB ('\x09') characters used for indentation in your code
with some fixed number of spaces or with a `<span>` to give them special
styling:

```html
<script type="text/javascript">
  hljs.tabReplace = '    '; // 4 spaces
  // ... or
  hljs.tabReplace = '<span class="indent">\t</span>';

  hljs.initHighlightingOnLoad();
</script>
```

## Custom initialization

If you use different markup for code blocks you can initialize them manually
with `highlightBlock(code, tabReplace, useBR)` function. It takes a DOM element
containing the code to highlight and optionally a string with which to replace
TAB characters.

Initialization using, for example, jQuery might look like this:

```javascript
$(document).ready(function() {
  $('pre code').each(function(i, e) {hljs.highlightBlock(e)});
});
```

You can use `highlightBlock` to highlight blocks dynamically inserted into
the page. Just make sure you don't do it twice for already highlighted
blocks.

If your code container relies on `<br>` tags instead of line breaks (i.e. if
it's not `<pre>`) pass `true` into the third parameter of `highlightBlock`
to make highlight.js use `<br>` in the output:

```javascript
$('div.code').each(function(i, e) {hljs.highlightBlock(e, null, true)});
```


## Heuristics

Autodetection of a code's language is done using a simple heuristic:
the program tries to highlight a fragment with all available languages and
counts all syntactic structures that it finds along the way. The language
with greatest count wins.

This means that in short fragments the probability of an error is high
(and it really happens sometimes). In this cases you can set the fragment's
language explicitly by assigning a class to the `<code>` element:

```html
<pre><code class="html">...</code></pre>
```

You can use class names recommended in HTML5: "language-html",
"language-php". Classes also can be assigned to the `<pre>` element.

To disable highlighting of a fragment altogether use "no-highlight" class:

```html
<pre><code class="no-highlight">...</code></pre>
```


## Export

File export.html contains a little program that allows you to paste in a code
snippet and then copy and paste the resulting HTML code generated by the
highlighter. This is useful in situations when you can't use the script itself
on a site.


## Meta

- Version: 6.2
- URL:     http://softwaremaniacs.org/soft/highlight/en/
- Author:  Ivan Sagalaev (<maniac@softwaremaniacs.org>)


## License ##

Copyright (c) 2006, Ivan Sagalaev
All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of highlight.js nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


## Authors ##

Syntax highlighting with language autodetection.

URL:   http://softwaremaniacs.org/soft/highlight/en/

Original author and current maintainer:
Ivan Sagalaev <maniac@softwaremaniacs.org>

Contributors:

- Peter Leonov <gojpeg@gmail.com>
- Victor Karamzin <Victor.Karamzin@enterra-inc.com>
- Vsevolod Solovyov <vsevolod.solovyov@gmail.com>
- Anton Kovalyov <anton@kovalyov.net>
- Nikita Ledyaev <lenikita@yandex.ru>
- Konstantin Evdokimenko <qewerty@gmail.com>
- Dmitri Roudakov <dmitri@roudakov.ru>
- Yuri Ivanov <ivanov@supersoft.ru>
- Vladimir Ermakov <vooon341@mail.ru>
- Vladimir Gubarkov <xonixx@gmail.com>
- Brian Beck <exogen@gmail.com>
- MajestiC <majestic2k@gmail.com>
- Vasily Polovnyov <vast@whiteants.net>
- Vladimir Epifanov <voldmar@voldmar.ru>
- Alexander Makarov (http://rmcreative.ru/)
- Vah <vahtenberg@gmail.com>
- Shuen-Huei Guan <drake.guan@gmail.com>
- Jason Diamond <jason@diamond.name>
- Michal Gabrukiewicz <mgabru@gmail.com>
- Ruslan Keba <rukeba@gmail.com>
- Sergey Baranov <segyrn@yandex.ru>
- Zaripov Yura <yur4ik7@ukr.net>
- Oleg Volchkov <oleg@volchkov.net>
- Vasily Mikhailitchenko <vaskas@programica.ru>
- Jan Berkel <jan.berkel@gmail.com>
- Vladimir Moskva <vladmos@gmail.com>
- Loren Segal <lsegal@soen.ca>
- Andrew Fedorov <dmmdrs@mail.ru>
- Igor Kalnitsky <igor@kalnitsky.org>
- Jeremy Hull <sourdrums@gmail.com>
- Valerii Hiora <valerii.hiora@gmail.com>
- Nikolay Zakharov <nikolay.desh@gmail.com>
- Dmitry Kovega <arhibot@gmail.com>
- Sergey Ignatov <sergey@ignatov.spb.su>
- Antono Vasiljev <self@antono.info>
- Stephan Kountso <steplg@gmail.com>
- pumbur <pumbur@pumbur.net>
- John Crepezzi <john.crepezzi@gmail.com>
- Andrey Vlasovskikh <andrey.vlasovskikh@gmail.com>
- Alexander Myadzel <myadzel@gmail.com>
- Evgeny Stepanischev <imbolk@gmail.com>
- Dmytrii Nagirniak <dnagir@gmail.com>
- Oleg Efimov <efimovov@gmail.com>
- Luigi Maselli <grigio.org@gmail.com>
- Denis Bardadym <bardadymchik@gmail.com>
- Aahan Krish <geekpanth3r@gmail.com>
- Ilya Baryshev <baryshev@gmail.com>
- Aleksandar Ruzicic <aleksandar@ruzicic.info>
- Joe Cheng <joe@rstudio.org>
- Angel G. Olloqui <angelgarcia.mail@gmail.com>
- Jason Tate <adminz@web-cms-designs.com>