/******************************************************************************

  This file is part of Map2DFusion.

  Copyright 2016 (c)  Yong Zhao <zd5945@126.com> http://www.zhaoyong.adv-ci.com

  ----------------------------------------------------------------------------

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H
#include <gui/gl/Win3D.h>
#include <opmapcontrol/opmapcontrol.h>

#include <QMainWindow>
#include <queue>

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget* parent = 0);
    virtual ~MainWindow() {}

    virtual int setupLayout(void);

    pi::gl::Win3D* getWin3D() {
        return win3d;
    }

    bool setMapType(const std::string& MapType);

    void call(const std::string& cmd);

signals:
    void call_signal();

protected slots:
    void call_slot();

protected:
    void keyPressEvent(QKeyEvent* event);
    void mousePressEvent(QMouseEvent* event);
    void resizeEvent(QResizeEvent* event);
    void timerEvent(QTimerEvent* event);

    pi::gl::Win3D* win3d;
    mapcontrol::OPMapWidget* mapwidget;

    std::queue<std::string> cmds;
};

#endif  // MAINWINDOW_H
