###################################
## THIS FILE IS AUTOGENERATED!   ##
## If you need custom logic      ##
## please edit Makefile.custom   ##
###################################

BUILD_DIR=build
ENGINE_DIR=engine
ROM_NAME={{ROM_NAME}}

export N64_INST={{N64_INST}}

include $(N64_INST)/include/n64.mk
include $(N64_INST)/include/t3d.mk

N64_CXXFLAGS += -std=gnu++20 -ftrivial-auto-var-init=uninitialized -fno-exceptions -Os -Isrc -Isrc/user \
	-I$(ENGINE_DIR)/include

# Allow custom attributes, otherwise GCC (rightfully) complains unknown ones
$(BUILD_DIR)/src/user/%.o: N64_CXXFLAGS += -Wno-attributes

src =  $(wildcard src/*.cpp) $(wildcard src/p64/*.cpp) $(wildcard src/user/*.cpp)

{{USER_CODE_DIRS}}

all: $(ROM_NAME).z64

include Makefile.custom

$(src): $(ENGINE_DIR)/build/engine.a

$(ENGINE_DIR)/build/engine.a: FORCE
	$(MAKE) -C $(ENGINE_DIR)
FORCE: ;

AUDIOCONV_FLAGS = --wav-resample 24000 --wav-compress 1

assets_conv = {{ASSET_LIST}}
assets_conv += filesystem/p64/font.ia4.sprite

# Images
filesystem/%.sprite: assets/p64/font.ia4.png
	@mkdir -p $(dir $@)
	@echo "    [SPRITE] $@"
	$(N64_MKSPRITE) $(MKSPRITE_FLAGS) -o $(dir $@) "$<"

filesystem/p64/%: assets/p64/%
	@mkdir -p $(dir $@)
	@echo "    [P64-BIN] $@"
	$(N64_BINDIR)/mkasset -c 1 -w 256 -o $(dir $@) "$<"

build/%.dfs:
	@mkdir -p $(dir $@)
	@echo "    [DFS*] $@ $(<D)"
	$(N64_MKDFS) $@ filesystem >/dev/null

$(BUILD_DIR)/$(ROM_NAME).dfs: $(assets_conv)
$(BUILD_DIR)/$(ROM_NAME).elf: $(src:%.cpp=$(BUILD_DIR)/%.o) $(ENGINE_DIR)/build/engine.a

$(ROM_NAME).z64: N64_ROM_TITLE="{{PROJECT_NAME}}"
$(ROM_NAME).z64: $(BUILD_DIR)/$(ROM_NAME).dfs

clean:
	{{P64_SELF_PATH}} --cli --cmd clean {{PROJECT_SELF_PATH}}

p64:
	{{P64_SELF_PATH}} --cli --cmd build {{PROJECT_SELF_PATH}}

-include $(wildcard $(BUILD_DIR)/src/*.d)

.PHONY: all clean
