/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.activities;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import org.piccolo2d.PRoot;
import org.piccolo2d.activities.PActivity;

public class PActivityScheduler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Timer activityTimer = null;
    private final PRoot root;
    private final List activities;
    private boolean activitiesChanged;
    private boolean animating;
    private final ArrayList processingActivities;

    public PActivityScheduler(PRoot rootNode) {
        this.root = rootNode;
        this.activities = new ArrayList();
        this.processingActivities = new ArrayList();
    }

    public PRoot getRoot() {
        return this.root;
    }

    public void addActivity(PActivity activity) {
        this.addActivity(activity, false);
    }

    public void addActivity(PActivity activity, boolean processLast) {
        if (this.activities.contains(activity)) {
            return;
        }
        this.activitiesChanged = true;
        if (processLast) {
            this.activities.add(0, activity);
        } else {
            this.activities.add(activity);
        }
        activity.setActivityScheduler(this);
        if (!this.getActivityTimer().isRunning()) {
            this.startActivityTimer();
        }
    }

    public void removeActivity(PActivity activity) {
        if (!this.activities.contains(activity)) {
            return;
        }
        this.activitiesChanged = true;
        this.activities.remove(activity);
        if (this.activities.size() == 0) {
            this.stopActivityTimer();
        }
    }

    public void removeAllActivities() {
        this.activitiesChanged = true;
        this.activities.clear();
        this.stopActivityTimer();
    }

    public List getActivitiesReference() {
        return this.activities;
    }

    public void processActivities(long currentTime) {
        int size = this.activities.size();
        if (size > 0) {
            this.processingActivities.addAll(this.activities);
            for (int i = size - 1; i >= 0; --i) {
                PActivity each = (PActivity)this.processingActivities.get(i);
                each.processStep(currentTime);
            }
            this.processingActivities.clear();
        }
    }

    public boolean getAnimating() {
        if (this.activitiesChanged) {
            this.animating = false;
            for (int i = 0; i < this.activities.size(); ++i) {
                PActivity each = (PActivity)this.activities.get(i);
                this.animating |= each.isAnimation();
            }
            this.activitiesChanged = false;
        }
        return this.animating;
    }

    protected void startActivityTimer() {
        this.getActivityTimer().start();
    }

    protected void stopActivityTimer() {
        this.getActivityTimer().stop();
    }

    protected Timer getActivityTimer() {
        if (this.activityTimer == null) {
            this.activityTimer = this.root.createTimer(10, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PActivityScheduler.this.root.processInputs();
                }
            });
        }
        return this.activityTimer;
    }
}

