#
#  Copyright 2025 The InfiniFlow Authors. All Rights Reserved.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


import pytest
from common import create_dataset, delete_datasets


@pytest.fixture(scope="class")
def add_table_parser_dataset(HttpApiAuth, request):
    """
    Fixture to create a table parser dataset for testing.
    Automatically cleans up after tests complete (deletes dataset and table).
    Note: field_map is automatically generated by the table parser when processing files.
    """
    dataset_payload = {
        "name": "test_table_parser_dataset",
        "chunk_method": "table",  # table parser
    }
    res = create_dataset(HttpApiAuth, dataset_payload)
    assert res["code"] == 0, f"Failed to create dataset: {res}"
    dataset_id = res["data"]["id"]

    def cleanup():
        delete_datasets(HttpApiAuth, {"ids": [dataset_id]})

    request.addfinalizer(cleanup)

    return dataset_id
