export default {
  translation: {
    common: {
      confirm: '确定',
      back: '返回',
      noResults: '未查到结果',
      selectPlaceholder: '请选择',
      selectAll: '全选',
      delete: '删除',
      deleteModalTitle: '确定删除吗?',
      deleteThem: '确定要删除吗？',
      ok: '确认',
      cancel: '取消',
      yes: '是',
      no: '否',
      total: '总共',
      rename: '重命名',
      name: '名称',
      save: '保存',
      namePlaceholder: '请输入名称',
      next: '下一步',
      create: '创建',
      edit: '编辑',
      upload: '上传',
      english: '英文',
      portugueseBr: '葡萄牙语 (巴西)',
      chinese: '简体中文',
      traditionalChinese: '繁体中文',
      language: '语言',
      languageMessage: '请输入语言',
      languagePlaceholder: '请选择语言',
      copy: '复制',
      copied: '复制成功',
      comingSoon: '即将推出',
      download: '下载',
      close: '关闭',
      preview: '预览',
      move: '移动',
      warn: '提醒',
      action: '操作',
      s: '秒',
      pleaseSelect: '请选择',
      pleaseInput: '请输入',
      submit: '提交',
      clear: '清空',
      embedIntoSite: '嵌入网站',
      previousPage: '上一页',
      nextPage: '下一页',
      add: '添加',
      remove: '移除',
      search: '搜索',
      noDataFound: '没有找到数据。',
      noData: '暂无数据',
      bedrockCredentialsHint:
        '提示：Access Key / Secret Key 可留空，以启用 AWS IAM 自动验证。',
      zendeskDescription: '连接 Zendesk，同步工单、文章及其他内容。',
      promptPlaceholder: '请输入或使用 / 快速插入变量。',
      selected: '已选择',
      seeAll: '查看全部',
    },
    login: {
      loginTitle: '登录账户',
      signUpTitle: '创建账户',
      login: '登录',
      signUp: '注册',
      loginDescription: '很高兴再次见到您！',
      registerDescription: '很高兴您加入！',
      emailLabel: '邮箱',
      emailPlaceholder: '请输入邮箱地址',
      passwordLabel: '密码',
      passwordPlaceholder: '请输入密码',
      rememberMe: '记住我',
      signInTip: '没有帐户？',
      signUpTip: '已经有帐户？',
      nicknameLabel: '名称',
      nicknamePlaceholder: '请输入名称',
      register: '创建账户',
      continue: '继续',
      title: 'A leading RAG engine for LLM context',
      start: '立即开始',
      description:
        '免费注册以探索顶级 RAG 技术。 创建知识库和人工智能来增强您的业务',
      review: '来自 500 多条评论',
    },
    header: {
      knowledgeBase: '知识库',
      chat: '聊天',
      register: '注册',
      signin: '登录',
      home: '首页',
      setting: '用户设置',
      logout: '登出',
      fileManager: '文件管理',
      flow: '智能体',
      search: '搜索',
      welcome: '欢迎来到',
      dataset: '知识库',
      memories: '记忆',
    },
    memories: {
      llmTooltip: '分析对话内容，提取关键信息，并生成结构化的记忆摘要。',
      embeddingModelTooltip:
        '将文本转换为数值向量，用于语义相似度搜索和记忆检索。',
      embeddingModelError: '记忆类型为必填项，且"原始"类型不可删除。',
      memoryTypeTooltip: `原始: 用户与智能体之间的原始对话内容（默认必需）。
语义记忆: 关于用户和世界的通用知识和事实。
情景记忆: 带时间戳的特定事件和经历记录。
程序记忆: 学习的技能、习惯和自动化程序。`,
      raw: '原始',
      semantic: '语义',
      episodic: '情景',
      procedural: '程序',
      editName: '编辑名称',
      memory: '记忆',
      createMemory: '创建记忆',
      name: '名称',
      memoryNamePlaceholder: '记忆名称',
      memoryType: '记忆类型',
      embeddingModel: '嵌入模型',
      selectModel: '选择模型',
      llm: '大语言模型',
      delMemoryWarn: `删除后，此记忆中的所有消息都将被删除，智能体将无法检索。`,
    },
    memory: {
      messages: {
        forget: '遗忘',
        forgetMessageTip: '确定遗忘吗？',
        messageDescription: '记忆提取使用高级设置中的提示词和温度值进行配置。',
        copied: '已复制！',
        content: '内容',
        delMessageWarn: `遗忘后，智能体将无法检索此消息。`,
        forgetMessage: '遗忘消息',
        sessionId: '会话ID',
        agent: '智能体',
        type: '类型',
        validDate: '有效日期',
        forgetAt: '遗忘于',
        source: '来源',
        enable: '启用',
        action: '操作',
      },
      config: {
        memorySizeTooltip: `记录每条消息的内容 + 其嵌入向量（≈ 内容 + 维度 × 8 字节）。
例如：一条带有 1024 维嵌入的 1 KB 消息大约使用 9 KB。5 MB 的默认限制大约可容纳 500 条此类消息。`,
        avatar: '头像',
        description: '描述',
        memorySize: '记忆大小',
        advancedSettings: '高级设置',
        permission: '权限',
        onlyMe: '仅自己',
        team: '团队',
        storageType: '存储类型',
        storageTypePlaceholder: '请选择存储类型',
        forgetPolicy: '遗忘策略',
        temperature: '温度',
        systemPrompt: '系统提示词',
        systemPromptPlaceholder: '请输入系统提示词',
        userPrompt: '用户提示词',
        userPromptPlaceholder: '请输入用户提示词',
      },
      sideBar: {
        messages: '消息',
        configuration: '配置',
      },
    },
    knowledgeList: {
      welcome: '欢迎回来',
      description: '今天我们要使用哪个知识库？',
      createKnowledgeBase: '创建知识库',
      name: '名称',
      namePlaceholder: '请输入名称',
      doc: '文档',
      searchKnowledgePlaceholder: '搜索',
      noMoreData: '没有更多数据了',
      parserRequired: '分块方法必填',
    },
    knowledgeDetails: {
      metadata: {
        selectFiles: '已选择 {{count}} 个文件',
        type: '类型',
        fieldNameInvalid: '字段名称只能包含字母或下划线。',
        builtIn: '内置',
        generation: '生成',
        toMetadataSettingTip: '在配置中设置自动元数据',
        toMetadataSetting: '生成设置',
        descriptionTip:
          '提供描述或示例来指导大语言模型为此字段提取值。如果留空，将依赖字段名称。',
        restrictDefinedValuesTip:
          '枚举模式：限制大语言模型提取的值只能匹配预设值。在下方定义值。',
        valueExists: '值已存在。确认合并重复项并组合所有关联文件。',
        fieldNameExists: '字段名已存在。确认合并重复项并组合所有关联文件。',
        valueSingleExists: '值已存在。确认合并重复项。',
        fieldSingleNameExists: '字段名已存在。确认合并重复项。',
        fieldExists: '字段名已存在。',
        fieldSetting: '字段设置',
        changesAffectNewParses: '更改仅影响新的解析。',
        // editMetadataForDataset: '查看和编辑元数据 ',
        restrictDefinedValues: '限制为已定义的值',
        metadataGenerationSettings: '元数据生成设置',
        // manageMetadataForDataset: '管理此数据集的元数据',
        manageMetadata: '管理元数据',
        metadata: '元数据',
        values: '值',
        value: '值',
        action: '操作',
        field: '字段',
        description: '描述',
        fieldName: '字段名称',
        editMetadata: '编辑元数据',
        deleteWarn: '此 {{field}} 将从所有关联文件中移除',
        deleteManageFieldAllWarn:
          '此字段及其所有对应值将从所有关联的文件中删除。',
        deleteManageValueAllWarn: '此值将从所有关联的文件中删除。',
        deleteManageFieldSingleWarn: '此字段及其所有对应值将从此文件中删除。',
        deleteManageValueSingleWarn: '此值将从此文件中删除。',
        deleteSettingFieldWarn: `此字段将被删除；现有元数据不会受到影响。`,
        deleteSettingValueWarn: `此值将被删除；现有元数据不会受到影响。`,
      },
      redoAll: '清除现有分块',
      applyAutoMetadataSettings: '应用全局自动元数据设置',
      parseFileTip: '您确定要解析吗？',
      parseFile: '解析文件',
      emptyMetadata: '无元数据',
      localUpload: '本地上传',
      fileSize: '文件大小',
      fileType: '文件类型',
      uploadedBy: '创建者',
      notGenerated: '未生成',
      generatedOn: '生成于',
      subbarFiles: '文件列表',
      generate: '生成',
      raptor: 'RAPTOR',
      processingType: '处理类型',
      dataPipeline: '数据管道',
      operations: '操作',
      taskId: '任务ID',
      duration: '耗时',
      details: '详情',
      status: '状态',
      task: '任务',
      startDate: '开始时间',
      source: '来源',
      fileName: '文件名',
      datasetLogs: '数据集',
      fileLogs: '文件',
      overview: '日志',
      success: '成功',
      failed: '失败',
      completed: '已完成',
      datasetLog: '知识库日志',
      created: '创建于',
      learnMore: '内置pipeline简介',
      general: '通用',
      chunkMethodTab: '切片方法',
      testResults: '测试结果',
      testSetting: '测试设置',
      retrievalTesting: '知识检索测试',
      retrievalTestingDescription:
        '进行检索测试，检查 RAGFlow 是否能够为大语言模型（LLM）恢复预期的内容。',
      Parse: '解析',
      dataset: '知识库',
      testing: '检索测试',
      configuration: '配置',
      knowledgeGraph: '知识图谱',
      files: '个文件',
      name: '名称',
      namePlaceholder: '请输入名称',
      doc: '文档',
      datasetDescription: '解析成功后才能问答哦。',
      addFile: '新增文件',
      searchFiles: '搜索文件',
      localFiles: '本地文件',
      emptyFiles: '新建空文件',
      webCrawl: '网页抓取',
      chunkNumber: '分块数',
      uploadDate: '上传日期',
      chunkMethod: '切片方法',
      enabled: '启用',
      disabled: '禁用',
      action: '动作',
      parsingStatus: '解析状态',
      parsingStatusTip:
        '文本解析的时间取决于诸多因素。如果开启了知识图谱、RAPTOR、自动问题提取、自动关键词提取等功能，时间会更长。如果解析进度条长时间不更新，也可以参考这两条 FAQ：https://ragflow.io/docs/dev/faq#why-does-my-document-parsing-stall-at-under-one-percent。',
      processBeginAt: '开始于',
      processDuration: '持续时间',
      progressMsg: '进度',
      noTestResultsForRuned: '未找到相关结果，请尝试调整查询语句或参数',
      noTestResultsForNotRuned: '尚未运行测试，结果会显示在这里',
      testingDescription:
        '请完成召回测试：确保你的配置可以从数据库召回正确的文本块。如果你调整了这里的默认设置，比如关键词相似度权重，请注意这里的改动不会被自动保存。请务必在聊天助手设置或者召回算子设置处同步更新相关设置。',
      similarityThreshold: '相似度阈值',
      similarityThresholdTip:
        '我们使用混合相似度得分来评估两行文本之间的距离。 它是加权关键词相似度和向量余弦相似度。 如果查询和块之间的相似度小于此阈值，则该块将被过滤掉。默认设置为 0.2，也就是说文本块的混合相似度得分至少 20 才会被召回。',
      vectorSimilarityWeight: '向量相似度权重',
      vectorSimilarityWeightTip:
        '我们使用混合相似性评分来评估两行文本之间的距离。它是加权关键字相似性和矢量余弦相似性或rerank得分（0〜1）。两个权重的总和为1.0。',
      keywordSimilarityWeight: '关键词相似度权重',
      keywordSimilarityWeightTip:
        '我们使用混合相似性评分来评估两行文本之间的距离。它是加权关键字相似性和矢量余弦相似性或rerank得分（0〜1）。两个权重的总和为1.0。',
      testText: '测试文本',
      testTextPlaceholder: '请输入您的问题！',
      testingLabel: '运行',
      similarity: '混合相似度',
      termSimilarity: '关键词相似度',
      vectorSimilarity: '向量相似度',
      hits: '命中数',
      view: '看法',
      filesSelected: '选定的文件',
      upload: '上传',
      run: '解析',
      runningStatus0: '未解析',
      runningStatus1: '解析中',
      runningStatus2: '取消',
      runningStatus3: '成功',
      runningStatus4: '失败',
      pageRanges: '页码范围',
      pageRangesTip:
        '页码范围：定义需要解析的页面范围。 不包含在这些范围内的页面将被忽略。',
      fromPlaceholder: '从',
      fromMessage: '缺少起始页码',
      toPlaceholder: '到',
      toMessage: '缺少结束页码（不包含）',
      layoutRecognize: 'PDF解析器',
      layoutRecognizeTip:
        '使用视觉模型进行 PDF 布局分析，以更好地识别文档结构，找到标题、文本块、图像和表格的位置。 如果选择 Naive 选项，则只能获取 PDF 的纯文本。请注意该功能只适用于 PDF 文档，对其他文档不生效。欲了解更多信息，请参阅 https://ragflow.io/docs/dev/select_pdf_parser。',
      taskPageSize: '任务页面大小',
      taskPageSizeMessage: '请输入您的任务页面大小！',
      taskPageSizeTip: `如果使用布局识别，PDF 文件将被分成连续的组。 布局分析将在组之间并行执行，以提高处理速度。 “任务页面大小”决定组的大小。 页面大小越大，将页面之间的连续文本分割成不同块的机会就越低。`,
      addPage: '新增页面',
      greaterThan: '当前值必须大于起始值！',
      greaterThanPrevious: '当前值必须大于之前的值！',
      selectFiles: '选择文件',
      changeSpecificCategory: '更改特定类别',
      uploadTitle: '点击或拖拽文件至此区域即可上传',
      uploadDescription:
        '支持单次或批量上传。本地部署的单次上传文件总大小上限为 1GB，单次批量上传文件数不超过 32，单个账户不限文件数量。对于 demo.ragflow.io：每次上传的总文件大小限制为 10MB，每个文件不得超过 10MB，每个账户最多可上传 128 个文件。严禁上传违禁文件。',
      chunk: '解析块',
      bulk: '批量',
      cancel: '取消',
      close: '关闭',
      rerankModel: 'Rerank模型',
      rerankPlaceholder: '请选择',
      rerankTip: `非必选项：若不选择 rerank 模型，系统将默认采用关键词相似度与向量余弦相似度相结合的混合查询方式；如果设置了 rerank 模型，则混合查询中的向量相似度部分将被 rerank 打分替代。请注意：采用 rerank 模型会非常耗时。如需选用 rerank 模型，建议使用 SaaS 的 rerank 模型服务；如果你倾向使用本地部署的 rerank 模型，请务必确保你使用 docker-compose-gpu.yml 启动 RAGFlow。`,
      topK: 'Top-K',
      topKTip: `与 Rerank 模型配合使用，用于设置传给 Rerank 模型的文本块数量。`,
      delimiter: `文本分段标识符`,
      delimiterTip:
        '支持多字符作为分隔符，多字符用两个反引号 \\`\\` 分隔符包裹。若配置成：\\n`##`; 系统将首先使用换行符、两个#号以及分号先对文本进行分割，随后再对分得的小文本块按照「建议文本块大小」设定的大小进行拼装。在设置文本分段标识符前请确保理解上述文本分段切片机制。',
      html4excel: '表格转HTML',
      html4excelTip: `与 General 切片方法配合使用。未开启状态下，表格文件（XLSX、XLS（Excel 97-2003））会按行解析为键值对。开启后，表格文件会被解析为 HTML 表格。若原始表格超过 12 行，系统会自动按每 12 行拆分为多个 HTML 表格。欲了解更多详情，请参阅 https://ragflow.io/docs/dev/enable_excel2html。`,
      autoKeywords: '自动关键词提取',
      autoKeywordsTip: `自动为每个文本块中提取 N 个关键词，用以提升查询精度。请注意：该功能采用在“配置”中指定的索引模型提取关键词，因此也会产生更多 Token 消耗。另外，你也可以手动更新生成的关键词。详情请见 https://ragflow.io/docs/dev/autokeyword_autoquestion。`,
      autoQuestions: '自动问题提取',
      autoQuestionsTip: `利用在“配置”中指定的索引模型 对知识库的每个文本块提取 N 个问题以提高其排名得分。请注意，开启后将消耗额外的 token。您可以在块列表中查看、编辑结果。如果自动问题提取发生错误，不会妨碍整个分块过程，只会将空结果添加到原始文本块。详情请见 https://ragflow.io/docs/dev/autokeyword_autoquestion。`,
      redo: '是否清空已有 {{chunkNum}}个 chunk？',
      setMetaData: '设置元数据',
      pleaseInputJson: '请输入JSON',
      documentMetaTips: `<p>元数据为 Json 格式（不可搜索）。如果提示中包含此文档的任何块，它将被添加到 LLM 的提示中。</p>
<p>示例：</p>
<b>元数据为：</b><br>
<code>
{
    "作者": "Alex Dowson",
    "日期": "2024-11-12"
}
</code><br>
<b>提示将为：</b><br>
<p>文档：the_name_of_document</p>
<p>作者：Alex Dowson</p>
<p>日期：2024-11-12</p>
<p>相关片段如下：</p>
<ul>
<li> 这是块内容....</li>
<li> 这是块内容....</li>
</ul>
`,
      metaData: '元数据',
      deleteDocumentConfirmContent:
        '该文档与知识图谱相关联。删除后，相关节点和关系信息将被删除，但图不会立即更新。更新图动作是在解析承载知识图谱提取任务的新文档的过程中执行的。',
      plainText: 'Naive',
      reRankModelWaring: '重排序模型非常耗时。',
      theDocumentBeingParsedCannotBeDeleted: '正在解析的文档不能被删除',
    },
    knowledgeConfiguration: {
      settings: '设置',
      autoMetadataTip:
        '自动生成元数据。适用于解析新文件。现有文件需要重新解析才能更新（chunk将保留）。请注意，配置中指定的索引模型将消耗额外的 Token。',
      imageTableContextWindow: '图像与表格上下文窗口',
      imageTableContextWindowTip:
        '抓取图像与表格上下方的 N 个 token，为该 chunk 提供更丰富的背景上下文。',
      autoMetadata: '自动元数据',
      mineruOptions: 'MinerU 选项',
      mineruParseMethod: '解析方法',
      mineruParseMethodTip:
        'PDF 解析方法：auto（自动检测）、txt（文本提取）、ocr（光学字符识别）',
      mineruFormulaEnable: '公式识别',
      mineruFormulaEnableTip:
        '启用公式识别。注意：对于西里尔文档可能无法正常工作。',
      mineruTableEnable: '表格识别',
      mineruTableEnableTip: '启用表格识别和提取。',
      paddleocrOptions: 'PaddleOCR 选项',
      paddleocrApiUrl: 'PaddleOCR API URL',
      paddleocrApiUrlTip: 'PaddleOCR 服务的 API 端点 URL',
      paddleocrApiUrlPlaceholder:
        '例如：https://paddleocr-server.com/layout-parsing',
      paddleocrAccessToken: 'AI Studio 访问令牌',
      paddleocrAccessTokenTip: 'PaddleOCR API 的访问令牌（可选）',
      paddleocrAccessTokenPlaceholder: '您的 AI Studio 令牌（可选）',
      paddleocrAlgorithm: 'PaddleOCR 算法',
      paddleocrAlgorithmTip: '用于 PaddleOCR 解析的算法',
      paddleocrSelectAlgorithm: '选择算法',
      paddleocrModelNamePlaceholder: '例如：paddleocr-环境-1',
      generationScopeTip: '选择 RAPTOR 的生成范围：整个知识库或单个文件。',
      generationScope: '生成范围',
      scopeSingleFile: '单文件',
      scopeDataset: '整库',

      autoParse: '自动解析',
      rebuildTip: '从所有已关联的数据源重新下载文件并再次解析。',
      baseInfo: '基础信息',
      globalIndex: '全局索引',
      dataSource: '数据源',
      linkSourceSetTip: '管理与此数据集的数据源链接',
      linkDataSource: '链接数据源',
      tocExtractionTip:
        '对于已有的chunk生成层级结构的目录信息（每个文件一个目录）。在查询时，激活`Page Index`后，系统会用大模型去判断用户问题和哪些目录项相关，从而找到相关的chunk。',
      deleteGenerateModalContent: `
        <p>删除生成的 <strong class='text-text-primary'>{{type}}</strong> 结果
          将从此数据集中移除所有派生实体和关系。
          您的原始文件将保持不变。<p>
          <br/>
          是否要继续？
      `,
      extractRaptor: '从文档中提取RAPTOR',
      extractKnowledgeGraph: '从文档中提取知识图谱',
      filterPlaceholder: '请输入',
      fileFilterTip: '',
      fileFilter: '正则匹配表达式',
      setDefaultTip: '',
      setDefault: '设置默认',
      editLinkDataPipeline: '编辑pipeline',
      linkPipelineSetTip: '管理与此数据集的数据管道链接',
      default: '默认',
      dataPipeline: 'Ingestion pipeline',
      linkDataPipeline: '关联pipeline',
      enableAutoGenerate: '是否启用自动生成',
      teamPlaceholder: '请选择团队',
      dataFlowPlaceholder: '请选择pipeline',
      buildItFromScratch: '去Scratch构建',
      dataFlow: 'pipeline',
      parseType: '解析方法',
      manualSetup: '选择pipeline',
      builtIn: '内置',
      titleDescription: '在这里更新您的记忆配置，特别是大语言模型和提示词。',
      name: '知识库名称',
      photo: '知识库图片',
      photoTip: '你可以上传4MB的文件',
      description: '描述',
      language: '文档语言',
      languageMessage: '请输入语言',
      languagePlaceholder: '请输入语言',
      permissions: '权限',
      embeddingModel: '嵌入模型',
      chunkTokenNumber: '建议文本块大小',
      chunkTokenNumberMessage: '块Token数是必填项',
      embeddingModelTip:
        '知识库采用的默认嵌入模型。一旦知识库内已经产生了文本块，更换嵌入模型时，系统将随机抽取若干 chunk 进行兼容性校验，使用新嵌入模型重新编码并计算新旧向量的余弦相似度，样本平均相似度需 ≥ 0.9 方可切换。否则，必须删除知识库内的所有文本块后才能更改。',
      permissionsTip:
        '如果把知识库权限设为“团队”，则所有团队成员都可以操作该知识库。',
      chunkTokenNumberTip:
        '建议的生成文本块的 token 数阈值。如果切分得到的小文本段 token 数达不到这一阈值就会不断与之后的文本段合并，直至再合并下一个文本段会超过这一阈值为止，此时产生一个最终文本块。如果系统在切分文本段时始终没有遇到文本分段标识符，即便文本段 token 数已经超过这一阈值，系统也不会生成新文本块。',
      chunkMethod: '切片方法',
      chunkMethodTip: '说明位于右侧。',
      upload: '上传',
      english: '英文',
      chinese: '中文',
      embeddingModelPlaceholder: '请选择嵌入模型',
      chunkMethodPlaceholder: '请选择分块方法',
      save: '保存',
      me: '只有我',
      team: '团队',
      cancel: '取消',
      methodTitle: '分块方法说明',
      methodExamples: '示例',
      methodExamplesDescription:
        '为帮助您更好地理解，我们提供了相关截图供您参考。',
      dialogueExamplesTitle: '对话示例',
      methodEmpty: '这将显示知识库类别的可视化解释',
      book: `<p>支持的文件格式为<b>DOCX</b>、<b>PDF</b>、<b>TXT</b>。</p><p>
      由于一本书很长，并不是所有部分都有用，如果是 PDF，
      请为每本书设置<i>页面范围</i>，以消除负面影响并节省分析计算时间。</p>`,
      laws: `<p>支持的文件格式为<b>DOCX</b>、<b>PDF</b>、<b>TXT</b>。</p><p>
      法律文件有非常严格的书写格式。 我们使用文本特征来检测分割点。
      </p><p>
      chunk的粒度与'ARTICLE'一致，所有上层文本都会包含在chunk中。
      </p>`,
      manual: `<p>仅支持<b>PDF</b>。</p><p>
      我们假设手册具有分层部分结构。 我们使用最低的部分标题作为对文档进行切片的枢轴。
      因此，同一部分中的图和表不会被分割，并且块大小可能会很大。
      </p>`,
      naive: `<p>支持的文件格式为<b>MD、MDX、DOCX、XLSX、XLS (Excel 97-2003)、PPTX、PDF、TXT、JPEG、JPG、PNG、TIF、GIF、CSV、JSON、EML、HTML</b>。</p>
      <p>此方法将简单的方法应用于块文件：</p>
      <p>
      <li>系统将使用视觉检测模型将连续文本分割成多个片段。</li>
      <li>接下来，这些连续的片段被合并成Token数不超过“Token数”的块。</li></p>`,
      paper: `<p>仅支持<b>PDF</b>文件。</p><p>
      如果我们的模型运行良好，论文将按其部分进行切片，例如<i>摘要、1.1、1.2</i>等。</p><p>
      这样做的好处是LLM可以更好的概括论文中相关章节的内容，
      产生更全面的答案，帮助读者更好地理解论文。
      缺点是它增加了 LLM 对话的背景并增加了计算成本，
      所以在对话过程中，你可以考虑减少‘<b>topN</b>’的设置。</p>`,
      presentation: `<p>支持的文件格式为<b>PDF</b>、<b>PPTX</b>。</p><p>
      每个页面都将被视为一个块。 并且每个页面的缩略图都会被存储。</p><p>
      <i>您上传的所有PPT文件都会使用此方法自动分块，无需为每个PPT文件进行设置。</i></p>`,
      qa: ` <p>
      此块方法支持<b> excel </b>和<b> csv/txt </b>文件格式。
    </p>
    <li>
      如果文件是<b> excel </b>格式，则应由两个列组成
      没有标题：一个提出问题，另一个用于答案，
      答案列之前的问题列。多张纸是
      只要列正确结构，就可以接受。
    </li>
    <li>
      如果文件是<b> csv/txt </b>格式
      以 UTF-8 编码且用 TAB 作分开问题和答案的定界符。
    </li>
    <p>
      <i>
        未能遵循上述规则的文本行将被忽略，并且
        每个问答对将被认为是一个独特的部分。
      </i>
    </p>`,
      resume: `<p>支持的文件格式为<b>DOCX</b>、<b>PDF</b>、<b>TXT</b>。
      </p><p>
      简历有多种格式，就像一个人的个性一样，但我们经常必须将它们组织成结构化数据，以便于搜索。
      </p><p>
      我们不是将简历分块，而是将简历解析为结构化数据。 作为HR，你可以扔掉所有的简历，
      您只需与<i>'RAGFlow'</i>交谈即可列出所有符合资格的候选人。
      </p>
        `,
      table: `支持<p><b>XLSX</b>和<b>CSV/TXT</b>格式文件。</p><p>
      以下是一些提示：
      <ul>
    <li>对于 csv 或 txt 文件，列之间的分隔符为 <em><b>TAB</b></em>。</li>
    <li>第一行必须是列标题。</li>
    <li>列标题必须是有意义的术语，以便我们的大语言模型能够理解。
    列举一些同义词时最好使用斜杠<i>'/'</i>来分隔，甚至更好
    使用方括号枚举值，例如 <i>'gender/sex(male,female)'</i>.<p>
    以下是标题的一些示例：<ol>
        <li>供应商/供货商<b>'TAB'</b>颜色（黄色、红色、棕色）<b>'TAB'</b>性别（男、女）<b>'TAB'</ b>尺码（M、L、XL、XXL）</li>
        <li>姓名/名字<b>'TAB'</b>电话/手机/微信<b>'TAB'</b>最高学历（高中，职高，硕士，本科，博士，初中，中技，中 专，专科，专升本，MPA，MBA，EMBA）</li>
        </ol>
        </p>
    </li>
    <li>表中的每一行都将被视为一个块。</li>
    </ul>`,
      picture: `
      <p>支持图像文件。 视频即将推出。</p><p>
      如果图片中有文字，则应用 OCR 提取文字作为其文字描述。
      </p><p>
      如果OCR提取的文本不够，可以使用视觉LLM来获取描述。
      </p>`,
      one: `
      <p>支持的文件格式为<b>DOCX、EXCEL、PDF、TXT</b>。
      </p><p>
      对于一个文档，它将被视为一个完整的块，根本不会被分割。
      </p><p>
      如果你要总结的东西需要一篇文章的全部上下文，并且所选LLM的上下文长度覆盖了文档长度，你可以尝试这种方法。
      </p>`,
      knowledgeGraph: `<p>支持的文件格式为<b>DOCX、EXCEL、PPT、IMAGE、PDF、TXT、MD、JSON、EML</b>

<p>文件分块后，使用分块提取整个文档的知识图谱和思维导图。此方法将简单的方法应用于分块文件：
连续的文本将被切成大约 512 个 token 数的块。</p>
<p>接下来，将分块传输到 LLM 以提取知识图谱和思维导图的节点和关系。</p>

注意您需要指定的条目类型。</p>`,
      tag: `<p>使用“Tag”分块方法的知识库用作标签集.其他知识库可以把标签集当中的标签按照相似度匹配到自己对应的文本块中，对这些知识库的查询也将根据此标签集对自己进行标记。</p>
<p>标签集<b>不会</b>直接参与 RAG 检索过程。</p>
<p>标签集中的每个文本分块都是相互独立的标签和标签描述的文本对。</p>

<p>Tag 分块方法支持<b>XLSX</b>和<b>CSV/TXT</b>文件格式。</p>
<p>如果文件为<b>XLSX</b>格式，则它应该包含无标题的两列：一列用于标签描述，另一列用于标签，标签描述列位于标签列之前。支持多个工作表，只要列结构正确即可。</p>
<p>如果文件为 <b>CSV/TXT</b> 格式，则必须使用 UTF-8 编码并以 TAB 作为分隔符来分隔内容和标签。</p>
<p>在标签列中，标签之间使用英文逗号分隔。</p>
<i>不符合上述规则的文本行将被忽略。</i>
`,
      useRaptor: '使用召回增强 RAPTOR 策略',
      useRaptorTip:
        'RAPTOR 常应用于复杂的多跳问答任务。如需打开，请跳转至知识库的文件页面，点击生成 > RAPTOR 开启。详见: https://ragflow.io/docs/dev/enable_raptor。',
      prompt: '提示词',
      promptMessage: '提示词是必填项',
      promptText: `请总结以下段落。 小心数字，不要编造。 段落如下：
      {cluster_content}
以上就是你需要总结的内容。`,
      maxToken: '最大token数',
      maxTokenMessage: '最大token数是必填项',
      threshold: '阈值',
      thresholdMessage: '阈值是必填项',
      maxCluster: '最大聚类数',
      maxClusterMessage: '最大聚类数是必填项',
      randomSeed: '随机种子',
      randomSeedMessage: '随机种子是必填项',
      promptTip:
        '系统提示为大模型提供任务描述、规定回复方式，以及设置其他各种要求。系统提示通常与 key （变量）合用，通过变量设置大模型的输入数据。你可以通过斜杠或者 (x) 按钮显示可用的 key。',
      maxTokenTip: '用于设定每个被总结的文本块的最大 token 数。',
      thresholdTip:
        '在 RAPTOR 中，数据块会根据它们的语义相似性进行聚类。阈值设定了数据块被分到同一组所需的最小相似度。阈值越高，每个聚类中的数据块越少；阈值越低，则每个聚类中的数据块越多。',
      maxClusterTip: '最多可创建的聚类数。',
      entityTypes: '实体类型',
      pageRank: '页面排名',
      pageRankTip: `知识库检索时，你可以为特定知识库设置较高的 PageRank 分数，该知识库中匹配文本块的混合相似度得分会自动叠加 PageRank 分数，从而提升排序权重。详见 https://ragflow.io/docs/dev/set_page_rank。`,
      tagName: '标签',
      frequency: '频次',
      searchTags: '搜索标签',
      tagCloud: '云',
      tagTable: '表',
      tagSet: '标签集',
      topnTags: 'Top-N 标签',
      tagSetTip: `
      <p> 请选择一个或多个标签集或标签知识库，用于对知识库中的每个文本块进行标记。</p>
      <p>对这些文本块的查询也将自动关联相应标签。 </p>
      <p>此功能基于文本相似度，能够为数据集的文本块批量添加更多领域知识，从而显著提高检索准确性。该功能还能提升大量文本块的操作效率。</p>
      <p>为了更好地理解标签集的作用，以下是标签集和关键词之间的主要区别：</p>
      <ul>
      <li>标签集是一个由用户定义和管理的封闭集，而自动生成的关键词属于开放集合。 </li>
      <li>在给你的知识库文本块批量打标签之前，你需要先生成标签集作为样本。 </li>
      <li>自动关键词提取功能中的关键词由 LLM 生成，此过程相对耗时，并且会产生一定的 Token 消耗。 </li>
      </ul>
      <p> 详见：https://ragflow.io/docs/dev/use_tag_sets </p>
      `,
      tags: '标签',
      addTag: '增加标签',
      useGraphRag: '提取知识图谱',
      useGraphRagTip:
        '基于知识库内所有切好的文本块构建知识图谱，用以提升多跳和复杂问题回答的正确率。请注意：构建知识图谱将消耗大量 token 和时间。详见 https://ragflow.io/docs/dev/construct_knowledge_graph。',
      graphRagMethod: '方法',
      graphRagMethodTip: `Light：实体和关系提取提示来自 GitHub - HKUDS/LightRAG：“LightRAG：简单快速的检索增强生成”<br>
General：实体和关系提取提示来自 GitHub - microsoft/graphrag：基于图的模块化检索增强生成 (RAG) 系统`,
      resolution: '实体归一化',
      resolutionTip: `解析过程会将具有相同含义的实体合并在一起，从而使知识图谱更简洁、更准确。应合并以下实体：特朗普总统、唐纳德·特朗普、唐纳德·J·特朗普、唐纳德·约翰·特朗普`,
      community: '社区报告生成',
      communityTip:
        '区块被聚集成层次化的社区，实体和关系通过更高抽象层次将每个部分连接起来。然后，我们使用 LLM 生成每个社区的摘要，称为社区报告。更多信息：https://www.microsoft.com/en-us/research/blog/graphrag-improving-global-search-via-dynamic-community-selection/',
    },
    chunk: {
      chunk: '解析块',
      bulk: '批量',
      selectAll: '选择所有',
      enabledSelected: '启用选定的',
      disabledSelected: '禁用选定的',
      deleteSelected: '删除选定的',
      search: '搜索',
      all: '所有',
      enabled: '启用',
      disabled: '禁用',
      keyword: '关键词',
      function: '函数',
      chunkMessage: '请输入值！',
      full: '全文',
      ellipse: '省略',
      graph: '知识图谱',
      mind: '思维导图',
      question: '问题',
      questionTip: `如果有给定的问题，则块的嵌入将基于它们。`,
      chunkResult: '切片结果',
      chunkResultTip: `查看用于嵌入和召回的切片段落。`,
      enable: '启用',
      disable: '禁用',
      delete: '删除',
    },
    chat: {
      messagePlaceholder: '请输入消息...',
      exit: '退出',
      multipleModels: '多模型',
      applyModelConfigs: '应用模型配置',
      conversations: '会话',
      chatApps: '聊天',
      createChat: '创建聊天',
      newConversation: '新会话',
      createAssistant: '新建助理',
      assistantSetting: '助理设置',
      promptEngine: '提示引擎',
      modelSetting: '模型设置',
      chat: '聊天',
      newChat: '新建聊天',
      send: '发送',
      sendPlaceholder: '给助理发送消息...',
      chatConfiguration: '聊天配置',
      chatConfigurationDescription: '为你的知识库配置专属聊天助手！ 💕',
      assistantName: '助理姓名',
      assistantNameMessage: '助理姓名是必填项',
      namePlaceholder: '例如 贾维斯简历',
      assistantAvatar: '助理头像',
      language: '语言',
      emptyResponse: '空回复',
      emptyResponseTip: `如果在知识库中没有检索到用户的问题，它将使用它作为答案。 如果您希望 LLM 在未检索到任何内容时提出自己的意见，请将此留空。`,
      emptyResponseMessage: `当知识库中未检索到任何相关信息时，将触发空响应。由于未选择任何知识库，因此请清除“空响应”。`,
      setAnOpener: '设置开场白',
      setAnOpenerInitial: `你好！ 我是你的助理，有什么可以帮到你的吗？`,
      setAnOpenerTip: '您想如何欢迎您的客户？',
      knowledgeBases: '知识库',
      knowledgeBasesMessage: '请选择',
      knowledgeBasesTip:
        '选择关联的知识库。新建或空知识库不会在下拉菜单中显示。',
      system: '系统提示词',
      systemInitialValue: `你是一个智能助手，请总结知识库的内容来回答问题，请列举知识库中的数据详细回答。当所有知识库内容都与问题无关时，你的回答必须包括“知识库中未找到您要的答案！”这句话。回答需要考虑聊天历史。
        以下是知识库：
        {knowledge}
        以上是知识库。`,
      systemMessage: '请输入',
      systemTip:
        '当LLM回答问题时，你需要LLM遵循的说明，比如角色设计、答案长度和答案语言等。如果您的模型原生支持在问答中推理，可以通过 //no_thinking 关闭自动推理。',
      topN: 'Top N',
      topNTip: `并非所有相似度得分高于“相似度阈值”的块都会被提供给大语言模型。 LLM 只能看到这些“Top N”块。`,
      variable: '变量',
      variableTip: `你可以通过对话 API，并配合变量设置来动态调整大模型的系统提示词。
      {knowledge}为系统预留变量，代表从指定知识库召回的文本块。
      “系统提示词”中的所有变量都必须用大括号{}括起来。详见 https://ragflow.io/docs/dev/set_chat_variables。`,
      add: '新增',
      key: '关键字',
      optional: '可选的',
      operation: '操作',
      model: '模型',
      modelTip: '大语言聊天模型',
      modelMessage: '请选择',
      modelEnabledTools: '可用的工具',
      modelEnabledToolsTip:
        '请选择一个或多个可供该模型所使用的工具。仅对支持工具调用的模型生效。',
      freedom: '自由度',
      improvise: '即兴创作',
      precise: '精确',
      balance: '平衡',
      custom: '自定义',
      freedomTip: `“精确”意味着大语言模型会保守并谨慎地回答你的问题。 “即兴发挥”意味着你希望大语言模型能够自由地畅所欲言。 “平衡”是谨慎与自由之间的平衡。`,
      temperature: '温度',
      temperatureMessage: '温度是必填项',
      temperatureTip:
        '该参数控制模型预测的随机性。 较低的温度使模型对其响应更有信心，而较高的温度则使其更具创造性和多样性。',
      topP: 'Top P',
      topPMessage: 'Top P 是必填项',
      topPTip:
        '该参数也称为“核心采样”，它设置一个阈值来选择较小的单词集进行采样。 它专注于最可能的单词，剔除不太可能的单词。',
      presencePenalty: '存在处罚',
      presencePenaltyMessage: '存在处罚是必填项',
      presencePenaltyTip:
        '这会通过惩罚对话中已经出现的单词来阻止模型重复相同的信息。',
      frequencyPenalty: '频率惩罚',
      frequencyPenaltyMessage: '频率惩罚是必填项',
      frequencyPenaltyTip:
        '与存在惩罚类似，这减少了模型频繁重复相同单词的倾向。',
      maxTokens: '最大token数',
      maxTokensMessage: '最大token数是必填项',
      maxTokensTip: `模型的最大上下文大小；无效或不正确的值会导致错误。默认值为 512。`,
      maxTokensInvalidMessage: '请输入有效的最大令牌数。',
      maxTokensMinMessage: '最大令牌数不能小于 0。',
      quote: '显示引文',
      quoteTip: '是否应该显示原文出处？',
      selfRag: 'Self-RAG',
      selfRagTip: '请参考: https://huggingface.co/papers/2310.11511',
      overview: '聊天 ID',
      pv: '消息数',
      uv: '活跃用户数',
      speed: 'Token 输出速度',
      tokens: '消耗Token数',
      round: '会话互动数',
      thumbUp: '用户满意度',
      preview: '预览',
      embedded: '嵌入',
      serviceApiEndpoint: '服务API端点',
      apiKey: 'API KEY',
      apiReference: 'API 文档',
      dateRange: '日期范围：',
      backendServiceApi: 'API 服务器',
      createNewKey: '创建新密钥',
      created: '创建于',
      action: '操作',
      embedModalTitle: '嵌入网站',
      comingSoon: '即将推出',
      fullScreenTitle: '全屏嵌入',
      fullScreenDescription: '将以下iframe嵌入您的网站处于所需位置',
      partialTitle: '部分嵌入',
      extensionTitle: 'Chrome 插件',
      tokenError: '请先创建 API Token!',
      betaError: '请先在系统设置中申请API密钥。',
      searching: '搜索中',
      parsing: '解析中',
      uploading: '上传中',
      uploadFailed: '上传失败',
      regenerate: '重新生成',
      read: '朗读内容',
      tts: '文本转语音',
      ttsTip: '是否用语音转换播放语音，请先在设置里面选择TTS（语音转换模型）。',
      relatedQuestion: '相关问题',
      answerTitle: '智能回答',
      multiTurn: '多轮对话优化',
      multiTurnTip:
        '在多轮对话时，对查询问题根据上下文进行优化。会调用大模型额外消耗 token。',
      howUseId: '如何使用聊天ID？',
      description: '助理描述',
      descriptionPlaceholder:
        '例如 你是一个专业的简历助手，只能回答简历的问题。',
      useKnowledgeGraph: '使用知识图谱',
      useKnowledgeGraphTip:
        '是否检索与所选知识库对应的知识图谱相关文本块，以处理复杂的多跳问题？这一过程将涉及对实体、关系和社区报告文本块的多次检索，会显著延长检索时间。',
      keyword: '关键词分析',
      keywordTip: `应用 LLM 分析用户的问题，提取在相关性计算中要强调的关键词。对长查询效果较好，但会延长响应时间。`,
      reasoning: '推理',
      reasoningTip:
        '在问答过程中是否启用推理工作流，例如Deepseek-R1或OpenAI o1等模型所采用的方式。启用后，该功能允许模型访问外部知识，并借助思维链推理等技术逐步解决复杂问题。通过将问题分解为可处理的步骤，这种方法增强了模型提供准确回答的能力，从而在需要逻辑推理和多步思考的任务上表现更优。',
      tavilyApiKeyTip:
        '如果 API 密钥设置正确，它将利用 Tavily 进行网络搜索作为知识库的补充。',
      tavilyApiKeyMessage: '请输入你的 Tavily API Key',
      tavilyApiKeyHelp: '如何获取？',
      crossLanguage: '跨语言搜索',
      crossLanguageTip: `选择一种或多种语言进行跨语言搜索。如果未选择任何语言，系统将使用原始查询进行搜索。`,
      metadata: '元数据',
      metadataTip:
        '元数据过滤是使用元数据属性（例如标签、类别或访问权限）来优化和控制系统内相关信息检索的过程。',
      conditions: '条件',
      metadataKeys: '可选过滤项',
      addCondition: '增加条件',
      meta: {
        disabled: '禁用',
        auto: '自动',
        manual: '手动',
        semi_auto: '半自动',
      },
      cancel: '取消',
      chatSetting: '聊天设置',
      avatarHidden: '隐藏头像',
      locale: '地区',
      tocEnhance: 'PageIndex',
      tocEnhanceTip: `解析文档时生成了目录信息（见General方法的'启用目录抽取'），让大模型返回和用户问题相关的目录项，从而利用目录项拿到相关chunk，对这些chunk在排序中进行加权。这种方法来源于模仿人类查询书本中知识的行为逻辑`,
      batchDeleteSessions: '批量删除',
      deleteSelectedConfirm: '删除选中的 {count} 个会话？',
    },
    setting: {
      Verify: '验证',
      keyValid: '你的 API 密钥有效。',
      keyInvalid: '你的 API 密钥无效。',
      deleteModel: '删除模型',
      modelEmptyTip: '暂无可用模型,<br>请先在右侧面板添加模型。',
      sourceEmptyTip: '暂未添加任何数据源，请从下方选择一个进行连接。',
      seconds: '秒',
      minutes: '分',
      edit: '编辑',
      cropTip: '拖动选区可以选择要图片的裁剪位置，滚动可以放大/缩小选区',
      cropImage: '剪裁图片',
      selectModelPlaceholder: '请选择模型',
      configureModelTitle: '配置模型',
      confluenceIsCloudTip:
        '检查这是否是 Confluence Cloud 实例，如果是 Confluence 服务/数据中心，则取消选中。',
      confluenceWikiBaseUrlTip:
        'Confluence Wiki 的基础 URL（例如 https://your-domain.atlassian.net/wiki）',
      confluenceSpaceKeyTip:
        '可选：指定空间键以限制同步到特定空间。留空则同步所有可访问的空间。多个空间请用逗号分隔（例如：DEV,DOCS,HR）',
      s3PrefixTip: `指定 S3 存储桶内的文件夹路径，用于读取文件。
示例：general/v2/`,
      addDataSourceModalTitle: '创建你的 {{name}} 链接',
      deleteSourceModalTitle: '删除数据源链接',
      deleteSourceModalContent: `
      <p>您确定要删除此数据源链接吗？</p>`,
      deleteSourceModalConfirmText: '确认',
      errorMsg: '错误信息',
      newDocs: '新文档',
      timeStarted: '开始时间',
      log: '日志',
      confluenceDescription: '连接你的 Confluence 工作区以搜索文档内容。',
      s3Description: ' 连接你的 AWS S3 存储桶以导入和同步文件。',
      google_cloud_storageDescription:
        '连接你的 Google Cloud Storage 存储桶以导入和同步文件。',
      discordDescription: ' 连接你的 Discord 服务器以访问和分析聊天数据。',
      notionDescription: ' 同步 Notion 页面与数据库，用于知识检索。',
      oci_storageDescription:
        '连接你的 Oracle Cloud Object Storage 存储桶以导入和同步文件。',
      google_driveDescription:
        '通过 OAuth 连接 Google Drive，并同步指定的文件夹或云端硬盘。',
      gmailDescription: '通过 OAuth 连接 Gmail，用于同步邮件。',
      google_driveTokenTip:
        '请上传由 OAuth helper 或 Google Cloud Console 导出的 OAuth token JSON。也支持上传 “installed” 或 “web” 类型的 client_secret JSON。若为首次同步，将自动弹出浏览器完成 OAuth 授权流程；如果该 JSON 已包含 refresh token，将会被自动复用。',
      google_drivePrimaryAdminTip: '拥有相应 Drive 访问权限的管理员邮箱。',
      google_driveMyDriveEmailsTip:
        '需要索引其 “我的云端硬盘” 的邮箱，多个邮箱用逗号分隔（建议包含管理员）。',
      google_driveSharedFoldersTip:
        '需要同步的 Google Drive 文件夹链接，多个链接用逗号分隔。',
      gmailPrimaryAdminTip:
        '拥有 Gmail / Workspace 访问权限的主要管理员邮箱，用于列出域内用户并作为默认同步账号。',
      gmailTokenTip:
        '请上传由 Google Console 生成的 OAuth JSON。如果仅包含 client credentials，请通过浏览器授权一次以获取长期有效的刷新 Token。',
      dropboxDescription: '连接 Dropbox，同步指定账号下的文件与文件夹。',
      boxDescription: '连接你的 Box 云盘以同步文件和文件夹。',
      bitbucketDescription: '连接 Bitbucket，同步 PR 内容。',
      bitbucketTopWorkspaceTip:
        '要索引的 Bitbucket 工作区（例如：https://bitbucket.org/atlassian/workspace 中的 "atlassian"）',
      bitbucketWorkspaceTip: '该连接器将索引工作区下的所有仓库。',
      bitbucketProjectsTip: '用英文逗号分隔的项目 key，例如：PROJ1,PROJ2',
      bitbucketRepositorySlugsTip:
        '用英文逗号分隔的仓库 slug，例如：repo-one,repo-two',
      connectorNameTip: '为连接器命名',
      githubDescription:
        '连接 GitHub，可同步 Pull Request 与 Issue 内容用于检索。',
      airtableDescription: '连接 Airtable，同步指定工作区下指定表格中的文件。',
      gitlabDescription:
        '连接 GitLab，同步仓库、Issue、合并请求（MR）及相关文档内容。',
      asanaDescription: '连接 Asana，同步工作区中的文件。',
      imapDescription:
        '连接你的 IMAP 邮箱，同步指定mailboxes中的邮件，用于知识检索与分析',
      r2Description: '连接你的 Cloudflare R2 存储桶以导入和同步文件。',
      dropboxAccessTokenTip:
        '请在 Dropbox App Console 生成 Access Token，并勾选 files.metadata.read、files.content.read、sharing.read 等必要权限。',
      jiraDescription: '接入 Jira 工作区，持续同步Issues、评论与附件。',
      jiraBaseUrlTip:
        'Jira 的 Base URL，例如：https://your-domain.atlassian.net。',
      jiraProjectKeyTip: '可选：仅同步指定的项目（如 RAG）。',
      jiraJqlTip: '可选：自定义 JQL 过滤条件，留空则使用项目 / 时间范围。',
      jiraBatchSizeTip: '每次向 Jira 请求的 Issue 数量上限。',
      jiraCommentsTip: '同步评论。',
      jiraAttachmentsTip: '开启后会将附件下载为独立文档。',
      jiraAttachmentSizeTip: '超过该字节阈值的附件会被跳过。',
      jiraLabelsTip: '需要跳过的标签（逗号分隔）。',
      jiraBlacklistTip: '这些邮箱作者的评论会被忽略。',
      jiraScopedTokenTip:
        '仅当凭证为 Atlassian scoped token（api.atlassian.com）时生效。',
      jiraEmailTip: '与 API Token 对应的 Jira 账户邮箱。',
      jiraTokenTip:
        '在 https://id.atlassian.com/manage-profile/security/api-tokens 生成的 API Token。 (Clould only)',
      jiraPasswordTip: '可选：仅 Jira Server/Data Center 环境需要的密码字段。',
      availableSourcesDescription: '选择要添加的数据源',
      availableSources: '可用数据源',
      datasourceDescription: '管理您的数据源和连接',
      save: '保存',
      search: '搜索',
      availableModels: '可选模型',
      profile: '概要',
      avatar: '头像',
      avatarTip: '这会在你的个人主页展示',
      profileDescription: '在此更新您的照片和个人详细信息。',
      maxTokens: '最大token数',
      maxTokensMessage: '最大token数是必填项',
      maxTokensTip: `模型的最大上下文大小；无效或不正确的值会导致错误。默认值为 512。`,
      maxTokensInvalidMessage: '请输入有效的最大令牌数。',
      maxTokensMinMessage: '最大令牌数不能小于 0。',
      password: '密码',
      passwordDescription: '请输入您当前的密码以更改您的密码。',
      model: '模型提供商',
      systemModelDescription: '请在开始之前完成这些设置',
      dataSources: '数据源',
      team: '团队',
      system: '系统',
      logout: '登出',
      api: 'API',
      username: '用户名',
      usernameMessage: '请输入用户名',
      photo: '头像',
      photoDescription: '这将显示在您的个人资料上。',
      colorSchema: '主题',
      colorSchemaMessage: '请选择您的主题！',
      colorSchemaPlaceholder: '请选择您的主题！',
      bright: '明亮',
      dark: '暗色',
      timezone: '时区',
      timezoneMessage: '请选择时区',
      timezonePlaceholder: '请选择时区',
      email: '邮箱',
      emailDescription: '一旦注册，电子邮件将无法更改。',
      currentPassword: '当前密码',
      currentPasswordMessage: '请输入当前密码',
      newPassword: '新密码',
      changePassword: '修改密码',
      newPasswordMessage: '请输入新密码',
      newPasswordDescription: '您的新密码必须超过 8 个字符。',
      confirmPassword: '确认新密码',
      confirmPasswordMessage: '请确认新密码',
      confirmPasswordNonMatchMessage: '您输入的新密码不匹配！',
      cancel: '取消',
      addedModels: '添加了的模型',
      modelsToBeAdded: '待添加的模型',
      addTheModel: '添加',
      apiKey: 'API-Key',
      apiKeyMessage: '请输入api key',
      apiKeyTip: 'API key可以通过注册相应的LLM供应商来获取。',
      showMoreModels: '展示更多模型',
      hideModels: '隐藏模型',
      baseUrl: 'Base-Url',
      baseUrlTip:
        '如果您的 API 密钥来自 OpenAI，请忽略它。 任何其他中间提供商都会提供带有 API 密钥的基本 URL。',
      tongyiBaseUrlTip:
        '对于中国用户，不需要填写或使用 https://dashscope.aliyuncs.com/compatible-mode/v1。对于国际用户，使用 https://dashscope-intl.aliyuncs.com/compatible-mode/v1。',
      tongyiBaseUrlPlaceholder: '(仅国际用户需要)',
      minimaxBaseUrlTip: '仅国际用户：使用 https://api.minimax.io/v1。',
      minimaxBaseUrlPlaceholder: '(仅国际用户填写 https://api.minimax.io/v1)',
      modify: '修改',
      systemModelSettings: '设置默认模型',
      chatModel: 'LLM',
      chatModelTip: '所有新创建的知识库都会使用默认的聊天模型。',
      ttsModel: 'TTS',
      ttsModelTip:
        '默认的tts模型会被用于在对话过程中请求语音生成时使用。如未显示可选模型，请根据 https://ragflow.io/docs/dev/supported_models 确认你的模型供应商是否提供该模型。',
      embeddingModel: 'Embedding',
      embeddingModelTip:
        '所有新创建的知识库使用的默认嵌入模型。如未显示可选模型，请检查你是否在使用 RAGFlow slim 版(不含嵌入模型)；或根据 https://ragflow.io/docs/dev/supported_models 确认你的模型供应商是否提供该模型。',
      img2txtModel: 'VLM',
      img2txtModelTip:
        '所有新创建的知识库都将使用默认的 img2txt 模型。 它可以描述图片或视频。如未显示可选模型，请根据 https://ragflow.io/docs/dev/supported_models 确认你的模型供应商是否提供该模型。',
      sequence2txtModel: 'ASR',
      sequence2txtModelTip:
        '所有新创建的知识库都将使用默认的 ASR 模型。 使用此模型将语音翻译为相应的文本。如未显示可选模型，请根据 https://ragflow.io/docs/dev/supported_models 确认你的模型供应商是否提供该模型。',
      rerankModel: 'Rerank',
      rerankModelTip: `默认的 reranking 模型。如未显示可选模型，请根据 https://ragflow.io/docs/dev/supported_models 确认你的模型供应商是否提供该模型。`,
      workspace: '工作空间',
      upgrade: '升级',
      addLlmTitle: '添加 LLM',
      editLlmTitle: '编辑 {{name}} 模型',
      editModel: '编辑模型',
      modelName: '模型名称',
      modelID: '模型ID',
      modelUid: '模型UID',
      modelType: '模型类型',
      addLlmBaseUrl: '基础 Url',
      vision: '是否支持 Vision',
      modelNameMessage: '请输入模型名称！',
      modelTypeMessage: '请输入模型类型！',
      baseUrlNameMessage: '请输入基础 Url！',
      ollamaLink: '如何集成 {{name}}',
      FishAudioLink: '如何使用Fish Audio',
      TencentCloudLink: '如何使用腾讯云语音识别',
      volcModelNameMessage: '请输入模型名称！',
      addEndpointID: '模型 EndpointID',
      endpointIDMessage: '请输入模型对应的EndpointID',
      addArkApiKey: '火山 ARK_API_KEY',
      ArkApiKeyMessage: '请输入火山创建的ARK_API_KEY',
      bedrockModelNameMessage: '请输入名称！',
      addBedrockEngineAK: 'ACCESS KEY',
      bedrockAKMessage: '请输入 ACCESS KEY',
      addBedrockSK: 'SECRET KEY',
      bedrockSKMessage: '请输入 SECRET KEY',
      awsAuthModeAccessKeySecret: 'Access Key 和 Secret',
      awsAuthModeIamRole: 'IAM Role',
      awsAuthModeAssumeRole: 'Assume Role',
      awsAccessKeyId: 'AWS Access Key ID',
      awsSecretAccessKey: 'AWS Secret Access Key',
      awsRoleArn: 'AWS Role ARN',
      awsRoleArnMessage: '请输入 AWS Role ARN',
      awsAssumeRoleTip:
        '选择此模式后，EC2 实例将使用其已有的 IAM Role 访问 AWS 服务，无需额外的凭证。',
      bedrockRegion: 'AWS Region',
      bedrockRegionMessage: '请选择！',
      'us-east-1': '美国东部 (弗吉尼亚北部)',
      'us-west-2': '美国西部 (俄勒冈州)',
      'ap-southeast-1': '亚太地区 (新加坡)',
      'ap-northeast-1': '亚太地区 (东京)',
      'eu-central-1': '欧洲 (法兰克福)',
      'us-gov-west-1': 'AWS GovCloud (US-West)',
      'ap-southeast-2': '亚太地区 (悉尼)',
      addTencentCloudSID: '腾讯云 Secret ID',
      TencentCloudSIDMessage: '请输入 Secret ID',
      addTencentCloudSK: '腾讯云 Secret Key',
      TencentCloudSKMessage: '请输入 Secret Key',
      SparkModelNameMessage: '请选择星火模型！',
      addSparkAPIPassword: '星火 APIPassword',
      SparkAPIPasswordMessage: '请输入 APIPassword',
      addSparkAPPID: '星火 APPID',
      SparkAPPIDMessage: '请输入 APPID',
      addSparkAPISecret: '星火 APISecret',
      SparkAPISecretMessage: '请输入 APISecret',
      addSparkAPIKey: '星火 APIKey',
      SparkAPIKeyMessage: '请输入 APIKey',
      yiyanModelNameMessage: '请输入模型名称',
      addyiyanAK: '一言 API KEY',
      yiyanAKMessage: '请输入 API KEY',
      addyiyanSK: '一言 Secret KEY',
      yiyanSKMessage: '请输入 Secret KEY',
      FishAudioModelNameMessage: '请为你的TTS模型起名',
      addFishAudioAK: 'Fish Audio API KEY',
      FishAudioAKMessage: '请输入 API KEY',
      addFishAudioRefID: 'FishAudio Refrence ID',
      FishAudioRefIDMessage: '请输入引用模型的ID（留空表示使用默认模型）',
      GoogleModelIDMessage: '请输入 model ID!',
      addGoogleProjectID: 'Project ID',
      GoogleProjectIDMessage: '请输入 Project ID',
      addGoogleServiceAccountKey:
        'Service Account Key(Leave blank if you use Application Default Credentials)',
      GoogleServiceAccountKeyMessage:
        '请输入 Google Cloud Service Account Key in base64 format',
      addGoogleRegion: 'Google Cloud 区域',
      GoogleRegionMessage: '请输入 Google Cloud 区域',
      modelProvidersWarn: `请先在<b>模型提供商</b>中添加嵌入模型和LLM，然后在“设置默认模型”中设置它们。`,
      apiVersion: 'API版本',
      apiVersionMessage: '请输入API版本!',
      add: '添加',
      updateDate: '日期',
      role: '状态',
      invite: '邀请成员',
      agree: '同意',
      refuse: '拒绝',
      teamMembers: '团队成员',
      joinedTeams: '加入的团队',
      sureDelete: '您确定要删除该成员吗？',
      quit: '退出',
      sureQuit: '确定退出加入的团队吗？',
      secretKey: '密钥',
      publicKey: '公钥',
      secretKeyMessage: '请输入私钥',
      publicKeyMessage: '请输入公钥',
      hostMessage: '请输入 host',
      configuration: '配置',
      langfuseDescription:
        '跟踪、评估、提示管理和指标，以调试和改进您的 LLM 应用程序。',
      viewLangfuseSDocumentation: '查看 Langfuse 的文档',
      view: '查看',
      modelsToBeAddedTooltip:
        '如果你的模型供应商在这里没有列出，但是宣称 OpenAI-compatible，可以通过选择卡片 OpenAI-API-compatible 设置相关模型。',
      mcp: 'MCP',
      mineru: {
        modelNameRequired: '模型名称为必填项',
        apiServerRequired: 'MinerU API服务器配置为必填项',
        serverUrlBackendLimit: '仅在backend 为vlm-http-client 时可填写',
        apiserver: 'MinerU API服务器配置',
        outputDir: 'MinerU输出目录路径',
        backend: 'MinerU处理后端类型',
        serverUrl: 'MinerU服务器URL地址',
        deleteOutput: '处理完成后删除输出文件',
        selectBackend: '选择处理后端',
        backendOptions: {
          pipeline: '标准流水线处理',
          vlmTransformers: '基于Transformers的视觉语言模型',
          vlmVllmEngine: '基于vLLM引擎的视觉语言模型',
          vlmHttpClient: '通过HTTP客户端连接的视觉语言模型',
          vlmMlxEngine: '基于MLX引擎的视觉语言模型',
          vlmVllmAsyncEngine: '基于vLLM异步引擎的视觉语言模型（实验性）',
          vlmLmdeployEngine: '基于LMDeploy引擎的视觉语言模型（实验性）',
        },
      },
      paddleocr: {
        apiUrl: 'PaddleOCR API URL',
        apiUrlPlaceholder: '例如：https://paddleocr-server.com/layout-parsing',
        accessToken: 'AI Studio访问令牌',
        accessTokenPlaceholder: '您的 AI Studio 令牌（可选）',
        algorithm: 'PaddleOCR算法',
        selectAlgorithm: '选择算法',
        modelNamePlaceholder: '例如：paddleocr-from-env-1',
        modelNameRequired: '模型名称为必填项',
        apiUrlRequired: 'PaddleOCR API URL 为必填项',
      },
      showToc: '显示目录',
      hideToc: '隐藏目录',
    },
    message: {
      registered: '注册成功',
      logout: '登出成功',
      logged: '登录成功',
      pleaseSelectChunk: '请选择解析块',
      modified: '更新成功',
      created: '创建成功',
      deleted: '删除成功',
      renamed: '重命名成功',
      operated: '操作成功',
      updated: '更新成功',
      uploaded: '上传成功',
      200: '服务器成功返回请求的数据。',
      201: '新建或修改数据成功。',
      202: '一个请求已经进入后台排队（异步任务）。',
      204: '删除数据成功。',
      400: '发出的请求有错误，服务器没有进行新建或修改数据的操作。',
      401: '请重新登录。',
      403: '用户得到授权，但是访问是被禁止的。',
      404: '发出的请求针对的是不存在的记录，服务器没有进行操作。',
      406: '请求的格式不可得。',
      410: '请求的资源被永久删除，且不会再得到的。',
      413: '上传的文件总大小过大。',
      422: '当创建一个对象时，发生一个验证错误。',
      500: '服务器发生错误，请检查服务器。',
      502: '网关错误。',
      503: '服务不可用，服务器暂时过载或维护。',
      504: '网关超时。',
      requestError: '请求错误',
      networkAnomalyDescription: '您的网络发生异常，无法连接服务器',
      networkAnomaly: '网络异常',
      hint: '提示',
    },
    fileManager: {
      files: '文件',
      name: '名称',
      uploadDate: '上传日期',
      knowledgeBase: '知识库',
      size: '大小',
      action: '操作',
      addToKnowledge: '链接知识库',
      pleaseSelect: '请选择',
      newFolder: '新建文件夹',
      uploadFile: '上传文件',
      parseOnCreation: '创建时解析',
      uploadTitle: '点击或拖拽文件至此区域即可上传',
      uploadDescription:
        '支持单次或批量上传。 本地部署的单次上传文件总大小上限为 1GB，单次批量上传文件数不超过 32，单个账户不限文件数量。对于 demo.ragflow.io：每次上传的总文件大小限制为 10MB，每个文件不得超过 10MB，每个账户最多可上传 128 个文件。严禁上传违禁文件。',
      file: '文件',
      directory: '文件夹',
      local: '本地上传',
      s3: 'S3 上传',
      preview: '预览',
      fileError: '文件错误',
      uploadLimit: '文件大小不能超过10M，文件总数不超过128个',
      destinationFolder: '目标文件夹',
      pleaseUploadAtLeastOneFile: '请上传至少一个文件',
    },
    flow: {
      autoPlay: '自动播放',
      downloadFileTypeTip: '文件下载的类型',
      downloadFileType: '文件类型',
      formatTypeError: '格式或类型错误',
      variableNameMessage: '名称只能包含字母,数字和下划线',
      variableDescription: '变量的描述',
      defaultValue: '默认值',
      conversationVariable: '会话变量',
      recommended: '推荐',
      customerSupport: '客户支持',
      marketing: '营销',
      consumerApp: '消费者应用',
      other: '其他',
      agents: '智能体',
      beginInput: '开始输入',
      seconds: '秒',
      ref: '引用变量',
      stockCode: '股票代码',
      apiKeyPlaceholder: '您的API密钥(从https://serpapi.com获取)',
      flowStart: '开始',
      flowNum: '编号',
      test: '测试',
      extractDepth: '深度提取',
      format: '格式',
      basic: '基本',
      advanced: '高级',
      general: '通用',
      searchDepth: '深度搜索',
      tavilyTopic: 'Tavily话题',
      maxResults: '最大结果数',
      includeAnswer: '包含答案',
      includeRawContent: '包含原始内容',
      includeImages: '包含图片',
      includeImageDescriptions: '包含图片描述',
      includeDomains: '包含域名',
      ExcludeDomains: '排除域名',
      days: '天数',
      comma: '逗号',
      semicolon: '分号',
      period: '句点',
      linebreak: '换行符',
      tab: '制表符',
      space: '空格',
      delimiters: '分隔符',
      merge: '合并',
      split: '拆分',
      script: '脚本',
      iterationItemDescription:
        '它是迭代过程中的当前元素，可以被后续流程引用和操作。',
      guidingQuestion: '引导问题',
      onFailure: '异常时',
      userPromptDefaultValue:
        'This is the order you need to send to the agent.',
      descriptionMessage: '这是一个用于特定任务的代理。',
      search: '搜索',
      communication: '通信',
      developer: '开发者',
      typeCommandORsearch: '输入命令或或搜索...',
      builtIn: '内置',
      goto: '异常分支',
      comment: '默认值',
      ExceptionDefaultValue: '异常处理默认值',
      exceptionMethod: '异常处理方法',
      maxRounds: '最大反思轮数',
      delayAfterError: '错误后延迟',
      maxRetries: '最大重试轮数',
      advancedSettings: '高级设置',
      addTools: '添加工具',
      sysPromptDefultValue: `
<role>
  你是一名乐于助人的助手，一名专注于为用户解决问题的 AI 助手。
  如果用户指定了特定领域，你需要在该领域展现专业性；如果没有，则以通用助手的方式工作。
</role>
<instructions>
        1. 理解用户请求。
        2. 将其分解为逻辑子任务。
        3. 逐步执行每个子任务，并清晰地进行推理。
        4. 验证准确性和一致性。
        5. 清晰地总结最终结果。
</instructions>`,
      line: '单行文本',
      paragraph: '段落文字',
      options: '选项',
      file: '文件',
      integer: '数字',
      boolean: '布尔值',
      name: '名称',
      singleLineText: '单行文本',
      variableSettings: '变量设置',
      multimodalModels: '多模态模型',
      textOnlyModels: '仅文本模型',
      allModels: '所有模型',
      codeExecDescription: '用 Python 或者 Javascript 编写自定义逻辑',
      stringTransformDescription:
        '修改文本内容，目前支持文本分割、文本拼接操作',
      foundation: '基础',
      tools: '工具',
      dataManipulation: '数据操控',
      dialog: '对话',
      flow: '工作流',
      noMoreData: '没有更多数据了',
      historyVersion: '历史版本',
      version: {
        details: '版本详情',
        download: '下载',
      },
      cite: '引用',
      citeTip: '引用',
      nameMessage: '请输入名称',
      description: '描述',
      examples: '示例',
      to: '下一步',
      msg: '消息',
      msgTip: '输出上游组件的变量内容或者自己输入的文本。',
      messagePlaceholder: '请输入您的消息内容，使用‘/’快速插入变量。',
      messageMsg: '请输入消息或删除此字段。',
      addField: '新增字段',
      addMessage: '新增消息',
      loop: '循环',
      loopDescription:
        'loop为当前组件循环次数上限，当循环次数超过loop的值时，说明组件不能完成当前任务，请重新优化agent',
      exitLoop: '退出循环',
      exitLoopDescription: `等同于 "break"。此节点没有配置项。当循环体到达此节点时，循环终止。`,
      loopVariables: '循环变量',
      maximumLoopCount: '最大循环次数',
      loopTerminationCondition: '循环终止条件',
      yes: '是',
      no: '否',
      key: '键',
      componentId: '组件ID',
      add: '新增',
      operation: '操作',
      run: '运行',
      save: '保存',
      title: 'ID：',
      beginDescription: '这是流程开始的地方',
      answerDescription: `该组件用作机器人与人类之间的接口。它接收用户的输入并显示机器人的计算结果。`,
      retrievalDescription: `此组件用于从知识库中检索相关信息。选择知识库。如果没有检索到任何内容，将返回“空响应”。`,
      generateDescription: `此组件用于调用LLM生成文本，请注意提示的设置。`,
      categorizeDescription: `此组件用于对文本进行分类。请指定类别的名称、描述和示例。每个类别都指向不同的下游组件。`,
      relevantDescription: `该组件用来判断upstream的输出是否与用户最新的问题相关，‘是’代表相关，‘否’代表不相关。`,
      rewriteQuestionDescription: `此组件用于细化用户的提问。通常，当用户的原始提问无法从知识库中检索到相关信息时，此组件可帮助您将问题更改为更符合知识库表达方式的适当问题。`,
      messageDescription:
        '该组件用来返回工作流最后产生的数据内容和原先设置的文本内容。',
      keywordDescription: `该组件用于从用户的问题中提取关键词。Top N指定需要提取的关键词数量。`,
      switchDescription: `该组件用于根据前面组件的输出评估条件，并相应地引导执行流程。通过定义各种情况并指定操作，或在不满足条件时采取默认操作，实现复杂的分支逻辑。`,
      wikipediaDescription: `此组件用于从 https://www.wikipedia.org/ 获取搜索结果。通常，它作为知识库的补充。Top N 指定您需要调整的搜索结果数量。`,
      promptText: `请总结以下段落。注意数字，不要胡编乱造。段落如下：
{input}
以上就是你需要总结的内容。`,
      createGraph: '创建智能体',
      createFromTemplates: '从模板创建',
      retrieval: '知识检索',
      generate: '生成回答',
      answer: '对话',
      categorize: '问题分类',
      relevant: '是否相关',
      rewriteQuestion: '问题优化',
      begin: '开始',
      message: '回复消息',
      blank: '空',
      createFromNothing: '从无到有',
      addItem: '新增',
      addSubItem: '新增子项',
      nameRequiredMsg: '名称不能为空',
      nameRepeatedMsg: '名称不能重复',
      keywordExtract: '关键词',
      keywordExtractDescription: `该组件用于从用户的问题中提取关键词。Top N指定需要提取的关键词数量。`,
      baidu: '百度',
      baiduDescription: `此组件用于从 www.baidu.com 获取搜索结果。通常，它作为知识库的补充。Top N 指定您需要调整的搜索结果数量。`,
      duckDuckGo: 'DuckDuckGo',
      duckDuckGoDescription:
        '此元件用於從 www.duckduckgo.com 取得搜尋結果。通常，它作為知識庫的補充。 Top N 指定您需要調整的搜尋結果數。',
      searXNG: 'SearXNG',
      searXNGDescription:
        '该组件通过您提供的 SearXNG 实例地址进行搜索。请设置 Top N 和实例 URL。',
      pdfGenerator: '文档生成器',
      pDFGenerator: '文档生成器',
      pdfGeneratorDescription: `该组件从 markdown 格式的内容生成文档（PDF、DOCX、TXT），支持自定义样式、图片和表格。支持：**粗体**、*斜体*、# 标题、- 列表、使用 | 语法的表格。`,
      pDFGeneratorDescription: `该组件从 markdown 格式的内容生成文档（PDF、DOCX、TXT），支持自定义样式、图片和表格。支持：**粗体**、*斜体*、# 标题、- 列表、使用 | 语法的表格。`,
      subtitle: '副标题',
      logoImage: '标志图片',
      logoPosition: '标志位置',
      logoWidth: '标志宽度',
      logoHeight: '标志高度',
      fontFamily: '字体系列',
      fontSize: '字体大小',
      titleFontSize: '标题字体大小',
      pageSize: '页面大小',
      orientation: '方向',
      marginTop: '上边距',
      marginBottom: '下边距',
      filename: '文件名',
      outputDirectory: '输出目录',
      addPageNumbers: '添加页码',
      addTimestamp: '添加时间戳',
      watermarkText: '水印文本',
      channel: '频道',
      channelTip: '针对该组件的输入进行文本搜索或新闻搜索',
      text: '文本',
      news: '新闻',
      messageHistoryWindowSize: '历史消息窗口大小',
      messageHistoryWindowSizeTip:
        'LLM 需要查看的对话历史窗口大小。越大越好。但要注意 LLM 的最大 Token 数。',
      wikipedia: '维基百科',
      emailTip:
        '此组件用于从 https://pubmed.ncbi.nlm.nih.gov/ 获取搜索结果。通常，它作为知识库的补充。Top N 指定您需要调整的搜索结果数。电子邮件是必填字段。',
      email: '邮箱',
      pubMed: 'PubMed',
      pubMedDescription:
        '此组件用于从 https://pubmed.ncbi.nlm.nih.gov/ 获取搜索结果。通常，它作为知识库的补充。Top N 指定您需要调整的搜索结果数。电子邮件是必填字段。',
      arXiv: 'ArXiv',
      arXivDescription:
        '此组件用于从 https://arxiv.org/ 获取搜索结果。通常，它作为知识库的补充。Top N 指定您需要调整的搜索结果数量。',
      sortBy: '排序方式',
      submittedDate: '提交日期',
      lastUpdatedDate: '最后更新日期',
      relevance: '关联',
      google: 'Google',
      googleDescription:
        '此组件用于从https://www.google.com/获取搜索结果。通常，它作为知识库的补充。Top N 和 SerpApi API 密钥指定您需要调整的搜索结果数量。',
      bing: 'Bing',
      bingDescription:
        '此组件用于从 https://www.bing.com/ 获取搜索结果。通常，它作为知识库的补充。Top N 和 Bing Subscription-Key 指定您需要调整的搜索结果数量。',
      apiKey: 'API密钥',
      country: '国家和地区',
      language: '语言',
      googleScholar: '谷歌学术',
      googleScholarDescription: `此组件用于从 https://scholar.google.com/ 获取搜索结果。通常，它作为知识库的补充。Top N 指定您需要调整的搜索结果数量。`,
      yearLow: '开始年份',
      yearHigh: '结束年份',
      patents: '专利',
      data: '数据',
      deepL: 'DeepL',
      deepLDescription:
        '该组件用于从 https://www.deepl.com/ 获取翻译。通常，它提供更专业的翻译结果。',
      authKey: '授权键',
      sourceLang: '源语言',
      targetLang: '目标语言',
      gitHub: 'GitHub',
      gitHubDescription:
        '该组件用于从 https://github.com/ 搜索仓库。Top N 指定需要调整的搜索结果数量。',
      baiduFanyi: '百度翻译',
      baiduFanyiDescription:
        '该组件用于从 https://fanyi.baidu.com/ 获取翻译。通常，它提供更专业的翻译结果',
      appid: 'App id',
      secretKey: '秘钥',
      domain: '领域',
      transType: '翻译类型',
      baiduSecretKeyOptions: {
        translate: '通用翻译',
        fieldtranslate: '领域翻译',
      },
      baiduDomainOptions: {
        it: '信息技术领域',
        finance: '金融财经领域',
        machinery: '机械制造领域',
        senimed: '生物医药领域',
        novel: '网络文学领域',
        academic: '学术论文领域',
        aerospace: '航空航天领域',
        wiki: '人文社科领域',
        news: '新闻资讯领域',
        law: '法律法规领域',
        contract: '合同领域',
      },
      baiduSourceLangOptions: {
        auto: '自动检测',
        zh: '中文',
        en: '英语',
        yue: '粤语',
        wyw: '文言文',
        jp: '日语',
        kor: '韩语',
        fra: '法语',
        spa: '西班牙语',
        th: '泰语',
        ara: '阿拉伯语',
        ru: '俄语',
        pt: '葡萄牙语',
        de: '德语',
        it: '意大利语',
        el: '希腊语',
        nl: '荷兰语',
        pl: '波兰语',
        bul: '保加利亚语',
        est: '爱沙尼亚语',
        dan: '丹麦语',
        fin: '芬兰语',
        cs: '捷克语',
        rom: '罗马尼亚语',
        slo: '斯洛文尼亚语',
        swe: '瑞典语',
        hu: '匈牙利语',
        cht: '繁体中文',
        vie: '越南语',
      },
      qWeather: '和风天气',
      qWeatherDescription:
        '该组件用于从 https://www.qweather.com/ 获取天气相关信息。您可以获取天气、指数、空气质量。',
      lang: '语言',
      type: '类型',
      webApiKey: 'Web API 密钥',
      userType: '用户类型',
      timePeriod: '时间段',
      qWeatherLangOptions: {
        zh: '简体中文',
        'zh-hant': '繁体中文',
        en: '英文',
        de: '德语',
        es: '西班牙语',
        fr: '法语',
        it: '意大利语',
        ja: '日语',
        ko: '韩语',
        ru: '俄语',
        hi: '印地语',
        th: '泰语',
        ar: '阿拉伯语',
        pt: '葡萄牙语',
        bn: '孟加拉语',
        ms: '马来语',
        nl: '荷兰语',
        el: '希腊语',
        la: '拉丁语',
        sv: '瑞典语',
        id: '印尼语',
        pl: '波兰语',
        tr: '土耳其语',
        cs: '捷克语',
        et: '爱沙尼亚语',
        vi: '越南语',
        fil: '菲律宾语',
        fi: '芬兰语',
        he: '希伯来语',
        is: '冰岛语',
        nb: '挪威语',
      },
      qWeatherTypeOptions: {
        weather: '天气预报',
        indices: '天气生活指数',
        airquality: '空气质量',
      },
      qWeatherUserTypeOptions: {
        free: '免费订阅用户',
        paid: '付费订阅用户',
      },
      qWeatherTimePeriodOptions: {
        now: '现在',
        '3d': '3天',
        '7d': '7天',
        '10d': '10天',
        '15d': '12天',
        '30d': '30天',
      },
      publish: 'API',
      exeSQL: '执行 SQL',
      exeSQLDescription:
        '该组件通过SQL语句从相应的关系数据库中查询结果。支持MySQL，PostgreSQL，MariaDB。',
      dbType: '数据库类型',
      database: '数据库',
      username: '用户名',
      host: '主机',
      port: '端口',
      password: '密码',
      switch: '条件',
      logicalOperator: '操作符',
      switchOperatorOptions: {
        equal: '等于',
        notEqual: '不等于',
        gt: '大于',
        ge: '大于等于',
        lt: '小于',
        le: '小于等于',
        contains: '包含',
        notContains: '不包含',
        startWith: '开始是',
        endWith: '结束是',
        empty: '为空',
        notEmpty: '不为空',
        is: '是',
        isNot: '不是',
      },
      switchLogicOperatorOptions: {
        and: '与',
        or: '或',
      },
      operator: '操作符',
      value: '值',
      useTemplate: '使用',
      wenCai: '问财',
      queryType: '查询类型',
      wenCaiDescription:
        '该组件可用于获取广泛金融领域的信息，包括但不限于股票、基金等...',
      wenCaiQueryTypeOptions: {
        stock: '股票',
        zhishu: '指数',
        fund: '基金',
        hkstock: '港股',
        usstock: '美股',
        threeboard: '新三板',
        conbond: '可转债',
        insurance: '保险',
        futures: '期货',
        lccp: '理财',
        foreign_exchange: '外汇',
      },
      akShare: 'AkShare',
      akShareDescription: '该组件可用于从东方财富网站获取相应股票的新闻信息。',
      yahooFinance: '雅虎财经',
      yahooFinanceDescription: '该组件根据提供的股票代码查询有关公司的信息。',
      crawler: '网页爬虫',
      crawlerDescription: '该组件可用于从指定url爬取html源码。',
      proxy: '代理',
      crawlerResultOptions: {
        html: 'Html',
        markdown: 'Markdown',
        content: '文本',
      },
      extractType: '提取类型',
      info: '信息',
      history: '历史',
      financials: '财务',
      balanceSheet: '资产负债表',
      cashFlowStatement: '现金流量表',
      jin10: '金十',
      jin10Description:
        '该组件可用于从金十开放平台获取金融领域的信息，包括快讯、日历、行情、参考。',
      flashType: '闪光类型',
      filter: '筛选',
      contain: '包含',
      calendarType: '日历类型',
      calendarDatashape: '日历数据形状',
      symbolsDatatype: '符号数据类型',
      symbolsType: '符号类型',
      jin10TypeOptions: {
        flash: '快讯',
        calendar: '日历',
        symbols: '行情',
        news: '参考',
      },
      jin10FlashTypeOptions: {
        '1': '市场快讯',
        '2': '期货快讯',
        '3': '美港快讯',
        '4': 'A股快讯',
        '5': '商品外汇快讯',
      },
      jin10CalendarTypeOptions: {
        cj: '宏观数据日历',
        qh: '期货日历',
        hk: '港股日历',
        us: '美股日历',
      },
      jin10CalendarDatashapeOptions: {
        data: '数据',
        event: ' 事件',
        holiday: '假期',
      },
      jin10SymbolsTypeOptions: {
        GOODS: '商品行情',
        FOREX: '外汇行情',
        FUTURE: '国际行情',
        CRYPTO: '加密货币行情',
      },
      jin10SymbolsDatatypeOptions: {
        symbols: '品种列表',
        quotes: '最新行情',
      },
      concentrator: '集线器',
      concentratorDescription:
        '该组件可用于连接多个下游组件。它接收来自上游组件的输入并将其传递给每个下游组件。',
      tuShare: 'TuShare',
      tuShareDescription:
        '该组件可用于从主流金融网站获取金融新闻简报，辅助行业和量化研究。',
      tuShareSrcOptions: {
        sina: '新浪财经',
        wallstreetcn: '华尔街见闻',
        '10jqka': '同花顺',
        eastmoney: '东方财富',
        yuncaijing: '云财经',
        fenghuang: '凤凰新闻',
        jinrongjie: '金融界',
      },
      token: 'Token',
      src: '源',
      startDate: '开始日期',
      endDate: '结束日期',
      keyword: '关键字',
      note: '注释',
      noteDescription: '注释',
      notePlaceholder: '请输入注释',
      invoke: 'HTTP 请求',
      invokeDescription:
        '该组件可以调用远程端点调用。将其他组件的输出作为参数或设置常量参数来调用远程函数。',
      url: 'Url',
      method: '方法',
      timeout: '超时',
      headers: '请求头',
      cleanHtml: '清除 HTML',
      cleanHtmlTip: '如果响应是 HTML 格式且只需要主要内容，请将其打开。',
      invalidUrl:
        '必须是有效的 URL 或包含变量占位符的 URL，格式为 {variable_name} 或 {component@variable}',
      reference: '引用',
      input: '输入',
      output: '输出',
      parameter: '参数',
      howUseId: '如何使用Agent ID？',
      content: '内容',
      operationResults: '运行结果',
      autosaved: '已自动保存',
      optional: '可选项',
      pasteFileLink: '粘贴文件链接',
      testRun: '试运行',
      template: '模板转换',
      templateDescription:
        '该组件用于排版各种组件的输出。1、支持Jinja2模板,会先将输入转为对象后进行模版渲染2、同时保留原使用{参数}字符串替换的方式',
      emailComponent: '邮件',
      emailDescription: '发送邮件到指定邮箱',
      smtpServer: 'SMTP服务器',
      smtpPort: 'SMTP端口',
      senderEmail: '发件人邮箱',
      authCode: '授权码',
      senderName: '发件人名称',
      toEmail: '收件人邮箱',
      ccEmail: '抄送邮箱',
      emailSubject: '邮件主题',
      emailContent: '邮件内容',
      smtpServerRequired: '请输入SMTP服务器地址',
      senderEmailRequired: '请输入发件人邮箱',
      authCodeRequired: '请输入授权码',
      toEmailRequired: '请输入收件人邮箱',
      emailContentRequired: '请输入邮件内容',
      emailSentSuccess: '邮件发送成功',
      emailSentFailed: '邮件发送失败',
      dynamicParameters: '动态参数说明',
      jsonFormatTip: '上游组件需要传入以下格式的JSON字符串:',
      toEmailTip: 'to_email: 收件人邮箱(必填)',
      ccEmailTip: 'cc_email: 抄送邮箱(可选)',
      subjectTip: 'subject: 邮件主题(可选)',
      contentTip: 'content: 邮件内容(可选)',
      jsonUploadTypeErrorMessage: '请上传json文件',
      jsonUploadContentErrorMessage: 'json 文件错误',
      iteration: '迭代',
      iterationDescription: `该组件负责迭代生成新的内容，对列表对象执行多次步骤直至输出所有结果。`,
      delimiterTip: `该分隔符用于将输入文本分割成几个文本片段，每个文本片段的回显将作为每次迭代的输入项。`,
      delimiterOptions: {
        comma: '逗号',
        lineBreak: '换行',
        tab: '制表符',
        underline: '下划线',
        diagonal: '斜线',
        minus: '连字符',
        semicolon: '分号',
      },
      addCategory: '新增分类',
      categoryName: '分类名称',
      nextStep: '下一步',
      insertVariableTip: `输入 / 插入变量`,
      setting: '设置',
      settings: {
        agentSetting: 'Agent设置',
        title: '标题',
        description: '描述',
        upload: '上传',
        photo: '照片',
        permissions: '权限',
        permissionsTip: '你可以在这里设置团队访问权限。',
        me: '仅限自己',
        team: '团队',
      },
      systemPrompt: '系统提示词',
      userPrompt: '用户提示词',
      prompt: '提示词',
      promptMessage: '提示词是必填项',
      promptTip:
        '系统提示为大模型提供任务描述、规定回复方式，以及设置其他各种要求。系统提示通常与 key （变量）合用，通过变量设置大模型的输入数据。你可以通过斜杠或者 (x) 按钮显示可用的 key。',
      knowledgeBasesTip: '选择关联的知识库，或者在下方选择包含知识库ID的变量。',
      knowledgeBaseVars: '知识库变量',
      code: '代码',
      codeDescription: '它允许开发人员编写自定义 Python 逻辑。',
      dataOperations: '数据操作',
      dataOperationsDescription: '对数据对象执行各种操作。',
      listOperations: '列表操作',
      listOperationsDescription: '对列表对象执行各种操作。',
      variableAssigner: '变量赋值器',
      variableAssignerDescription:
        '此组件对数据对象执行操作，包括提取、筛选和编辑数据中的键和值。',
      variableAggregator: '变量聚合',
      variableAggregatorDescription: `该过程将来自多个分支的变量聚合到一个变量中，以实现下游节点的统一配置。`,
      inputVariables: '输入变量',
      addVariable: '新增变量',
      runningHintText: '正在运行中...🕞',
      openingSwitch: '开场白开关',
      openingCopy: '开场白文案',
      openingSwitchTip: '您的用户将在开始时看到此欢迎消息。',
      modeTip: '模式定义了工作流的启动方式。',
      mode: '模式',
      conversational: '对话式',
      task: '任务',
      beginInputTip: '通过定义输入参数，此内容可以被后续流程中的其他组件访问。',
      query: '查询变量',
      queryRequired: '查询变量是必填项',
      queryTip: '选择您想要使用的变量',
      agent: '智能体',
      addAgent: '添加智能体',
      agentDescription: '构建具备推理、工具调用和多智能体协同的智能体组件。',
      maxRecords: '最大记录数',
      createAgent: '智能体流程',
      stringTransform: '文本处理',
      userFillUp: '等待输入',
      userFillUpDescription: `此组件会暂停当前的流程并等待用户发送消息，接收到消息之后再进行之后的流程。`,

      codeExec: '代码',
      tavilySearch: 'Tavily 搜索',
      tavilySearchDescription: '通过 Tavily 服务搜索结果',
      tavilyExtract: 'Tavily 提取',
      tavilyExtractDescription: 'Tavily 提取',
      log: '日志',
      management: '管理',
      import: '导入',
      export: '导出',
      subject: '主题',
      logTimeline: {
        begin: '准备开始',
        userFillUp: '等你输入',
        agent: '智能体正在思考',
        retrieval: '查找知识',
        message: '回复',
        awaitResponse: '等你输入',
        switch: '选择最佳路线',
        iteration: '批量处理',
        categorize: '信息归类',
        code: '运行小段代码',
        textProcessing: '整理文字',
        tavilySearch: '正在网上搜索',
        tavilyExtract: '读取网页内容',
        exeSQL: '查询数据库',
        google: '正在网上搜索',
        wikipedia: '搜索维基百科',
        googleScholar: '学术检索',
        gitHub: '搜索',
        email: '发送邮件',
        httpRequest: '请求接口',
        wenCai: '查询财务数据',
      },
      sqlStatement: 'SQL 语句',
      sqlStatementTip:
        '在此处编写您的 SQL 查询。您可以使用变量、原始 SQL，或使用变量语法混合使用两者。',
      frameworkPrompts: '框架',
      release: '发布',
      createFromBlank: '从空白创建',
      createFromTemplate: '从模板创建',
      importJsonFile: '导入 JSON 文件',
      chooseAgentType: '选择智能体类型',
      parser: '解析器',
      parserDescription: '从文件中提取原始文本和结构以供下游处理。',
      tokenizer: '分词器',
      tokenizerRequired: '请先添加Tokenizer节点',
      tokenizerDescription:
        '根据所选的搜索方法，将文本转换为所需的数据结构（例如，用于嵌入搜索的向量嵌入）。',
      splitter: '按字符分割',
      splitterDescription:
        '根据分词器长度将文本拆分成块，并带有可选的分隔符和重叠。',
      hierarchicalMergerDescription:
        '使用正则表达式规则按标题层次结构将文档拆分成多个部分，以实现更精细的控制。',
      hierarchicalMerger: '按标题分割',
      extractor: '提取器',
      extractorDescription:
        '使用 LLM 从文档块（例如摘要、分类等）中提取结构化见解。',
      outputFormat: '输出格式',
      fileFormats: '文件类型',
      fields: '字段',
      addParser: '增加解析器',
      hierarchy: '层次结构',
      regularExpressions: '正则表达式',
      overlappedPercent: '重叠百分比（%）',
      searchMethod: '搜索方法',
      searchMethodTip: `决定该数据集启用的搜索方式，可选择全文、向量，或两者兼有。
Tokenizer 会根据所选方式将内容存储为对应的数据结构。`,
      filenameEmbdWeight: '文件名嵌入权重',
      parserMethod: '解析方法',
      tableResultType: '表格返回形式',
      markdownImageResponseType: '图片返回形式',
      systemPromptPlaceholder:
        '请输入用于图像分析的系统提示词，若为空则使用系统缺省值',
      exportJson: '导出 JSON',
      viewResult: '查看结果',
      running: '运行中',
      summary: '增强上下文',
      keywords: '关键词',
      questions: '问题',
      metadata: '元数据',
      toc: 'PageIndex',
      fieldName: '结果目的地',
      prompts: {
        system: {
          keywords: `角色
你是一名文本分析员。

任务
从给定的文本内容中提取最重要的关键词/短语。

要求
- 总结文本内容，并给出最重要的5个关键词/短语。
- 关键词必须与给定的文本内容使用相同的语言。
- 关键词之间用英文逗号分隔。
- 仅输出关键词。`,
          questions: `角色
你是一名文本分析员。

任务
针对给定的文本内容提出3个问题。

要求
- 理解并总结文本内容，并提出最重要的3个问题。
- 问题的含义不应重叠。
- 问题应尽可能涵盖文本的主要内容。
- 问题必须与给定的文本内容使用相同的语言。
- 每行一个问题。
- 仅输出问题。`,
          summary: `扮演一个精准的摘要者。你的任务是为提供的内容创建一个简洁且忠实于原文的摘要。

关键说明：
1. 准确性：摘要必须严格基于所提供的信息。请勿引入任何未明确说明的新事实、结论或解释。
2. 语言：摘要必须使用与原文相同的语言。
3. 客观性：不带偏见地呈现要点，保留内容的原始意图和语气。请勿进行编辑。
4. 简洁性：专注于最重要的思想，省略细节和多余的内容。`,
          metadata: `从给定内容中提取重要的结构化信息。仅输出有效的 JSON 字符串，不包含任何附加文本。如果未找到重要的结构化信息，则输出一个空的 JSON 对象：{}。

重要的结构化信息可能包括：姓名、日期、地点、事件、关键事实、数字数据或其他可提取实体。`,
        },
        user: {
          keywords: `文本内容
[在此处插入文本]`,
          questions: `文本内容
[在此处插入文本]`,
          summary: `要总结的文本：
[在此处插入文本]`,
          metadata: `内容：[在此处插入内容]`,
        },
      },
      cancel: '取消',
      filenameEmbeddingWeight: '文件名嵌入权重',
      switchPromptMessage: '提示词将发生变化，请确认是否放弃已有提示词？',
      structuredOutput: {
        configuration: '配置',
        structuredOutput: '结构化输出',
      },
      operations: '操作',
      operationsOptions: {
        selectKeys: '选择键',
        literalEval: '字面值求值',
        combine: '合并',
        filterValues: '筛选值',
        appendOrUpdate: '追加或更新',
        removeKeys: '删除键',
        renameKeys: '重命名键',
      },
      ListOperationsOptions: {
        topN: '取前N项',
        head: '取前第N项',
        tail: '取后第N项',
        sort: '排序',
        filter: '筛选',
        dropDuplicates: '去重',
      },
      sortMethod: '排序方式',
      SortMethodOptions: {
        asc: '升序',
        desc: '降序',
      },
      variableAssignerLogicalOperatorOptions: {
        overwrite: '覆盖',
        clear: '清除',
        set: '设置',
        add: '加',
        subtract: '减',
        multiply: '乘',
        divide: '除',
        append: '追加',
        extend: '扩展',
        removeFirst: '移除第一个',
        removeLast: '移除最后一个',
      },
      webhook: {
        name: '网络钩子',
        methods: '方法',
        contentTypes: '内容类型',
        security: '安全配置',
        schema: '模式',
        response: '响应',
        executionMode: '执行模式',
        executionModeTip:
          'Accepted Response：请求校验通过后立即返回接收成功响应，工作流在后台异步执行；Final Response：系统在工作流执行完成后返回最终处理结果',
        authMethods: '认证方法',
        authType: '认证类型',
        limit: '请求限制',
        per: '时间周期',
        maxBodySize: '最大主体大小',
        ipWhitelist: 'IP白名单',
        tokenHeader: '令牌头部',
        tokenValue: '令牌值',
        username: '用户名',
        password: '密码',
        algorithm: '算法',
        secret: '密钥',
        issuer: '签发者',
        audience: '受众',
        requiredClaims: '必需声明',
        header: '头部',
        status: '状态',
        headersTemplate: '头部模板',
        bodyTemplate: '主体模板',
        basic: '基础认证',
        bearer: '承载令牌',
        apiKey: 'API密钥',
        queryParameters: '查询参数',
        headerParameters: '请求头参数',
        requestBodyParameters: '请求体参数',
        overview: '概述',
        logs: '日志',
        agentStatus: '智能体状态：',
      },
      saveToMemory: '保存到Memory',
      retrievalFrom: '检索来源',
    },
    footer: {
      profile: 'All rights reserved @ React',
    },
    layout: {
      file: 'file',
      knowledge: 'knowledge',
      chat: 'chat',
    },
    llmTools: {
      bad_calculator: {
        name: '计算器',
        description: '用于计算两个数的和的工具（会给出错误答案）',
        params: {
          a: '第一个数',
          b: '第二个数',
        },
      },
    },
    modal: {
      okText: '确认',
      cancelText: '取消',
    },
    mcp: {
      export: '导出',
      import: '导入',
      url: 'URL',
      serverType: '服务器类型',
      addMCP: '添加 MCP',
      editMCP: '编辑 MCP',
      toolsAvailable: '可用的工具',
      mcpServers: 'MCP 服务器',
      mcpServer: 'MCP 服务器',
      customizeTheListOfMcpServers: '自定义 MCP 服务器列表',
      cachedTools: '缓存工具',
      selected: '已选择',
      bulkManage: '批量管理',
      exitBulkManage: '退出批量管理',
    },
    search: {
      searchApps: '搜索',
      createSearch: '创建查询',
      searchGreeting: '今天我能为你做些什么？',
      profile: '隐藏个人资料',
      locale: '语言',
      embedCode: '嵌入代码',
      id: 'ID',
      copySuccess: '复制成功',
      welcomeBack: '欢迎回来',
      searchSettings: '搜索设置',
      name: '姓名',
      avatar: '头像',
      description: '描述',
      datasets: '知识库',
      rerankModel: 'rerank 模型',
      AISummary: 'AI 总结',
      enableWebSearch: '启用网页搜索',
      enableRelatedSearch: '启用相关搜索',
      showQueryMindmap: '显示查询思维导图',
      embedApp: '嵌入网站',
      relatedSearch: '相关搜索',
      descriptionValue: '你是一位智能助手。',
      okText: '保存',
      cancelText: '返回',
      chooseDataset: '请先选择知识库',
    },
    language: {
      english: '英语',
      chinese: '中文',
      spanish: '西班牙语',
      french: '法语',
      german: '德语',
      japanese: '日语',
      korean: '韩语',
      vietnamese: '越南语',
    },
    pagination: {
      total: '总共 {{total}} 条',
      page: '{{page}}条/页',
    },
    dataflowParser: {
      result: '结果',
      parseSummary: '解析摘要',
      parseSummaryTip: '解析器: deepdoc',
      parserMethod: '解析方法',
      outputFormat: '输出格式',
      rerunFromCurrentStep: '从当前步骤重新运行',
      rerunFromCurrentStepTip: '已修改，点击重新运行。',
      confirmRerun: '确认重新运行流程',
      confirmRerunModalContent: `
      <p class="text-sm text-text-disabled font-medium mb-2">
        您即将从 <span class="text-text-secondary">{{step}}</span> 步骤开始重新运行该过程
      </p>
      <p class="text-sm mb-3 text-text-disabled">这将:</p>
      <ul class="list-disc list-inside space-y-1 text-sm text-text-secondary">
        <li>• 从当前步骤开始覆盖现有结果</li>
        <li>• 创建新的日志条目进行跟踪</li>
        <li>• 之前的步骤将保持不变</li>
      </ul>`,
      changeStepModalTitle: '切换步骤警告',
      changeStepModalContent: `
      <p>您目前正在编辑此阶段的结果。</p>
      <p>如果您切换到后续阶段，您的更改将会丢失。</p>
      <p>要保留这些更改，请点击“重新运行”以重新运行当前阶段。</p> `,
      changeStepModalConfirmText: '继续切换',
      changeStepModalCancelText: '取消',
      unlinkPipelineModalTitle: '解绑pipeline',
      unlinkPipelineModalContent: `
      <p>一旦取消链接，该数据集将不再连接到当前数据管道。</p>
      <p>正在解析的文件将继续解析，直到完成。</p>
      <p>尚未解析的文件将不再被处理。</p> <br/>
      <p>你确定要继续吗?</p> `,
      unlinkPipelineModalConfirmText: '解绑',
      unlinkSourceModalTitle: '取消链接数据源',
      unlinkSourceModalContent: `
      <p>您确定要取消链接此数据源吗？</p>`,
      unlinkSourceModalConfirmText: '取消链接',
    },
    datasetOverview: {
      downloadTip: '正在从数据源下载文件。',
      processingTip: '正在由pipeline处理文件。',
      totalFiles: '文件总数',
      downloading: '正在下载',
      processing: '正在处理',
      downloadSuccessTip: '下载成功总数',
      downloadFailedTip: '下载失败总数',
      processingSuccessTip: '处理成功的文件总数',
      processingFailedTip: '处理失败的文件总数',
      noData: '暂无日志',
    },

    deleteModal: {
      delAgent: '删除智能体',
      delDataset: '删除知识库',
      delSearch: '删除搜索',
      delFile: '删除文件',
      delFiles: '删除文件',
      delFilesContent: '已选择 {{count}} 个文件',
      delChat: '删除聊天',
      delMember: '删除成员',
      delMemory: '删除记忆',
    },

    empty: {
      noMCP: '暂无 MCP 服务器可用',
      agentTitle: '尚未创建智能体',
      notFoundAgent: '未查询到智能体',
      datasetTitle: '尚未创建数据集',
      notFoundDataset: '未查询到数据集',
      chatTitle: '尚未创建聊天应用',
      notFoundChat: '未查询到聊天应用',
      searchTitle: '尚未创建搜索应用',
      notFoundSearch: '未查询到搜索应用',
      memoryTitle: '尚未创建记忆',
      notFoundMemory: '未查询到记忆',
      addNow: '立即添加',
    },

    explore: {
      title: '探索',
      canvasList: '画布列表',
      sessions: '会话列表',
      newSession: '新建会话',
      newSessionLabel: '开始新对话',
      deleteSession: '删除会话',
      searchCanvas: '搜索画布...',
      searchSessions: '搜索会话...',
      noCanvasSelected: '请选择一个画布',
      noSessionSelected: '请选择一个会话或创建新会话',
      noSessionsFound: '未找到会话',
      createFirstSession: '创建您的第一个会话',
      noCanvasFound: '未找到画布',
      deleteSelectedConfirm: '确定要删除 {{count}} 个会话吗？',
      batchDeleteSessions: '删除会话',
    },
  },
};
